/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.apache.sshd.server.shell.InvertedShell;

public class InvertedShellWrapper
extends AbstractLoggingBean
implements Command,
ServerSessionAware {
    private final InvertedShell shell;
    private final Executor executor;
    private int bufferSize;
    private Duration pumpSleepTime;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private OutputStream shellIn;
    private InputStream shellOut;
    private InputStream shellErr;
    private ExitCallback callback;
    private boolean shutdownExecutor;

    public InvertedShellWrapper(InvertedShell shell) {
        this(shell, CoreModuleProperties.BUFFER_SIZE.getRequiredDefault());
    }

    public InvertedShellWrapper(InvertedShell shell, int bufferSize) {
        this(shell, null, true, bufferSize);
    }

    public InvertedShellWrapper(InvertedShell shell, Executor executor, boolean shutdownExecutor, int bufferSize) {
        this.shell = Objects.requireNonNull(shell, "No shell");
        this.executor = executor == null ? ThreadUtils.newSingleThreadExecutor("shell[0x" + Integer.toHexString(shell.hashCode()) + "]") : executor;
        ValidateUtils.checkTrue(bufferSize > 8, "Copy buffer size too small: %d", bufferSize);
        this.bufferSize = bufferSize;
        this.pumpSleepTime = CoreModuleProperties.PUMP_SLEEP_TIME.getRequiredDefault();
        this.shutdownExecutor = executor == null || shutdownExecutor;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out2) {
        this.out = out2;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback2) {
        this.callback = callback2;
    }

    @Override
    public void setSession(ServerSession session2) {
        this.bufferSize = CoreModuleProperties.BUFFER_SIZE.getRequired(session2);
        this.pumpSleepTime = CoreModuleProperties.PUMP_SLEEP_TIME.getRequired(session2);
        ValidateUtils.checkTrue(GenericUtils.isPositive(this.pumpSleepTime), "Invalid " + CoreModuleProperties.PUMP_SLEEP_TIME + ": %d", (Object)this.pumpSleepTime);
        this.shell.setSession(session2);
    }

    @Override
    public synchronized void start(ChannelSession channel2, Environment env) throws IOException {
        this.shell.start(channel2, env);
        this.shellIn = this.shell.getInputStream();
        this.shellOut = this.shell.getOutputStream();
        this.shellErr = this.shell.getErrorStream();
        this.executor.execute(this::pumpStreams);
    }

    @Override
    public synchronized void destroy(ChannelSession channel2) throws Exception {
        Throwable err = null;
        try {
            this.shell.destroy(channel2);
        }
        catch (Throwable e2) {
            this.warn("destroy({}) failed ({}) to destroy shell: {}", this, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            err = ExceptionUtils.accumulateException(err, e2);
        }
        if (this.shutdownExecutor && this.executor instanceof ExecutorService) {
            try {
                ((ExecutorService)this.executor).shutdown();
            }
            catch (Exception e3) {
                this.warn("destroy({}) failed ({}) to shut down executor: {}", this, e3.getClass().getSimpleName(), e3.getMessage(), e3);
                err = ExceptionUtils.accumulateException(err, e3);
            }
        }
        if (err != null) {
            if (err instanceof Exception) {
                throw (Exception)err;
            }
            throw new RuntimeSshException(err);
        }
    }

    protected void pumpStreams() {
        try {
            byte[] buffer = new byte[this.bufferSize];
            while (true) {
                if (this.pumpStream(this.in, this.shellIn, buffer) || this.pumpStream(this.shellOut, this.out, buffer) || this.pumpStream(this.shellErr, this.err, buffer)) {
                    continue;
                }
                if (!this.shell.isAlive() && this.in.available() <= 0 && this.shellOut.available() <= 0 && this.shellErr.available() <= 0) {
                    this.callback.onExit(this.shell.exitValue());
                    return;
                }
                Thread.sleep(this.pumpSleepTime.toMillis());
            }
        }
        catch (Throwable e2) {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                this.shell.destroy(this.shell.getServerChannelSession());
            }
            catch (Throwable err) {
                this.warn("pumpStreams({}) failed ({}) to destroy shell: {}", this, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
            int exitValue = this.shell.exitValue();
            if (debugEnabled) {
                this.log.debug(e2.getClass().getSimpleName() + " while pumping the streams (exit=" + exitValue + "): " + e2.getMessage(), e2);
            }
            this.callback.onExit(exitValue, e2.getClass().getSimpleName());
            return;
        }
    }

    protected boolean pumpStream(InputStream in, OutputStream out2, byte[] buffer) throws IOException {
        int available = in.available();
        if (available > 0) {
            int len2 = in.read(buffer);
            if (len2 > 0) {
                out2.write(buffer, 0, len2);
                out2.flush();
                return true;
            }
        } else if (available == -1) {
            out2.close();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.shell;
    }
}

