/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;
import org.apache.sshd.server.shell.ProcessShell;
import org.apache.sshd.server.shell.ShellFactory;

public class ProcessShellFactory
extends AbstractLoggingBean
implements ShellFactory {
    private String command;
    private List<String> elements;

    public ProcessShellFactory() {
        this.command = "";
        this.elements = Collections.emptyList();
    }

    public ProcessShellFactory(String command2, String ... elements) {
        this(command2, GenericUtils.isEmpty(elements) ? Collections.emptyList() : Arrays.asList(elements));
    }

    public ProcessShellFactory(String command2, List<String> elements) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command2, "No command");
        this.elements = ValidateUtils.checkNotNullAndNotEmpty(elements, "No parsed elements", new Object[0]);
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setCommand(String command2, String ... elements) {
        this.setCommand(command2, GenericUtils.isEmpty(elements) ? Collections.emptyList() : Arrays.asList(elements));
    }

    public void setCommand(String command2, List<String> elements) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command2, "No command");
        this.elements = ValidateUtils.checkNotNullAndNotEmpty(elements, "No parsed elements", new Object[0]);
    }

    @Override
    public Command createShell(ChannelSession channel2) {
        InvertedShell shell = this.createInvertedShell(channel2);
        return new InvertedShellWrapper(shell);
    }

    protected InvertedShell createInvertedShell(ChannelSession channel2) {
        return new ProcessShell(this.resolveEffectiveCommand(channel2, this.getCommand(), this.getElements()));
    }

    protected List<String> resolveEffectiveCommand(ChannelSession channel2, String rawCommand, List<String> parsedElements) {
        if (!OsUtils.isWin32()) {
            return ValidateUtils.checkNotNullAndNotEmpty(parsedElements, "No parsed command elements", new Object[0]);
        }
        if (GenericUtils.size(parsedElements) <= 1) {
            return ValidateUtils.checkNotNullAndNotEmpty(parsedElements, "No parsed command elements", new Object[0]);
        }
        String cmdName = parsedElements.get(0);
        if ("cmd.exe".equalsIgnoreCase(cmdName)) {
            return ValidateUtils.checkNotNullAndNotEmpty(parsedElements, "No parsed command elements", new Object[0]);
        }
        return Arrays.asList("cmd.exe", "/C", ValidateUtils.checkNotNullAndNotEmpty(rawCommand, "No command"));
    }
}

