/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.shell.TtyFilterInputStream;

public class TtyFilterOutputStream
extends FilterOutputStream {
    public static final Set<PtyMode> OUTPUT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ECHO, PtyMode.INLCR, PtyMode.ICRNL, PtyMode.IGNCR));
    private final Set<PtyMode> ttyOptions;
    private final TtyFilterInputStream echo;

    public TtyFilterOutputStream(OutputStream out2, TtyFilterInputStream echo, Map<PtyMode, ?> modes) {
        this(out2, echo, PtyMode.resolveEnabledOptions(modes, OUTPUT_OPTIONS));
    }

    public TtyFilterOutputStream(OutputStream out2, TtyFilterInputStream echo, Collection<PtyMode> ttyOptions) {
        super(out2);
        this.ttyOptions = GenericUtils.of(ttyOptions);
        this.echo = this.ttyOptions.contains((Object)PtyMode.ECHO) ? Objects.requireNonNull(echo, "No echo stream") : echo;
    }

    @Override
    public void write(int c2) throws IOException {
        if (c2 == 13) {
            this.handleCR();
        } else if (c2 == 10) {
            this.handleLF();
        } else {
            this.writeRawOutput(c2);
        }
    }

    protected void handleCR() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.ICRNL)) {
            this.writeRawOutput(10);
        } else {
            if (this.ttyOptions.contains((Object)PtyMode.IGNCR)) {
                return;
            }
            this.writeRawOutput(13);
        }
    }

    protected void handleLF() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.INLCR)) {
            this.writeRawOutput(13);
        } else {
            this.writeRawOutput(10);
        }
    }

    protected void writeRawOutput(int c2) throws IOException {
        this.out.write(c2);
        if (this.ttyOptions.contains((Object)PtyMode.ECHO)) {
            this.echo.write(c2);
        }
    }

    @Override
    public void write(byte[] b2, int off, int len2) throws IOException {
        if (len2 == 1) {
            this.write(b2[off] & 0xFF);
            return;
        }
        int lastPos = 0;
        int maxPos = off + len2;
        for (int curPos = off; curPos < maxPos; ++curPos) {
            int c2 = b2[curPos] & 0xFF;
            if (c2 != 13 && c2 != 10) continue;
            if (lastPos < curPos) {
                this.writeRawOutput(b2, lastPos, curPos - lastPos);
            }
            lastPos = curPos + 1;
            this.write(c2);
        }
        if (lastPos < maxPos) {
            this.writeRawOutput(b2, lastPos, maxPos - lastPos);
        }
    }

    protected void writeRawOutput(byte[] b2, int off, int len2) throws IOException {
        this.out.write(b2, off, len2);
        if (this.ttyOptions.contains((Object)PtyMode.ECHO)) {
            this.echo.write(b2, off, len2);
        }
    }
}

