/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;

public class UnknownCommand
implements Command,
Runnable {
    private final String command;
    private final String message;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;

    public UnknownCommand(String command2) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command2, "No command");
        this.message = "Unknown command: " + command2;
    }

    public String getCommand() {
        return this.command;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out2) {
        this.out = out2;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback2) {
        this.callback = callback2;
    }

    @Override
    public void run() {
        String errorMessage = this.getMessage();
        try {
            try {
                this.err.write(errorMessage.getBytes(StandardCharsets.UTF_8));
                this.err.write(10);
            }
            finally {
                this.err.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.callback != null) {
            this.callback.onExit(1, errorMessage);
        }
    }

    @Override
    public void start(ChannelSession channel2, Environment env) throws IOException {
        Thread thread2 = new Thread(this);
        thread2.setDaemon(true);
        thread2.start();
    }

    @Override
    public void destroy(ChannelSession channel2) {
    }

    public int hashCode() {
        return Objects.hashCode(this.getCommand());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.getCommand(), ((UnknownCommand)obj).getCommand());
    }

    public String toString() {
        return this.getMessage();
    }
}

