/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.x11.ChannelForwardedX11;
import org.apache.sshd.server.x11.X11ForwardSupport;
import org.apache.sshd.server.x11.X11ForwardingExceptionMarker;

public class DefaultX11ForwardSupport
extends AbstractInnerCloseable
implements X11ForwardSupport {
    private final ConnectionService service;
    private IoAcceptor acceptor;

    public DefaultX11ForwardSupport(ConnectionService service) {
        this.service = Objects.requireNonNull(service, "No connection service");
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.acceptor).build();
    }

    @Override
    public synchronized String createDisplay(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.isClosed()) {
            throw new IllegalStateException("X11ForwardSupport is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("X11ForwardSupport is closing");
        }
        if (OsUtils.isWin32()) {
            if (debugEnabled) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) Windows O/S N/A", authenticationProtocol, authenticationCookie, screen);
            }
            return null;
        }
        Session session2 = (Session)Objects.requireNonNull(this.service.getSession(), "No session");
        if (this.acceptor == null) {
            FactoryManager manager = Objects.requireNonNull(session2.getFactoryManager(), "No factory manager");
            IoServiceFactory factory2 = Objects.requireNonNull(manager.getIoServiceFactory(), "No I/O service factory");
            this.acceptor = factory2.createAcceptor(this);
        }
        int minDisplayNumber = CoreModuleProperties.X11_DISPLAY_OFFSET.getRequired(session2);
        int maxDisplayNumber = CoreModuleProperties.X11_MAX_DISPLAYS.getRequired(session2);
        int basePort = CoreModuleProperties.X11_BASE_PORT.getRequired(session2);
        String bindHost = CoreModuleProperties.X11_BIND_HOST.getRequired(session2);
        InetSocketAddress addr = null;
        for (int displayNumber = minDisplayNumber; displayNumber < maxDisplayNumber; ++displayNumber) {
            int port2 = basePort + displayNumber;
            addr = new InetSocketAddress(bindHost, port2);
            try {
                this.acceptor.bind(addr);
                break;
            }
            catch (BindException bindErr) {
                if (debugEnabled) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) failed ({}) to bind to address={}: {}", authenticationProtocol, authenticationCookie, screen, bindErr.getClass().getSimpleName(), addr, bindErr.getMessage());
                }
                addr = null;
                continue;
            }
        }
        if (addr == null) {
            this.log.warn("createDisplay(auth={}, cookie={}, screen={}) failed to allocate internet-domain X11 display socket in range {}-{}", authenticationProtocol, authenticationCookie, screen, minDisplayNumber, maxDisplayNumber);
            Set<SocketAddress> boundAddresses = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(boundAddresses)) {
                if (debugEnabled) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - no more bound addresses", authenticationProtocol, authenticationCookie, screen);
                }
                this.close();
            } else if (debugEnabled) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - remaining bound addresses: {}", authenticationProtocol, authenticationCookie, screen, boundAddresses);
            }
            return null;
        }
        int port3 = addr.getPort();
        int displayNumber = port3 - basePort;
        String authDisplay = "unix:" + displayNumber + "." + screen;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(XAUTH_COMMAND, "remove", authDisplay);
            Process p = processBuilder.start();
            int result2 = p.waitFor();
            if (debugEnabled) {
                this.log.debug("createDisplay({}) {} remove result={}", authDisplay, XAUTH_COMMAND, result2);
            }
            if (result2 == 0) {
                processBuilder = new ProcessBuilder(XAUTH_COMMAND, "add", authDisplay, authenticationProtocol, authenticationCookie);
                p = processBuilder.start();
                result2 = p.waitFor();
                if (debugEnabled) {
                    this.log.debug("createDisplay({}) {} add result={}", authDisplay, XAUTH_COMMAND, result2);
                }
            }
            if (result2 != 0) {
                throw new IllegalStateException("Bad " + XAUTH_COMMAND + " invocation result: " + result2);
            }
            return bindHost + ":" + displayNumber + "." + screen;
        }
        catch (Throwable e2) {
            this.warn("createDisplay({}) failed ({}) run xauth: {}", authDisplay, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            return null;
        }
    }

    @Override
    public void sessionCreated(IoSession session2) throws Exception {
        ChannelForwardedX11 channel2 = new ChannelForwardedX11(session2);
        session2.setAttribute(ChannelForwardedX11.class, channel2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sessionCreated({}) channel{}", (Object)session2, (Object)channel2);
        }
        this.service.registerChannel(channel2);
        Duration openTimeout = CoreModuleProperties.X11_OPEN_TIMEOUT.getRequired(channel2);
        channel2.open().verify(openTimeout);
    }

    @Override
    public void sessionClosed(IoSession session2) throws Exception {
        ChannelForwardedX11 channel2 = (ChannelForwardedX11)session2.removeAttribute(ChannelForwardedX11.class);
        Throwable cause = (Throwable)session2.removeAttribute(X11ForwardingExceptionMarker.class);
        if (channel2 != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) close channel={} - cause={}", session2, channel2, cause == null ? null : cause.getClass().getSimpleName());
            }
            channel2.close(cause != null);
        }
    }

    @Override
    public void messageReceived(IoSession session2, Readable message) throws Exception {
        ChannelForwardedX11 channel2 = (ChannelForwardedX11)session2.getAttribute(ChannelForwardedX11.class);
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        if (this.log.isTraceEnabled()) {
            this.log.trace("messageReceived({}) channel={}, len={}", session2, channel2, buffer.available());
        }
        OutputStream outputStream2 = channel2.getInvertedIn();
        outputStream2.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
        outputStream2.flush();
    }

    @Override
    public void exceptionCaught(IoSession session2, Throwable cause) throws Exception {
        session2.setAttribute(X11ForwardingExceptionMarker.class, cause);
        this.log.debug("exceptionCaught({}) {}: {}", session2, cause.getClass().getSimpleName(), cause.getMessage(), cause);
        session2.close(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.service.getClass();
    }
}

