/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client;

import java.io.IOException;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.impl.DefaultSftpClientFactory;

public interface SftpClientFactory {
    public static SftpClientFactory instance() {
        return DefaultSftpClientFactory.INSTANCE;
    }

    default public SftpClient createSftpClient(ClientSession session2) throws IOException {
        return this.createSftpClient(session2, SftpVersionSelector.CURRENT);
    }

    default public SftpClient createSftpClient(ClientSession session2, int version2) throws IOException {
        return this.createSftpClient(session2, SftpVersionSelector.fixedVersionSelector(version2));
    }

    default public SftpClient createSftpClient(ClientSession session2, SftpVersionSelector selector) throws IOException {
        return this.createSftpClient(session2, selector, SftpErrorDataHandler.EMPTY);
    }

    default public SftpClient createSftpClient(ClientSession session2, SftpErrorDataHandler errorDataHandler) throws IOException {
        return this.createSftpClient(session2, SftpVersionSelector.CURRENT, errorDataHandler);
    }

    public SftpClient createSftpClient(ClientSession var1, SftpVersionSelector var2, SftpErrorDataHandler var3) throws IOException;

    default public SftpFileSystem createSftpFileSystem(ClientSession session2) throws IOException {
        return this.createSftpFileSystem(session2, SftpVersionSelector.CURRENT);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session2, int version2) throws IOException {
        return this.createSftpFileSystem(session2, SftpVersionSelector.fixedVersionSelector(version2));
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session2, SftpVersionSelector selector) throws IOException {
        return this.createSftpFileSystem(session2, selector, 0, 0);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session2, int version2, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session2, SftpVersionSelector.fixedVersionSelector(version2), readBufferSize, writeBufferSize);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session2, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session2, SftpVersionSelector.CURRENT, readBufferSize, writeBufferSize);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session2, SftpVersionSelector selector, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session2, selector, SftpErrorDataHandler.EMPTY, readBufferSize, writeBufferSize);
    }

    public SftpFileSystem createSftpFileSystem(ClientSession var1, SftpVersionSelector var2, SftpErrorDataHandler var3, int var4, int var5) throws IOException;
}

