/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.sftp.client.SftpClient;

public interface SimpleSftpClient
extends Channel {
    default public SftpClient sftpLogin(String host2, String username, String password) throws IOException {
        return this.sftpLogin(host2, 22, username, password);
    }

    default public SftpClient sftpLogin(String host2, int port2, String username, String password) throws IOException {
        return this.sftpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host2, "No host")), port2, username, password);
    }

    default public SftpClient sftpLogin(String host2, String username, KeyPair identity) throws IOException {
        return this.sftpLogin(host2, 22, username, identity);
    }

    default public SftpClient sftpLogin(String host2, int port2, String username, KeyPair identity) throws IOException {
        return this.sftpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host2, "No host")), port2, username, identity);
    }

    default public SftpClient sftpLogin(InetAddress host2, String username, String password) throws IOException {
        return this.sftpLogin(host2, 22, username, password);
    }

    default public SftpClient sftpLogin(InetAddress host2, int port2, String username, String password) throws IOException {
        return this.sftpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host2, "No host address"), port2), username, password);
    }

    default public SftpClient sftpLogin(InetAddress host2, String username, KeyPair identity) throws IOException {
        return this.sftpLogin(host2, 22, username, identity);
    }

    default public SftpClient sftpLogin(InetAddress host2, int port2, String username, KeyPair identity) throws IOException {
        return this.sftpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host2, "No host address"), port2), username, identity);
    }

    public SftpClient sftpLogin(SocketAddress var1, String var2, String var3) throws IOException;

    public SftpClient sftpLogin(SocketAddress var1, String var2, KeyPair var3) throws IOException;
}

