/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Collection;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.helpers.AbstractSftpClientExtension;

public abstract class AbstractMD5HashExtension
extends AbstractSftpClientExtension {
    protected AbstractMD5HashExtension(String name, SftpClient client2, RawSftpClient raw, Collection<String> extras) {
        super(name, client2, raw, extras);
    }

    protected byte[] doGetHash(Object target, long offset, long length, byte[] quickHash) throws IOException {
        Buffer buffer = this.getCommandBuffer(target, 84 + NumberUtils.length(quickHash));
        String opcode = this.getName();
        this.putTarget(buffer, target);
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putBytes(quickHash == null ? GenericUtils.EMPTY_BYTE_ARRAY : quickHash);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doGetHash({})[{}] - offset={}, length={}, quick-hash={}", opcode, target instanceof CharSequence ? target : BufferUtils.toHex('\u0000', (byte[])target), offset, length, BufferUtils.toHex(':', quickHash));
        }
        if ((buffer = this.checkExtendedReplyBuffer(this.receive(this.sendExtendedCommand(buffer)))) == null) {
            throw new StreamCorruptedException("Missing extended reply data");
        }
        String targetType = buffer.getString();
        if (String.CASE_INSENSITIVE_ORDER.compare(targetType, opcode) != 0) {
            throw new StreamCorruptedException("Mismatched reply target type: expected=" + opcode + ", actual=" + targetType);
        }
        byte[] hashValue = buffer.getBytes();
        if (debugEnabled) {
            this.log.debug("doGetHash({})[{}] - offset={}, length={}, quick-hash={} - result={}", opcode, target, offset, length, BufferUtils.toHex(':', quickHash), BufferUtils.toHex(':', hashValue));
        }
        return hashValue;
    }
}

