/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions.helpers;

import java.io.IOException;
import java.util.Collection;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.CopyDataExtension;
import org.apache.sshd.sftp.client.extensions.helpers.AbstractSftpClientExtension;

public class CopyDataExtensionImpl
extends AbstractSftpClientExtension
implements CopyDataExtension {
    public CopyDataExtensionImpl(SftpClient client2, RawSftpClient raw, Collection<String> extra) {
        super("copy-data", client2, raw, extra);
    }

    @Override
    public void copyData(SftpClient.Handle readHandle, long readOffset, long readLength, SftpClient.Handle writeHandle, long writeOffset) throws IOException {
        byte[] srcId = readHandle.getIdentifier();
        byte[] dstId = writeHandle.getIdentifier();
        Buffer buffer = this.getCommandBuffer(4 + NumberUtils.length(srcId) + 4 + NumberUtils.length(dstId) + 204);
        buffer.putBytes(srcId);
        buffer.putLong(readOffset);
        buffer.putLong(readLength);
        buffer.putBytes(dstId);
        buffer.putLong(writeOffset);
        this.sendAndCheckExtendedCommandStatus(buffer);
    }
}

