/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.FilenameTranslationControlExtension;
import org.apache.sshd.sftp.client.extensions.helpers.AbstractSftpClientExtension;

public class FilenameTranslationControlExtensionImpl
extends AbstractSftpClientExtension
implements FilenameTranslationControlExtension {
    public FilenameTranslationControlExtensionImpl(SftpClient client2, RawSftpClient raw, Collection<String> extras) {
        super("filename-translation-control", client2, raw, GenericUtils.isNotEmpty(extras) && extras.contains("filename-charset"));
    }

    public FilenameTranslationControlExtensionImpl(SftpClient client2, RawSftpClient raw, Map<String, byte[]> extensions) {
        super("filename-translation-control", client2, raw, MapEntryUtils.isNotEmpty(extensions) && extensions.containsKey("filename-charset"));
    }

    @Override
    public void setFilenameTranslationControl(boolean doTranslate) throws IOException {
        Buffer request2 = this.getCommandBuffer(8);
        request2.putBoolean(doTranslate);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFilenameTranslationControl({}) doTranslate={}", (Object)this.getName(), (Object)doTranslate);
        }
        int id = this.sendExtendedCommand(request2);
        Buffer response2 = this.receive(id);
        if ((response2 = this.checkExtendedReplyBuffer(response2)) != null) {
            throw new StreamCorruptedException("Unexpected extended reply data");
        }
    }
}

