/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientHolder;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.SftpPathIterator;

public class SftpDirectoryStream
implements SftpClientHolder,
DirectoryStream<Path> {
    protected SftpPathIterator pathIterator;
    protected boolean pathIteratorConsumed;
    private final SftpPath path;
    private final DirectoryStream.Filter<? super Path> filter;
    private final SftpClient sftp;

    public SftpDirectoryStream(SftpPath path2) throws IOException {
        this(path2, null);
    }

    public SftpDirectoryStream(SftpPath path2, DirectoryStream.Filter<? super Path> filter2) throws IOException {
        this.path = Objects.requireNonNull(path2, "No path specified");
        this.filter = filter2;
        SftpFileSystem fs = (SftpFileSystem)path2.getFileSystem();
        this.sftp = fs.getClient();
        Iterable<SftpClient.DirEntry> iter = this.sftp.readDir(path2.toString());
        this.pathIterator = new SftpPathIterator(this.getRootPath(), iter, this.getFilter());
    }

    @Override
    public final SftpClient getClient() {
        return this.sftp;
    }

    public final SftpPath getRootPath() {
        return this.path;
    }

    public final DirectoryStream.Filter<? super Path> getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<Path> iterator() {
        if (!this.sftp.isOpen()) {
            throw new IllegalStateException("Stream has been closed");
        }
        if (this.pathIteratorConsumed) {
            throw new IllegalStateException("Iterator has already been consumed");
        }
        this.pathIteratorConsumed = true;
        return this.pathIterator;
    }

    @Override
    public void close() throws IOException {
        if (this.pathIterator != null) {
            this.pathIterator.close();
        }
        this.sftp.close();
    }
}

