/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpMessage;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileStore;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpPathImpl;
import org.apache.sshd.sftp.common.SftpConstants;

public class SftpFileSystem
extends BaseFileSystem<SftpPath>
implements SessionHolder<ClientSession>,
ClientSessionHolder {
    public static final NavigableSet<String> UNIVERSAL_SUPPORTED_VIEWS = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"basic", "posix", "owner"}));
    public static final AttributeRepository.AttributeKey<Boolean> OWNED_SESSION = new AttributeRepository.AttributeKey();
    private final String id;
    private final SftpClientFactory factory;
    private final SftpVersionSelector selector;
    private final SftpErrorDataHandler errorDataHandler;
    private SftpClientPool pool;
    private int version;
    private Set<String> supportedViews;
    private SftpPath defaultDir;
    private int readBufferSize;
    private int writeBufferSize;
    private final List<FileStore> stores;
    private final AtomicBoolean open = new AtomicBoolean();
    private AtomicReference<ClientSession> clientSession = new AtomicReference();

    public SftpFileSystem(SftpFileSystemProvider provider2, String id, ClientSession session2, SftpClientFactory factory2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        this(provider2, id, factory2, selector, errorDataHandler);
        this.clientSession.set(Objects.requireNonNull(session2, "No client session"));
        if (!Boolean.TRUE.equals(session2.getAttribute(OWNED_SESSION))) {
            session2.addSessionListener(new SessionListener(){

                @Override
                public void sessionClosed(Session session2) {
                    if (SftpFileSystem.this.clientSession.get() == session2) {
                        try {
                            SftpFileSystem.this.close();
                        }
                        catch (IOException e2) {
                            SftpFileSystem.this.log.warn("sessionClosed({}) [{}] could not close file system properly: {}", session2, SftpFileSystem.this, e2.toString(), e2);
                        }
                    }
                }
            });
        }
        this.init();
    }

    protected SftpFileSystem(SftpFileSystemProvider provider2, String id, SftpClientFactory factory2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        super(provider2);
        this.id = id;
        this.factory = factory2 != null ? factory2 : SftpClientFactory.instance();
        this.selector = selector;
        this.errorDataHandler = errorDataHandler;
        this.stores = Collections.singletonList(new SftpFileStore(id, this));
    }

    protected void init() throws IOException {
        this.open.set(true);
        try (SftpClient client2 = this.getClient();){
            ClientSession session2 = client2.getClientSession();
            this.pool = new SftpClientPool(SftpModuleProperties.POOL_SIZE.getRequired(session2), SftpModuleProperties.POOL_LIFE_TIME.getRequired(session2), SftpModuleProperties.POOL_CORE_SIZE.getRequired(session2));
            this.version = client2.getVersion();
            this.defaultDir = (SftpPath)this.getPath(client2.canonicalPath("."), new String[0]);
        }
        catch (IOException | RuntimeException e2) {
            this.open.set(false);
            if (this.pool != null) {
                this.pool.close();
            }
            throw e2;
        }
        if (this.version >= 4) {
            TreeSet<String> views = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            views.addAll(UNIVERSAL_SUPPORTED_VIEWS);
            views.add("acl");
            this.supportedViews = Collections.unmodifiableSet(views);
        } else {
            this.supportedViews = UNIVERSAL_SUPPORTED_VIEWS;
        }
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.selector;
    }

    public SftpErrorDataHandler getSftpErrorDataHandler() {
        return this.errorDataHandler;
    }

    public final String getId() {
        return this.id;
    }

    public final int getVersion() {
        return this.version;
    }

    @Override
    public SftpFileSystemProvider provider() {
        return (SftpFileSystemProvider)super.provider();
    }

    public List<FileStore> getFileStores() {
        return this.stores;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int size2) {
        if (size2 < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + size2 + ", min.=" + 256);
        }
        this.readBufferSize = size2;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int size2) {
        if (size2 < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + size2 + ", min.=" + 256);
        }
        this.writeBufferSize = size2;
    }

    @Override
    protected SftpPath create(String root, List<String> names2) {
        return new SftpPathImpl(this, root, names2);
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession.get();
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    protected void setClientSession(ClientSession newSession) {
        this.clientSession.set(newSession);
    }

    protected ClientSession sessionForSftpClient() throws IOException {
        return this.getClientSession();
    }

    public SftpClient getClient() throws IOException {
        Wrapper wrapper2 = null;
        do {
            SftpClient client2;
            if (!this.isOpen()) {
                throw new IOException("SftpFileSystem is closed" + this);
            }
            SftpClient sftpClient = client2 = this.pool != null ? this.pool.poll() : null;
            if (client2 == null) {
                ClientSession session2 = this.sessionForSftpClient();
                client2 = this.factory.createSftpClient(session2, this.getSftpVersionSelector(), this.getSftpErrorDataHandler());
            }
            if (client2.isClosing()) continue;
            wrapper2 = new Wrapper(client2, this.getSftpErrorDataHandler(), this.getReadBufferSize(), this.getWriteBufferSize());
        } while (wrapper2 == null);
        return wrapper2;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            if (this.pool != null) {
                this.pool.close();
            }
            SftpFileSystemProvider provider2 = this.provider();
            String fsId = this.getId();
            SftpFileSystem fs = provider2.removeFileSystem(fsId);
            ClientSession session2 = this.getClientSession();
            if (Boolean.TRUE.equals(session2.getAttribute(OWNED_SESSION))) {
                session2.close(true);
            }
            if (fs != null && fs != this) {
                throw new FileSystemException(fsId, fsId, "Mismatched FS instance for id=" + fsId);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.supportedViews;
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return DefaultUserPrincipalLookupService.INSTANCE;
    }

    @Override
    public SftpPath getDefaultDir() {
        return this.defaultDir;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getClientSession() + "]";
    }

    protected class SftpClientPool {
        private final ScheduledExecutorService timeouts;
        private final BlockingQueue<SftpClientHandle> pool;
        private final long idleLifeTime;
        private final int coreSize;

        public SftpClientPool(int maxSize2, Duration idleLifeTime, int coreSize) {
            long timeout2;
            ValidateUtils.checkState(idleLifeTime == null || !idleLifeTime.isNegative(), "idleLifeTime must not be negative");
            long l = timeout2 = idleLifeTime == null ? 0L : idleLifeTime.toMillis();
            if (timeout2 == 0L && idleLifeTime != null && !idleLifeTime.isZero()) {
                timeout2 = 1L;
            }
            if (timeout2 > 0L) {
                ValidateUtils.checkState(coreSize >= 0, "coreSize must not be neagtive");
                if (coreSize > maxSize2) {
                    SftpFileSystem.this.log.warn("SftpClientPool {}: pool core size > pool maximum size, channels will not expire", (Object)SftpFileSystem.this);
                }
                if (coreSize >= maxSize2) {
                    timeout2 = 0L;
                }
            }
            this.pool = new LinkedBlockingQueue<SftpClientHandle>(maxSize2);
            this.coreSize = coreSize;
            this.idleLifeTime = timeout2;
            this.timeouts = timeout2 > 0L ? Executors.newScheduledThreadPool(1) : null;
        }

        public void close() {
            if (this.timeouts != null && !this.timeouts.isShutdown()) {
                this.timeouts.shutdownNow();
            }
            ArrayList handles = new ArrayList(this.pool.size());
            this.pool.drainTo(handles);
            handles.forEach(this::closeSilently);
        }

        public SftpClient poll() {
            SftpClient client2 = null;
            while (client2 == null) {
                SftpClientHandle handle2;
                SftpClientHandle sftpClientHandle = handle2 = SftpFileSystem.this.open.get() ? (SftpClientHandle)this.pool.poll() : null;
                if (handle2 == null) {
                    return null;
                }
                client2 = handle2.getClient();
                if (client2.isOpen()) continue;
                client2 = null;
            }
            return client2;
        }

        public boolean offer(SftpClient client2) {
            boolean wasAdded;
            SftpClientHandle handle2 = new SftpClientHandle(this.pool, client2);
            boolean bl = wasAdded = SftpFileSystem.this.open.get() && this.pool.offer(handle2);
            if (wasAdded && this.timeouts != null) {
                try {
                    handle2.setExpiration(this.timeouts.schedule(() -> {
                        if (this.pool.size() > this.coreSize && this.pool.remove(handle2)) {
                            this.closeSilently(handle2);
                        }
                    }, this.idleLifeTime, TimeUnit.MILLISECONDS));
                }
                catch (RejectedExecutionException e2) {
                    SftpFileSystem.this.log.warn("SftpClientPool {} [{}]: cannot schedule idle closure: {}", SftpFileSystem.this, client2, e2.toString());
                }
            } else if (!wasAdded) {
                handle2.destroy();
            }
            return wasAdded;
        }

        private void closeSilently(SftpClientHandle handle2) {
            SftpClient client2 = handle2.getClient();
            try {
                client2.close();
            }
            catch (IOException e2) {
                SftpFileSystem.this.log.warn("SftpClientPool {} [{}]: cannot close SftpClient properly: {}", SftpFileSystem.this, client2, e2.toString());
            }
        }
    }

    private final class Wrapper
    extends AbstractSftpClient {
        private final SftpClient delegate;
        private final int readSize;
        private final int writeSize;
        private final AtomicBoolean open;

        private Wrapper(SftpClient delegate, SftpErrorDataHandler errorHandler, int readSize, int writeSize) {
            super(errorHandler);
            this.open = new AtomicBoolean();
            this.delegate = delegate;
            this.readSize = readSize;
            this.writeSize = writeSize;
            this.open.set(delegate.isOpen());
        }

        @Override
        public int getVersion() {
            return this.delegate.getVersion();
        }

        @Override
        public ClientSession getClientSession() {
            return this.delegate.getClientSession();
        }

        @Override
        public ClientChannel getClientChannel() {
            return this.delegate.getClientChannel();
        }

        @Override
        public NavigableMap<String, byte[]> getServerExtensions() {
            return this.delegate.getServerExtensions();
        }

        @Override
        public Charset getNameDecodingCharset() {
            return this.delegate.getNameDecodingCharset();
        }

        @Override
        public void setNameDecodingCharset(Charset cs) {
            this.delegate.setNameDecodingCharset(cs);
        }

        @Override
        public boolean isClosing() {
            if (!this.open.get()) {
                return true;
            }
            if (!this.delegate.isOpen()) {
                this.open.set(false);
                return true;
            }
            return false;
        }

        @Override
        public boolean isOpen() {
            return this.open.get() && this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            if (this.open.getAndSet(false) && this.delegate.isOpen() && !SftpFileSystem.this.pool.offer(this.delegate)) {
                this.delegate.close();
            }
        }

        @Override
        public SftpClient.CloseableHandle open(String path2, Collection<SftpClient.OpenMode> options2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("open(" + path2 + ")[" + options2 + "] client is closed");
            }
            return this.delegate.open(path2, options2);
        }

        @Override
        public void close(SftpClient.Handle handle2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("close(" + handle2 + ") client is closed");
            }
            this.delegate.close(handle2);
        }

        @Override
        public void remove(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("remove(" + path2 + ") client is closed");
            }
            this.delegate.remove(path2);
        }

        @Override
        public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options2 + "] client is closed");
            }
            this.delegate.rename(oldPath, newPath, options2);
        }

        @Override
        public int read(SftpClient.Handle handle2, long fileOffset, byte[] dst, int dstOffset, int len2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("read(" + handle2 + "/" + fileOffset + ")[" + dstOffset + "/" + len2 + "] client is closed");
            }
            return this.delegate.read(handle2, fileOffset, dst, dstOffset, len2);
        }

        @Override
        public void write(SftpClient.Handle handle2, long fileOffset, byte[] src, int srcOffset, int len2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(" + handle2 + "/" + fileOffset + ")[" + srcOffset + "/" + len2 + "] client is closed");
            }
            this.delegate.write(handle2, fileOffset, src, srcOffset, len2);
        }

        @Override
        public void mkdir(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("mkdir(" + path2 + ") client is closed");
            }
            this.delegate.mkdir(path2);
        }

        @Override
        public void rmdir(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rmdir(" + path2 + ") client is closed");
            }
            this.delegate.rmdir(path2);
        }

        @Override
        public SftpClient.CloseableHandle openDir(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("openDir(" + path2 + ") client is closed");
            }
            return this.delegate.openDir(path2);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle2 + ") client is closed");
            }
            return this.delegate.readDir(handle2);
        }

        @Override
        public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle2 + ") client is closed");
            }
            return this.delegate.listDir(handle2);
        }

        @Override
        public String canonicalPath(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("canonicalPath(" + path2 + ") client is closed");
            }
            return this.delegate.canonicalPath(path2);
        }

        @Override
        public SftpClient.Attributes stat(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + path2 + ") client is closed");
            }
            return this.delegate.stat(path2);
        }

        @Override
        public SftpClient.Attributes lstat(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lstat(" + path2 + ") client is closed");
            }
            return this.delegate.lstat(path2);
        }

        @Override
        public SftpClient.Attributes stat(SftpClient.Handle handle2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + handle2 + ") client is closed");
            }
            return this.delegate.stat(handle2);
        }

        @Override
        public void setStat(String path2, SftpClient.Attributes attributes2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + path2 + ")[" + attributes2 + "] client is closed");
            }
            this.delegate.setStat(path2, attributes2);
        }

        @Override
        public void setStat(SftpClient.Handle handle2, SftpClient.Attributes attributes2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + handle2 + ")[" + attributes2 + "] client is closed");
            }
            this.delegate.setStat(handle2, attributes2);
        }

        @Override
        public String readLink(String path2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readLink(" + path2 + ") client is closed");
            }
            return this.delegate.readLink(path2);
        }

        @Override
        public void symLink(String linkPath, String targetPath) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("symLink(" + linkPath + " => " + targetPath + ") client is closed");
            }
            this.delegate.symLink(linkPath, targetPath);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle2, AtomicReference<Boolean> eolIndicator) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle2 + ") client is closed");
            }
            return this.delegate.readDir(handle2, eolIndicator);
        }

        @Override
        public InputStream read(String path2) throws IOException {
            return this.read(path2, this.readSize);
        }

        @Override
        public InputStream read(String path2, SftpClient.OpenMode ... mode) throws IOException {
            return this.read(path2, this.readSize, mode);
        }

        @Override
        public InputStream read(String path2, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.read(path2, this.readSize, mode);
        }

        @Override
        public OutputStream write(String path2) throws IOException {
            return this.write(path2, this.writeSize);
        }

        @Override
        public OutputStream write(String path2, SftpClient.OpenMode ... mode) throws IOException {
            return this.write(path2, this.writeSize, mode);
        }

        @Override
        public OutputStream write(String path2, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.write(path2, this.writeSize, (Collection)mode);
        }

        @Override
        public void put(Path localFile, String path2) throws IOException {
            this.put(localFile, this.writeSize, path2);
        }

        @Override
        public void put(InputStream stream, String path2) throws IOException {
            this.put(stream, this.writeSize, path2);
        }

        @Override
        public void put(Path localFile, String path2, SftpClient.OpenMode ... modes) throws IOException {
            this.put(localFile, this.writeSize, path2, (Collection<SftpClient.OpenMode>)GenericUtils.of((Enum[])modes));
        }

        @Override
        public void put(InputStream stream, String path2, SftpClient.OpenMode ... modes) throws IOException {
            this.put(stream, this.writeSize, path2, (Collection<SftpClient.OpenMode>)GenericUtils.of((Enum[])modes));
        }

        @Override
        public void put(Path localFile, String path2, Collection<SftpClient.OpenMode> modes) throws IOException {
            this.put(localFile, this.writeSize, path2, modes);
        }

        @Override
        public void put(InputStream stream, String path2, Collection<SftpClient.OpenMode> modes) throws IOException {
            this.put(stream, this.writeSize, path2, modes);
        }

        @Override
        public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("link(" + linkPath + " => " + targetPath + "] symbolic=" + symbolic + ": client is closed");
            }
            this.delegate.link(linkPath, targetPath, symbolic);
        }

        @Override
        public void lock(SftpClient.Handle handle2, long offset, long length, int mask) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lock(" + handle2 + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
            }
            this.delegate.lock(handle2, offset, length, mask);
        }

        @Override
        public void unlock(SftpClient.Handle handle2, long offset, long length) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("unlock" + handle2 + ")[offset=" + offset + ", length=" + length + "] client is closed");
            }
            this.delegate.unlock(handle2, offset, length);
        }

        @Override
        public int send(int cmd, Buffer buffer) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).send(cmd, buffer);
            }
            throw new StreamCorruptedException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public SftpMessage write(int cmd, Buffer buffer) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).write(cmd, buffer);
            }
            throw new StreamCorruptedException("write(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id);
            }
            throw new StreamCorruptedException("receive(id=" + id + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, long timeout2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout2 + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout2);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout2 + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, Duration timeout2) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout2 + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout2);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout2 + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }
    }

    public static class DefaultUserPrincipalLookupService
    extends UserPrincipalLookupService {
        public static final DefaultUserPrincipalLookupService INSTANCE = new DefaultUserPrincipalLookupService();

        @Override
        public UserPrincipal lookupPrincipalByName(String name) throws IOException {
            return new DefaultUserPrincipal(name);
        }

        @Override
        public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
            return new DefaultGroupPrincipal(group);
        }
    }

    protected static class SftpClientHandle
    implements ChannelListener {
        private final SftpClient client;
        private final BlockingQueue<? extends SftpClientHandle> pool;
        private Future<?> expiration;

        public SftpClientHandle(BlockingQueue<? extends SftpClientHandle> pool, SftpClient client2) {
            this.pool = Objects.requireNonNull(pool);
            this.client = Objects.requireNonNull(client2);
            Channel channel2 = client2.getChannel();
            if (channel2 != null) {
                channel2.addChannelListener(this);
            }
        }

        public void destroy() {
            Channel channel2;
            if (this.expiration != null) {
                this.expiration.cancel(true);
            }
            if ((channel2 = this.client.getChannel()) != null) {
                channel2.removeChannelListener(this);
            }
        }

        public SftpClient getClient() {
            this.destroy();
            return this.client;
        }

        public void setExpiration(Future<?> future) {
            this.expiration = future;
        }

        @Override
        public void channelClosed(Channel channel2, Throwable reason) {
            if (this.pool.remove(this)) {
                channel2.removeChannelListener(this);
            }
        }
    }

    public static class DefaultGroupPrincipal
    extends DefaultUserPrincipal
    implements GroupPrincipal {
        public DefaultGroupPrincipal(String name) {
            super(name);
        }
    }

    public static class DefaultUserPrincipal
    implements UserPrincipal {
        private final String name;

        public DefaultUserPrincipal(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultUserPrincipal that = (DefaultUserPrincipal)o;
            return Objects.equals(this.getName(), that.getName());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getName());
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

