/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.time.Duration;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.auth.BasicCredentialsProvider;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemAutomatic;
import org.apache.sshd.sftp.client.fs.SftpFileSystemInitializationContext;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public interface SftpFileSystemClientSessionInitializer {
    public static final SftpFileSystemClientSessionInitializer DEFAULT = new SftpFileSystemClientSessionInitializer(){

        public String toString() {
            return SftpFileSystemClientSessionInitializer.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public ClientSession createClientSession(SftpFileSystemProvider provider2, SftpFileSystemInitializationContext context) throws IOException {
        BasicCredentialsProvider user = context.getCredentials();
        SshClient client2 = provider2.getClientInstance();
        return (ClientSession)((ConnectFuture)client2.connect(user.getUsername(), context.getHost(), context.getPort()).verify(context.getMaxConnectTime())).getSession();
    }

    default public void authenticateClientSession(SftpFileSystemProvider provider2, SftpFileSystemInitializationContext context, ClientSession session2) throws IOException {
        BasicCredentialsProvider passwordHolder = context.getCredentials();
        String password = passwordHolder.getPassword();
        if (password != null) {
            session2.addPasswordIdentity(password);
        }
        session2.auth().verify(context.getMaxAuthTime());
        session2.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, Duration.ofSeconds(10L));
    }

    @Deprecated
    default public SftpFileSystem createSftpFileSystem(SftpFileSystemProvider provider2, SftpFileSystemInitializationContext context, ClientSession session2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        return this.createSftpFileSystem(provider2, context, (Boolean x) -> session2, selector, errorDataHandler);
    }

    default public SftpFileSystem createSftpFileSystem(SftpFileSystemProvider provider2, SftpFileSystemInitializationContext context, IOFunction<Boolean, ClientSession> sessionProvider, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        return new SftpFileSystemAutomatic(provider2, context.getId(), sessionProvider, provider2.getSftpClientFactory(), selector, errorDataHandler);
    }
}

