/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.auth.BasicCredentialsImpl;
import org.apache.sshd.common.auth.MutableBasicCredentials;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.extensions.CopyFileExtension;
import org.apache.sshd.sftp.client.fs.SftpAclFileAttributeView;
import org.apache.sshd.sftp.client.fs.SftpDirectoryStream;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemClientSessionInitializer;
import org.apache.sshd.sftp.client.fs.SftpFileSystemInitializationContext;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.SftpPosixFileAttributeView;
import org.apache.sshd.sftp.client.fs.WithFileAttributeCache;
import org.apache.sshd.sftp.client.impl.SftpRemotePathChannel;
import org.apache.sshd.sftp.common.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpFileSystemProvider
extends FileSystemProvider {
    public static final String VERSION_PARAM = "version";
    public static final Set<Class<? extends FileAttributeView>> UNIVERSAL_SUPPORTED_VIEWS = Collections.unmodifiableSet(GenericUtils.asSet(PosixFileAttributeView.class, FileOwnerAttributeView.class, BasicFileAttributeView.class));
    protected final Logger log;
    private final SshClient clientInstance;
    private final SftpClientFactory factory;
    private final SftpVersionSelector versionSelector;
    private final SftpErrorDataHandler errorDataHandler;
    private final NavigableMap<String, SftpFileSystem> fileSystems = new TreeMap<String, SftpFileSystem>(String.CASE_INSENSITIVE_ORDER);
    private SftpFileSystemClientSessionInitializer fsSessionInitializer = SftpFileSystemClientSessionInitializer.DEFAULT;

    public SftpFileSystemProvider() {
        this((SshClient)null);
    }

    public SftpFileSystemProvider(SftpVersionSelector selector) {
        this(null, selector);
    }

    public SftpFileSystemProvider(SshClient client2) {
        this(client2, SftpVersionSelector.CURRENT);
    }

    public SftpFileSystemProvider(SshClient client2, SftpVersionSelector selector) {
        this(client2, selector, SftpErrorDataHandler.EMPTY);
    }

    public SftpFileSystemProvider(SshClient client2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        this(client2, null, selector, errorDataHandler);
    }

    public SftpFileSystemProvider(SshClient client2, SftpClientFactory factory2, SftpVersionSelector selector) {
        this(client2, factory2, selector, SftpErrorDataHandler.EMPTY);
    }

    public SftpFileSystemProvider(SshClient client2, SftpClientFactory factory2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.factory = factory2;
        this.versionSelector = selector;
        this.errorDataHandler = errorDataHandler;
        if (client2 == null) {
            client2 = SshClient.setUpDefaultClient();
            client2.start();
        }
        this.clientInstance = client2;
    }

    @Override
    public String getScheme() {
        return "sftp";
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.versionSelector;
    }

    public SftpErrorDataHandler getSftpErrorDataHandler() {
        return this.errorDataHandler;
    }

    public final SshClient getClientInstance() {
        return this.clientInstance;
    }

    public SftpClientFactory getSftpClientFactory() {
        return this.factory;
    }

    public SftpFileSystemClientSessionInitializer getSftpFileSystemClientSessionInitializer() {
        return this.fsSessionInitializer;
    }

    public void setSftpFileSystemClientSessionInitializer(SftpFileSystemClientSessionInitializer initializer2) {
        this.fsSessionInitializer = Objects.requireNonNull(initializer2, "No initializer provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SftpFileSystem newFileSystem(URI uri2, Map<String, ?> env) throws IOException {
        MutableBasicCredentials credentials;
        String host2 = ValidateUtils.checkNotNullAndNotEmpty(uri2.getHost(), "Host not provided");
        int port2 = uri2.getPort();
        if (port2 <= 0) {
            port2 = 22;
        }
        ValidateUtils.checkState((credentials = SftpFileSystemProvider.parseCredentials(uri2)) != null, "No credentials provided");
        String username = credentials.getUsername();
        String id = SftpFileSystemProvider.getFileSystemIdentifier(host2, port2, username);
        SftpFileSystemInitializationContext context = new SftpFileSystemInitializationContext(id, uri2, env);
        context.setHost(host2);
        context.setPort(port2);
        context.setCredentials(credentials);
        Map<String, Object> params = SftpFileSystemProvider.resolveFileSystemParameters(env, SftpFileSystemProvider.parseURIParameters(uri2));
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(params);
        context.setPropertyResolver(resolver);
        context.setMaxConnectTime(SftpModuleProperties.CONNECT_TIME.getRequired(resolver));
        context.setMaxAuthTime(SftpModuleProperties.AUTH_TIME.getRequired(resolver));
        SftpVersionSelector selector = this.resolveSftpVersionSelector(uri2, this.getSftpVersionSelector(), resolver);
        SftpErrorDataHandler errorHandler = this.resolveSftpErrorDataHandler(uri2, this.getSftpErrorDataHandler(), resolver);
        Charset decodingCharset = SftpModuleProperties.NAME_DECODER_CHARSET.getRequired(resolver);
        SftpFileSystemClientSessionInitializer initializer2 = this.getSftpFileSystemClientSessionInitializer();
        SftpFileSystem fileSystem = null;
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            if (this.fileSystems.containsKey(id)) {
                throw new FileSystemAlreadyExistsException(id);
            }
            SessionProvider sessionProvider = new SessionProvider(context, params, decodingCharset);
            try {
                fileSystem = initializer2.createSftpFileSystem(this, context, sessionProvider, selector, errorHandler);
                this.fileSystems.put(id, fileSystem);
            }
            catch (Exception e2) {
                if (fileSystem != null) {
                    try {
                        fileSystem.close();
                    }
                    catch (IOException t2) {
                        e2.addSuppressed(t2);
                        LoggingUtils.debug(this.log, "Failed ({}) to close new failed file system on {}}:{} due to {}[{}]: {}", t2.getClass().getSimpleName(), host2, port2, e2.getClass().getSimpleName(), e2.getMessage(), t2.getMessage(), t2);
                    }
                }
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                if (e2 instanceof RuntimeException) {
                    throw (RuntimeException)e2;
                }
                throw new IOException(e2);
            }
        }
        Integer bs = SftpModuleProperties.READ_BUFFER_SIZE.getOrNull(resolver);
        if (bs != null) {
            fileSystem.setReadBufferSize(bs);
        }
        if ((bs = SftpModuleProperties.WRITE_BUFFER_SIZE.getOrNull(resolver)) != null) {
            fileSystem.setWriteBufferSize(bs);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("newFileSystem({}): {}", (Object)uri2.toASCIIString(), (Object)fileSystem);
        }
        return fileSystem;
    }

    protected SftpVersionSelector resolveSftpVersionSelector(URI uri2, SftpVersionSelector defaultSelector, PropertyResolver resolver) {
        String preference = resolver.getString(VERSION_PARAM);
        if (GenericUtils.isEmpty(preference)) {
            return defaultSelector;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveSftpVersionSelector({}) preference={}", (Object)uri2, (Object)preference);
        }
        if ("max".equalsIgnoreCase(preference)) {
            return SftpVersionSelector.MAXIMUM;
        }
        if ("min".equalsIgnoreCase(preference)) {
            return SftpVersionSelector.MINIMUM;
        }
        return SftpVersionSelector.resolveVersionSelector(preference);
    }

    protected SftpErrorDataHandler resolveSftpErrorDataHandler(URI uri2, SftpErrorDataHandler errorHandler, PropertyResolver resolver) {
        return errorHandler;
    }

    public static Map<String, Object> resolveFileSystemParameters(Map<String, ?> env, Map<String, Object> uriParams) {
        if (MapEntryUtils.isEmpty(env)) {
            return MapEntryUtils.isEmpty(uriParams) ? Collections.emptyMap() : uriParams;
        }
        if (MapEntryUtils.isEmpty(uriParams)) {
            return Collections.unmodifiableMap(env);
        }
        TreeMap<String, Object> resolved2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        resolved2.putAll(env);
        resolved2.putAll(uriParams);
        return resolved2;
    }

    public static MutableBasicCredentials parseCredentials(URI uri2) {
        return SftpFileSystemProvider.parseCredentials(uri2 == null ? "" : uri2.getUserInfo());
    }

    public static MutableBasicCredentials parseCredentials(String userInfo) {
        if (GenericUtils.isEmpty(userInfo)) {
            return null;
        }
        int pos = userInfo.indexOf(58);
        if (pos < 0) {
            return new BasicCredentialsImpl(userInfo, null);
        }
        return new BasicCredentialsImpl(userInfo.substring(0, pos), userInfo.substring(pos + 1));
    }

    public static Map<String, Object> parseURIParameters(URI uri2) {
        return SftpFileSystemProvider.parseURIParameters(uri2 == null ? "" : uri2.getQuery());
    }

    public static Map<String, Object> parseURIParameters(String params) {
        if (GenericUtils.isEmpty(params)) {
            return Collections.emptyMap();
        }
        if (params.charAt(0) == '?') {
            if (params.length() == 1) {
                return Collections.emptyMap();
            }
            params = params.substring(1);
        }
        String[] pairs2 = GenericUtils.split(params, '&');
        TreeMap<String, Object> map2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (String p : pairs2) {
            int pos = p.indexOf(61);
            if (pos < 0) {
                map2.put(p, Boolean.TRUE);
                continue;
            }
            String key2 = p.substring(0, pos);
            String value2 = p.substring(pos + 1);
            if (NumberUtils.isIntegerNumber(value2)) {
                map2.put(key2, Long.valueOf(value2));
                continue;
            }
            if ("true".equals(value2) || "false".equals("value")) {
                map2.put(key2, Boolean.valueOf(value2));
                continue;
            }
            map2.put(key2, value2);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem newFileSystem(ClientSession session2) throws IOException {
        Integer wbs;
        SftpFileSystem fileSystem;
        String id = SftpFileSystemProvider.getFileSystemIdentifier(session2);
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            if (this.fileSystems.containsKey(id)) {
                throw new FileSystemAlreadyExistsException(id);
            }
            fileSystem = new SftpFileSystem(this, id, session2, this.factory, this.getSftpVersionSelector(), this.getSftpErrorDataHandler());
            this.fileSystems.put(id, fileSystem);
        }
        Integer rbs = session2.getInteger(SftpModuleProperties.READ_BUFFER_SIZE.getName());
        if (rbs != null) {
            fileSystem.setReadBufferSize(rbs);
        }
        if ((wbs = session2.getInteger(SftpModuleProperties.WRITE_BUFFER_SIZE.getName())) != null) {
            fileSystem.setWriteBufferSize(wbs);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("newFileSystem: {}", (Object)fileSystem);
        }
        return fileSystem;
    }

    @Override
    public FileSystem getFileSystem(URI uri2) {
        String id = SftpFileSystemProvider.getFileSystemIdentifier(uri2);
        SftpFileSystem fs = this.getFileSystem(id);
        if (fs == null) {
            throw new FileSystemNotFoundException(id);
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem removeFileSystem(String id) {
        SftpFileSystem removed;
        if (GenericUtils.isEmpty(id)) {
            return null;
        }
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            removed = (SftpFileSystem)this.fileSystems.remove(id);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeFileSystem({}): {}", (Object)id, (Object)removed);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileSystem getFileSystem(String id) {
        if (GenericUtils.isEmpty(id)) {
            return null;
        }
        NavigableMap<String, SftpFileSystem> navigableMap = this.fileSystems;
        synchronized (navigableMap) {
            return (SftpFileSystem)this.fileSystems.get(id);
        }
    }

    @Override
    public Path getPath(URI uri2) {
        FileSystem fs = this.getFileSystem(uri2);
        return fs.getPath(uri2.getPath(), new String[0]);
    }

    @Override
    public FileChannel newByteChannel(Path path2, Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(path2, options2, attrs);
    }

    @Override
    public FileChannel newFileChannel(Path path2, Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) throws IOException {
        boolean writable;
        Set<SftpClient.OpenMode> modes = SftpClient.OpenMode.fromOpenOptions(options2);
        boolean readable = modes.contains((Object)SftpClient.OpenMode.Read);
        boolean bl = writable = modes.contains((Object)SftpClient.OpenMode.Write) || modes.contains((Object)SftpClient.OpenMode.Append);
        if (!readable && !writable) {
            modes.add(SftpClient.OpenMode.Read);
        } else if (modes.contains((Object)SftpClient.OpenMode.Append)) {
            if (modes.contains((Object)SftpClient.OpenMode.Truncate)) {
                throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
            }
            if (modes.contains((Object)SftpClient.OpenMode.Read)) {
                throw new IllegalArgumentException("APPEND + READ not allowed");
            }
        }
        if (!writable) {
            modes.remove((Object)SftpClient.OpenMode.Truncate);
            modes.remove((Object)SftpClient.OpenMode.Create);
            modes.remove((Object)SftpClient.OpenMode.Exclusive);
        }
        SftpPath p = this.toSftpPath(path2);
        return new SftpRemotePathChannel(p.toString(), ((SftpFileSystem)p.getFileSystem()).getClient(), true, modes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream newInputStream(Path path2, OpenOption ... options2) throws IOException {
        Set<SftpClient.OpenMode> modes = SftpClient.OpenMode.fromOpenOptions(Arrays.asList(options2));
        if (modes.contains((Object)SftpClient.OpenMode.Write) || modes.contains((Object)SftpClient.OpenMode.Append)) {
            throw new IllegalArgumentException("WRITE or APPEND not allowed");
        }
        modes = EnumSet.of(SftpClient.OpenMode.Read);
        SftpPath p = this.toSftpPath(path2);
        try (SftpClient client2 = ((SftpFileSystem)p.getFileSystem()).getClient();){
            final SftpClient inner = client2;
            FilterInputStream result2 = new FilterInputStream(client2.read(p.toString(), modes)){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        inner.close();
                    }
                }
            };
            client2 = null;
            FilterInputStream filterInputStream = result2;
            return filterInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream newOutputStream(Path path2, OpenOption ... options2) throws IOException {
        Set<SftpClient.OpenMode> modes = SftpClient.OpenMode.fromOpenOptions(Arrays.asList(options2));
        if (modes.contains((Object)SftpClient.OpenMode.Read)) {
            throw new IllegalArgumentException("READ not allowed");
        }
        if (modes.isEmpty()) {
            modes = EnumSet.of(SftpClient.OpenMode.Create, SftpClient.OpenMode.Truncate, SftpClient.OpenMode.Write);
        } else if (modes.contains((Object)SftpClient.OpenMode.Append)) {
            if (modes.contains((Object)SftpClient.OpenMode.Truncate)) {
                throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
            }
        } else {
            modes.add(SftpClient.OpenMode.Write);
        }
        SftpPath p = this.toSftpPath(path2);
        try (SftpClient client2 = ((SftpFileSystem)p.getFileSystem()).getClient();){
            final SftpClient inner = client2;
            FilterOutputStream result2 = new FilterOutputStream(client2.write(p.toString(), modes)){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        inner.close();
                    }
                }

                @Override
                public void write(byte[] b2, int off, int len2) throws IOException {
                    this.out.write(b2, off, len2);
                }
            };
            client2 = null;
            FilterOutputStream filterOutputStream = result2;
            return filterOutputStream;
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
        SftpPath p = this.toSftpPath(dir);
        return new SftpDirectoryStream(p, filter2);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        SftpPath p = this.toSftpPath(dir);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectory({}) {} ({})", fs, dir, Arrays.asList(attrs));
        }
        try (SftpClient sftp = fs.getClient();){
            try {
                sftp.mkdir(dir.toString());
            }
            catch (SftpException e2) {
                int sftpStatus = e2.getStatus();
                if (sftp.getVersion() == 3 && sftpStatus == 4) {
                    try {
                        SftpClient.Attributes attributes2 = sftp.stat(dir.toString());
                        if (attributes2 != null) {
                            throw new FileAlreadyExistsException(p.toString());
                        }
                    }
                    catch (SshException e22) {
                        e2.addSuppressed(e22);
                    }
                }
                if (sftpStatus == 11) {
                    throw new FileAlreadyExistsException(p.toString());
                }
                throw e2;
            }
            for (FileAttribute<?> attr : attrs) {
                this.setAttribute((Path)p, attr.name(), attr.value(), new LinkOption[0]);
            }
        }
    }

    @Override
    public void delete(Path path2) throws IOException {
        SftpPath p = this.toSftpPath(path2);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (this.log.isDebugEnabled()) {
            this.log.debug("delete({}) {}", (Object)fs, (Object)path2);
        }
        if (fs.isReadOnly()) {
            throw new AccessDeniedException("Filesystem is read-only: " + path2.toString());
        }
        BasicFileAttributes attributes2 = this.readAttributes(path2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        try (SftpClient sftp = fs.getClient();){
            if (attributes2.isDirectory()) {
                sftp.rmdir(path2.toString());
            } else {
                sftp.remove(path2.toString());
            }
        }
    }

    @Override
    public void copy(Path source2, Path target, CopyOption ... options2) throws IOException {
        BasicFileAttributes attrs;
        LinkOption[] linkOptions;
        boolean copyAttributes;
        block34: {
            SftpPath src = this.toSftpPath(source2);
            SftpPath dst = this.toSftpPath(target);
            if (src.getFileSystem() != dst.getFileSystem()) {
                throw new ProviderMismatchException("Mismatched file system providers for " + src + " vs. " + dst);
            }
            this.checkAccess(src, new AccessMode[0]);
            boolean replaceExisting = false;
            copyAttributes = false;
            boolean noFollowLinks = false;
            for (CopyOption opt : options2) {
                replaceExisting |= opt == StandardCopyOption.REPLACE_EXISTING;
                copyAttributes |= opt == StandardCopyOption.COPY_ATTRIBUTES;
                noFollowLinks |= opt == LinkOption.NOFOLLOW_LINKS;
            }
            linkOptions = IoUtils.getLinkOptions(!noFollowLinks);
            attrs = this.readAttributes(source2, BasicFileAttributes.class, linkOptions);
            if (attrs.isSymbolicLink()) {
                throw new IOException("Copying of symbolic links not supported");
            }
            Boolean status2 = IoUtils.checkFileExistsAnySymlinks(target, noFollowLinks);
            if (status2 == null) {
                throw new AccessDeniedException("Existence cannot be determined for copy target: " + target);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("copy({})[{}] {} => {}", src.getFileSystem(), Arrays.asList(options2), src, dst);
            }
            if (replaceExisting) {
                this.deleteIfExists(target);
            } else if (status2.booleanValue()) {
                throw new FileAlreadyExistsException(target.toString());
            }
            if (attrs.isDirectory()) {
                this.createDirectory(target, new FileAttribute[0]);
            } else {
                try (SftpClient client2 = ((SftpFileSystem)src.getFileSystem()).getClient();){
                    CopyFileExtension copyFile = client2.getExtension(CopyFileExtension.class);
                    if (copyFile.isSupported()) {
                        copyFile.copyFile(source2.toString(), target.toString(), false);
                        break block34;
                    }
                    try (InputStream in = this.newInputStream(source2, new OpenOption[0]);
                         OutputStream os = this.newOutputStream(target, new OpenOption[0]);){
                        IoUtils.copy(in, os);
                    }
                }
            }
        }
        if (copyAttributes) {
            BasicFileAttributeView view = this.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    this.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    @Override
    public void move(Path source2, Path target, CopyOption ... options2) throws IOException {
        SftpPath src = this.toSftpPath(source2);
        SftpFileSystem fsSrc = (SftpFileSystem)src.getFileSystem();
        SftpPath dst = this.toSftpPath(target);
        if (src.getFileSystem() != dst.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + src + " vs. " + dst);
        }
        this.checkAccess(src, new AccessMode[0]);
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean noFollowLinks = false;
        for (CopyOption opt : options2) {
            replaceExisting |= opt == StandardCopyOption.REPLACE_EXISTING;
            copyAttributes |= opt == StandardCopyOption.COPY_ATTRIBUTES;
            noFollowLinks |= opt == LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = IoUtils.getLinkOptions(noFollowLinks);
        BasicFileAttributes attrs = this.readAttributes(source2, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Moving of source symbolic link (" + source2 + ") to " + target + " not supported");
        }
        Boolean status2 = IoUtils.checkFileExistsAnySymlinks(target, noFollowLinks);
        if (status2 == null) {
            throw new AccessDeniedException("Existence cannot be determined for move target " + target);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("move({})[{}] {} => {}", src.getFileSystem(), Arrays.asList(options2), src, dst);
        }
        if (replaceExisting) {
            this.deleteIfExists(target);
        } else if (status2.booleanValue()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        try (SftpClient sftp = fsSrc.getClient();){
            sftp.rename(src.toString(), dst.toString());
        }
        if (copyAttributes) {
            BasicFileAttributeView view = this.getFileAttributeView(target, BasicFileAttributeView.class, linkOptions);
            try {
                view.setTimes(attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime());
            }
            catch (Throwable x) {
                try {
                    this.delete(target);
                }
                catch (Throwable suppressed) {
                    x.addSuppressed(suppressed);
                }
                throw x;
            }
        }
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        SftpPath p1 = this.toSftpPath(path1);
        SftpPath p2 = this.toSftpPath(path2);
        if (p1.getFileSystem() != p2.getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + p1 + " vs. " + p2);
        }
        this.checkAccess(p1, new AccessMode[0]);
        this.checkAccess(p2, new AccessMode[0]);
        return p1.equals(p2);
    }

    @Override
    public boolean isHidden(Path path2) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path2) throws IOException {
        FileSystem fs = path2.getFileSystem();
        if (!(fs instanceof SftpFileSystem)) {
            throw new FileSystemException(path2.toString(), path2.toString(), "getFileStore(" + path2 + ") path not attached to an SFTP file system");
        }
        SftpFileSystem sftpFs = (SftpFileSystem)fs;
        String id = sftpFs.getId();
        SftpFileSystem cached = this.getFileSystem(id);
        if (cached != sftpFs) {
            throw new FileSystemException(path2.toString(), path2.toString(), "Mismatched file system instance for id=" + id);
        }
        return (FileStore)sftpFs.getFileStores().get(0);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        SftpPath t2;
        SftpPath l = this.toSftpPath(link);
        SftpFileSystem fsLink = (SftpFileSystem)l.getFileSystem();
        if (fsLink != (t2 = this.toSftpPath(target)).getFileSystem()) {
            throw new ProviderMismatchException("Mismatched file system providers for " + l + " vs. " + t2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSymbolicLink({})[{}] {} => {}", fsLink, Arrays.asList(attrs), link, target);
        }
        try (SftpClient client2 = fsLink.getClient();){
            client2.symLink(l.toString(), t2.toString());
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        SftpPath l = this.toSftpPath(link);
        SftpFileSystem fsLink = (SftpFileSystem)l.getFileSystem();
        try (SftpClient client2 = fsLink.getClient();){
            String linkPath = client2.readLink(l.toString());
            if (this.log.isDebugEnabled()) {
                this.log.debug("readSymbolicLink({}) {} => {}", fsLink, link, linkPath);
            }
            Object t2 = fsLink.getPath(linkPath, new String[0]);
            return t2;
        }
    }

    @Override
    public void checkAccess(Path path2, AccessMode ... modes) throws IOException {
        BasicFileAttributes attrs;
        SftpPath p = this.toSftpPath(path2);
        boolean w = false;
        boolean x = false;
        if (GenericUtils.length(modes) > 0) {
            block5: for (AccessMode mode : modes) {
                switch (mode) {
                    case READ: {
                        continue block5;
                    }
                    case WRITE: {
                        w = true;
                        continue block5;
                    }
                    case EXECUTE: {
                        x = true;
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported mode: " + (Object)((Object)mode));
                    }
                }
            }
        }
        if (!((attrs = this.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes()) != null || p.isAbsolute() && p.getNameCount() == 0)) {
            throw new NoSuchFileException(path2.toString());
        }
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        if (x || w && fs.isReadOnly()) {
            throw new AccessDeniedException("Filesystem is read-only: " + path2.toString());
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path2, Class<V> type2, LinkOption ... options2) {
        if (this.isSupportedFileAttributeView(path2, type2)) {
            if (AclFileAttributeView.class.isAssignableFrom(type2)) {
                return (V)((FileAttributeView)type2.cast(new SftpAclFileAttributeView(this, path2, options2)));
            }
            if (BasicFileAttributeView.class.isAssignableFrom(type2)) {
                return (V)((FileAttributeView)type2.cast(new SftpPosixFileAttributeView(this, path2, options2)));
            }
        }
        throw new UnsupportedOperationException("getFileAttributeView(" + path2 + ") view not supported: " + type2.getSimpleName());
    }

    public boolean isSupportedFileAttributeView(Path path2, Class<? extends FileAttributeView> type2) {
        return this.isSupportedFileAttributeView((SftpFileSystem)this.toSftpPath(path2).getFileSystem(), type2);
    }

    public boolean isSupportedFileAttributeView(SftpFileSystem fs, Class<? extends FileAttributeView> type2) {
        Set<String> views = fs.supportedFileAttributeViews();
        if (type2 == null || GenericUtils.isEmpty(views)) {
            return false;
        }
        if (PosixFileAttributeView.class.isAssignableFrom(type2)) {
            return views.contains("posix");
        }
        if (AclFileAttributeView.class.isAssignableFrom(type2)) {
            return views.contains("acl");
        }
        if (FileOwnerAttributeView.class.isAssignableFrom(type2)) {
            return views.contains("owner");
        }
        if (BasicFileAttributeView.class.isAssignableFrom(type2)) {
            return views.contains("basic");
        }
        return false;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path2, Class<A> type2, LinkOption ... options2) throws IOException {
        if (type2.isAssignableFrom(PosixFileAttributes.class)) {
            return (A)((BasicFileAttributes)type2.cast(this.getFileAttributeView(path2, PosixFileAttributeView.class, options2).readAttributes()));
        }
        throw new UnsupportedOperationException("readAttributes(" + path2 + ")[" + type2.getSimpleName() + "] N/A");
    }

    @Override
    public Map<String, Object> readAttributes(Path path2, String attributes2, LinkOption ... options2) throws IOException {
        String attrs;
        String view;
        int i2 = attributes2.indexOf(58);
        if (i2 == -1) {
            view = "basic";
            attrs = attributes2;
        } else {
            view = attributes2.substring(0, i2++);
            attrs = attributes2.substring(i2);
        }
        return this.readAttributes(path2, view, attrs, options2);
    }

    public Map<String, Object> readAttributes(Path path2, String view, String attrs, LinkOption ... options2) throws IOException {
        SftpPath p = this.toSftpPath(path2);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (GenericUtils.isEmpty(views) || !views.contains(view)) {
            throw new UnsupportedOperationException("readAttributes(" + path2 + ")[" + view + ":" + attrs + "] view not supported: " + views);
        }
        if ("basic".equalsIgnoreCase(view) || "posix".equalsIgnoreCase(view) || "owner".equalsIgnoreCase(view)) {
            return this.readPosixViewAttributes(p, view, attrs, options2);
        }
        if ("acl".equalsIgnoreCase(view)) {
            return this.readAclViewAttributes(p, view, attrs, options2);
        }
        return this.readCustomViewAttributes(p, view, attrs, options2);
    }

    protected Map<String, Object> readCustomViewAttributes(SftpPath path2, String view, String attrs, LinkOption ... options2) throws IOException {
        throw new UnsupportedOperationException("readCustomViewAttributes(" + path2 + ")[" + view + ":" + attrs + "] view not supported");
    }

    protected NavigableMap<String, Object> readAclViewAttributes(SftpPath path2, String view, String attrs, LinkOption ... options2) throws IOException {
        SftpClient.Attributes attributes2;
        if ("*".equals(attrs)) {
            attrs = "acl,owner";
        }
        SftpFileSystem fs = (SftpFileSystem)path2.getFileSystem();
        try (SftpClient client2 = fs.getClient();){
            attributes2 = this.readRemoteAttributes(path2, options2);
        }
        TreeMap<String, Object> map2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String[] attrValues = GenericUtils.split(attrs, ',');
        boolean traceEnabled = this.log.isTraceEnabled();
        String[] stringArray = attrValues;
        int n = stringArray.length;
        block13: for (int i2 = 0; i2 < n; ++i2) {
            String attr;
            switch (attr = stringArray[i2]) {
                case "acl": {
                    List<AclEntry> acl = attributes2.getAcl();
                    if (acl == null) continue block13;
                    map2.put(attr, acl);
                    continue block13;
                }
                case "owner": {
                    String owner = attributes2.getOwner();
                    if (GenericUtils.length(owner) <= 0) continue block13;
                    map2.put(attr, new SftpFileSystem.DefaultUserPrincipal(owner));
                    continue block13;
                }
                default: {
                    if (!traceEnabled) continue block13;
                    this.log.trace("readAclViewAttributes({})[{}] unknown attribute: {}", fs, attrs, attr);
                }
            }
        }
        return map2;
    }

    public SftpClient.Attributes readRemoteAttributes(SftpPath path2, LinkOption ... options2) throws IOException {
        return WithFileAttributeCache.withAttributeCache(path2, p -> this.resolveRemoteFileAttributes(path2, options2));
    }

    protected SftpClient.Attributes resolveRemoteFileAttributes(SftpPath path2, LinkOption ... options2) throws IOException {
        SftpClient.Attributes attributes2;
        block12: {
            SftpClient.Attributes attributes3 = path2.getAttributes();
            if (attributes3 != null) {
                return attributes3;
            }
            SftpFileSystem fs = (SftpFileSystem)path2.getFileSystem();
            SftpClient client2 = fs.getClient();
            try {
                SftpClient.Attributes attrs = IoUtils.followLinks(options2) ? client2.stat(path2.toString()) : client2.lstat(path2.toString());
                if (this.log.isTraceEnabled()) {
                    this.log.trace("resolveRemoteFileAttributes({})[{}]: {}", fs, path2, attrs);
                }
                if (path2 instanceof WithFileAttributeCache) {
                    ((WithFileAttributeCache)((Object)path2)).setAttributes(attrs);
                }
                attributes2 = attrs;
                if (client2 == null) break block12;
            }
            catch (Throwable attrs) {
                try {
                    if (client2 != null) {
                        try {
                            client2.close();
                        }
                        catch (Throwable throwable) {
                            attrs.addSuppressed(throwable);
                        }
                    }
                    throw attrs;
                }
                catch (SftpException e2) {
                    if (e2.getStatus() == 2) {
                        NoSuchFileException toThrow = new NoSuchFileException(path2.toString());
                        toThrow.initCause(e2);
                        throw toThrow;
                    }
                    throw e2;
                }
            }
            client2.close();
        }
        return attributes2;
    }

    protected NavigableMap<String, Object> readPosixViewAttributes(SftpPath path2, String view, String attrs, LinkOption ... options2) throws IOException {
        String[] attrValues;
        PosixFileAttributes v = this.readAttributes((Path)path2, PosixFileAttributes.class, options2);
        if ("*".equals(attrs)) {
            attrs = "lastModifiedTime,lastAccessTime,creationTime,size,isRegularFile,isDirectory,isSymbolicLink,isOther,fileKey,owner,group,permissions,fileKey";
        }
        TreeMap<String, Object> map2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        boolean traceEnabled = this.log.isTraceEnabled();
        String[] stringArray = attrValues = GenericUtils.split(attrs, ',');
        int n = stringArray.length;
        block28: for (int i2 = 0; i2 < n; ++i2) {
            String attr;
            switch (attr = stringArray[i2]) {
                case "lastModifiedTime": {
                    map2.put(attr, v.lastModifiedTime());
                    continue block28;
                }
                case "lastAccessTime": {
                    map2.put(attr, v.lastAccessTime());
                    continue block28;
                }
                case "creationTime": {
                    map2.put(attr, v.creationTime());
                    continue block28;
                }
                case "size": {
                    map2.put(attr, v.size());
                    continue block28;
                }
                case "isRegularFile": {
                    map2.put(attr, v.isRegularFile());
                    continue block28;
                }
                case "isDirectory": {
                    map2.put(attr, v.isDirectory());
                    continue block28;
                }
                case "isSymbolicLink": {
                    map2.put(attr, v.isSymbolicLink());
                    continue block28;
                }
                case "isOther": {
                    map2.put(attr, v.isOther());
                    continue block28;
                }
                case "fileKey": {
                    map2.put(attr, v.fileKey());
                    continue block28;
                }
                case "owner": {
                    map2.put(attr, v.owner());
                    continue block28;
                }
                case "permissions": {
                    map2.put(attr, v.permissions());
                    continue block28;
                }
                case "group": {
                    map2.put(attr, v.group());
                    continue block28;
                }
                default: {
                    if (!traceEnabled) continue block28;
                    this.log.trace("readPosixViewAttributes({})[{}:{}] ignored for {}", path2, view, attr, attrs);
                }
            }
        }
        return map2;
    }

    @Override
    public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options2) throws IOException {
        String attr;
        String view;
        int i2 = attribute.indexOf(58);
        if (i2 == -1) {
            view = "basic";
            attr = attribute;
        } else {
            view = attribute.substring(0, i2++);
            attr = attribute.substring(i2);
        }
        this.setAttribute(path2, view, attr, value2, options2);
    }

    public void setAttribute(Path path2, String view, String attr, Object value2, LinkOption ... options2) throws IOException {
        SftpPath p = this.toSftpPath(path2);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (GenericUtils.isEmpty(views) || !views.contains(view)) {
            throw new UnsupportedOperationException("setAttribute(" + path2 + ")[" + view + ":" + attr + "=" + value2 + "] view " + view + " not supported: " + views);
        }
        SftpClient.Attributes attributes2 = new SftpClient.Attributes();
        switch (attr) {
            case "lastModifiedTime": {
                attributes2.modifyTime((int)((FileTime)value2).to(TimeUnit.SECONDS));
                break;
            }
            case "lastAccessTime": {
                attributes2.accessTime((int)((FileTime)value2).to(TimeUnit.SECONDS));
                break;
            }
            case "creationTime": {
                attributes2.createTime((int)((FileTime)value2).to(TimeUnit.SECONDS));
                break;
            }
            case "size": {
                attributes2.size(((Number)value2).longValue());
                break;
            }
            case "permissions": {
                Set attrSet = (Set)value2;
                attributes2.perms(this.attributesToPermissions(path2, attrSet));
                break;
            }
            case "owner": {
                attributes2.owner(((UserPrincipal)value2).getName());
                break;
            }
            case "group": {
                attributes2.group(((GroupPrincipal)value2).getName());
                break;
            }
            case "acl": {
                ValidateUtils.checkTrue("acl".equalsIgnoreCase(view), "ACL cannot be set via view=%s", (Object)view);
                List acl = (List)value2;
                attributes2.acl(acl);
                break;
            }
            case "isRegularFile": 
            case "isDirectory": 
            case "isSymbolicLink": 
            case "isOther": 
            case "fileKey": {
                throw new UnsupportedOperationException("setAttribute(" + path2 + ")[" + view + ":" + attr + "=" + value2 + "] modification N/A");
            }
            default: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace("setAttribute({})[{}] ignore {}:{}={}", fs, path2, view, attr, value2);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setAttribute({}) {}: {}", fs, path2, attributes2);
        }
        try (SftpClient client2 = fs.getClient();){
            client2.setStat(p.toString(), attributes2);
        }
    }

    public SftpPath toSftpPath(Path path2) {
        Objects.requireNonNull(path2, "No path provided");
        if (!(path2 instanceof SftpPath)) {
            throw new ProviderMismatchException("Path is not SFTP: " + path2);
        }
        return (SftpPath)path2;
    }

    protected int attributesToPermissions(Path path2, Collection<PosixFilePermission> perms) {
        if (GenericUtils.isEmpty(perms)) {
            return 0;
        }
        int pf = 0;
        boolean traceEnabled = this.log.isTraceEnabled();
        block11: for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    continue block11;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    continue block11;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    continue block11;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    continue block11;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    continue block11;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    continue block11;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    continue block11;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    continue block11;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    continue block11;
                }
            }
            if (!traceEnabled) continue;
            this.log.trace("attributesToPermissions({}) ignored {}", (Object)path2, (Object)p);
        }
        return pf;
    }

    public static String getRWXPermissions(int perms) {
        StringBuilder sb = new StringBuilder(10);
        if ((perms & 0xA000) == 40960) {
            sb.append('l');
        } else if ((perms & 0x4000) == 16384) {
            sb.append('d');
        } else {
            sb.append('-');
        }
        if ((perms & 0x100) == 256) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 0x80) == 128) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 0x40) == 64) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        if ((perms & 0x20) == 32) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 0x10) == 16) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 8) == 8) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        if ((perms & 4) == 4) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((perms & 2) == 2) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((perms & 1) == 1) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getOctalPermissions(int perms) {
        Set<PosixFilePermission> attrs = SftpFileSystemProvider.permissionsToAttributes(perms);
        return SftpFileSystemProvider.getOctalPermissions(attrs);
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) == 256) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) == 128) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) == 64) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) == 32) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) == 16) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) == 8) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) == 4) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) == 2) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) == 1) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static String getOctalPermissions(Collection<PosixFilePermission> perms) {
        int pf = 0;
        for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    break;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    break;
                }
            }
        }
        return String.format("%04o", pf);
    }

    public static String getFileSystemIdentifier(URI uri2) {
        String userInfo = ValidateUtils.checkNotNullAndNotEmpty(uri2.getUserInfo(), "UserInfo not provided");
        String[] ui = GenericUtils.split(userInfo, ':');
        ValidateUtils.checkTrue(GenericUtils.length(ui) == 2, "Invalid user info: %s", (Object)userInfo);
        return SftpFileSystemProvider.getFileSystemIdentifier(uri2.getHost(), uri2.getPort(), ui[0]);
    }

    public static String getFileSystemIdentifier(ClientSession session2) {
        IoSession ioSession = session2.getIoSession();
        SocketAddress addr = ioSession.getRemoteAddress();
        String username = session2.getUsername();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress inetAddr = (InetSocketAddress)addr;
            return SftpFileSystemProvider.getFileSystemIdentifier(inetAddr.getHostString(), inetAddr.getPort(), username);
        }
        return SftpFileSystemProvider.getFileSystemIdentifier(addr.toString(), 22, username);
    }

    public static String getFileSystemIdentifier(String host2, int port2, String username) {
        return GenericUtils.trimToEmpty(host2) + ':' + SshConstants.TO_EFFECTIVE_PORT.applyAsInt(port2) + ':' + GenericUtils.trimToEmpty(username);
    }

    public static URI createFileSystemURI(String host2, int port2, String username, String password) {
        return SftpFileSystemProvider.createFileSystemURI(host2, port2, username, password, Collections.emptyMap());
    }

    public static URI createFileSystemURI(String host2, int port2, String username, String password, Map<String, ?> params) {
        ValidateUtils.checkNotNullAndNotEmpty(host2, "No host provided");
        String queryPart = null;
        int numParams = MapEntryUtils.size(params);
        if (numParams > 0) {
            StringBuilder sb = new StringBuilder(numParams * 16);
            for (Map.Entry<String, ?> pe : params.entrySet()) {
                String key2 = pe.getKey();
                Object value2 = pe.getValue();
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(key2);
                if (value2 == null) continue;
                sb.append('=').append(Objects.toString(value2, null));
            }
            queryPart = sb.toString();
        }
        try {
            String userAuth = SftpFileSystemProvider.encodeCredentials(username, password);
            return new URI("sftp", userAuth, host2, port2, "/", queryPart, null);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException("Failed (" + e2.getClass().getSimpleName() + ") to create access URI: " + e2.getMessage(), e2);
        }
    }

    public static String encodeCredentials(String username, String password) {
        ValidateUtils.hasContent(username, "No username provided");
        ValidateUtils.checkTrue(username.indexOf(58) < 0 && (password == null || password.indexOf(58) < 0), "Reserved character used in credentials");
        if (password == null) {
            return username;
        }
        return username + ":" + password;
    }

    private class SessionProvider
    implements IOFunction<Boolean, ClientSession> {
        private final SftpFileSystemInitializationContext context;
        private final Map<String, ?> params;
        private final Charset decodingCharset;
        private AtomicReference<ClientSession> currentSession = new AtomicReference();

        SessionProvider(SftpFileSystemInitializationContext context, Map<String, ?> params, Charset decodingCharset) {
            this.context = Objects.requireNonNull(context);
            this.params = Objects.requireNonNull(params);
            this.decodingCharset = Objects.requireNonNull(decodingCharset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientSession apply(Boolean create2) throws IOException {
            SessionProvider sessionProvider = this;
            synchronized (sessionProvider) {
                ClientSession session2 = this.currentSession.get();
                if ((session2 == null || !session2.isOpen()) && Boolean.TRUE.equals(create2)) {
                    session2 = this.create();
                    this.currentSession.set(session2);
                }
                return session2;
            }
        }

        private ClientSession create() throws IOException {
            SftpFileSystemClientSessionInitializer initializer2 = SftpFileSystemProvider.this.getSftpFileSystemClientSessionInitializer();
            ClientSession session2 = null;
            try {
                final ClientSession mySelf = session2 = initializer2.createClientSession(SftpFileSystemProvider.this, this.context);
                this.params.forEach((key2, value2) -> {
                    if (!SftpFileSystemProvider.VERSION_PARAM.equalsIgnoreCase((String)key2)) {
                        PropertyResolverUtils.updateProperty((PropertyResolver)mySelf, key2, value2);
                    }
                });
                SftpModuleProperties.NAME_DECODING_CHARSET.set(session2, this.decodingCharset);
                initializer2.authenticateClientSession(SftpFileSystemProvider.this, this.context, session2);
                session2.setAttribute(SftpFileSystem.OWNED_SESSION, Boolean.TRUE);
                session2.addSessionListener(new SessionListener(){

                    @Override
                    public void sessionClosed(Session s2) {
                        if (mySelf == s2) {
                            SessionProvider.this.currentSession.compareAndSet(mySelf, null);
                        }
                    }
                });
                return session2;
            }
            catch (Exception e2) {
                if (session2 != null) {
                    try {
                        session2.close();
                    }
                    catch (IOException t2) {
                        e2.addSuppressed(t2);
                        LoggingUtils.debug(SftpFileSystemProvider.this.log, "Failed ({}) to close session for new file system on {}}:{} due to {}[{}]: {}", t2.getClass().getSimpleName(), this.context.getHost(), this.context.getPort(), e2.getClass().getSimpleName(), e2.getMessage(), t2.getMessage(), t2);
                    }
                }
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                if (e2 instanceof RuntimeException) {
                    throw (RuntimeException)e2;
                }
                throw new IOException(e2);
            }
        }
    }
}

