/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.DirectoryScanner;

public class SftpPathDirectoryScanner
extends DirectoryScanner {
    public SftpPathDirectoryScanner() {
        this(true);
    }

    public SftpPathDirectoryScanner(boolean caseSensitive) {
        this.setSeparator("/");
        this.setCaseSensitive(caseSensitive);
    }

    public SftpPathDirectoryScanner(Path dir) {
        this(dir, Collections.emptyList());
    }

    public SftpPathDirectoryScanner(Path dir, String ... includes) {
        this(dir, GenericUtils.isEmpty(includes) ? Collections.emptyList() : Arrays.asList(includes));
    }

    public SftpPathDirectoryScanner(Path dir, Collection<String> includes) {
        this();
        this.setBasedir(dir);
        this.setIncludes(includes);
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public void setSeparator(String separator) {
        ValidateUtils.checkState("/".equals(separator), "Invalid separator: '%s'", (Object)separator);
        super.setSeparator(separator);
    }

    @Override
    public void setIncludes(Collection<String> includes) {
        this.includePatterns = GenericUtils.isEmpty(includes) ? Collections.emptyList() : Collections.unmodifiableList(includes.stream().map(SftpPathDirectoryScanner::adjustPattern).collect(Collectors.toCollection(() -> new ArrayList(includes.size()))));
    }

    public static String adjustPattern(String pattern2) {
        if (!(pattern2 = pattern2.trim()).startsWith("%regex[") && pattern2.endsWith("/")) {
            return pattern2 + "**";
        }
        return pattern2;
    }
}

