/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public class SftpPosixFileAttributes
implements PosixFileAttributes {
    private final Path path;
    private final SftpClient.Attributes attributes;

    public SftpPosixFileAttributes(Path path2, SftpClient.Attributes attributes2) {
        this.path = path2;
        this.attributes = attributes2;
    }

    public final Path getPath() {
        return this.path;
    }

    @Override
    public UserPrincipal owner() {
        String owner = this.attributes.getOwner();
        return GenericUtils.isEmpty(owner) ? null : new SftpFileSystem.DefaultUserPrincipal(owner);
    }

    @Override
    public GroupPrincipal group() {
        String group = this.attributes.getGroup();
        return GenericUtils.isEmpty(group) ? null : new SftpFileSystem.DefaultGroupPrincipal(group);
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        return SftpFileSystemProvider.permissionsToAttributes(this.attributes.getPermissions());
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.attributes.getModifyTime();
    }

    @Override
    public FileTime lastAccessTime() {
        return this.attributes.getAccessTime();
    }

    @Override
    public FileTime creationTime() {
        return this.attributes.getCreateTime();
    }

    @Override
    public boolean isRegularFile() {
        return this.attributes.isRegularFile();
    }

    @Override
    public boolean isDirectory() {
        return this.attributes.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.attributes.isSymbolicLink();
    }

    @Override
    public boolean isOther() {
        return this.attributes.isOther();
    }

    @Override
    public long size() {
        return this.attributes.getSize();
    }

    @Override
    public Object fileKey() {
        return null;
    }
}

