/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.subsystem.AbstractSubsystemClient;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.FullAccessSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.extensions.BuiltinSftpClientExtensions;
import org.apache.sshd.sftp.client.extensions.SftpClientExtension;
import org.apache.sshd.sftp.client.extensions.SftpClientExtensionFactory;
import org.apache.sshd.sftp.client.impl.DefaultCloseableHandle;
import org.apache.sshd.sftp.client.impl.SftpAckData;
import org.apache.sshd.sftp.client.impl.SftpInputStreamAsync;
import org.apache.sshd.sftp.client.impl.SftpIterableDirEntry;
import org.apache.sshd.sftp.client.impl.SftpOutputStreamAsync;
import org.apache.sshd.sftp.client.impl.SftpRemotePathChannel;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.apache.sshd.sftp.client.impl.SftpStatus;
import org.apache.sshd.sftp.client.impl.StfpIterableDirHandle;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpHelper;
import org.apache.sshd.sftp.common.extensions.ParserUtils;

public abstract class AbstractSftpClient
extends AbstractSubsystemClient
implements FullAccessSftpClient,
SftpErrorDataHandler {
    public static final int INIT_COMMAND_SIZE = 5;
    public static final Property<Duration> SFTP_CLIENT_CMD_TIMEOUT = Property.duration("sftp-client-cmd-timeout", Duration.ofSeconds(30L));
    protected final SftpErrorDataHandler errorDataHandler;
    private final SftpClient.Attributes fileOpenAttributes = new SftpClient.Attributes();
    private final AtomicReference<Map<String, Object>> parsedExtensionsHolder = new AtomicReference<Object>(null);

    protected AbstractSftpClient(SftpErrorDataHandler delegateHandler) {
        this.errorDataHandler = delegateHandler == null ? SftpErrorDataHandler.EMPTY : delegateHandler;
        this.fileOpenAttributes.setType(1);
    }

    @Override
    public Channel getChannel() {
        return this.getClientChannel();
    }

    @Override
    public <E extends SftpClientExtension> E getExtension(Class<? extends E> extensionType) {
        SftpClientExtension instance = this.getExtension(BuiltinSftpClientExtensions.fromType(extensionType));
        if (instance == null) {
            return null;
        }
        return (E)((SftpClientExtension)extensionType.cast(instance));
    }

    @Override
    public SftpClientExtension getExtension(SftpClientExtensionFactory factory2) {
        if (factory2 == null) {
            return null;
        }
        NavigableMap<String, byte[]> extensions = this.getServerExtensions();
        Map<String, Object> parsed = this.getParsedServerExtensions(extensions);
        return factory2.create(this, this, extensions, parsed);
    }

    protected Map<String, Object> getParsedServerExtensions() {
        return this.getParsedServerExtensions(this.getServerExtensions());
    }

    protected Map<String, Object> getParsedServerExtensions(Map<String, byte[]> extensions) {
        Map<String, Object> parsed = this.parsedExtensionsHolder.get();
        if (parsed == null) {
            parsed = ParserUtils.parse(extensions);
            if (parsed == null) {
                parsed = Collections.emptyMap();
            }
            this.parsedExtensionsHolder.set(parsed);
        }
        return parsed;
    }

    protected String getReferencedName(int cmd, Buffer buf, int nameIndex) {
        Charset cs = this.getNameDecodingCharset();
        return buf.getString(cs);
    }

    protected <B extends Buffer> B putReferencedName(int cmd, B buf, String name, int nameIndex) {
        Charset cs = this.getNameDecodingCharset();
        buf.putString(name, cs);
        return buf;
    }

    protected SftpResponse rpc(int cmd, Buffer request2) throws IOException {
        int reqId = this.send(cmd, request2);
        return this.response(cmd, reqId);
    }

    protected SftpResponse response(int cmd, int requestId) throws IOException {
        SftpResponse result2 = SftpResponse.parse(cmd, this.receive(requestId));
        if (this.log.isDebugEnabled()) {
            switch (result2.getType()) {
                case 101: {
                    Buffer buffer = result2.getBuffer();
                    if (buffer.available() < 4) break;
                    int rpos = buffer.rpos();
                    int status2 = buffer.getInt();
                    buffer.rpos(rpos);
                    if (status2 == 0 && cmd == 6) {
                        if (!this.log.isTraceEnabled()) break;
                        this.log.trace("response({}): received {}({}) for command {} (id={})", this.getClientChannel(), SftpConstants.getCommandMessageName(result2.getType()), SftpConstants.getStatusName(status2), SftpConstants.getCommandMessageName(cmd), result2.getId());
                        break;
                    }
                    this.log.debug("response({}): received {}({}) for command {} (id={})", this.getClientChannel(), SftpConstants.getCommandMessageName(result2.getType()), SftpConstants.getStatusName(status2), SftpConstants.getCommandMessageName(cmd), result2.getId());
                    break;
                }
                case 103: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.debug("response({}): received {} for command {} (id={})", this.getClientChannel(), SftpConstants.getCommandMessageName(result2.getType()), SftpConstants.getCommandMessageName(cmd), result2.getId());
                    break;
                }
                default: {
                    this.log.debug("response({}): received {} for command {} (id={})", this.getClientChannel(), SftpConstants.getCommandMessageName(result2.getType()), SftpConstants.getCommandMessageName(cmd), result2.getId());
                }
            }
        }
        return result2;
    }

    protected void checkCommandStatus(int cmd, Buffer request2) throws IOException {
        this.checkResponseStatus(this.rpc(cmd, request2));
    }

    protected void checkResponseStatus(SftpResponse response2) throws IOException {
        if (response2.getType() == 101) {
            this.checkResponseStatus(response2.getCmd(), response2.getId(), SftpStatus.parse(response2));
        } else {
            IOException err = this.handleUnexpectedPacket(101, response2);
            if (err != null) {
                throw err;
            }
        }
    }

    protected void checkResponseStatus(int cmd, int id, SftpStatus status2) throws IOException {
        if (!status2.isOk()) {
            this.throwStatusException(cmd, id, status2);
        }
    }

    protected void throwStatusException(int cmd, int id, SftpStatus status2) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("throwStatusException({})[id={}] cmd={} status={}", this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), status2);
        }
        throw new SftpException(status2.getStatusCode(), status2.getMessage());
    }

    protected byte[] checkHandle(int cmd, Buffer request2) throws IOException {
        return this.checkHandleResponse(this.rpc(cmd, request2));
    }

    protected byte[] checkHandleResponse(SftpResponse response2) throws IOException {
        switch (response2.getType()) {
            case 102: {
                return ValidateUtils.checkNotNullAndNotEmpty(response2.getBuffer().getBytes(), "Null/empty handle in buffer", GenericUtils.EMPTY_OBJECT_ARRAY);
            }
            case 101: {
                this.throwStatusException(response2.getCmd(), response2.getId(), SftpStatus.parse(response2));
                return null;
            }
        }
        return this.handleUnexpectedHandlePacket(response2);
    }

    protected byte[] handleUnexpectedHandlePacket(SftpResponse response2) throws IOException {
        IOException err = this.handleUnexpectedPacket(102, response2);
        if (err != null) {
            throw err;
        }
        throw new SshException("No handling for unexpected handle packet id=" + response2.getId() + ", type=" + SftpConstants.getCommandMessageName(response2.getType()) + ", length=" + response2.getLength());
    }

    protected SftpClient.Attributes checkAttributes(int cmd, Buffer request2) throws IOException {
        return this.checkAttributesResponse(this.rpc(cmd, request2));
    }

    protected SftpClient.Attributes checkAttributesResponse(SftpResponse response2) throws IOException {
        switch (response2.getType()) {
            case 105: {
                return this.readAttributes(response2.getCmd(), response2.getBuffer(), new AtomicInteger(0));
            }
            case 101: {
                this.throwStatusException(response2.getCmd(), response2.getId(), SftpStatus.parse(response2));
                return null;
            }
        }
        return this.handleUnexpectedAttributesPacket(response2);
    }

    protected SftpClient.Attributes handleUnexpectedAttributesPacket(SftpResponse response2) throws IOException {
        IOException err = this.handleUnexpectedPacket(105, response2);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected String checkOneName(int cmd, Buffer request2) throws IOException {
        return this.checkOneNameResponse(this.rpc(cmd, request2));
    }

    protected String checkOneNameResponse(SftpResponse response2) throws IOException {
        switch (response2.getType()) {
            case 104: {
                Buffer buffer = response2.getBuffer();
                int cmd = response2.getCmd();
                int len2 = buffer.getInt();
                if (len2 != 1) {
                    throw new SshException("SFTP error: received " + len2 + " names instead of 1");
                }
                AtomicInteger nameIndex = new AtomicInteger(0);
                String name = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                String longName = null;
                int version2 = this.getVersion();
                if (version2 == 3) {
                    longName = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                }
                SftpClient.Attributes attrs = SftpHelper.complete(this.readAttributes(cmd, buffer, nameIndex), longName);
                Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version2);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("checkOneNameResponse({})[id={}] {} ({})[{}] eol={}: {}", this.getClientChannel(), response2.getId(), SftpConstants.getCommandMessageName(cmd), name, longName, indicator, attrs);
                }
                return name;
            }
            case 101: {
                this.throwStatusException(response2.getCmd(), response2.getId(), SftpStatus.parse(response2));
                return null;
            }
        }
        return this.handleUnknownOneNamePacket(response2);
    }

    protected String handleUnknownOneNamePacket(SftpResponse response2) throws IOException {
        IOException err = this.handleUnexpectedPacket(104, response2);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected SftpClient.Attributes readAttributes(int cmd, Buffer buffer, AtomicInteger nameIndex) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        int flags = buffer.getInt();
        int version2 = this.getVersion();
        if (version2 == 3) {
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if ((flags & 2) != 0) {
                attrs.owner(buffer.getInt(), buffer.getInt());
            }
            if ((flags & 4) != 0) {
                int perms = buffer.getInt();
                attrs.setPermissions(perms);
                attrs.setType(SftpHelper.permissionsToFileType(perms));
            }
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version2, flags));
                attrs.setModifyTime(SftpHelper.readTime(buffer, version2, flags));
            }
        } else if (version2 >= 4) {
            Object object;
            ValidateUtils.checkTrue((flags & 2) == 0, "SFTP v%d server sent invalid SSH_FXP_ATTRS flags 0x%X; flag 0x2 must not be set", version2, flags);
            attrs.setType(buffer.getUByte());
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if (version2 >= 6 && (flags & 0x400) != 0) {
                long perms = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.setOwner(buffer.getString());
                attrs.setGroup(buffer.getString());
            }
            if ((flags & 4) != 0) {
                attrs.setPermissions(buffer.getInt());
            }
            int perms = attrs.getPermissions();
            attrs.setPermissions(perms |= SftpHelper.fileTypeToPermission(attrs.getType()));
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version2, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.setCreateTime(SftpHelper.readTime(buffer, version2, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.setModifyTime(SftpHelper.readTime(buffer, version2, flags));
            }
            if (version2 >= 6 && (flags & 0x8000) != 0) {
                object = SftpHelper.readTime(buffer, version2, flags);
            }
            if ((flags & 0x40) != 0) {
                attrs.setAcl(SftpHelper.readACLs(buffer, version2));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version2 >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version2 >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    object = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                }
            }
        } else {
            throw new IllegalStateException("readAttributes - unsupported version: " + version2);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.setExtensions(SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    protected <B extends Buffer> B writeAttributes(int cmd, B buffer, SftpClient.Attributes attributes2) {
        return SftpHelper.writeAttributes(buffer, attributes2, this.getVersion());
    }

    @Override
    public SftpClient.CloseableHandle open(String path2, Collection<SftpClient.OpenMode> options2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("open(" + path2 + ")[" + options2 + "] client is closed");
        }
        if (GenericUtils.isEmpty(options2)) {
            options2 = EnumSet.of(SftpClient.OpenMode.Read);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(3, buffer, path2, 0);
        int version2 = this.getVersion();
        int mode = 0;
        if (version2 < 5) {
            for (SftpClient.OpenMode m4 : options2) {
                switch (m4) {
                    case Read: {
                        mode |= 1;
                        break;
                    }
                    case Write: {
                        mode |= 2;
                        break;
                    }
                    case Append: {
                        mode |= 4;
                        break;
                    }
                    case Create: {
                        mode |= 8;
                        break;
                    }
                    case Truncate: {
                        mode |= 0x10;
                        break;
                    }
                    case Exclusive: {
                        mode |= 0x20;
                        break;
                    }
                }
            }
        } else {
            int access = 0;
            if (options2.contains((Object)SftpClient.OpenMode.Read)) {
                access |= 0x81;
            }
            if (options2.contains((Object)SftpClient.OpenMode.Write)) {
                access |= 0x102;
            }
            if (options2.contains((Object)SftpClient.OpenMode.Append)) {
                access |= 4;
                mode |= 8;
            }
            ((Buffer)buffer).putInt(access);
            mode = options2.contains((Object)SftpClient.OpenMode.Create) && options2.contains((Object)SftpClient.OpenMode.Exclusive) ? (mode |= 0) : (options2.contains((Object)SftpClient.OpenMode.Create) && options2.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 1) : (options2.contains((Object)SftpClient.OpenMode.Create) ? (mode |= 3) : (options2.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 4) : (mode |= 2))));
        }
        ((Buffer)buffer).putInt(mode);
        buffer = this.writeAttributes(3, buffer, this.fileOpenAttributes);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}): send SSH_FXP_OPEN {} mode={}", this.getClientChannel(), path2, String.format("0x%04x", mode));
        }
        DefaultCloseableHandle handle2 = new DefaultCloseableHandle(this, path2, this.checkHandle(3, buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("open({})[{}] options={}: {}", this.getClientChannel(), path2, options2, handle2);
        }
        return handle2;
    }

    @Override
    public void close(SftpClient.Handle handle2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("close(" + handle2 + ") client is closed");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("close({}) {}", (Object)this.getClientChannel(), (Object)handle2);
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({})[{}]: send SSH_FXP_CLOSE", (Object)this.getClientChannel(), (Object)handle2);
        }
        this.checkCommandStatus(4, buffer);
    }

    @Override
    public void remove(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("remove(" + path2 + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("remove({}) {}", (Object)this.getClientChannel(), (Object)path2);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(13, buffer, path2, 0);
        this.checkCommandStatus(13, buffer);
    }

    @Override
    public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options2 + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rename({}) {} => {}", this.getClientChannel(), oldPath, newPath);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(oldPath.length() + newPath.length() + 64, false);
        buffer = this.putReferencedName(18, buffer, oldPath, 0);
        buffer = this.putReferencedName(18, buffer, newPath, 1);
        int numOptions = GenericUtils.size(options2);
        int version2 = this.getVersion();
        if (version2 >= 5) {
            int opts = 0;
            if (numOptions > 0) {
                for (SftpClient.CopyMode opt : options2) {
                    switch (opt) {
                        case Atomic: {
                            opts |= 2;
                            break;
                        }
                        case Overwrite: {
                            opts |= 1;
                            break;
                        }
                    }
                }
            }
            ((Buffer)buffer).putInt(opts);
        } else if (numOptions > 0) {
            throw new UnsupportedOperationException("rename(" + oldPath + " => " + newPath + ") - copy options can not be used with this SFTP version: " + options2);
        }
        this.checkCommandStatus(18, buffer);
    }

    @Override
    public int read(SftpClient.Handle handle2, long fileOffset, byte[] dst, int dstOffset, int len2, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + handle2 + "/" + fileOffset + ")[" + dstOffset + "/" + len2 + "] client is closed");
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        Buffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putUInt(len2);
        int reqId = this.send(5, buffer);
        SftpAckData ack = new SftpAckData(reqId, fileOffset, len2);
        SftpResponse response2 = this.response(5, reqId);
        buffer = this.checkDataResponse(ack, response2, eofSignalled);
        if (buffer == null) {
            return -1;
        }
        if (buffer.available() <= 0) {
            if (eofSignalled != null) {
                Boolean eof = eofSignalled.get();
                return eof != null && eof != false ? -1 : 0;
            }
            return 0;
        }
        int bytesRead = buffer.available();
        buffer.getRawBytes(dst, dstOffset, bytesRead);
        return bytesRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Buffer checkDataResponse(SftpAckData ack, SftpResponse response2, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        switch (response2.getType()) {
            case 103: {
                Buffer buffer = response2.getBuffer();
                int dlen = buffer.getInt();
                ValidateUtils.checkTrue(dlen >= 0 && dlen <= buffer.available(), "Invalid response data len: %d", dlen);
                if (dlen > ack.length) {
                    buffer.wpos(buffer.rpos() + ack.length);
                    boolean dropExcessData = SftpModuleProperties.TOLERATE_EXCESS_DATA.getRequired(this.getClientChannel());
                    if (!dropExcessData) throw new SshException("SFTP protocol violation: requested at most " + ack.length + " bytes but got " + dlen + " bytes");
                    this.log.warn("checkDataResponse({}][id={}] {} offset={}, len={} SFTP protocol violation: server returned more data than requested, excess data dropped (requested len={})", this.getClientChannel(), SftpConstants.getCommandMessageName(response2.getCmd()), response2.getId(), ack.offset, dlen, ack.length);
                    return buffer;
                } else {
                    int rpos = buffer.rpos();
                    buffer.rpos(rpos + dlen);
                    Boolean indicator = SftpHelper.getEndOfFileIndicatorValue(buffer, this.getVersion());
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("checkDataResponse({}][id={}] {} offset={}, len={}, EOF={}", this.getClientChannel(), SftpConstants.getCommandMessageName(response2.getCmd()), response2.getId(), ack.offset, dlen, indicator);
                    }
                    if (eofSignalled != null) {
                        eofSignalled.set(indicator);
                    }
                    buffer.rpos(rpos);
                    buffer.wpos(buffer.rpos() + dlen);
                }
                return buffer;
            }
            case 101: {
                SftpStatus status2 = SftpStatus.parse(response2);
                if (status2.getStatusCode() == 1) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("checkDataResponse({})[id={}] {} status: {}", this.getClientChannel(), response2.getId(), SftpConstants.getCommandMessageName(response2.getCmd()), status2);
                    }
                    if (eofSignalled == null) return null;
                    eofSignalled.set(Boolean.TRUE);
                    return null;
                }
                this.checkResponseStatus(5, response2.getId(), status2);
                return new ByteArrayBuffer(new byte[0]);
            }
        }
        this.handleUnknownDataPacket(response2);
        return new ByteArrayBuffer(new byte[0]);
    }

    protected int handleUnknownDataPacket(SftpResponse response2) throws IOException {
        IOException err = this.handleUnexpectedPacket(103, response2);
        if (err != null) {
            throw err;
        }
        return 0;
    }

    @Override
    public void errorData(byte[] buf, int start2, int len2) throws IOException {
        if (this.errorDataHandler != null) {
            this.errorDataHandler.errorData(buf, start2, len2);
        }
    }

    @Override
    public void write(SftpClient.Handle handle2, long fileOffset, byte[] src, int srcOffset, int len2) throws IOException {
        int writeSize;
        if (fileOffset < 0L || srcOffset < 0 || len2 < 0) {
            throw new IllegalArgumentException("write(" + handle2 + ") please ensure all parameters  are non-negative values: file-offset=" + fileOffset + ", src-offset=" + srcOffset + ", len=" + len2);
        }
        if (srcOffset + len2 > src.length) {
            throw new IllegalArgumentException("write(" + handle2 + ") cannot read bytes " + srcOffset + " to " + (srcOffset + len2) + " when array is only of length " + src.length);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + handle2 + "/" + fileOffset + ")[" + srcOffset + "/" + len2 + "] client is closed");
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int chunkSize = SftpModuleProperties.WRITE_CHUNK_SIZE.getRequired(clientChannel);
        ValidateUtils.checkState(chunkSize > 256, "Write chunk size too small: %d", chunkSize);
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        int remLen = len2;
        do {
            writeSize = Math.min(remLen, chunkSize);
            ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + writeSize + 64, false);
            buffer.putBytes(id);
            buffer.putLong(fileOffset);
            ((Buffer)buffer).putBytes(src, srcOffset, writeSize);
            if (traceEnabled) {
                this.log.trace("write({}) handle={}, file-offset={}, buf-offset={}, writeSize={}, remLen={}", clientChannel, handle2, fileOffset, srcOffset, writeSize, remLen - writeSize);
            }
            this.checkCommandStatus(6, buffer);
            fileOffset += (long)writeSize;
            srcOffset += writeSize;
        } while ((remLen -= writeSize) > 0);
    }

    @Override
    public void mkdir(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("mkdir(" + path2 + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("mkdir({}): send SSH_FXP_MKDIR {}", (Object)this.getClientChannel(), (Object)path2);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(14, buffer, path2, 0);
        ((Buffer)buffer).putUInt(0L);
        int version2 = this.getVersion();
        if (version2 != 3) {
            ((Buffer)buffer).putByte((byte)0);
        }
        this.checkCommandStatus(14, buffer);
    }

    @Override
    public void rmdir(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rmdir(" + path2 + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rmdir({}): send SSH_FXP_RMDIR {}", (Object)this.getClientChannel(), (Object)path2);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(15, buffer, path2, 0);
        this.checkCommandStatus(15, buffer);
    }

    @Override
    public SftpClient.CloseableHandle openDir(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("openDir(" + path2 + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(11, buffer, path2, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("openDir({}): send SSH_FXP_OPENDIR {}", (Object)this.getClientChannel(), (Object)path2);
        }
        DefaultCloseableHandle handle2 = new DefaultCloseableHandle(this, path2, this.checkHandle(11, buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("openDir({})[{}]: {}", this.getClientChannel(), path2, handle2);
        }
        return handle2;
    }

    @Override
    public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle2, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        if (!this.isOpen()) {
            throw new IOException("readDir(" + handle2 + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("readDir({})[{}]: send SSH_FXP_READDIR", (Object)this.getClientChannel(), (Object)handle2);
        }
        return this.checkDirResponse(this.rpc(12, buffer), eolIndicator);
    }

    protected List<SftpClient.DirEntry> checkDirResponse(SftpResponse response2, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        switch (response2.getType()) {
            case 104: {
                ClientChannel channel2 = this.getClientChannel();
                Buffer buffer = response2.getBuffer();
                int cmd = response2.getCmd();
                int count2 = buffer.getInt();
                int version2 = this.getVersion();
                if (count2 < 0 || count2 > 32768) {
                    this.log.error("checkDirResponse({})[id={}] illogical dir entries count: {}", channel2, response2.getId(), count2);
                    throw new SshException("Illogical dir entries count: " + count2);
                }
                boolean debugEnabled = this.log.isDebugEnabled();
                if (debugEnabled) {
                    this.log.debug("checkDirResponse({})[id={}] reading {} entries", channel2, response2.getId(), count2);
                }
                ArrayList<SftpClient.DirEntry> entries2 = new ArrayList<SftpClient.DirEntry>(count2);
                AtomicInteger nameIndex = new AtomicInteger(0);
                for (int index = 1; index <= count2; ++index) {
                    String name = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                    String longName = null;
                    if (version2 == 3) {
                        longName = this.getReferencedName(cmd, buffer, nameIndex.getAndIncrement());
                    }
                    SftpClient.Attributes attrs = SftpHelper.complete(this.readAttributes(cmd, buffer, nameIndex), longName);
                    if (traceEnabled) {
                        this.log.trace("checkDirResponse({})[id={}][{}/{}] ({})[{}]: {}", channel2, response2.getId(), index, count2, name, longName, attrs);
                    }
                    entries2.add(new SftpClient.DirEntry(name, longName, attrs));
                }
                Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version2);
                if (eolIndicator != null) {
                    eolIndicator.set(indicator);
                }
                if (debugEnabled) {
                    this.log.debug("checkDirResponse({})[id={}] read count={}, eol={}", channel2, response2.getId(), entries2.size(), indicator);
                }
                return entries2;
            }
            case 101: {
                SftpStatus status2 = SftpStatus.parse(response2);
                if (status2.getStatusCode() != 1) {
                    this.throwStatusException(response2.getCmd(), response2.getId(), status2);
                } else if (traceEnabled) {
                    this.log.trace("checkDirResponse({})[id={}] - status: {}", this.getClientChannel(), response2.getId(), status2);
                }
                return null;
            }
        }
        return this.handleUnknownDirListingPacket(response2);
    }

    protected List<SftpClient.DirEntry> handleUnknownDirListingPacket(SftpResponse response2) throws IOException {
        IOException err = this.handleUnexpectedPacket(104, response2);
        if (err != null) {
            throw err;
        }
        return Collections.emptyList();
    }

    protected IOException handleUnexpectedPacket(int expected, SftpResponse response2) throws IOException {
        return new SshException("Unexpected SFTP packet received while awaiting " + SftpConstants.getCommandMessageName(expected) + " response to " + SftpConstants.getCommandMessageName(response2.getCmd()) + ": type=" + SftpConstants.getCommandMessageName(response2.getType()) + ", id=" + response2.getId() + ", length=" + response2.getLength());
    }

    @Override
    public String canonicalPath(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("canonicalPath(" + path2 + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(16, buffer, path2, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("canonicalPath({}): send SSH_FXP_REALPATH {}", (Object)this.getClientChannel(), (Object)path2);
        }
        return this.checkOneName(16, buffer);
    }

    @Override
    public SftpClient.Attributes stat(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + path2 + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(17, buffer, path2, 0);
        int version2 = this.getVersion();
        if (version2 >= 4) {
            ((Buffer)buffer).putInt(65533L);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("stat({}): send SSH_FXP_STAT {}", (Object)this.getClientChannel(), (Object)path2);
        }
        return this.checkAttributes(17, buffer);
    }

    @Override
    public SftpClient.Attributes lstat(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lstat(" + path2 + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(7, buffer, path2, 0);
        int version2 = this.getVersion();
        if (version2 >= 4) {
            ((Buffer)buffer).putInt(65533L);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("stat({}): send SSH_FXP_LSTAT {}", (Object)this.getClientChannel(), (Object)path2);
        }
        return this.checkAttributes(7, buffer);
    }

    @Override
    public SftpClient.Attributes stat(SftpClient.Handle handle2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + handle2 + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        int version2 = this.getVersion();
        if (version2 >= 4) {
            ((Buffer)buffer).putInt(65533L);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("stat({}): send SSH_FXP_FSTAT {}", (Object)this.getClientChannel(), (Object)handle2);
        }
        return this.checkAttributes(8, buffer);
    }

    @Override
    public void setStat(String path2, SftpClient.Attributes attributes2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + path2 + ")[" + attributes2 + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", this.getClientChannel(), path2, attributes2);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer = this.putReferencedName(9, buffer, path2, 0);
        buffer = this.writeAttributes(9, buffer, attributes2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({}): send SSH_FXP_SETSTAT {}", (Object)this.getClientChannel(), (Object)path2);
        }
        this.checkCommandStatus(9, buffer);
    }

    @Override
    public void setStat(SftpClient.Handle handle2, SftpClient.Attributes attributes2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + handle2 + ")[" + attributes2 + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", this.getClientChannel(), handle2, attributes2);
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 128, false);
        buffer.putBytes(id);
        buffer = this.writeAttributes(10, buffer, attributes2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({}): send SSH_FXP_FSETSTAT {}", (Object)this.getClientChannel(), (Object)handle2);
        }
        this.checkCommandStatus(10, buffer);
    }

    @Override
    public String readLink(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readLink(" + path2 + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path2.length() + 64, false);
        buffer = this.putReferencedName(19, buffer, path2, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("readLink({}): send SSH_FXP_READLINK {}", (Object)this.getClientChannel(), (Object)path2);
        }
        return this.checkOneName(19, buffer);
    }

    @Override
    public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
        int cmd;
        if (!this.isOpen()) {
            throw new IOException("link(" + linkPath + " => " + targetPath + ")[symbolic=" + symbolic + "] client is closed");
        }
        int version2 = this.getVersion();
        int n = cmd = version2 < 6 ? 20 : 21;
        if (this.log.isDebugEnabled()) {
            this.log.debug("link({})[symbolic={}] send {} {} => {}", this.getClientChannel(), symbolic, SshConstants.getCommandMessageName(cmd), linkPath, targetPath);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(linkPath.length() + targetPath.length() + 64, false);
        if (version2 < 6) {
            if (!symbolic) {
                throw new UnsupportedOperationException("Hard links are not supported in sftp v" + version2 + ", need SFTPv6");
            }
            buffer = this.putReferencedName(cmd, buffer, targetPath, 0);
            buffer = this.putReferencedName(cmd, buffer, linkPath, 1);
        } else {
            buffer = this.putReferencedName(cmd, buffer, targetPath, 0);
            buffer = this.putReferencedName(cmd, buffer, linkPath, 1);
            buffer.putBoolean(symbolic);
        }
        this.checkCommandStatus(cmd, buffer);
    }

    @Override
    public void lock(SftpClient.Handle handle2, long offset, long length, int mask) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lock(" + handle2 + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
        }
        int version2 = this.getVersion();
        if (version2 < 6) {
            throw new UnsupportedOperationException("File locks are not supported in sftp v" + version2 + ", need SFTPv6");
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        ((Buffer)buffer).putInt(mask);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock({})[{}] send SSH_FXP_BLOCK offset={}, length={}, mask=0x{}", this.getClientChannel(), handle2, offset, length, Integer.toHexString(mask));
        }
        this.checkCommandStatus(22, buffer);
    }

    @Override
    public void unlock(SftpClient.Handle handle2, long offset, long length) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("unlock" + handle2 + ")[offset=" + offset + ", length=" + length + "] client is closed");
        }
        int version2 = this.getVersion();
        if (version2 < 6) {
            throw new UnsupportedOperationException("File locks are not supported in sftp v" + version2 + ", need SFTPv6");
        }
        byte[] id = Objects.requireNonNull(handle2, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        if (this.log.isDebugEnabled()) {
            this.log.debug("unlock({})[{}] send SSH_FXP_UNBLOCK offset={}, length={}", this.getClientChannel(), handle2, offset, length);
        }
        this.checkCommandStatus(23, buffer);
    }

    @Override
    public Iterable<SftpClient.DirEntry> readDir(String path2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readDir(" + path2 + ") client is closed");
        }
        return new SftpIterableDirEntry(this, path2);
    }

    @Override
    public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("listDir(" + handle2 + ") client is closed");
        }
        return new StfpIterableDirHandle(this, handle2);
    }

    @Override
    public FileChannel openRemoteFileChannel(String path2, Collection<SftpClient.OpenMode> modes) throws IOException {
        return new SftpRemotePathChannel(path2, this, false, (Collection<SftpClient.OpenMode>)(GenericUtils.isEmpty(modes) ? DEFAULT_CHANNEL_MODES : modes));
    }

    @Override
    public InputStream read(String path2, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize <= 0) {
            bufferSize = this.getReadBufferSize();
        }
        if (bufferSize < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + bufferSize + ", min.=" + 256);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path2 + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpInputStreamAsync(this, bufferSize, path2, mode);
    }

    @Override
    public SftpOutputStreamAsync write(String path2, int bufferSize, Collection<SftpClient.OpenMode> mode) throws IOException {
        if (bufferSize != 0 && bufferSize < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + bufferSize + ", min.=" + 256);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path2 + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpOutputStreamAsync(this, bufferSize, path2, mode);
    }

    @Override
    public void put(InputStream stream, int bufferSize, String path2, Collection<SftpClient.OpenMode> modes) throws IOException {
        try (OutputStream out2 = this.write(path2, bufferSize, (Collection)modes);){
            ((SftpOutputStreamAsync)out2).transferFrom(stream);
        }
    }

    protected int getReadBufferSize() {
        return (int)this.getClientChannel().getLocalWindow().getPacketSize() - 13;
    }

    protected int getWriteBufferSize() {
        return (int)this.getClientChannel().getRemoteWindow().getPacketSize() - 13;
    }
}

