/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.sftp.client.SftpClient;

public class DefaultCloseableHandle
extends SftpClient.CloseableHandle {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final SftpClient client;

    public DefaultCloseableHandle(SftpClient client2, String path2, byte[] id) {
        super(path2, id);
        this.client = ValidateUtils.checkNotNull(client2, "No client for path=%s", (Object)path2);
    }

    public final SftpClient getSftpClient() {
        return this.client;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.client.close(this);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

