/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpMessage;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.apache.sshd.sftp.client.impl.SftpStatus;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.extensions.ParserUtils;
import org.apache.sshd.sftp.common.extensions.VersionsParser;
import org.apache.sshd.sftp.server.SftpSubsystemEnvironment;

public class DefaultSftpClient
extends AbstractSftpClient {
    private final ClientSession clientSession;
    private final ChannelSubsystem channel;
    private final Map<Integer, Buffer> messages = new ConcurrentHashMap<Integer, Buffer>();
    private final AtomicInteger cmdId = new AtomicInteger(100);
    private final Buffer receiveBuffer = new ByteArrayBuffer();
    private final AtomicInteger versionHolder = new AtomicInteger(0);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final NavigableMap<String, byte[]> extensions = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
    private final NavigableMap<String, byte[]> exposedExtensions = Collections.unmodifiableNavigableMap(this.extensions);
    private Charset nameDecodingCharset;

    public DefaultSftpClient(ClientSession clientSession, SftpVersionSelector initialVersionSelector, SftpErrorDataHandler errorDataHandler) throws IOException {
        super(errorDataHandler);
        this.nameDecodingCharset = SftpModuleProperties.NAME_DECODING_CHARSET.getRequired(clientSession);
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.channel = this.createSftpChannelSubsystem(clientSession);
        clientSession.getService(ConnectionService.class).registerChannel(this.channel);
        Duration initializationTimeout = SftpModuleProperties.SFTP_CHANNEL_OPEN_TIMEOUT.getRequired(clientSession);
        this.channel.open().verify(initializationTimeout);
        this.channel.onClose(() -> {
            Map<Integer, Buffer> map2 = this.messages;
            synchronized (map2) {
                this.closing.set(true);
                this.messages.notifyAll();
            }
            if (this.versionHolder.get() <= 0) {
                this.log.warn("onClose({}) closed before version negotiated", (Object)this.channel);
            }
        });
        try {
            this.init(clientSession, initialVersionSelector, initializationTimeout);
        }
        catch (IOException | Error | RuntimeException e2) {
            this.channel.close(true);
            throw e2;
        }
    }

    @Override
    public int getVersion() {
        return this.versionHolder.get();
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public ClientChannel getClientChannel() {
        return this.channel;
    }

    @Override
    public NavigableMap<String, byte[]> getServerExtensions() {
        return this.exposedExtensions;
    }

    @Override
    public Charset getNameDecodingCharset() {
        return this.nameDecodingCharset;
    }

    @Override
    public void setNameDecodingCharset(Charset nameDecodingCharset) {
        this.nameDecodingCharset = Objects.requireNonNull(nameDecodingCharset, "No charset provided");
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close(false);
        }
    }

    protected int data(byte[] buf, int start2, int len2) throws IOException {
        Buffer incoming = new ByteArrayBuffer(buf, start2, len2);
        if (this.receiveBuffer.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
            incoming = this.receiveBuffer;
        }
        int rpos = incoming.rpos();
        boolean traceEnabled = this.log.isTraceEnabled();
        int count2 = 1;
        while (this.receive(incoming)) {
            if (traceEnabled) {
                this.log.trace("data({}) Processed {} data messages", (Object)this.getClientChannel(), (Object)count2);
            }
            ++count2;
        }
        int read2 = incoming.rpos() - rpos;
        this.receiveBuffer.compact();
        if (this.receiveBuffer != incoming && incoming.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
        }
        return read2;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        ClientSession session2 = this.getClientSession();
        session2.resetIdleTimeout();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (length > 262144) {
                throw new StreamCorruptedException("Illogical sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Buffer incoming) throws IOException {
        ByteArrayBuffer buffer = new ByteArrayBuffer(incoming.available() + 64, false);
        buffer.putBuffer(incoming);
        int rpos = ((Buffer)buffer).rpos();
        int length = ((Buffer)buffer).getInt();
        int type2 = buffer.getUByte();
        Integer id = ((Buffer)buffer).getInt();
        ((Buffer)buffer).rpos(rpos);
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) id={}, type={}, len={}", this.getClientChannel(), id, SftpConstants.getCommandMessageName(type2), length);
        }
        Map<Integer, Buffer> map2 = this.messages;
        synchronized (map2) {
            this.messages.put(id, buffer);
            this.messages.notifyAll();
        }
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        SftpMessage msg = this.write(cmd, buffer);
        msg.waitUntilSent();
        return msg.getId();
    }

    @Override
    public SftpMessage write(int cmd, Buffer buffer) throws IOException {
        Buffer buf;
        int id = this.cmdId.incrementAndGet();
        int len2 = buffer.available();
        if (this.log.isTraceEnabled()) {
            this.log.trace("send({}) cmd={}, len={}, id={}", this.getClientChannel(), SftpConstants.getCommandMessageName(cmd), len2, id);
        }
        int hdr = 9;
        if (buffer.rpos() >= hdr) {
            int wpos = buffer.wpos();
            int s2 = buffer.rpos() - hdr;
            buffer.rpos(s2);
            buffer.wpos(s2);
            buffer.putUInt(5 + len2);
            buffer.putByte((byte)(cmd & 0xFF));
            buffer.putInt(id);
            buffer.wpos(wpos);
            buf = buffer;
        } else {
            buf = new ByteArrayBuffer(hdr + len2);
            ((Buffer)buf).putUInt(5 + len2);
            ((Buffer)buf).putByte((byte)(cmd & 0xFF));
            ((Buffer)buf).putInt(id);
            buf.putBuffer(buffer);
        }
        ClientChannel clientChannel = this.getClientChannel();
        IoOutputStream asyncIn = clientChannel.getAsyncIn();
        IoWriteFuture writeFuture = asyncIn.writeBuffer(buf);
        Duration sendTimeout = (Duration)SFTP_CLIENT_CMD_TIMEOUT.getRequired(clientChannel);
        return new SftpMessage(id, writeFuture, sendTimeout);
    }

    @Override
    public Buffer receive(int id) throws IOException {
        Buffer result2;
        Duration idleTimeout = CoreModuleProperties.IDLE_TIMEOUT.getRequired(this.getClientSession());
        if (GenericUtils.isNegativeOrNull(idleTimeout)) {
            idleTimeout = CoreModuleProperties.IDLE_TIMEOUT.getRequiredDefault();
        }
        if ((result2 = this.receive(id, idleTimeout)) == null) {
            throw new SshException("Timeout expired while waiting for id=" + id);
        }
        return result2;
    }

    @Override
    public Buffer receive(int id, long idleTimeout) throws IOException {
        return this.receive(id, Duration.ofMillis(idleTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer receive(int id, Duration idleTimeout) throws IOException {
        Map<Integer, Buffer> map2 = this.messages;
        synchronized (map2) {
            if (GenericUtils.isPositive(idleTimeout)) {
                Instant waitUntil = Instant.now().plus(idleTimeout);
                while (true) {
                    if (this.isClosing() || !this.isOpen()) {
                        throw new SshException("Channel is being closed");
                    }
                    Buffer buffer = this.messages.remove(id);
                    if (buffer != null) {
                        return buffer;
                    }
                    Duration waitFor = Duration.between(Instant.now(), waitUntil);
                    if (!GenericUtils.isPositive(waitFor)) break;
                    try {
                        this.messages.wait(waitFor.toMillis(), waitFor.getNano() % 1000000);
                    }
                    catch (InterruptedException e2) {
                        throw (IOException)new InterruptedIOException("Interrupted while waiting for messages").initCause(e2);
                    }
                }
            }
            return this.messages.remove(id);
        }
    }

    protected void init(ClientSession session2, SftpVersionSelector initialVersionSelector, Duration initializationTimeout) throws IOException {
        int initialVersion = initialVersionSelector == null ? 6 : initialVersionSelector.selectVersion(session2, true, 6, SftpSubsystemEnvironment.SUPPORTED_SFTP_VERSIONS);
        ValidateUtils.checkState(SftpSubsystemEnvironment.SUPPORTED_SFTP_VERSIONS.contains(initialVersion), "Unsupported initial version selected: %d", initialVersion);
        ByteArrayBuffer buf = new ByteArrayBuffer(10);
        ((Buffer)buf).putUInt(5L);
        ((Buffer)buf).putByte((byte)1);
        ((Buffer)buf).putUInt(initialVersion);
        boolean traceEnabled = this.log.isTraceEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        IoOutputStream asyncIn = clientChannel.getAsyncIn();
        if (traceEnabled) {
            this.log.trace("init({}) send SSH_FXP_INIT - initial version={}", (Object)clientChannel, (Object)initialVersion);
        }
        IoWriteFuture writeFuture = asyncIn.writeBuffer(buf);
        writeFuture.verify(initializationTimeout);
        if (traceEnabled) {
            this.log.trace("init({}) wait for SSH_FXP_INIT respose (timeout={})", (Object)clientChannel, (Object)initializationTimeout);
        }
        Buffer buffer = this.waitForInitResponse(initializationTimeout);
        this.handleInitResponse(buffer);
    }

    protected void handleInitResponse(Buffer buffer) throws IOException {
        boolean traceEnabled = this.log.isTraceEnabled();
        SftpResponse response2 = SftpResponse.parse(1, buffer);
        ClientChannel clientChannel = this.getClientChannel();
        int length = response2.getLength();
        int type2 = response2.getType();
        int id = response2.getId();
        if (traceEnabled) {
            this.log.trace("handleInitResponse({}) id={} type={} len={}", clientChannel, id, SftpConstants.getCommandMessageName(type2), length);
        }
        switch (type2) {
            case 2: {
                if (id < 3 || id > 6) {
                    throw new SshException("Unsupported sftp version " + id);
                }
                this.versionHolder.set(id);
                if (traceEnabled) {
                    this.log.trace("handleInitResponse({}) version={}", (Object)clientChannel, (Object)this.versionHolder);
                }
                while (buffer.available() > 0) {
                    String name = buffer.getString();
                    byte[] data2 = buffer.getBytes();
                    if (traceEnabled) {
                        this.log.trace("handleInitResponse({}) added extension={}", (Object)clientChannel, (Object)name);
                    }
                    this.extensions.put(name, data2);
                }
                break;
            }
            case 101: {
                this.throwStatusException(1, id, SftpStatus.parse(response2));
                break;
            }
            default: {
                IOException err = this.handleUnexpectedPacket(2, response2);
                if (err == null) break;
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer waitForInitResponse(Duration initializationTimeout) throws IOException {
        ValidateUtils.checkTrue(GenericUtils.isPositive(initializationTimeout), "Invalid initialization timeout: %d", (Object)initializationTimeout);
        Map<Integer, Buffer> map2 = this.messages;
        synchronized (map2) {
            Instant now = Instant.now();
            Instant max2 = now.plus(initializationTimeout);
            while (now.compareTo(max2) < 0 && this.messages.isEmpty() && !this.isClosing() && this.isOpen()) {
                try {
                    Duration rem = Duration.between(now, max2);
                    this.messages.wait(rem.toMillis(), rem.getNano() % 1000000);
                    now = Instant.now();
                }
                catch (InterruptedException e2) {
                    throw (IOException)new InterruptedIOException("Interrupted init() while " + Duration.between(now, max2) + " remaining").initCause(e2);
                }
            }
            if (this.isClosing() || !this.isOpen()) {
                throw new EOFException("Closing while await init message");
            }
            if (this.messages.isEmpty()) {
                throw new SocketTimeoutException("No incoming initialization response received within " + initializationTimeout + " msec.");
            }
            Set<Integer> ids = this.messages.keySet();
            Iterator iter = ids.iterator();
            Integer reqId = (Integer)iter.next();
            return this.messages.remove(reqId);
        }
    }

    public int negotiateVersion(SftpVersionSelector selector) throws IOException {
        List<Integer> availableVersions;
        boolean debugEnabled = this.log.isDebugEnabled();
        ClientChannel clientChannel = this.getClientChannel();
        int current = this.getVersion();
        if (selector == null) {
            if (debugEnabled) {
                this.log.debug("negotiateVersion({}) no selector to override current={}", (Object)clientChannel, (Object)current);
            }
            return current;
        }
        Map<String, Object> parsed = this.getParsedServerExtensions();
        Set<String> extensions = ParserUtils.supportedExtensions(parsed);
        if (GenericUtils.size(extensions) > 0 && extensions.contains("version-select")) {
            VersionsParser.Versions vers = MapEntryUtils.isEmpty(parsed) ? null : (VersionsParser.Versions)parsed.get("versions");
            availableVersions = vers == null ? Collections.singletonList(current) : vers.resolveAvailableVersions(current);
        } else {
            availableVersions = Collections.singletonList(current);
        }
        ClientSession session2 = this.getClientSession();
        int selected = selector.selectVersion(session2, false, current, availableVersions);
        if (debugEnabled) {
            this.log.debug("negotiateVersion({}) current={} {} -> {}", clientChannel, current, availableVersions, selected);
        }
        if (selected == current) {
            return current;
        }
        if (!availableVersions.contains(selected)) {
            throw new StreamCorruptedException("Selected version (" + selected + ") not part of available: " + availableVersions);
        }
        String verVal = String.valueOf(selected);
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + "version-select".length() + 4 + verVal.length() + 8, false);
        buffer.putString("version-select");
        buffer.putString(verVal);
        this.checkCommandStatus(200, buffer);
        this.versionHolder.set(selected);
        return selected;
    }

    protected ChannelSubsystem createSftpChannelSubsystem(ClientSession clientSession) {
        return new SftpChannelSubsystem();
    }

    protected class SftpChannelSubsystem
    extends ChannelSubsystem {
        protected SftpChannelSubsystem() {
            super("sftp");
        }

        @Override
        protected void doOpen() throws IOException {
            String systemName = this.getSubsystem();
            Session session2 = this.getSession();
            boolean wantReply = CoreModuleProperties.REQUEST_SUBSYSTEM_REPLY.getRequired(this);
            Buffer buffer = session2.createBuffer((byte)98, "subsystem".length() + systemName.length() + 32);
            buffer.putUInt(this.getRecipient());
            buffer.putString("subsystem");
            buffer.putBoolean(wantReply);
            buffer.putString(systemName);
            this.addPendingRequest("subsystem", wantReply);
            this.writePacket(buffer);
            this.setStreaming(StreamingChannel.Streaming.Async);
            this.asyncIn = this.createAsyncInput(session2);
            this.setOut(this.createStdOutputStream(session2));
            this.setErr(this.createErrOutputStream(session2));
        }

        protected ChannelAsyncOutputStream createAsyncInput(Session session2) {
            return new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    DefaultCloseFuture result2 = new DefaultCloseFuture(SftpChannelSubsystem.this.getChannelId(), this.futureLock);
                    CloseFuture packetsWritten = super.doCloseGracefully();
                    packetsWritten.addListener(p -> {
                        try {
                            IoWriteFuture eofSent = SftpChannelSubsystem.this.sendEof();
                            if (eofSent != null) {
                                eofSent.addListener(f2 -> result2.setClosed());
                                return;
                            }
                        }
                        catch (Exception e2) {
                            SftpChannelSubsystem.this.getSession().exceptionCaught(e2);
                        }
                        result2.setClosed();
                    });
                    return result2;
                }
            };
        }

        protected OutputStream createStdOutputStream(Session session2) {
            return new OutputStream(){
                private final byte[] singleByte = new byte[1];

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b2) throws IOException {
                    byte[] byArray = this.singleByte;
                    synchronized (this.singleByte) {
                        this.singleByte[0] = (byte)b2;
                        this.write(this.singleByte);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public void write(byte[] b2, int off, int len2) throws IOException {
                    DefaultSftpClient.this.data(b2, off, len2);
                }
            };
        }

        protected OutputStream createErrOutputStream(Session session2) {
            return new OutputStream(){
                private final byte[] singleByte = new byte[1];

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(int b2) throws IOException {
                    byte[] byArray = this.singleByte;
                    synchronized (this.singleByte) {
                        this.singleByte[0] = (byte)b2;
                        this.write(this.singleByte);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public void write(byte[] b2, int off, int len2) throws IOException {
                    DefaultSftpClient.this.errorData(b2, off, len2);
                }
            };
        }
    }
}

