/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.impl.DefaultSftpClient;

public class DefaultSftpClientFactory
extends AbstractLoggingBean
implements SftpClientFactory {
    public static final DefaultSftpClientFactory INSTANCE = new DefaultSftpClientFactory();

    @Override
    public SftpClient createSftpClient(ClientSession session2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        DefaultSftpClient client2 = this.createDefaultSftpClient(session2, selector, errorDataHandler);
        try {
            client2.negotiateVersion(selector);
        }
        catch (IOException | Error | RuntimeException e2) {
            this.debug("createSftpClient({}) failed ({}) to negotiate version: {}", session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            client2.close();
            throw e2;
        }
        return client2;
    }

    protected DefaultSftpClient createDefaultSftpClient(ClientSession session2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        return new DefaultSftpClient(session2, selector, errorDataHandler);
    }

    @Override
    public SftpFileSystem createSftpFileSystem(ClientSession session2, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler, int readBufferSize, int writeBufferSize) throws IOException {
        ClientFactoryManager manager = session2.getFactoryManager();
        SftpFileSystemProvider provider2 = new SftpFileSystemProvider((SshClient)manager, selector, errorDataHandler);
        SftpFileSystem fs = provider2.newFileSystem(session2);
        if (readBufferSize > 0) {
            fs.setReadBufferSize(readBufferSize);
        }
        if (writeBufferSize > 0) {
            fs.setWriteBufferSize(writeBufferSize);
        }
        return fs;
    }
}

