/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.input.InputStreamWithChannel;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientHolder;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpAckData;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpInputStreamAsync
extends InputStreamWithChannel
implements SftpClientHolder {
    private static final int MIN_BUFFER_SIZE = 8192;
    protected final Logger log;
    protected final byte[] bb = new byte[1];
    protected final long fileSize;
    protected Buffer buffer;
    protected SftpClient.CloseableHandle handle;
    protected long requestOffset;
    protected long clientOffset;
    protected final Deque<SftpAckData> pendingReads = new LinkedList<SftpAckData>();
    protected boolean eofIndicator;
    protected int bufferSize;
    protected int maxReceived;
    protected long shortReads;
    protected boolean bufferAdjusted;
    private final AbstractSftpClient clientInstance;
    private final String path;
    private final boolean ownsHandle;

    public SftpInputStreamAsync(AbstractSftpClient client2, int bufferSize, String path2, Collection<SftpClient.OpenMode> mode) throws IOException {
        this(client2, bufferSize, 0L, client2.stat(path2).getSize(), path2, client2.open(path2, mode));
    }

    public SftpInputStreamAsync(AbstractSftpClient client2, int bufferSize, long clientOffset, long fileSize, String path2, SftpClient.CloseableHandle handle2) {
        this(client2, bufferSize, clientOffset, fileSize, path2, handle2, true);
    }

    public SftpInputStreamAsync(AbstractSftpClient client2, int bufferSize, long clientOffset, long fileSize, String path2, SftpClient.CloseableHandle handle2, boolean closeHandle) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clientInstance = Objects.requireNonNull(client2, "No SFTP client instance");
        this.path = path2;
        this.handle = handle2;
        this.ownsHandle = closeHandle;
        this.bufferSize = bufferSize;
        this.requestOffset = clientOffset;
        this.clientOffset = clientOffset;
        this.fileSize = fileSize;
    }

    @Override
    public final AbstractSftpClient getClient() {
        return this.clientInstance;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isEof() {
        return this.eofIndicator && this.hasNoData();
    }

    @Override
    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    @Override
    public int read() throws IOException {
        int read2 = this.read(this.bb, 0, 1);
        if (read2 > 0) {
            return this.bb[0] & 0xFF;
        }
        return read2;
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + this.getPath() + ") stream closed");
        }
        AtomicInteger offset = new AtomicInteger(off);
        int res = (int)this.doRead(len2, buf -> {
            int l = buf.available();
            buf.getRawBytes(b2, offset.getAndAdd(l), l);
        });
        if (res == 0 && this.eofIndicator && this.hasNoData()) {
            res = -1;
        }
        return res;
    }

    public long transferTo(long len2, WritableByteChannel out2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("transferTo(" + this.getPath() + ") stream closed");
        }
        long numXfered = this.doRead(len2, buf -> {
            ByteBuffer bb = ByteBuffer.wrap(buf.array(), buf.rpos(), buf.available());
            while (bb.hasRemaining()) {
                out2.write(bb);
            }
        });
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferTo({}) transferred {}/{} bytes", this, numXfered, len2);
        }
        return numXfered;
    }

    @Override
    public long transferTo(OutputStream out2) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("transferTo(" + this.getPath() + ") stream closed");
        }
        long numXfered = this.doRead(Long.MAX_VALUE, buf -> out2.write(buf.array(), buf.rpos(), buf.available()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferTo({}) transferred {} bytes", (Object)this, (Object)numXfered);
        }
        return numXfered;
    }

    private long doRead(long max2, BufferConsumer consumer2) throws IOException {
        long orgOffset = this.clientOffset;
        while (max2 > 0L) {
            if (this.hasNoData()) {
                if (this.eofIndicator) break;
                boolean backtracked = false;
                if (!this.pendingReads.isEmpty()) {
                    backtracked = this.fillData();
                }
                if (this.eofIndicator || backtracked) continue;
                this.sendRequests();
                continue;
            }
            int nb = (int)Math.min(max2, (long)this.buffer.available());
            consumer2.consume(new ByteArrayBuffer(this.buffer.array(), this.buffer.rpos(), nb));
            this.buffer.rpos(this.buffer.rpos() + nb);
            this.clientOffset += (long)nb;
            max2 -= (long)nb;
        }
        return this.clientOffset - orgOffset;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("skip(" + this.getPath() + ") stream closed");
        }
        if (this.clientOffset == 0L && this.pendingReads.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("skip({}) virtual skip of {} bytes", (Object)this, (Object)n);
            }
            this.requestOffset = n;
            this.clientOffset = n;
            return n;
        }
        return super.skip(n);
    }

    protected boolean hasNoData() {
        return this.buffer == null || this.buffer.available() == 0;
    }

    protected void sendRequests() throws IOException {
        AbstractSftpClient client2 = this.getClient();
        Channel channel2 = client2.getChannel();
        LocalWindow localWindow = channel2.getLocalWindow();
        long windowSize = localWindow.getMaxSize();
        ClientSession session2 = client2.getSession();
        byte[] id = this.handle.getIdentifier();
        boolean debugEnabled = this.log.isTraceEnabled();
        if (this.fileSize > 0L && this.requestOffset > this.fileSize) {
            if (!this.pendingReads.isEmpty()) {
                return;
            }
            this.requestOffset = this.clientOffset + (long)this.buffer.available();
        }
        while ((long)this.pendingReads.size() < Math.max(1L, windowSize / (long)this.bufferSize)) {
            Buffer buf = session2.createBuffer((byte)94, 39 + id.length);
            buf.rpos(23);
            buf.wpos(23);
            buf.putBytes(id);
            buf.putLong(this.requestOffset);
            buf.putUInt(this.bufferSize);
            int reqId = client2.send(5, buf);
            SftpAckData ack = new SftpAckData(reqId, this.requestOffset, this.bufferSize);
            if (debugEnabled) {
                this.log.debug("sendRequests({}) enqueue pending ack: {}", (Object)this, (Object)ack);
            }
            this.pendingReads.add(ack);
            this.requestOffset += (long)this.bufferSize;
            if (this.fileSize <= 0L || this.requestOffset <= this.fileSize) continue;
            break;
        }
    }

    protected boolean fillData() throws IOException {
        SftpAckData ack = this.pendingReads.pollFirst();
        boolean traceEnabled = this.log.isTraceEnabled();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (ack == null) {
            if (traceEnabled) {
                this.log.trace("fillData({}) no pending ack", (Object)this);
            }
            return false;
        }
        if (traceEnabled) {
            this.log.trace("fillData({}) process ack={}", (Object)this, (Object)ack);
        }
        boolean alreadyEof = this.eofIndicator;
        this.pollBuffer(ack);
        if (!alreadyEof && this.clientOffset < ack.offset) {
            ++this.shortReads;
            int nb = (int)(ack.offset - this.clientOffset);
            byte[] data2 = new byte[nb + this.buffer.available()];
            if (traceEnabled) {
                this.log.trace("fillData({}) reading {} bytes", (Object)this, (Object)nb);
            }
            AtomicReference<Boolean> eof = new AtomicReference<Boolean>();
            AbstractSftpClient client2 = this.getClient();
            int cur = 0;
            while (cur < nb) {
                int dlen = client2.read(this.handle, this.clientOffset + (long)cur, data2, cur, nb - cur, eof);
                if (dlen > 0) {
                    cur += dlen;
                }
                Boolean eofSignal = eof.getAndSet(null);
                if (dlen >= 0 && (eofSignal == null || !eofSignal.booleanValue())) continue;
                this.eofIndicator = true;
                break;
            }
            if (debugEnabled) {
                this.log.debug("fillData({}) read {} of {} bytes - EOF={}", this, cur, nb, this.eofIndicator);
            }
            if (cur == 0) {
                this.buffer.rpos(this.buffer.wpos());
            } else if (cur < nb) {
                this.buffer = new ByteArrayBuffer(data2, 0, cur);
            } else {
                this.buffer.getRawBytes(data2, cur, this.buffer.available());
                this.buffer = new ByteArrayBuffer(data2);
            }
            if (!this.eofIndicator && !this.bufferAdjusted) {
                int newBufferSize = this.adjustBufferIfNeeded(this.bufferSize, this.shortReads, this.maxReceived, ack.offset - this.clientOffset);
                if (newBufferSize > 0 && newBufferSize < this.bufferSize) {
                    int originalSize = this.bufferSize;
                    this.bufferSize = newBufferSize;
                    this.bufferAdjusted = true;
                    if (debugEnabled) {
                        this.log.debug("adjustBufferIfNeeded({}) changing SFTP buffer size: {} -> {}", this, originalSize, this.bufferSize);
                    }
                } else if (newBufferSize > this.bufferSize) {
                    throw new IllegalStateException("New buffer size " + newBufferSize + " > existing size " + this.bufferSize);
                }
            }
            return !this.pendingReads.isEmpty();
        }
        return false;
    }

    protected int adjustBufferIfNeeded(int currentBufferSize, long nOfShortReads, int maxBufferReceived, long gap) {
        if (currentBufferSize > 8192 && nOfShortReads > 4L) {
            return Math.max(8192, maxBufferReceived);
        }
        return currentBufferSize;
    }

    protected void pollBuffer(SftpAckData ack) throws IOException {
        AtomicReference<Boolean> eofSignalled;
        Buffer buf;
        if (this.log.isTraceEnabled()) {
            this.log.trace("pollBuffer({}) polling ack={}", (Object)this, (Object)ack);
        }
        AbstractSftpClient client2 = this.getClient();
        SftpResponse response2 = client2.response(5, ack.id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("pollBuffer({}) response={} for ack={} - len={}", this, response2.getType(), ack, response2.getLength());
        }
        if ((buf = client2.checkDataResponse(ack, response2, eofSignalled = new AtomicReference<Boolean>())) == null) {
            this.eofIndicator = true;
        } else {
            this.maxReceived = Math.max(buf.available(), this.maxReceived);
            Boolean eof = eofSignalled.get();
            if (eof != null && eof.booleanValue()) {
                this.eofIndicator = true;
            }
            this.buffer = buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                int ackIndex = 1;
                while (!this.pendingReads.isEmpty()) {
                    SftpAckData ack = this.pendingReads.removeFirst();
                    if (debugEnabled) {
                        this.log.debug("close({}) process ack #{}: {}", this, ackIndex, ack);
                    }
                    this.pollBuffer(ack);
                    ++ackIndex;
                }
            }
            finally {
                if (this.ownsHandle) {
                    if (debugEnabled) {
                        this.log.debug("close({}) closing file handle; {} short reads", (Object)this, (Object)this.shortReads);
                    }
                    this.handle.close();
                }
            }
        }
        finally {
            this.handle = null;
        }
    }

    public String toString() {
        AbstractSftpClient client2 = this.getClient();
        return this.getClass().getSimpleName() + "[" + client2.getSession() + "][" + this.getPath() + "]";
    }

    static interface BufferConsumer {
        public void consume(Buffer var1) throws IOException;
    }
}

