/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpInputStreamAsync;
import org.apache.sshd.sftp.client.impl.SftpOutputStreamAsync;
import org.apache.sshd.sftp.common.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpRemotePathChannel
extends FileChannel {
    public static final Set<SftpClient.OpenMode> READ_MODES = Collections.unmodifiableSet(EnumSet.of(SftpClient.OpenMode.Read));
    public static final Set<SftpClient.OpenMode> WRITE_MODES = Collections.unmodifiableSet(EnumSet.of(SftpClient.OpenMode.Write, SftpClient.OpenMode.Append, SftpClient.OpenMode.Create, SftpClient.OpenMode.Truncate));
    protected final Logger log;
    protected final Collection<SftpClient.OpenMode> modes;
    protected final boolean closeOnExit;
    protected final SftpClient sftp;
    protected final SftpClient.CloseableHandle handle;
    protected final Object lock = new Object();
    protected final AtomicLong posTracker = new AtomicLong(0L);
    protected final AtomicReference<Thread> blockingThreadHolder = new AtomicReference<Object>(null);
    private final String path;

    public SftpRemotePathChannel(String path2, SftpClient sftp, boolean closeOnExit, Collection<SftpClient.OpenMode> modes) throws IOException {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.path = ValidateUtils.hasContent(path2, "No remote file path specified");
        this.modes = Collections.unmodifiableSet(EnumSet.copyOf(modes));
        if (this.modes.isEmpty()) {
            throw new IllegalArgumentException("At least one OpenMode is required for a SftpRemotePathChannel");
        }
        this.sftp = Objects.requireNonNull(sftp, "No SFTP client instance");
        this.closeOnExit = closeOnExit;
        this.handle = sftp.open(path2, this.modes);
    }

    public String getRemotePath() {
        return this.path;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        long totalRead = this.doRead(Collections.singletonList(dst), -1L);
        if (totalRead >= Integer.MAX_VALUE) {
            throw new StreamCorruptedException("Total read size exceeds integer: " + totalRead);
        }
        return (int)totalRead;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("read(" + this.getRemotePath() + ") illegal position to read from: " + position);
        }
        long totalRead = this.doRead(Collections.singletonList(dst), position);
        if (totalRead >= Integer.MAX_VALUE) {
            throw new StreamCorruptedException("Total read size exceeds integer: " + totalRead);
        }
        return (int)totalRead;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        List<ByteBuffer> buffers = Arrays.asList(dsts).subList(offset, offset + length);
        return this.doRead(buffers, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doRead(Collection<? extends ByteBuffer> buffers, long position) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ensureMode(false);
        ClientSession clientSession = this.sftp.getClientSession();
        int copySize = SftpModuleProperties.COPY_BUF_SIZE.getRequired(clientSession);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doRead({})[position={}] fill {} buffers using copySize={}", this, position, buffers.size(), copySize);
        }
        boolean completed = false;
        boolean eof = false;
        long totalRead = 0L;
        int numBufsUsed = 0;
        Object object = this.lock;
        synchronized (object) {
            long curPos = position >= 0L ? position : this.posTracker.get();
            try {
                this.beginBlocking("doRead");
                block6: for (ByteBuffer byteBuffer : buffers) {
                    ++numBufsUsed;
                    while (byteBuffer.remaining() > 0) {
                        int read2;
                        ByteBuffer wrap2 = byteBuffer;
                        if (!byteBuffer.hasArray()) {
                            wrap2 = ByteBuffer.allocate(Math.min(copySize, byteBuffer.remaining()));
                        }
                        if ((read2 = this.sftp.read(this.handle, curPos, wrap2.array(), wrap2.arrayOffset() + wrap2.position(), wrap2.remaining())) > 0) {
                            if (wrap2 == byteBuffer) {
                                wrap2.position(wrap2.position() + read2);
                            } else {
                                byteBuffer.put(wrap2.array(), wrap2.arrayOffset(), read2);
                            }
                            curPos += (long)read2;
                            totalRead += (long)read2;
                            continue;
                        }
                        eof = read2 == -1;
                        break block6;
                    }
                }
                completed = true;
            }
            finally {
                if (position < 0L) {
                    this.posTracker.set(curPos);
                }
                this.endBlocking("doRead", completed);
            }
        }
        if (debugEnabled) {
            this.log.debug("doRead({})[position={}] filled {}/{} with copySize={} - totalRead={}, completed={}, eof={}", this, position, numBufsUsed, buffers.size(), copySize, totalRead, completed, eof);
        }
        if (totalRead > 0L) {
            return totalRead;
        }
        if (eof) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        long totalWritten = this.doWrite(Collections.singletonList(src), -1L);
        if (totalWritten >= Integer.MAX_VALUE) {
            throw new StreamCorruptedException("Total written size exceeds integer: " + totalWritten);
        }
        return (int)totalWritten;
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("write(" + this.getRemotePath() + ") illegal position to write to: " + position);
        }
        long totalWritten = this.doWrite(Collections.singletonList(src), position);
        if (totalWritten >= Integer.MAX_VALUE) {
            throw new StreamCorruptedException("Total written size exceeds integer: " + totalWritten);
        }
        return (int)totalWritten;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        List<ByteBuffer> buffers = Arrays.asList(srcs).subList(offset, offset + length);
        return this.doWrite(buffers, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doWrite(Collection<? extends ByteBuffer> buffers, long position) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ensureMode(true);
        ClientSession clientSession = this.sftp.getClientSession();
        int copySize = SftpModuleProperties.COPY_BUF_SIZE.getRequired(clientSession);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doWrite({})[position={}] write {} buffers using copySize={}", this, position, buffers.size(), copySize);
        }
        boolean completed = false;
        long totalWritten = 0L;
        int numBufsUsed = 0;
        Object object = this.lock;
        synchronized (object) {
            long curPos = position >= 0L ? position : this.posTracker.get();
            try {
                this.beginBlocking("doWrite");
                for (ByteBuffer byteBuffer : buffers) {
                    ++numBufsUsed;
                    while (byteBuffer.remaining() > 0) {
                        ByteBuffer wrap2 = byteBuffer;
                        if (!byteBuffer.hasArray()) {
                            wrap2 = ByteBuffer.allocate(Math.min(copySize, byteBuffer.remaining()));
                            byteBuffer.get(wrap2.array(), wrap2.arrayOffset(), wrap2.remaining());
                        }
                        int written = wrap2.remaining();
                        this.sftp.write(this.handle, curPos, wrap2.array(), wrap2.arrayOffset() + wrap2.position(), written);
                        if (wrap2 == byteBuffer) {
                            wrap2.position(wrap2.position() + written);
                        }
                        curPos += (long)written;
                        totalWritten += (long)written;
                    }
                }
                completed = true;
            }
            finally {
                if (position < 0L) {
                    this.posTracker.set(curPos);
                }
                this.endBlocking("doWrite", completed);
            }
        }
        if (debugEnabled) {
            this.log.debug("doWrite({})[position={}] used {}/{} with copySize={} - totalWritten={}, completed={}", this, position, numBufsUsed, buffers.size(), copySize, totalWritten, completed);
        }
        return totalWritten;
    }

    @Override
    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.posTracker.get();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("position(" + this.getRemotePath() + ") illegal file channel position: " + newPosition);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.posTracker.set(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        SftpClient.Attributes stat = this.sftp.stat(this.handle);
        return stat.getSize();
    }

    @Override
    public FileChannel truncate(long size2) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ensureMode(true);
        this.sftp.setStat(this.handle, new SftpClient.Attributes().size(size2));
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count2, WritableByteChannel target) throws IOException {
        boolean eof;
        long totalRead;
        if (position < 0L || count2 < 0L) {
            throw new IllegalArgumentException("transferTo(" + this.getRemotePath() + ") illegal position (" + position + ") or count (" + count2 + ")");
        }
        if (!this.isOpen() || !target.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ensureMode(false);
        ClientSession clientSession = this.sftp.getClientSession();
        int copySize = SftpModuleProperties.COPY_BUF_SIZE.getRequired(clientSession);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("transferTo({})[position={}, count={}] use copySize={} for target={}", this, position, count2, copySize, target);
        }
        boolean completed = false;
        Object object = this.lock;
        synchronized (object) {
            this.beginBlocking("transferTo");
            try (SftpInputStreamAsync input = new SftpInputStreamAsync((AbstractSftpClient)this.sftp, copySize, position, count2, this.getRemotePath(), this.handle, false);){
                totalRead = input.transferTo(count2, target);
                eof = input.isEof();
                completed = true;
            }
            finally {
                this.endBlocking("transferTo", completed);
            }
        }
        if (debugEnabled) {
            this.log.debug("transferTo({})[position={}, count={}] with copySize={} - totalRead={}, eo{} for target={}", this, position, count2, copySize, totalRead, eof, target);
        }
        if (totalRead > 0L) {
            return totalRead;
        }
        return eof ? -1L : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count2) throws IOException {
        if (position < 0L || count2 < 0L) {
            throw new IllegalArgumentException("transferFrom(" + this.getRemotePath() + ") illegal position (" + position + ") or count (" + count2 + ")");
        }
        if (!this.isOpen() || !src.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ensureMode(true);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("transferFrom({})[position={}, count={}] for source={}", this, position, count2, src);
        }
        boolean completed = false;
        long totalWritten = 0L;
        Object object = this.lock;
        synchronized (object) {
            this.beginBlocking("transferFrom");
            try (SftpOutputStreamAsync output = new SftpOutputStreamAsync((AbstractSftpClient)this.sftp, 0, this.getRemotePath(), this.handle, false);){
                output.setOffset(position);
                totalWritten = output.transferFrom(src, count2);
                output.flush();
                completed = true;
            }
            finally {
                this.endBlocking("transferFrom", completed);
            }
        }
        if (debugEnabled) {
            this.log.debug("transferFrom({})[position={}, count={}] - totalRead={}, completed={} for source={}", this, position, count2, totalWritten, completed, src);
        }
        return totalWritten;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size2) throws IOException {
        throw new UnsupportedOperationException("map(" + this.getRemotePath() + ")[" + mode + "," + position + "," + size2 + "] N/A");
    }

    @Override
    public FileLock lock(long position, long size2, boolean shared) throws IOException {
        return this.tryLock(position, size2, shared);
    }

    @Override
    public FileLock tryLock(final long position, final long size2, boolean shared) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ensureMode(!shared);
        int lockFlags = shared ? 64 : 128;
        try {
            this.sftp.lock(this.handle, position, size2, lockFlags);
        }
        catch (SftpException e2) {
            if (e2.getStatus() == 17) {
                throw new OverlappingFileLockException();
            }
            throw e2;
        }
        return new FileLock(this, position, size2, shared){
            private final AtomicBoolean valid;
            {
                super(arg0, arg1, arg2, arg3);
                this.valid = new AtomicBoolean(true);
            }

            @Override
            public boolean isValid() {
                return this.acquiredBy().isOpen() && this.valid.get();
            }

            @Override
            public void release() throws IOException {
                if (this.valid.getAndSet(false)) {
                    SftpRemotePathChannel.this.sftp.unlock(SftpRemotePathChannel.this.handle, position, size2);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("implCloseChannel({}) closeOnExit={}", (Object)this, (Object)this.closeOnExit);
        }
        try {
            Thread thread2 = this.blockingThreadHolder.get();
            if (thread2 != null) {
                thread2.interrupt();
            }
        }
        finally {
            try {
                this.handle.close();
            }
            finally {
                if (this.closeOnExit) {
                    this.sftp.close();
                }
            }
        }
    }

    protected void beginBlocking(Object actionHint) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("beginBlocking({})[{}]", (Object)this, actionHint);
        }
        this.begin();
        this.blockingThreadHolder.set(Thread.currentThread());
    }

    protected void endBlocking(Object actionHint, boolean completed) throws AsynchronousCloseException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("endBlocking({})[{}] completed={}", this, actionHint, completed);
        }
        this.blockingThreadHolder.set(null);
        this.end(completed);
    }

    private void ensureMode(boolean forWriting) {
        if (!forWriting && !this.modes.contains((Object)SftpClient.OpenMode.Read)) {
            throw new NonReadableChannelException();
        }
        if (forWriting) {
            EnumSet<SftpClient.OpenMode> myModes = EnumSet.copyOf(this.modes);
            myModes.retainAll(WRITE_MODES);
            if (myModes.isEmpty()) {
                throw new NonWritableChannelException();
            }
        }
    }

    public String toString() {
        return this.getRemotePath();
    }
}

