/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.common.SftpConstants;

public final class SftpResponse {
    private final int cmd;
    private final int id;
    private final int type;
    private final int length;
    private final Buffer buffer;

    private SftpResponse(int cmd, int id, int type2, int length, Buffer buffer) {
        this.cmd = cmd;
        this.id = id;
        this.type = type2;
        this.length = length;
        this.buffer = buffer;
    }

    public int getCmd() {
        return this.cmd;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public static SftpResponse parse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type2 = buffer.getUByte();
        int id = buffer.getInt();
        return new SftpResponse(cmd, id, type2, length, buffer);
    }

    public static void validateIncomingResponse(int cmd, int id, int type2, int length, Buffer buffer) throws IOException {
        int remaining = buffer.available();
        if (length < 0 || length > remaining + 5) {
            throw new SshException("Bad length (" + length + ") for remaining data (" + remaining + ") in response to " + SftpConstants.getCommandMessageName(cmd) + ": type=" + SftpConstants.getCommandMessageName(type2) + ", id=" + id);
        }
    }
}

