/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;

public final class SftpStatus {
    private final int statusCode;
    private final String language;
    private final String message;

    private SftpStatus(int statusCode, String message, String language) {
        this.statusCode = statusCode;
        this.message = message;
        this.language = language;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isOk() {
        return this.statusCode == 0;
    }

    public String toString() {
        return "SSH_FXP_STATUS[" + SftpConstants.getStatusName(this.statusCode) + ", language=" + this.language + ", message=" + this.message + ']';
    }

    static SftpStatus parse(Buffer buffer) {
        int code = buffer.getInt();
        String message = buffer.available() > 0 ? buffer.getString() : null;
        String language = buffer.available() > 0 ? buffer.getString() : null;
        return new SftpStatus(code, message, language);
    }

    public static SftpStatus parse(SftpResponse response2) throws SftpException {
        if (response2.getType() != 101) {
            throw new SftpException(5, "Unexpected SFTP response: expected SSH_FXP_STATUS but got " + SftpConstants.getCommandMessageName(response2.getType()));
        }
        return SftpStatus.parse(response2.getBuffer());
    }
}

