/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SimpleSftpClient;

public class SimpleSftpClientImpl
extends AbstractLoggingBean
implements SimpleSftpClient {
    private SimpleClient clientInstance;
    private SftpClientFactory sftpClientFactory;

    public SimpleSftpClientImpl() {
        this((SimpleClient)null);
    }

    public SimpleSftpClientImpl(SimpleClient client2) {
        this(client2, null);
    }

    public SimpleSftpClientImpl(SimpleClient client2, SftpClientFactory sftpClientFactory) {
        this.clientInstance = client2;
        this.setSftpClientFactory(sftpClientFactory);
    }

    public SimpleClient getClient() {
        return this.clientInstance;
    }

    public void setClient(SimpleClient client2) {
        this.clientInstance = client2;
    }

    public SftpClientFactory getSftpClientFactory() {
        return this.sftpClientFactory;
    }

    public void setSftpClientFactory(SftpClientFactory sftpClientFactory) {
        this.sftpClientFactory = sftpClientFactory != null ? sftpClientFactory : SftpClientFactory.instance();
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, String password) throws IOException {
        return this.createSftpClient((? super SimpleClient client2) -> client2.sessionLogin(target, username, password));
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.createSftpClient((? super SimpleClient client2) -> client2.sessionLogin(target, username, identity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SftpClient createSftpClient(IOFunction<? super SimpleClient, ? extends ClientSession> sessionProvider) throws IOException {
        SimpleClient client2 = this.getClient();
        try (ClientSession session2 = sessionProvider.apply(client2);){
            SftpClient sftp = this.createSftpClient(session2);
            session2 = null;
            SftpClient sftpClient = sftp;
            return sftpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SftpClient createSftpClient(ClientSession session2) throws IOException {
        Exception err = null;
        try {
            SftpClient client2 = this.sftpClientFactory.createSftpClient(session2);
            try {
                SftpClient closer = client2.singleSessionInstance();
                client2 = null;
                SftpClient sftpClient = closer;
                return sftpClient;
            }
            catch (Exception e2) {
                err = ExceptionUtils.accumulateException(err, e2);
            }
            finally {
                if (client2 != null) {
                    try {
                        client2.close();
                    }
                    catch (Exception t3) {
                        this.debug("createSftpClient({}) failed ({}) to close client: {}", session2, t3.getClass().getSimpleName(), t3.getMessage(), t3);
                        err = ExceptionUtils.accumulateException(err, t3);
                    }
                }
            }
        }
        catch (Exception e3) {
            err = ExceptionUtils.accumulateException(err, e3);
        }
        this.log.warn("createSftpClient({}) failed ({}) to create client: {}", session2, err.getClass().getSimpleName(), err.getMessage());
        try {
            session2.close();
        }
        catch (Exception e4) {
            this.debug("createSftpClient({}) failed ({}) to close session: {}", session2, e4.getClass().getSimpleName(), e4.getMessage(), e4);
            err = ExceptionUtils.accumulateException(err, e4);
        }
        if (!(err instanceof IOException)) throw new IOException(err);
        throw (IOException)err;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

