/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.net.UnknownServiceException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpUniversalOwnerAndGroup;
import org.apache.sshd.sftp.server.DefaultGroupPrincipal;
import org.apache.sshd.sftp.server.InvalidHandleException;
import org.apache.sshd.sftp.server.UnixDateFormat;

public final class SftpHelper {
    public static final Map<Integer, String> DEFAULT_SUBSTATUS_MESSAGE;
    private static final Pattern UNIX_PERMISSIONS_START;

    private SftpHelper() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Boolean getEndOfFileIndicatorValue(Buffer buffer, int version2) {
        return version2 < 6 || buffer.available() < 1 ? null : Boolean.valueOf(buffer.getBoolean());
    }

    public static Boolean getEndOfListIndicatorValue(Buffer buffer, int version2) {
        return version2 < 6 || buffer.available() < 1 ? null : Boolean.valueOf(buffer.getBoolean());
    }

    public static Boolean indicateEndOfNamesList(Buffer buffer, int version2, PropertyResolver resolver) {
        return SftpHelper.indicateEndOfNamesList(buffer, version2, resolver, true);
    }

    public static Boolean indicateEndOfNamesList(Buffer buffer, int version2, PropertyResolver resolver, boolean indicatorValue) {
        if (version2 < 6) {
            return null;
        }
        if (!SftpModuleProperties.APPEND_END_OF_LIST_INDICATOR.getRequired(resolver).booleanValue()) {
            return null;
        }
        buffer.putBoolean(indicatorValue);
        return indicatorValue;
    }

    public static <B extends Buffer> B writeAttrs(B buffer, int version2, Map<String, ?> attributes2) {
        if (version2 == 3) {
            return SftpHelper.writeAttrsV3(buffer, version2, attributes2);
        }
        if (version2 >= 4) {
            return SftpHelper.writeAttrsV4(buffer, version2, attributes2);
        }
        throw new IllegalStateException("Unsupported SFTP version: " + version2);
    }

    public static <B extends Buffer> B writeAttrsV3(B buffer, int version2, Map<String, ?> attributes2) {
        ValidateUtils.checkTrue(version2 == 3, "Illegal version: %d", version2);
        boolean isReg = SftpHelper.getBool((Boolean)attributes2.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes2.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes2.get("isSymbolicLink"));
        Collection perms = (Collection)attributes2.get("permissions");
        Number size2 = (Number)attributes2.get("size");
        FileTime lastModifiedTime = (FileTime)attributes2.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes2.get("lastAccessTime");
        Map extensions = (Map)attributes2.get("extended");
        int flags = ((isReg || isLnk) && size2 != null ? 1 : 0) | (attributes2.containsKey("uid") && attributes2.containsKey("gid") ? 2 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null && lastAccessTime != null ? 8 : 0) | (extensions != null ? Integer.MIN_VALUE : 0);
        buffer.putInt(flags);
        if ((flags & 1) != 0) {
            buffer.putLong(size2.longValue());
        }
        if ((flags & 2) != 0) {
            buffer.putInt(((Number)attributes2.get("uid")).intValue());
            buffer.putInt(((Number)attributes2.get("gid")).intValue());
        }
        if ((flags & 4) != 0) {
            buffer.putInt(SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            buffer = SftpHelper.writeTime(buffer, version2, flags, lastAccessTime);
            buffer = SftpHelper.writeTime(buffer, version2, flags, lastModifiedTime);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, extensions);
        }
        return buffer;
    }

    public static <B extends Buffer> B writeAttrsV4(B buffer, int version2, Map<String, ?> attributes2) {
        ValidateUtils.checkTrue(version2 >= 4, "Illegal version: %d", version2);
        boolean isReg = SftpHelper.getBool((Boolean)attributes2.get("isRegularFile"));
        boolean isDir = SftpHelper.getBool((Boolean)attributes2.get("isDirectory"));
        boolean isLnk = SftpHelper.getBool((Boolean)attributes2.get("isSymbolicLink"));
        Collection perms = (Collection)attributes2.get("permissions");
        Number size2 = (Number)attributes2.get("size");
        FileTime lastModifiedTime = (FileTime)attributes2.get("lastModifiedTime");
        FileTime lastAccessTime = (FileTime)attributes2.get("lastAccessTime");
        FileTime creationTime = (FileTime)attributes2.get("creationTime");
        Collection acl = (Collection)attributes2.get("acl");
        Map extensions = (Map)attributes2.get("extended");
        int flags = ((isReg || isLnk) && size2 != null ? 1 : 0) | (attributes2.containsKey("owner") && attributes2.containsKey("group") ? 128 : 0) | (perms != null ? 4 : 0) | (lastModifiedTime != null ? 32 : 0) | (creationTime != null ? 16 : 0) | (lastAccessTime != null ? 8 : 0) | (acl != null ? 64 : 0) | (extensions != null ? Integer.MIN_VALUE : 0);
        buffer.putInt(flags);
        buffer.putByte((byte)(isReg ? 1 : (isDir ? 2 : (isLnk ? 3 : 5))));
        if ((flags & 1) != 0) {
            buffer.putLong(size2.longValue());
        }
        if ((flags & 0x80) != 0) {
            buffer.putString(Objects.toString(attributes2.get("owner"), SftpUniversalOwnerAndGroup.Owner.getName()));
            buffer.putString(Objects.toString(attributes2.get("group"), SftpUniversalOwnerAndGroup.Group.getName()));
        }
        if ((flags & 4) != 0) {
            buffer.putInt(SftpHelper.attributesToPermissions(isReg, isDir, isLnk, perms));
        }
        if ((flags & 8) != 0) {
            buffer = SftpHelper.writeTime(buffer, version2, flags, lastAccessTime);
        }
        if ((flags & 0x10) != 0) {
            buffer = SftpHelper.writeTime(buffer, version2, flags, creationTime);
        }
        if ((flags & 0x20) != 0) {
            buffer = SftpHelper.writeTime(buffer, version2, flags, lastModifiedTime);
        }
        if ((flags & 0x40) != 0) {
            buffer = SftpHelper.writeACLs(buffer, version2, acl);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, extensions);
        }
        return buffer;
    }

    public static <B extends Buffer> B writeAttributes(B buffer, SftpClient.Attributes attributes2, int sftpVersion) {
        int flagsMask = 0;
        Set<SftpClient.Attribute> flags = Objects.requireNonNull(attributes2, "No attributes").getFlags();
        if (sftpVersion == 3) {
            for (SftpClient.Attribute a2 : flags) {
                switch (a2) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case UidGid: {
                        flagsMask |= 2;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.ModifyTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.AccessTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt(flagsMask);
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes2.getSize());
            }
            if ((flagsMask & 2) != 0) {
                buffer.putInt(attributes2.getUserId());
                buffer.putInt(attributes2.getGroupId());
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt(attributes2.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes2.getAccessTime());
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes2.getModifyTime());
            }
        } else if (sftpVersion >= 4) {
            for (SftpClient.Attribute a3 : flags) {
                switch (a3) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case OwnerGroup: {
                        String owner = attributes2.getOwner();
                        String group = attributes2.getGroup();
                        if (!GenericUtils.isNotEmpty(owner) || !GenericUtils.isNotEmpty(group)) break;
                        flagsMask |= 0x80;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        flagsMask |= 0x20;
                        break;
                    }
                    case CreateTime: {
                        flagsMask |= 0x10;
                        break;
                    }
                    case Acl: {
                        flagsMask |= 0x40;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt(flagsMask);
            buffer.putByte((byte)attributes2.getType());
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes2.getSize());
            }
            if ((flagsMask & 0x80) != 0) {
                String owner = attributes2.getOwner();
                buffer.putString(owner);
                String group = attributes2.getGroup();
                buffer.putString(group);
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt(attributes2.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes2.getAccessTime());
            }
            if ((flagsMask & 0x10) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes2.getCreateTime());
            }
            if ((flagsMask & 0x20) != 0) {
                buffer = SftpHelper.writeTime(buffer, sftpVersion, flagsMask, attributes2.getModifyTime());
            }
            if ((flagsMask & 0x40) != 0) {
                buffer = SftpHelper.writeACLs(buffer, sftpVersion, attributes2.getAcl());
            }
        } else {
            throw new UnsupportedOperationException("writeAttributes(" + attributes2 + ") unsupported version: " + sftpVersion);
        }
        if ((flagsMask & Integer.MIN_VALUE) != 0) {
            buffer = SftpHelper.writeExtensions(buffer, attributes2.getExtensions());
        }
        return buffer;
    }

    public static boolean getBool(Boolean bool) {
        return bool != null && bool != false;
    }

    public static int attributesToPermissions(boolean isReg, boolean isDir, boolean isLnk, Collection<PosixFilePermission> perms) {
        int pf = 0;
        if (perms != null) {
            for (PosixFilePermission p : perms) {
                switch (p) {
                    case OWNER_READ: {
                        pf |= 0x100;
                        break;
                    }
                    case OWNER_WRITE: {
                        pf |= 0x80;
                        break;
                    }
                    case OWNER_EXECUTE: {
                        pf |= 0x40;
                        break;
                    }
                    case GROUP_READ: {
                        pf |= 0x20;
                        break;
                    }
                    case GROUP_WRITE: {
                        pf |= 0x10;
                        break;
                    }
                    case GROUP_EXECUTE: {
                        pf |= 8;
                        break;
                    }
                    case OTHERS_READ: {
                        pf |= 4;
                        break;
                    }
                    case OTHERS_WRITE: {
                        pf |= 2;
                        break;
                    }
                    case OTHERS_EXECUTE: {
                        pf |= 1;
                        break;
                    }
                }
            }
        }
        pf |= isReg ? 32768 : 0;
        pf |= isDir ? 16384 : 0;
        return pf |= isLnk ? 40960 : 0;
    }

    public static int permissionsToFileType(int perms) {
        switch (perms & 0xF000) {
            case 40960: {
                return 3;
            }
            case 32768: {
                return 1;
            }
            case 16384: {
                return 2;
            }
            case 49152: {
                return 6;
            }
            case 24576: {
                return 8;
            }
            case 8192: {
                return 7;
            }
            case 4096: {
                return 9;
            }
        }
        return 5;
    }

    public static int fileTypeToPermission(int type2) {
        switch (type2) {
            case 1: {
                return 32768;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 40960;
            }
            case 6: {
                return 49152;
            }
            case 8: {
                return 24576;
            }
            case 7: {
                return 8192;
            }
            case 9: {
                return 4096;
            }
        }
        return 0;
    }

    public static int fileTypeFromChar(char ch) {
        switch (ch) {
            case '-': {
                return 1;
            }
            case 'd': {
                return 2;
            }
            case 'l': {
                return 3;
            }
            case 's': {
                return 6;
            }
            case 'b': {
                return 8;
            }
            case 'c': {
                return 7;
            }
            case 'p': {
                return 9;
            }
        }
        return 5;
    }

    public static SftpClient.Attributes complete(SftpClient.Attributes attrs, String longName) {
        int type2;
        if (longName == null || longName.isEmpty()) {
            return attrs;
        }
        if (attrs.getType() == 5 && (attrs.getPermissions() & 0xF000) == 0 && SftpHelper.isUnixPermissions(longName) && (type2 = SftpHelper.fileTypeFromChar(longName.charAt(0))) != 5) {
            attrs.setType(type2);
            attrs.setPermissions(attrs.getPermissions() | SftpHelper.fileTypeToPermission(type2));
        }
        return attrs;
    }

    private static boolean isUnixPermissions(String longName) {
        int i2 = longName.indexOf(32);
        if (i2 < 6 || i2 > 11) {
            return false;
        }
        return UNIX_PERMISSIONS_START.matcher(longName.substring(0, i2)).matches();
    }

    public static Set<PosixFilePermission> permissionsToAttributes(int perms) {
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) != 0) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) != 0) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) != 0) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) != 0) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) != 0) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) != 0) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) != 0) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) != 0) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) != 0) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }

    public static int resolveSubstatus(Throwable t2) {
        if (t2 instanceof NoSuchFileException || t2 instanceof FileNotFoundException) {
            return 2;
        }
        if (t2 instanceof InvalidHandleException) {
            return 9;
        }
        if (t2 instanceof FileAlreadyExistsException) {
            return 11;
        }
        if (t2 instanceof DirectoryNotEmptyException) {
            return 18;
        }
        if (t2 instanceof NotDirectoryException) {
            return 19;
        }
        if (t2 instanceof AccessDeniedException) {
            return 3;
        }
        if (t2 instanceof EOFException) {
            return 1;
        }
        if (t2 instanceof OverlappingFileLockException) {
            return 17;
        }
        if (t2 instanceof UnsupportedOperationException || t2 instanceof UnknownServiceException) {
            return 8;
        }
        if (t2 instanceof InvalidPathException) {
            return 20;
        }
        if (t2 instanceof IllegalArgumentException) {
            return 23;
        }
        if (t2 instanceof UserPrincipalNotFoundException) {
            return 16;
        }
        if (t2 instanceof FileSystemLoopException) {
            return 21;
        }
        if (t2 instanceof SftpException) {
            return ((SftpException)t2).getStatus();
        }
        return 4;
    }

    public static String resolveStatusMessage(int subStatus) {
        String message = DEFAULT_SUBSTATUS_MESSAGE.get(subStatus);
        return GenericUtils.isEmpty(message) ? "Unknown error: " + subStatus : message;
    }

    public static NavigableMap<String, Object> readAttrs(Buffer buffer, int version2) {
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        int flags = buffer.getInt();
        if (version2 >= 4) {
            int type2 = buffer.getUByte();
            switch (type2) {
                case 1: {
                    attrs.put("isRegularFile", Boolean.TRUE);
                    break;
                }
                case 2: {
                    attrs.put("isDirectory", Boolean.TRUE);
                    break;
                }
                case 3: {
                    attrs.put("isSymbolicLink", Boolean.TRUE);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    attrs.put("isOther", Boolean.TRUE);
                    break;
                }
            }
        }
        if ((flags & 1) != 0) {
            attrs.put("size", buffer.getLong());
        }
        if (version2 == 3) {
            if ((flags & 2) != 0) {
                attrs.put("uid", buffer.getInt());
                attrs.put("gid", buffer.getInt());
            }
        } else {
            if (version2 >= 6 && (flags & 0x400) != 0) {
                long type2 = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.put("owner", new DefaultGroupPrincipal(buffer.getString()));
                attrs.put("group", new DefaultGroupPrincipal(buffer.getString()));
            }
        }
        if ((flags & 4) != 0) {
            attrs.put("permissions", SftpHelper.permissionsToAttributes(buffer.getInt()));
        }
        if (version2 == 3) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, version2, flags));
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, version2, flags));
            }
        } else if (version2 >= 4) {
            if ((flags & 8) != 0) {
                attrs.put("lastAccessTime", SftpHelper.readTime(buffer, version2, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.put("creationTime", SftpHelper.readTime(buffer, version2, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.put("lastModifiedTime", SftpHelper.readTime(buffer, version2, flags));
            }
            if (version2 >= 6 && (flags & 0x8000) != 0) {
                attrs.put("ctime", SftpHelper.readTime(buffer, version2, flags));
            }
            if ((flags & 0x40) != 0) {
                attrs.put("acl", SftpHelper.readACLs(buffer, version2));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version2 >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version2 >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    String string = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = buffer.getString();
                }
            }
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.put("extended", SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    public static NavigableMap<String, byte[]> readExtensions(Buffer buffer) {
        int count2 = buffer.getInt();
        if (count2 < 0 || count2 > 32768) {
            throw new IndexOutOfBoundsException("Illogical extensions count: " + count2);
        }
        TreeMap<String, byte[]> extended = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
        for (int i2 = 1; i2 <= count2; ++i2) {
            byte[] val;
            String key2 = buffer.getString();
            byte[] prev = extended.put(key2, val = buffer.getBytes());
            ValidateUtils.checkTrue(prev == null, "Duplicate values for extended key=%s", (Object)key2);
        }
        return extended;
    }

    public static <B extends Buffer> B writeExtensions(B buffer, Map<?, ?> extensions) {
        int numExtensions = MapEntryUtils.size(extensions);
        buffer.putUInt(numExtensions);
        if (numExtensions <= 0) {
            return buffer;
        }
        for (Map.Entry<?, ?> ee : extensions.entrySet()) {
            Object key2 = Objects.requireNonNull(ee.getKey(), "No extension type");
            Object value2 = Objects.requireNonNull(ee.getValue(), "No extension value");
            buffer.putString(key2.toString());
            if (value2 instanceof byte[]) {
                buffer.putBytes((byte[])value2);
                continue;
            }
            buffer.putString(value2.toString());
        }
        return buffer;
    }

    public static NavigableMap<String, String> toStringExtensions(Map<String, ?> extensions) {
        if (MapEntryUtils.isEmpty(extensions)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, String> map2 = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, ?> ee : extensions.entrySet()) {
            String key2 = Objects.requireNonNull(ee.getKey(), "No extension type");
            Object value2 = ValidateUtils.checkNotNull(ee.getValue(), "No value for extension=%s", (Object)key2);
            String prev = map2.put(key2.toString(), value2 instanceof byte[] ? new String((byte[])value2, StandardCharsets.UTF_8) : value2.toString());
            ValidateUtils.checkTrue(prev == null, "Multiple values for extension=%s", (Object)key2);
        }
        return map2;
    }

    public static NavigableMap<String, byte[]> toBinaryExtensions(Map<String, String> extensions) {
        if (MapEntryUtils.isEmpty(extensions)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, byte[]> map2 = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
        extensions.forEach((key2, value2) -> {
            ValidateUtils.checkNotNull(value2, "No value for extension=%s", key2);
            byte[] prev = map2.put((String)key2, value2.getBytes(StandardCharsets.UTF_8));
            ValidateUtils.checkTrue(prev == null, "Multiple values for extension=%s", key2);
        });
        return map2;
    }

    public static List<AclEntry> readACLs(Buffer buffer, int version2) {
        int aclSize = buffer.getInt();
        if (aclSize < 0 || aclSize > 65536) {
            throw new IndexOutOfBoundsException("Illogical ACL entries size: " + aclSize);
        }
        int startPos = buffer.rpos();
        ByteArrayBuffer aclBuffer = new ByteArrayBuffer(buffer.array(), startPos, aclSize, true);
        List<AclEntry> acl = SftpHelper.decodeACLs(aclBuffer, version2);
        buffer.rpos(startPos + aclSize);
        return acl;
    }

    public static List<AclEntry> decodeACLs(Buffer buffer, int version2) {
        int count2;
        int aclFlags = 0;
        if (version2 >= 6) {
            aclFlags = buffer.getInt();
        }
        if ((count2 = buffer.getInt()) < 0 || count2 > 32768) {
            throw new IndexOutOfBoundsException("Illogical ACL entries count: " + count2);
        }
        ValidateUtils.checkTrue(count2 >= 0, "Invalid ACL entries count: %d", count2);
        if (count2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<AclEntry> acls = new ArrayList<AclEntry>(count2);
        for (int i2 = 1; i2 <= count2; ++i2) {
            int aclType = buffer.getInt();
            int aclFlag = buffer.getInt();
            int aclMask = buffer.getInt();
            String aclWho = buffer.getString();
            acls.add(SftpHelper.buildAclEntry(aclType, aclFlag, aclMask, aclWho));
        }
        return acls;
    }

    public static AclEntry buildAclEntry(int aclType, int aclFlag, int aclMask, String aclWho) {
        DefaultGroupPrincipal who = new DefaultGroupPrincipal(aclWho);
        return AclEntry.newBuilder().setType(ValidateUtils.checkNotNull(SftpHelper.decodeAclEntryType(aclType), "Unknown ACL type: %d", aclType)).setFlags(SftpHelper.decodeAclFlags(aclFlag)).setPermissions(SftpHelper.decodeAclMask(aclMask)).setPrincipal(who).build();
    }

    public static AclEntryType decodeAclEntryType(int aclType) {
        switch (aclType) {
            case 0: {
                return AclEntryType.ALLOW;
            }
            case 1: {
                return AclEntryType.DENY;
            }
            case 2: {
                return AclEntryType.AUDIT;
            }
            case 3: {
                return AclEntryType.ALARM;
            }
        }
        return null;
    }

    public static Set<AclEntryFlag> decodeAclFlags(int aclFlag) {
        EnumSet<AclEntryFlag> flags = EnumSet.noneOf(AclEntryFlag.class);
        if ((aclFlag & 1) != 0) {
            flags.add(AclEntryFlag.FILE_INHERIT);
        }
        if ((aclFlag & 2) != 0) {
            flags.add(AclEntryFlag.DIRECTORY_INHERIT);
        }
        if ((aclFlag & 4) != 0) {
            flags.add(AclEntryFlag.NO_PROPAGATE_INHERIT);
        }
        if ((aclFlag & 8) != 0) {
            flags.add(AclEntryFlag.INHERIT_ONLY);
        }
        return flags;
    }

    public static Set<AclEntryPermission> decodeAclMask(int aclMask) {
        EnumSet<AclEntryPermission> mask = EnumSet.noneOf(AclEntryPermission.class);
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.READ_DATA);
        }
        if ((aclMask & 1) != 0) {
            mask.add(AclEntryPermission.LIST_DIRECTORY);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.WRITE_DATA);
        }
        if ((aclMask & 2) != 0) {
            mask.add(AclEntryPermission.ADD_FILE);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.APPEND_DATA);
        }
        if ((aclMask & 4) != 0) {
            mask.add(AclEntryPermission.ADD_SUBDIRECTORY);
        }
        if ((aclMask & 8) != 0) {
            mask.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if ((aclMask & 0x10) != 0) {
            mask.add(AclEntryPermission.WRITE_NAMED_ATTRS);
        }
        if ((aclMask & 0x20) != 0) {
            mask.add(AclEntryPermission.EXECUTE);
        }
        if ((aclMask & 0x40) != 0) {
            mask.add(AclEntryPermission.DELETE_CHILD);
        }
        if ((aclMask & 0x80) != 0) {
            mask.add(AclEntryPermission.READ_ATTRIBUTES);
        }
        if ((aclMask & 0x100) != 0) {
            mask.add(AclEntryPermission.WRITE_ATTRIBUTES);
        }
        if ((aclMask & 0x10000) != 0) {
            mask.add(AclEntryPermission.DELETE);
        }
        if ((aclMask & 0x20000) != 0) {
            mask.add(AclEntryPermission.READ_ACL);
        }
        if ((aclMask & 0x40000) != 0) {
            mask.add(AclEntryPermission.WRITE_ACL);
        }
        if ((aclMask & 0x80000) != 0) {
            mask.add(AclEntryPermission.WRITE_OWNER);
        }
        if ((aclMask & 0x100000) != 0) {
            mask.add(AclEntryPermission.SYNCHRONIZE);
        }
        return mask;
    }

    public static <B extends Buffer> B writeACLs(B buffer, int version2, Collection<AclEntry> acl) {
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        SftpHelper.encodeACLs(buffer, version2, acl);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
        return buffer;
    }

    public static <B extends Buffer> B encodeACLs(B buffer, int version2, Collection<AclEntry> acl) {
        Objects.requireNonNull(acl, "No ACL");
        if (version2 >= 6) {
            buffer.putUInt(0L);
        }
        int numEntries = GenericUtils.size(acl);
        buffer.putInt(numEntries);
        if (numEntries > 0) {
            for (AclEntry e2 : acl) {
                SftpHelper.writeAclEntry(buffer, e2);
            }
        }
        return buffer;
    }

    public static <B extends Buffer> B writeAclEntry(B buffer, AclEntry acl) {
        Objects.requireNonNull(acl, "No ACL");
        AclEntryType type2 = acl.type();
        int aclType = SftpHelper.encodeAclEntryType(type2);
        ValidateUtils.checkTrue(aclType >= 0, "Unknown ACL type: %s", (Object)type2);
        buffer.putInt(aclType);
        buffer.putInt(SftpHelper.encodeAclFlags(acl.flags()));
        buffer.putInt(SftpHelper.encodeAclMask(acl.permissions()));
        UserPrincipal user = acl.principal();
        buffer.putString(user.getName());
        return buffer;
    }

    public static int encodeAclEntryType(AclEntryType type2) {
        if (type2 == null) {
            return Integer.MIN_VALUE;
        }
        switch (type2) {
            case ALARM: {
                return 3;
            }
            case ALLOW: {
                return 0;
            }
            case AUDIT: {
                return 2;
            }
            case DENY: {
                return 1;
            }
        }
        return -1;
    }

    public static long encodeAclFlags(Collection<AclEntryFlag> flags) {
        if (GenericUtils.isEmpty(flags)) {
            return 0L;
        }
        long aclFlag = 0L;
        if (flags.contains((Object)AclEntryFlag.FILE_INHERIT)) {
            aclFlag |= 1L;
        }
        if (flags.contains((Object)AclEntryFlag.DIRECTORY_INHERIT)) {
            aclFlag |= 2L;
        }
        if (flags.contains((Object)AclEntryFlag.NO_PROPAGATE_INHERIT)) {
            aclFlag |= 4L;
        }
        if (flags.contains((Object)AclEntryFlag.INHERIT_ONLY)) {
            aclFlag |= 8L;
        }
        return aclFlag;
    }

    public static long encodeAclMask(Collection<AclEntryPermission> mask) {
        if (GenericUtils.isEmpty(mask)) {
            return 0L;
        }
        long aclMask = 0L;
        if (mask.contains((Object)AclEntryPermission.READ_DATA)) {
            aclMask |= 1L;
        }
        if (mask.contains((Object)AclEntryPermission.LIST_DIRECTORY)) {
            aclMask |= 1L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_DATA)) {
            aclMask |= 2L;
        }
        if (mask.contains((Object)AclEntryPermission.ADD_FILE)) {
            aclMask |= 2L;
        }
        if (mask.contains((Object)AclEntryPermission.APPEND_DATA)) {
            aclMask |= 4L;
        }
        if (mask.contains((Object)AclEntryPermission.ADD_SUBDIRECTORY)) {
            aclMask |= 4L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_NAMED_ATTRS)) {
            aclMask |= 8L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_NAMED_ATTRS)) {
            aclMask |= 0x10L;
        }
        if (mask.contains((Object)AclEntryPermission.EXECUTE)) {
            aclMask |= 0x20L;
        }
        if (mask.contains((Object)AclEntryPermission.DELETE_CHILD)) {
            aclMask |= 0x40L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_ATTRIBUTES)) {
            aclMask |= 0x80L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_ATTRIBUTES)) {
            aclMask |= 0x100L;
        }
        if (mask.contains((Object)AclEntryPermission.DELETE)) {
            aclMask |= 0x10000L;
        }
        if (mask.contains((Object)AclEntryPermission.READ_ACL)) {
            aclMask |= 0x20000L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_ACL)) {
            aclMask |= 0x40000L;
        }
        if (mask.contains((Object)AclEntryPermission.WRITE_OWNER)) {
            aclMask |= 0x80000L;
        }
        if (mask.contains((Object)AclEntryPermission.SYNCHRONIZE)) {
            aclMask |= 0x100000L;
        }
        return aclMask;
    }

    public static <B extends Buffer> B writeTime(B buffer, int version2, int flags, FileTime time) {
        if (version2 >= 4) {
            buffer.putLong(time.to(TimeUnit.SECONDS));
            if ((flags & 0x100) != 0) {
                buffer.putInt(time.toInstant().getNano());
            }
        } else {
            buffer.putInt(time.to(TimeUnit.SECONDS));
        }
        return buffer;
    }

    public static FileTime readTime(Buffer buffer, int version2, int flags) {
        long secs;
        if (version2 >= 4) {
            long nanos;
            secs = buffer.getLong();
            if ((flags & 0x100) != 0 && (nanos = buffer.getUInt()) != 0L) {
                try {
                    return FileTime.from(Instant.ofEpochSecond(secs, nanos));
                }
                catch (ArithmeticException | DateTimeException runtimeException) {}
            }
        } else {
            secs = buffer.getUInt();
        }
        return FileTime.from(secs, TimeUnit.SECONDS);
    }

    public static String getLongName(String shortName, Map<String, ?> attributes2) {
        int index;
        Number length;
        String owner = Objects.toString(attributes2.get("owner"), null);
        String username = OsUtils.getCanonicalUser(owner);
        if (GenericUtils.isEmpty(username)) {
            username = SftpUniversalOwnerAndGroup.Owner.getName();
        }
        String group = Objects.toString(attributes2.get("group"), null);
        if (GenericUtils.isEmpty(group = OsUtils.resolveCanonicalGroup(group, owner))) {
            group = SftpUniversalOwnerAndGroup.Group.getName();
        }
        if ((length = (Number)attributes2.get("size")) == null) {
            length = 0L;
        }
        String lengthString = String.format("%1$8s", length);
        String linkCount = Objects.toString(attributes2.get("nlink"), null);
        if (GenericUtils.isEmpty(linkCount)) {
            linkCount = "1";
        }
        Boolean isDirectory = (Boolean)attributes2.get("isDirectory");
        Boolean isLink = (Boolean)attributes2.get("isSymbolicLink");
        EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)attributes2.get("permissions");
        if (perms == null) {
            perms = EnumSet.noneOf(PosixFilePermission.class);
        }
        String permsString = PosixFilePermissions.toString((Set<PosixFilePermission>)perms);
        String timeStamp = UnixDateFormat.getUnixDate((FileTime)attributes2.get("lastModifiedTime"));
        StringBuilder sb = new StringBuilder(GenericUtils.length(linkCount) + GenericUtils.length(username) + GenericUtils.length(group) + GenericUtils.length(timeStamp) + GenericUtils.length(lengthString) + GenericUtils.length(permsString) + GenericUtils.length(shortName) + 32);
        sb.append((char)(SftpHelper.getBool(isDirectory) ? 100 : (SftpHelper.getBool(isLink) ? 108 : 45))).append(permsString);
        sb.append(' ');
        for (index = linkCount.length(); index < 3; ++index) {
            sb.append(' ');
        }
        sb.append(linkCount);
        sb.append(' ').append(username);
        for (index = username.length(); index < 8; ++index) {
            sb.append(' ');
        }
        sb.append(' ').append(group);
        for (index = group.length(); index < 8; ++index) {
            sb.append(' ');
        }
        sb.append(' ').append(lengthString).append(' ').append(timeStamp).append(' ').append(shortName);
        return sb.toString();
    }

    static {
        TreeMap map2 = new TreeMap(Comparator.naturalOrder());
        map2.put(0, "Success");
        map2.put(1, "End of file");
        map2.put(2, "No such file or directory");
        map2.put(3, "Permission denied");
        map2.put(4, "General failure");
        map2.put(5, "Bad message data");
        map2.put(6, "No connection to server");
        map2.put(7, "Connection lost");
        map2.put(8, "Unsupported operation requested");
        map2.put(9, "Invalid handle value");
        map2.put(10, "No such path");
        map2.put(11, "File/Directory already exists");
        map2.put(12, "File/Directory is write-protected");
        map2.put(13, "No such meadia");
        map2.put(14, "No space left on device");
        map2.put(15, "Quota exceeded");
        map2.put(16, "Unknown user/group");
        map2.put(17, "Lock conflict");
        map2.put(18, "Directory not empty");
        map2.put(19, "Accessed location is not a directory");
        map2.put(20, "Invalid filename");
        map2.put(21, "Link loop");
        map2.put(22, "Cannot remove");
        map2.put(23, "Invalid parameter");
        map2.put(24, "Accessed location is a directory");
        map2.put(25, "Range lock conflict");
        map2.put(26, "Range lock refused");
        map2.put(27, "Delete pending");
        map2.put(28, "Corrupted file/directory");
        map2.put(29, "Invalid file/directory owner");
        map2.put(30, "Invalid file/directory group");
        map2.put(31, "No matching byte range lock");
        DEFAULT_SUBSTATUS_MESSAGE = Collections.unmodifiableMap(map2);
        UNIX_PERMISSIONS_START = Pattern.compile("[-dlcbps][-r][-w][-a-zA-Z*][-r*][-w*][-a-zA-Z*].*");
    }
}

