/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common.extensions;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.extensions.AbstractParser;

public class AclSupportedParser
extends AbstractParser<AclCapabilities> {
    public static final AclSupportedParser INSTANCE = new AclSupportedParser();

    public AclSupportedParser() {
        super("acl-supported");
    }

    @Override
    public AclCapabilities parse(byte[] input, int offset, int len2) {
        return this.parse(new ByteArrayBuffer(input, offset, len2));
    }

    public AclCapabilities parse(Buffer buffer) {
        return new AclCapabilities(buffer.getInt());
    }

    public static class AclCapabilities
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3118426327336468237L;
        private int capabilities;

        public AclCapabilities() {
            this(0);
        }

        public AclCapabilities(int capabilities2) {
            ValidateUtils.checkTrue(capabilities2 >= 0 && capabilities2 < 32768, "Illogical ACL capabilities count: %d", capabilities2);
            this.capabilities = capabilities2;
        }

        public int getCapabilities() {
            return this.capabilities;
        }

        public void setCapabilities(int capabilities2) {
            this.capabilities = capabilities2;
        }

        public int hashCode() {
            return this.getCapabilities();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return ((AclCapabilities)obj).getCapabilities() == this.getCapabilities();
        }

        public AclCapabilities clone() {
            try {
                return (AclCapabilities)this.getClass().cast(super.clone());
            }
            catch (CloneNotSupportedException e2) {
                throw new UnsupportedOperationException("Failed to clone " + this.toString() + ": " + e2.getMessage(), e2);
            }
        }

        public String toString() {
            return Objects.toString(AclCapabilities.decodeAclCapabilities(this.getCapabilities()));
        }

        public static NavigableMap<String, Integer> getAclCapabilityNamesMap() {
            return LazyAclCapabilityNameHolder.ACL_NAMES_MAP;
        }

        public static Integer getAclCapabilityValue(String name) {
            if (GenericUtils.isEmpty(name)) {
                return null;
            }
            if (!(name = name.toUpperCase()).startsWith("SSH_ACL_CAP_")) {
                name = name + "SSH_ACL_CAP_";
            }
            NavigableMap<String, Integer> map2 = AclCapabilities.getAclCapabilityNamesMap();
            return (Integer)map2.get(name);
        }

        public static NavigableMap<Integer, String> getAclCapabilityValuesMap() {
            return LazyAclCapabilityNameHolder.ACL_VALUES_MAP;
        }

        public static String getAclCapabilityName(int aclCapValue) {
            NavigableMap<Integer, String> map2 = AclCapabilities.getAclCapabilityValuesMap();
            String name = (String)map2.get(aclCapValue);
            if (GenericUtils.isEmpty(name)) {
                return Integer.toString(aclCapValue);
            }
            return name;
        }

        public static NavigableSet<String> decodeAclCapabilities(int mask) {
            if (mask == 0) {
                return Collections.emptyNavigableSet();
            }
            TreeSet<String> caps = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            NavigableMap<Integer, String> map2 = AclCapabilities.getAclCapabilityValuesMap();
            map2.forEach((value2, name) -> {
                if ((mask & value2) != 0) {
                    caps.add((String)name);
                }
            });
            return caps;
        }

        public static int constructAclCapabilities(Collection<Integer> maskValues) {
            if (GenericUtils.isEmpty(maskValues)) {
                return 0;
            }
            int mask = 0;
            for (Integer v : maskValues) {
                mask |= v.intValue();
            }
            return mask;
        }

        public static Set<Integer> deconstructAclCapabilities(int mask) {
            if (mask == 0) {
                return Collections.emptySet();
            }
            NavigableMap<Integer, String> map2 = AclCapabilities.getAclCapabilityValuesMap();
            HashSet<Integer> caps = new HashSet<Integer>(map2.size());
            for (Integer v : map2.keySet()) {
                if ((mask & v) == 0) continue;
                caps.add(v);
            }
            return caps;
        }

        private static final class LazyAclCapabilityNameHolder {
            private static final String ACL_CAP_NAME_PREFIX = "SSH_ACL_CAP_";
            private static final NavigableMap<Integer, String> ACL_VALUES_MAP = LoggingUtils.generateMnemonicMap(SftpConstants.class, "SSH_ACL_CAP_");
            private static final NavigableMap<String, Integer> ACL_NAMES_MAP = Collections.unmodifiableNavigableMap(MapEntryUtils.flipMap(ACL_VALUES_MAP, MapEntryUtils.caseInsensitiveMap(), false));

            private LazyAclCapabilityNameHolder() {
                throw new UnsupportedOperationException("No instance allowed");
            }
        }
    }
}

