/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.sftp.common.extensions.AclSupportedParser;
import org.apache.sshd.sftp.common.extensions.ExtensionParser;
import org.apache.sshd.sftp.common.extensions.FilenameCharsetParser;
import org.apache.sshd.sftp.common.extensions.NewlineParser;
import org.apache.sshd.sftp.common.extensions.Supported2Parser;
import org.apache.sshd.sftp.common.extensions.SupportedParser;
import org.apache.sshd.sftp.common.extensions.VendorIdParser;
import org.apache.sshd.sftp.common.extensions.VersionsParser;
import org.apache.sshd.sftp.common.extensions.openssh.FstatVfsExtensionParser;
import org.apache.sshd.sftp.common.extensions.openssh.FsyncExtensionParser;
import org.apache.sshd.sftp.common.extensions.openssh.HardLinkExtensionParser;
import org.apache.sshd.sftp.common.extensions.openssh.LSetStatExtensionParser;
import org.apache.sshd.sftp.common.extensions.openssh.LimitsExtensionParser;
import org.apache.sshd.sftp.common.extensions.openssh.PosixRenameExtensionParser;
import org.apache.sshd.sftp.common.extensions.openssh.StatVfsExtensionParser;

public final class ParserUtils {
    public static final Collection<ExtensionParser<?>> BUILT_IN_PARSERS = Collections.unmodifiableList(Arrays.asList(VendorIdParser.INSTANCE, NewlineParser.INSTANCE, VersionsParser.INSTANCE, SupportedParser.INSTANCE, Supported2Parser.INSTANCE, AclSupportedParser.INSTANCE, FilenameCharsetParser.INSTANCE, PosixRenameExtensionParser.INSTANCE, StatVfsExtensionParser.INSTANCE, FstatVfsExtensionParser.INSTANCE, HardLinkExtensionParser.INSTANCE, FsyncExtensionParser.INSTANCE, LSetStatExtensionParser.INSTANCE, LimitsExtensionParser.INSTANCE));
    private static final NavigableMap<String, ExtensionParser<?>> PARSERS_MAP = Collections.unmodifiableNavigableMap(BUILT_IN_PARSERS.stream().collect(Collectors.toMap(NamedResource::getName, Function.identity(), MapEntryUtils.throwingMerger(), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER))));

    private ParserUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionParser<?> registerParser(ExtensionParser<?> parser) {
        Objects.requireNonNull(parser, "No parser instance");
        NavigableMap<String, ExtensionParser<?>> navigableMap = PARSERS_MAP;
        synchronized (navigableMap) {
            return PARSERS_MAP.put(parser.getName(), parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionParser<?> unregisterParser(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        NavigableMap<String, ExtensionParser<?>> navigableMap = PARSERS_MAP;
        synchronized (navigableMap) {
            return (ExtensionParser)PARSERS_MAP.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionParser<?> getRegisteredParser(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        NavigableMap<String, ExtensionParser<?>> navigableMap = PARSERS_MAP;
        synchronized (navigableMap) {
            return (ExtensionParser)PARSERS_MAP.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRegisteredParsersNames() {
        NavigableMap<String, ExtensionParser<?>> navigableMap = PARSERS_MAP;
        synchronized (navigableMap) {
            if (PARSERS_MAP.isEmpty()) {
                return Collections.emptySet();
            }
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, PARSERS_MAP.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExtensionParser<?>> getRegisteredParsers() {
        NavigableMap<String, ExtensionParser<?>> navigableMap = PARSERS_MAP;
        synchronized (navigableMap) {
            if (PARSERS_MAP.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList(PARSERS_MAP.values());
        }
    }

    public static Set<String> supportedExtensions(Map<String, ?> parsed) {
        Collection<String> extra2;
        if (MapEntryUtils.isEmpty(parsed)) {
            return Collections.emptySet();
        }
        SupportedParser.Supported sup = (SupportedParser.Supported)parsed.get(SupportedParser.INSTANCE.getName());
        Collection<String> extra = sup == null ? null : sup.extensionNames;
        Supported2Parser.Supported2 sup2 = (Supported2Parser.Supported2)parsed.get(Supported2Parser.INSTANCE.getName());
        Collection<String> collection = extra2 = sup2 == null ? null : sup2.extensionNames;
        if (GenericUtils.isEmpty(extra)) {
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, extra2);
        }
        if (GenericUtils.isEmpty(extra2)) {
            return GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, extra);
        }
        TreeSet<String> result2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result2.addAll(extra);
        result2.addAll(extra2);
        return result2;
    }

    public static Map<String, Object> parse(Map<String, byte[]> extensions) {
        if (MapEntryUtils.isEmpty(extensions)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Object> data2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        extensions.forEach((name, value2) -> {
            Object result2 = ParserUtils.parse(name, value2);
            if (result2 == null) {
                return;
            }
            data2.put((String)name, result2);
        });
        return data2;
    }

    public static Object parse(String name, byte ... encoded) {
        ExtensionParser<?> parser = ParserUtils.getRegisteredParser(name);
        if (parser == null) {
            return null;
        }
        return parser.parse(encoded);
    }
}

