/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.common.extensions;

import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.sftp.common.extensions.AbstractParser;

public class VendorIdParser
extends AbstractParser<VendorId> {
    public static final VendorIdParser INSTANCE = new VendorIdParser();

    public VendorIdParser() {
        super("vendor-id");
    }

    @Override
    public VendorId parse(byte[] input, int offset, int len2) {
        return this.parse(new ByteArrayBuffer(input, offset, len2));
    }

    public VendorId parse(Buffer buffer) {
        VendorId id = new VendorId();
        id.vendorName = buffer.getString();
        id.productName = buffer.getString();
        id.productVersion = buffer.getString();
        id.productBuildNumber = buffer.getLong();
        return id;
    }

    public static class VendorId {
        public String vendorName;
        public String productName;
        public String productVersion;
        public long productBuildNumber;

        public String toString() {
            return this.vendorName + "-" + this.productName + "-" + this.productVersion + "-" + this.productBuildNumber;
        }
    }
}

