/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.SftpEventListener;

public abstract class AbstractSftpEventListenerAdapter
extends AbstractLoggingBean
implements SftpEventListener {
    protected AbstractSftpEventListenerAdapter() {
    }

    @Override
    public void receivedExtension(ServerSession session2, String extension, int id) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("receivedExtension({}) id={}, extension={}", session2, id, extension);
        }
    }

    @Override
    public void initialized(ServerSession session2, int version2) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("initialized({}) version={}", (Object)session2, (Object)version2);
        }
    }

    @Override
    public void destroying(ServerSession session2) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("destroying({})", (Object)session2);
        }
    }

    @Override
    public void opening(ServerSession session2, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path2 = localHandle.getFile();
            this.log.trace("opening({})[{}] {} {}", session2, remoteHandle, Files.isDirectory(path2, new LinkOption[0]) ? "directory" : "file", path2);
        }
    }

    @Override
    public void openFailed(ServerSession session2, String remotePath, Path localPath, boolean isDirectory, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("openFailed({}) remotePath={}, localPath={}, isDir={}, thrown={}", session2, remotePath, localPath, isDirectory, thrown);
        }
    }

    @Override
    public void open(ServerSession session2, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path2 = localHandle.getFile();
            this.log.trace("open({})[{}] {} {}", session2, remoteHandle, Files.isDirectory(path2, new LinkOption[0]) ? "directory" : "file", path2);
        }
    }

    @Override
    public void readingEntries(ServerSession session2, String remoteHandle, DirectoryHandle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("readingEntries({}) handle={}[{}]", session2, remoteHandle, localHandle.getFile());
        }
    }

    @Override
    public void readEntries(ServerSession session2, String remoteHandle, DirectoryHandle localHandle, Map<String, Path> entries2) throws IOException {
        int numEntries = MapEntryUtils.size(entries2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("read({})[{}] {} entries", session2, localHandle.getFile(), numEntries);
        }
        if (numEntries > 0 && this.log.isTraceEnabled()) {
            entries2.forEach((key2, value2) -> this.log.trace("read({})[{}] {} - {}", session2, localHandle.getFile(), key2, value2));
        }
    }

    @Override
    public void reading(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, byte[] data2, int dataOffset, int dataLen) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("reading({})[{}] offset={}, requested={}", session2, localHandle.getFile(), offset, dataLen);
        }
    }

    @Override
    public void read(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, byte[] data2, int dataOffset, int dataLen, int readLen, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("read({})[{}] offset={}, requested={}, read={}{}", session2, localHandle.getFile(), offset, dataLen, readLen, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void writing(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, byte[] data2, int dataOffset, int dataLen) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("writing({})[{}] offset={}, requested={}", session2, localHandle.getFile(), offset, dataLen);
        }
    }

    @Override
    public void written(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, byte[] data2, int dataOffset, int dataLen, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("written({})[{}] offset={}, requested={}{}", session2, localHandle.getFile(), offset, dataLen, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void blocking(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("blocking({})[{}] offset={}, length={}, mask=0x{}", session2, localHandle.getFile(), offset, length, Integer.toHexString(mask));
        }
    }

    @Override
    public void blocked(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, long length, int mask, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("blocked({})[{}] offset={}, length={}, mask=0x{}{}", session2, localHandle.getFile(), offset, length, Integer.toHexString(mask), thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void unblocking(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, long length) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocking({})[{}] offset={}, length={}", session2, localHandle.getFile(), offset, length);
        }
    }

    @Override
    public void unblocked(ServerSession session2, String remoteHandle, FileHandle localHandle, long offset, long length, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocked({})[{}] offset={}, length={}{}", session2, localHandle.getFile(), offset, length, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void closing(ServerSession session2, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path2 = localHandle.getFile();
            this.log.trace("close({})[{}] {} {}", session2, localHandle.getFile(), Files.isDirectory(path2, new LinkOption[0]) ? "directory" : "file", path2);
        }
    }

    @Override
    public void closed(ServerSession session2, String remoteHandle, Handle localHandle, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("closed({}) handle={}[{}]{}", session2, remoteHandle, localHandle.getFile(), thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void creating(ServerSession session2, Path path2, Map<String, ?> attrs) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("creating({}) {} {}", session2, Files.isDirectory(path2, new LinkOption[0]) ? "directory" : "file", path2);
        }
    }

    @Override
    public void created(ServerSession session2, Path path2, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("created({}) {} {}{}", session2, Files.isDirectory(path2, new LinkOption[0]) ? "directory" : "file", path2, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void moving(ServerSession session2, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("moving({})[{}] {} => {}", session2, opts, srcPath, dstPath);
        }
    }

    @Override
    public void moved(ServerSession session2, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("moved({})[{}] {} => {}{}", session2, opts, srcPath, dstPath, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void removing(ServerSession session2, Path path2, boolean isDirectory) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("removing({})[dir={}] {}", session2, isDirectory, path2);
        }
    }

    @Override
    public void removed(ServerSession session2, Path path2, boolean isDirectory, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("removed({})[dir={}] {}{}", session2, isDirectory, path2, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void linking(ServerSession session2, Path source2, Path target, boolean symLink) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("linking({})[{}] {} => {}", session2, symLink, source2, target);
        }
    }

    @Override
    public void linked(ServerSession session2, Path source2, Path target, boolean symLink, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("linked({})[{}] {} => {}{}", session2, symLink, source2, target, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void modifyingAttributes(ServerSession session2, Path path2, Map<String, ?> attrs) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("modifyingAttributes({}) {}: {}", session2, path2, attrs);
        }
    }

    @Override
    public void modifiedAttributes(ServerSession session2, Path path2, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("modifiedAttributes({}) {}{}", session2, path2, thrown == null ? "" : ": " + thrown);
        }
    }

    @Override
    public void exiting(ServerSession session2, Handle handle2) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("exiting({}) handle={}[{}]", session2, handle2.getFile(), handle2.getFileHandle());
        }
    }
}

