/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHLimitsExtensionInfo;
import org.apache.sshd.sftp.client.fs.WithFileAttributeCache;
import org.apache.sshd.sftp.client.fs.WithFileAttributes;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpHelper;
import org.apache.sshd.sftp.common.extensions.AclSupportedParser;
import org.apache.sshd.sftp.common.extensions.SpaceAvailableExtensionInfo;
import org.apache.sshd.sftp.common.extensions.openssh.AbstractOpenSSHExtensionParser;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.InvalidHandleException;
import org.apache.sshd.sftp.server.SftpErrorStatusDataHandler;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import org.apache.sshd.sftp.server.SftpSubsystemConfigurator;
import org.apache.sshd.sftp.server.SftpSubsystemEnvironment;
import org.apache.sshd.sftp.server.SftpSubsystemProxy;
import org.apache.sshd.sftp.server.UnsupportedAttributePolicy;

public abstract class AbstractSftpSubsystemHelper
extends AbstractLoggingBean
implements SftpSubsystemProxy {
    public static final NavigableMap<String, OptionalFeature> DEFAULT_SUPPORTED_CLIENT_EXTENSIONS = ((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)((MapEntryUtils.NavigableMapBuilder)MapEntryUtils.NavigableMapBuilder.builder().put("version-select", OptionalFeature.TRUE)).put("copy-file", OptionalFeature.TRUE)).put("md5-hash", BuiltinDigests.md5)).put("md5-hash-handle", BuiltinDigests.md5)).put("check-file-handle", OptionalFeature.any(BuiltinDigests.VALUES))).put("check-file-name", OptionalFeature.any(BuiltinDigests.VALUES))).put("copy-data", OptionalFeature.TRUE)).put("space-available", OptionalFeature.TRUE)).immutable();
    public static final List<AbstractOpenSSHExtensionParser.OpenSSHExtension> DEFAULT_OPEN_SSH_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(new AbstractOpenSSHExtensionParser.OpenSSHExtension("fsync@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("hardlink@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("lsetstat@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("posix-rename@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("limits@openssh.com", "1")));
    public static final List<String> DEFAULT_OPEN_SSH_EXTENSIONS_NAMES = Collections.unmodifiableList(NamedResource.getNameList(DEFAULT_OPEN_SSH_EXTENSIONS));
    public static final Set<Integer> DEFAULT_ACL_SUPPORTED_MASK = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 4, 8)));
    private final ChannelSession channelSession;
    private final UnsupportedAttributePolicy unsupportedAttributePolicy;
    private final Collection<SftpEventListener> sftpEventListeners = new CopyOnWriteArraySet<SftpEventListener>();
    private final SftpEventListener sftpEventListenerProxy;
    private final SftpFileSystemAccessor fileSystemAccessor;
    private final SftpErrorStatusDataHandler errorStatusDataHandler;

    protected AbstractSftpSubsystemHelper(ChannelSession channelSession, SftpSubsystemConfigurator configurator) {
        this.channelSession = Objects.requireNonNull(channelSession, "No channel session provided");
        this.unsupportedAttributePolicy = Objects.requireNonNull(configurator.getUnsupportedAttributePolicy(), "No unsupported attribute policy provided");
        this.fileSystemAccessor = Objects.requireNonNull(configurator.getFileSystemAccessor(), "No file system accessor");
        this.sftpEventListenerProxy = EventListenerUtils.proxyWrapper(SftpEventListener.class, this.sftpEventListeners);
        this.errorStatusDataHandler = Objects.requireNonNull(configurator.getErrorStatusDataHandler(), "No error status data handler");
    }

    @Override
    public ChannelSession getServerChannelSession() {
        return this.channelSession;
    }

    @Override
    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.unsupportedAttributePolicy;
    }

    @Override
    public SftpFileSystemAccessor getFileSystemAccessor() {
        return this.fileSystemAccessor;
    }

    @Override
    public SftpEventListener getSftpEventListenerProxy() {
        return this.sftpEventListenerProxy;
    }

    @Override
    public boolean addSftpEventListener(SftpEventListener listener) {
        return this.sftpEventListeners.add(SftpEventListener.validateListener(listener));
    }

    @Override
    public boolean removeSftpEventListener(SftpEventListener listener) {
        if (listener == null) {
            return false;
        }
        return this.sftpEventListeners.remove(SftpEventListener.validateListener(listener));
    }

    @Override
    public SftpErrorStatusDataHandler getErrorStatusDataHandler() {
        return this.errorStatusDataHandler;
    }

    protected Boolean validateProposedVersion(Buffer buffer, int id, String proposal) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        ServerSession session2 = this.getServerSession();
        if (debugEnabled) {
            this.log.debug("validateProposedVersion({})[id={}] SSH_FXP_EXTENDED(version-select) (version={})", session2, id, proposal);
        }
        if (GenericUtils.length(proposal) != 1) {
            return Boolean.FALSE;
        }
        char digit = proposal.charAt(0);
        if (digit < '0' || digit > '9') {
            return Boolean.FALSE;
        }
        int proposed = digit - 48;
        Map.Entry<Integer, String> result2 = this.checkVersionCompatibility(buffer, id, proposed, 4);
        if (result2 == null) {
            return null;
        }
        int negotiated = result2.getKey();
        if (negotiated != proposed) {
            if (debugEnabled) {
                this.log.debug("validateProposedVersion({})[id={}] SSH_FXP_EXTENDED(version-select) proposed={} different than negotiated={}", session2, id, proposed, negotiated);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Map.Entry<Integer, String> checkVersionCompatibility(Buffer buffer, int id, int proposed, int failureOpcode) throws IOException {
        boolean traceEnabled;
        int low = 3;
        int hig = 6;
        String available = SftpSubsystemEnvironment.ALL_SFTP_IMPL;
        ServerSession session2 = this.getServerSession();
        Integer sftpVersion = SftpModuleProperties.SFTP_VERSION.getOrNull(session2);
        if (sftpVersion != null) {
            int forcedValue = sftpVersion;
            if (forcedValue < 3 || forcedValue > 6) {
                throw new IllegalStateException("Forced SFTP version (" + sftpVersion + ") not within supported values: " + available);
            }
            low = hig = sftpVersion.intValue();
            available = sftpVersion.toString();
        }
        if (traceEnabled = this.log.isTraceEnabled()) {
            this.log.trace("checkVersionCompatibility({})[id={}] - proposed={}, available={}", session2, id, proposed, available);
        }
        if (proposed < low) {
            this.sendStatus(this.prepareReply(buffer), id, failureOpcode, "Proposed version (" + proposed + ") not in supported range: " + available);
            return null;
        }
        if (proposed > hig) {
            if (traceEnabled) {
                this.log.trace("checkVersionCompatibility({})[id={}] - replace proposed={} with negotiated={} due to available={}", session2, id, proposed, hig, available);
            }
            proposed = hig;
        }
        return new AbstractMap.SimpleImmutableEntry<Integer, String>(proposed, available);
    }

    protected void process(Buffer buffer) throws IOException {
        ServerSession session2 = this.getServerSession();
        int length = buffer.getInt();
        int type2 = buffer.getUByte();
        int id = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[length={}, type={}, id={}] processing", session2, length, SftpConstants.getCommandMessageName(type2), id);
        }
        try {
            SftpEventListener listener = this.getSftpEventListenerProxy();
            listener.received(session2, type2, id);
        }
        catch (IOException | RuntimeException e2) {
            if (type2 == 1) {
                throw e2;
            }
            this.sendStatus(this.prepareReply(buffer), id, e2, type2, new Object[0]);
            return;
        }
        this.doProcess(buffer, length, type2, id);
    }

    protected void doProcess(Buffer buffer, int length, int type2, int id) throws IOException {
        switch (type2) {
            case 1: {
                this.doInit(buffer, id);
                break;
            }
            case 3: {
                this.doOpen(buffer, id);
                break;
            }
            case 4: {
                this.doClose(buffer, id);
                break;
            }
            case 5: {
                this.doRead(buffer, id);
                break;
            }
            case 6: {
                this.doWrite(buffer, id);
                break;
            }
            case 7: {
                this.doLStat(buffer, id);
                break;
            }
            case 8: {
                this.doFStat(buffer, id);
                break;
            }
            case 9: {
                this.doSetStat(buffer, id, "", type2, null);
                break;
            }
            case 10: {
                this.doFSetStat(buffer, id);
                break;
            }
            case 11: {
                this.doOpenDir(buffer, id);
                break;
            }
            case 12: {
                this.doReadDir(buffer, id);
                break;
            }
            case 13: {
                this.doRemove(buffer, id);
                break;
            }
            case 14: {
                this.doMakeDirectory(buffer, id);
                break;
            }
            case 15: {
                this.doRemoveDirectory(buffer, id);
                break;
            }
            case 16: {
                this.doRealPath(buffer, id);
                break;
            }
            case 17: {
                this.doStat(buffer, id);
                break;
            }
            case 18: {
                this.doRename(buffer, id);
                break;
            }
            case 19: {
                this.doReadLink(buffer, id);
                break;
            }
            case 20: {
                this.doSymLink(buffer, id);
                break;
            }
            case 21: {
                this.doLink(buffer, id);
                break;
            }
            case 22: {
                this.doBlock(buffer, id);
                break;
            }
            case 23: {
                this.doUnblock(buffer, id);
                break;
            }
            case 200: {
                this.doExtended(buffer, id);
                break;
            }
            default: {
                this.doUnsupported(buffer, length, type2, id);
            }
        }
    }

    protected void doUnsupported(Buffer buffer, int length, int type2, int id) throws IOException {
        String name = SftpConstants.getCommandMessageName(type2);
        this.log.warn("process({})[length={}, type={}, id={}] unknown command", this.getServerSession(), length, name, id);
        this.sendStatus(this.prepareReply(buffer), id, 8, "Command " + name + " is unsupported or not implemented");
    }

    protected abstract void doInit(Buffer var1, int var2) throws IOException;

    protected void doVersionSelect(Buffer buffer, int id) throws IOException {
        String proposed = buffer.getString();
        this.doVersionSelect(buffer, id, proposed);
    }

    protected abstract void doVersionSelect(Buffer var1, int var2, String var3) throws IOException;

    protected void doOpen(Buffer buffer, int id) throws IOException {
        String handle2;
        String path2 = buffer.getString();
        int access = 0;
        int version2 = this.getVersion();
        if (version2 >= 5 && (access = buffer.getInt()) == 0) {
            access = 129;
        }
        int pflags = buffer.getInt();
        if (version2 < 5) {
            int flags = pflags == 0 ? 1 : pflags;
            pflags = 0;
            switch (flags & 3) {
                case 1: {
                    access |= 0x81;
                    break;
                }
                case 2: {
                    access |= 0x102;
                    break;
                }
                default: {
                    access |= 0x81;
                    access |= 0x102;
                }
            }
            if ((flags & 4) != 0) {
                access |= 4;
                pflags |= 0x18;
            }
            pflags = (flags & 8) != 0 ? ((flags & 0x20) != 0 ? (pflags |= 0) : ((flags & 0x10) != 0 ? (pflags |= 1) : (pflags |= 3))) : ((flags & 0x10) != 0 ? (pflags |= 4) : (pflags |= 2));
        }
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            handle2 = this.doOpen(id, path2, pflags, access, attrs);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 3, path2);
            return;
        }
        this.sendHandle(this.prepareReply(buffer), id, handle2);
    }

    protected abstract String doOpen(int var1, String var2, int var3, int var4, Map<String, Object> var5) throws IOException;

    protected <E extends IOException> E signalOpenFailure(int id, String pathValue, Path path2, boolean isDir, E thrown) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("signalOpenFailure(id={})[{}] signal {} for {}: {}", id, pathValue, thrown.getClass().getSimpleName(), path2, thrown.getMessage());
        }
        listener.openFailed(session2, pathValue, path2, isDir, thrown);
        return thrown;
    }

    protected void doClose(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        try {
            this.doClose(id, handle2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 4, Handle.safe(handle2));
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "", "");
    }

    protected abstract void doClose(int var1, String var2) throws IOException;

    protected void doRead(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        long offset = buffer.getLong();
        int requestedLength = buffer.getInt();
        ServerSession session2 = this.getServerSession();
        int maxAllowed = SftpModuleProperties.MAX_READDATA_PACKET_LENGTH.getRequired(session2);
        int readLen = Math.min(requestedLength, maxAllowed);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[id={}]({})[offset={}] - req={}, max={}, effective={}", session2, id, Handle.safe(handle2), offset, requestedLength, maxAllowed, readLen);
        }
        try {
            Boolean eof;
            int version2;
            ValidateUtils.checkTrue(readLen >= 0, "Illegal requested read length: %d", readLen);
            buffer = this.prepareReply(buffer);
            buffer.ensureCapacity(readLen + 64, IntUnaryOperator.identity());
            buffer.putByte((byte)103);
            buffer.putInt(id);
            int lenPos = buffer.wpos();
            buffer.putUInt(0L);
            AtomicReference<Boolean> eofRef = new AtomicReference<Boolean>();
            int startPos = buffer.wpos();
            int len2 = this.doRead(id, handle2, offset, readLen, buffer.array(), startPos, eofRef);
            if (len2 < 0) {
                throw new EOFException("Unable to read " + readLen + " bytes from offset=" + offset + " of " + Handle.safe(handle2));
            }
            buffer.wpos(startPos + len2);
            BufferUtils.updateLengthPlaceholder(buffer, lenPos, len2);
            if (len2 < readLen && (version2 = this.getVersion()) >= 6 && (eof = eofRef.get()) != null) {
                buffer.putBoolean(eof);
            }
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 5, Handle.safe(handle2), offset, requestedLength);
            return;
        }
        this.send(buffer);
    }

    protected abstract int doRead(int var1, String var2, long var3, int var5, byte[] var6, int var7, AtomicReference<Boolean> var8) throws IOException;

    protected void doWrite(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        long offset = buffer.getLong();
        int length = buffer.getInt();
        try {
            this.doWrite(id, handle2, offset, length, buffer.array(), buffer.rpos(), buffer.available());
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 6, Handle.safe(handle2), offset, length);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doWrite(int var1, String var2, long var3, int var5, byte[] var6, int var7, int var8) throws IOException;

    protected void doLStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path2 = buffer.getString();
        int flags = 65535;
        int version2 = this.getVersion();
        if (version2 >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doLStat(id, path2, flags);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 7, path2, flags);
            return;
        }
        this.sendAttrs(this.prepareReply(buffer), id, attrs);
    }

    protected Map<String, Object> doLStat(int id, String path2, int flags) throws IOException {
        Path p = this.resolveFile(path2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doLStat({})[id={}] SSH_FXP_LSTAT (path={}[{}], flags=0x{})", this.getServerSession(), id, path2, p, Integer.toHexString(flags));
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean followLinks = this.resolvePathResolutionFollowLinks(7, "", p);
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, p, 7, "", false);
        return this.resolveFileAttributes(p, flags, !followLinks, options2);
    }

    protected void doSetStat(Buffer buffer, int id, String extension, int cmd, Boolean followLinks) throws IOException {
        String path2 = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doSetStat(id, path2, cmd, extension, attrs, followLinks);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 9, path2);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doSetStat(int id, String path2, int cmd, String extension, Map<String, ?> attrs, Boolean followLinks) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSetStat({})[id={}, cmd={}, extension={}]  (path={}, attrs={}, followLinks={})", this.getServerSession(), id, cmd, extension, path2, attrs, followLinks);
        }
        Path p = this.resolveFile(path2);
        if (followLinks == null) {
            followLinks = this.resolvePathResolutionFollowLinks(9, extension, p);
        }
        this.doSetAttributes(cmd, extension, p, attrs, followLinks);
    }

    protected void doFStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        int flags = 65535;
        int version2 = this.getVersion();
        if (version2 >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doFStat(id, handle2, flags);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 8, Handle.safe(handle2), flags);
            return;
        }
        this.sendAttrs(this.prepareReply(buffer), id, attrs);
    }

    protected abstract Map<String, Object> doFStat(int var1, String var2, int var3) throws IOException;

    protected void doFSetStat(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doFSetStat(id, handle2, attrs);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 10, Handle.safe(handle2), attrs);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doFSetStat(int var1, String var2, Map<String, ?> var3) throws IOException;

    protected void doOpenDir(Buffer buffer, int id) throws IOException {
        String handle2;
        String path2 = buffer.getString();
        try {
            Path p = this.resolveNormalizedLocation(path2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doOpenDir({})[id={}] SSH_FXP_OPENDIR (path={})[{}]", this.getServerSession(), id, path2, p);
            }
            LinkOption[] options2 = this.getPathResolutionLinkOption(11, "", p);
            handle2 = this.doOpenDir(id, path2, p, options2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 11, path2);
            return;
        }
        this.sendHandle(this.prepareReply(buffer), id, handle2);
    }

    protected abstract String doOpenDir(int var1, String var2, Path var3, LinkOption ... var4) throws IOException;

    protected abstract void doReadDir(Buffer var1, int var2) throws IOException;

    protected void doLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        boolean symLink = buffer.getBoolean();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doLink({})[id={}] SSH_FXP_LINK linkpath={}, targetpath={}, symlink={}", this.getServerSession(), id, linkPath, targetPath, symLink);
            }
            this.doLink(id, targetPath, linkPath, symLink);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 21, targetPath, linkPath, symLink);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doLink(int id, String targetPath, String linkPath, boolean symLink) throws IOException {
        this.createLink(id, targetPath, linkPath, symLink);
    }

    protected void doSymLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doSymLink({})[id={}] SSH_FXP_SYMLINK linkpath={}, targetpath={}", this.getServerSession(), id, targetPath, linkPath);
            }
            this.doSymLink(id, targetPath, linkPath);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 20, targetPath, linkPath);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doSymLink(int id, String targetPath, String linkPath) throws IOException {
        this.createLink(id, targetPath, linkPath, true);
    }

    protected abstract void createLink(int var1, String var2, String var3, boolean var4) throws IOException;

    protected void doOpenSSHHardLink(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        try {
            this.doOpenSSHHardLink(id, srcFile, dstFile);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, "hardlink@openssh.com", srcFile, dstFile);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doOpenSSHLimits(Buffer buffer, int id) throws IOException {
        OpenSSHLimitsExtensionInfo info = this.getOpenSSHLimitsExtensionInfo(id, this.getServerChannelSession());
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        info.encode(buffer);
        this.send(buffer);
    }

    protected OpenSSHLimitsExtensionInfo getOpenSSHLimitsExtensionInfo(int id, ChannelSession channel2) throws IOException {
        return new OpenSSHLimitsExtensionInfo(channel2);
    }

    protected void doOpenSSHHardLink(int id, String srcFile, String dstFile) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHHardLink({})[id={}] SSH_FXP_EXTENDED[{}] (src={}, dst={})", this.getServerSession(), id, "hardlink@openssh.com", srcFile, dstFile);
        }
        this.createLink(id, srcFile, dstFile, false);
    }

    protected void doSpaceAvailable(Buffer buffer, int id) throws IOException {
        SpaceAvailableExtensionInfo info;
        String path2 = buffer.getString();
        try {
            info = this.doSpaceAvailable(id, path2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, "space-available", path2);
            return;
        }
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        SpaceAvailableExtensionInfo.encode(buffer, info);
        this.send(buffer);
    }

    protected SpaceAvailableExtensionInfo doSpaceAvailable(int id, String path2) throws IOException {
        Path nrm = this.resolveNormalizedLocation(path2);
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSpaceAvailable({})[id={}] path={}[{}]", session2, id, path2, nrm);
        }
        FileStore store2 = Files.getFileStore(nrm);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doSpaceAvailable({})[id={}] path={}[{}] - {}[{}]", session2, id, path2, nrm, store2.name(), store2.type());
        }
        return new SpaceAvailableExtensionInfo(store2);
    }

    protected void doTextSeek(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        long line = buffer.getLong();
        try {
            this.doTextSeek(id, handle2, line);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, "text-seek", Handle.safe(handle2), line);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doTextSeek(int var1, String var2, long var3) throws IOException;

    protected void doOpenSSHFsync(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        try {
            this.doOpenSSHFsync(id, handle2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, "fsync@openssh.com", Handle.safe(handle2));
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doOpenSSHFsync(int var1, String var2) throws IOException;

    protected void doCheckFileHash(Buffer buffer, int id, String targetType) throws IOException {
        String target = buffer.getString();
        String algList = buffer.getString();
        String[] algos = GenericUtils.split(algList, ',');
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        int blockSize = buffer.getInt();
        try {
            buffer = this.prepareReply(buffer);
            buffer.putByte((byte)-55);
            buffer.putInt(id);
            buffer.putString("check-file");
            this.doCheckFileHash(id, targetType, target, Arrays.asList(algos), startOffset, length, blockSize, buffer);
        }
        catch (Exception e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, targetType, target, algList, startOffset, length, blockSize);
            return;
        }
        this.send(buffer);
    }

    protected void doCheckFileHash(int id, Path file2, NamedFactory<? extends Digest> factory2, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue(startOffset >= 0L, "Invalid start offset: %d", startOffset);
        ValidateUtils.checkTrue(length >= 0L, "Invalid length: %d", length);
        ValidateUtils.checkTrue(blockSize == 0 || blockSize >= 256, "Invalid block size: %d", blockSize);
        Objects.requireNonNull(factory2, "No digest factory provided");
        buffer.putString(factory2.getName());
        long effectiveLength = length;
        long totalLength = Files.size(file2);
        if (effectiveLength == 0L) {
            effectiveLength = totalLength - startOffset;
        } else {
            long maxRead = startOffset + length;
            if (maxRead > totalLength) {
                effectiveLength = totalLength - startOffset;
            }
        }
        ValidateUtils.checkTrue(effectiveLength > 0L, "Non-positive effective hash data length: %d", effectiveLength);
        byte[] digestBuf = blockSize == 0 ? new byte[Math.min((int)effectiveLength, 8192)] : new byte[Math.min((int)effectiveLength, blockSize)];
        ByteBuffer wb = ByteBuffer.wrap(digestBuf);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        ServerSession session2 = this.getServerSession();
        try (SeekableByteChannel channel2 = accessor.openFile(this, null, file2, null, Collections.emptySet(), new FileAttribute[0]);){
            channel2.position(startOffset);
            Digest digest = (Digest)factory2.create();
            digest.init();
            boolean traceEnabled = this.log.isTraceEnabled();
            if (blockSize == 0) {
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel2.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                }
                byte[] hashValue = digest.digest();
                if (traceEnabled) {
                    this.log.trace("doCheckFileHash({})[{}] offset={}, length={} - algo={}, hash={}", session2, file2, startOffset, length, digest.getAlgorithm(), BufferUtils.toHex(':', hashValue));
                }
                buffer.putBytes(hashValue);
            } else {
                int count2 = 0;
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel2.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                    byte[] hashValue = digest.digest();
                    if (traceEnabled) {
                        this.log.trace("doCheckFileHash({})({})[{}] offset={}, length={} - algo={}, hash={}", session2, file2, count2, startOffset, length, digest.getAlgorithm(), BufferUtils.toHex(':', hashValue));
                    }
                    buffer.putBytes(hashValue);
                    ++count2;
                }
            }
            accessor.closeFile(this, null, file2, null, channel2, Collections.emptySet());
        }
    }

    protected void doMD5Hash(Buffer buffer, int id, String targetType) throws IOException {
        byte[] hashValue;
        String target = buffer.getString();
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        byte[] quickCheckHash = buffer.getBytes();
        try {
            hashValue = this.doMD5Hash(id, targetType, target, startOffset, length, quickCheckHash);
            if (this.log.isTraceEnabled()) {
                this.log.trace("doMD5Hash({})({})[{}] offset={}, length={}, quick-hash={} - hash={}", this.getServerSession(), targetType, target, startOffset, length, BufferUtils.toHex(':', quickCheckHash), BufferUtils.toHex(':', hashValue));
            }
        }
        catch (Exception e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, targetType, target, startOffset, length, quickCheckHash);
            return;
        }
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        buffer.putString(targetType);
        buffer.putBytes(hashValue);
        this.send(buffer);
    }

    protected abstract byte[] doMD5Hash(int var1, String var2, String var3, long var4, long var6, byte[] var8) throws Exception;

    protected byte[] doMD5Hash(int id, Path path2, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        ValidateUtils.checkTrue(startOffset >= 0L, "Invalid start offset: %d", startOffset);
        ValidateUtils.checkTrue(length > 0L, "Invalid length: %d", length);
        if (!BuiltinDigests.md5.isSupported()) {
            throw new UnsupportedOperationException(BuiltinDigests.md5.getAlgorithm() + " hash not supported");
        }
        Digest digest = BuiltinDigests.md5.create();
        digest.init();
        long effectiveLength = length;
        byte[] digestBuf = new byte[(int)Math.min(effectiveLength, 2048L)];
        ByteBuffer wb = ByteBuffer.wrap(digestBuf);
        boolean hashMatches = false;
        byte[] hashValue = null;
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean traceEnabled = this.log.isTraceEnabled();
        ServerSession session2 = this.getServerSession();
        try (SeekableByteChannel channel2 = accessor.openFile(this, null, path2, null, Collections.emptySet(), new FileAttribute[0]);){
            channel2.position(startOffset);
            if (NumberUtils.length(quickCheckHash) <= 0) {
                hashMatches = true;
            } else {
                int readLen = channel2.read(wb);
                if (readLen < 0) {
                    throw new EOFException("EOF while read initial buffer from " + path2);
                }
                effectiveLength -= (long)readLen;
                digest.update(digestBuf, 0, readLen);
                hashValue = digest.digest();
                hashMatches = Arrays.equals(quickCheckHash, hashValue);
                if (hashMatches) {
                    if (effectiveLength > 0L) {
                        digest = BuiltinDigests.md5.create();
                        digest.init();
                        digest.update(digestBuf, 0, readLen);
                        hashValue = null;
                    }
                } else if (traceEnabled) {
                    this.log.trace("doMD5Hash({})({}) offset={}, length={} - quick-hash mismatched expected={}, actual={}", session2, path2, startOffset, length, BufferUtils.toHex(':', quickCheckHash), BufferUtils.toHex(':', hashValue));
                }
            }
            if (hashMatches) {
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel2.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                }
                if (hashValue == null) {
                    hashValue = digest.digest();
                }
            } else {
                hashValue = GenericUtils.EMPTY_BYTE_ARRAY;
            }
            accessor.closeFile(this, null, path2, null, channel2, Collections.emptySet());
        }
        if (traceEnabled) {
            this.log.trace("doMD5Hash({})({}) offset={}, length={} - matches={}, quick={} hash={}", session2, path2, startOffset, length, hashMatches, BufferUtils.toHex(':', quickCheckHash), BufferUtils.toHex(':', hashValue));
        }
        return hashValue;
    }

    protected abstract void doCheckFileHash(int var1, String var2, String var3, Collection<String> var4, long var5, long var7, int var9, Buffer var10) throws Exception;

    protected void doReadLink(Buffer buffer, int id) throws IOException {
        AbstractMap.SimpleImmutableEntry<Path, String> link;
        String path2 = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doReadLink({})[id={}] SSH_FXP_READLINK path={}", this.getServerSession(), id, path2);
            }
            link = this.doReadLink(id, path2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 19, path2);
            return;
        }
        this.sendLink(this.prepareReply(buffer), id, (Path)link.getKey(), (String)link.getValue());
    }

    protected AbstractMap.SimpleImmutableEntry<Path, String> doReadLink(int id, String path2) throws IOException {
        Path link = this.resolveFile(path2);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        String target = accessor.resolveLinkTarget(this, link);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doReadLink({})[id={}] path={}[{}]: {}", this.getServerSession(), id, path2, link, target);
        }
        return new AbstractMap.SimpleImmutableEntry<Path, String>(link, target);
    }

    protected void doRename(Buffer buffer, int id) throws IOException {
        String oldPath = buffer.getString();
        String newPath = buffer.getString();
        int flags = 0;
        int version2 = this.getVersion();
        if (version2 >= 5) {
            flags = buffer.getInt();
        }
        try {
            this.doRename(id, oldPath, newPath, flags);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 18, oldPath, newPath, flags);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doRename(int id, String oldPath, String newPath, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRename({})[id={}] SSH_FXP_RENAME (oldPath={}, newPath={}, flags=0x{})", this.getServerSession(), id, oldPath, newPath, Integer.toHexString(flags));
        }
        List<CopyOption> opts = Collections.emptyList();
        if (flags != 0) {
            opts = new ArrayList();
            if ((flags & 2) == 2) {
                opts.add(StandardCopyOption.ATOMIC_MOVE);
            }
            if ((flags & 1) == 1) {
                opts.add(StandardCopyOption.REPLACE_EXISTING);
            }
        }
        this.doRename(id, oldPath, newPath, opts);
    }

    protected void doRename(int id, String oldPath, String newPath, Collection<CopyOption> opts) throws IOException {
        Path o = this.resolveFile(oldPath);
        Path n = this.resolveFile(newPath);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session2 = this.getServerSession();
        listener.moving(session2, o, n, opts);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            accessor.renameFile(this, o, n, opts);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.moved(session2, o, n, opts, e2);
            throw e2;
        }
        listener.moved(session2, o, n, opts, null);
    }

    protected void doPosixRename(Buffer buffer, int id) throws IOException {
        String oldPath = buffer.getString();
        String newPath = buffer.getString();
        try {
            int flags = 3;
            this.doRename(id, oldPath, newPath, flags);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, 18, oldPath, newPath);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doCopyData(Buffer buffer, int id) throws IOException {
        String readHandle = buffer.getString();
        long readOffset = buffer.getLong();
        long readLength = buffer.getLong();
        String writeHandle = buffer.getString();
        long writeOffset = buffer.getLong();
        try {
            this.doCopyData(id, readHandle, readOffset, readLength, writeHandle, writeOffset);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, "copy-data", readHandle, readOffset, readLength, writeHandle, writeOffset);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doCopyData(int var1, String var2, long var3, long var5, String var7, long var8) throws IOException;

    protected void doCopyFile(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        boolean overwriteDestination = buffer.getBoolean();
        try {
            this.doCopyFile(id, srcFile, dstFile, overwriteDestination);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, "copy-file", srcFile, dstFile, overwriteDestination);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, boolean overwriteDestination) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doCopyFile({})[id={}] SSH_FXP_EXTENDED[{}] (src={}, dst={}, overwrite=0x{})", this.getServerSession(), id, "copy-file", srcFile, dstFile, overwriteDestination);
        }
        this.doCopyFile(id, srcFile, dstFile, overwriteDestination ? Collections.singletonList(StandardCopyOption.REPLACE_EXISTING) : Collections.emptyList());
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, Collection<CopyOption> opts) throws IOException {
        Path src = this.resolveFile(srcFile);
        Path dst = this.resolveFile(dstFile);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.copyFile(this, src, dst, opts);
    }

    protected void doBlock(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        long offset = buffer.getLong();
        long length = buffer.getLong();
        int mask = buffer.getInt();
        try {
            this.doBlock(id, handle2, offset, length, mask);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 22, Handle.safe(handle2), offset, length, mask);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doBlock(int var1, String var2, long var3, long var5, int var7) throws IOException;

    protected void doUnblock(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        long offset = buffer.getLong();
        long length = buffer.getLong();
        try {
            this.doUnblock(id, handle2, offset, length);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 23, Handle.safe(handle2), offset, length);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected abstract void doUnblock(int var1, String var2, long var3, long var5) throws IOException;

    protected void doStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path2 = buffer.getString();
        int flags = 65535;
        int version2 = this.getVersion();
        if (version2 >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doStat(id, path2, flags);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 17, path2, flags);
            return;
        }
        this.sendAttrs(this.prepareReply(buffer), id, attrs);
    }

    protected Map<String, Object> doStat(int id, String path2, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doStat({})[id={}] SSH_FXP_STAT (path={}, flags=0x{})", this.getServerSession(), id, path2, Integer.toHexString(flags));
        }
        Path p = this.resolveFile(path2);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean followLinks = this.resolvePathResolutionFollowLinks(17, "", p);
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, p, 17, "", followLinks);
        return this.resolveFileAttributes(p, flags, !followLinks, options2);
    }

    protected void doRealPath(Buffer buffer, int id) throws IOException {
        AbstractMap.SimpleImmutableEntry<Path, Boolean> result2;
        Map attrs;
        block20: {
            String path2 = buffer.getString();
            boolean debugEnabled = this.log.isDebugEnabled();
            ServerSession session2 = this.getServerSession();
            if (debugEnabled) {
                this.log.debug("doRealPath({})[id={}] SSH_FXP_REALPATH (path={})", session2, id, path2);
            }
            if (GenericUtils.isEmpty(path2 = GenericUtils.trimToEmpty(path2))) {
                path2 = ".";
            }
            attrs = Collections.emptyMap();
            try {
                int version2 = this.getVersion();
                if (version2 < 6) {
                    Path p = this.resolveFile(path2);
                    LinkOption[] options2 = this.getPathResolutionLinkOption(16, "", p);
                    result2 = this.doRealPathV345(id, path2, p, options2);
                    break block20;
                }
                int control = 1;
                if (buffer.available() > 0) {
                    control = buffer.getUByte();
                    if (debugEnabled) {
                        this.log.debug("doRealPath({}) - control=0x{} for path={}", session2, Integer.toHexString(control), path2);
                    }
                }
                LinkedList<String> extraPaths = new LinkedList<String>();
                while (buffer.available() > 0) {
                    extraPaths.add(buffer.getString());
                }
                Path p = this.resolveFile(path2);
                LinkOption[] options3 = this.getPathResolutionLinkOption(16, "", p);
                result2 = this.doRealPathV6(id, path2, extraPaths, p, options3);
                p = (Path)result2.getKey();
                Boolean status2 = (Boolean)result2.getValue();
                switch (control) {
                    case 2: {
                        if (status2 == null) {
                            attrs = this.handleUnknownStatusFileAttributes(p, 65535, options3);
                            break;
                        }
                        if (status2.booleanValue()) {
                            try {
                                attrs = this.getAttributes(p, options3);
                            }
                            catch (IOException e2) {
                                this.debug("doRealPath({}) - failed ({}) to retrieve attributes of {}: {}", session2, e2.getClass().getSimpleName(), p, e2.getMessage(), e2);
                            }
                            break;
                        }
                        if (debugEnabled) {
                            this.log.debug("doRealPath({}) - dummy attributes for non-existing file: {}", (Object)session2, (Object)p);
                        }
                        break;
                    }
                    case 3: {
                        if (status2 == null) {
                            attrs = this.handleUnknownStatusFileAttributes(p, 65535, options3);
                            break;
                        }
                        if (status2.booleanValue()) {
                            attrs = this.getAttributes(p, options3);
                            break;
                        }
                        throw new NoSuchFileException(p.toString(), p.toString(), "Real path N/A for target");
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.log.warn("doRealPath({}) unknown control value 0x{} for path={}", session2, Integer.toHexString(control), p);
                    }
                }
            }
            catch (IOException | RuntimeException e3) {
                this.sendStatus(this.prepareReply(buffer), id, e3, 16, path2);
                return;
            }
        }
        this.sendPath(this.prepareReply(buffer), id, (Path)result2.getKey(), attrs);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> doRealPathV6(int id, String path2, Collection<String> extraPaths, Path p, LinkOption ... options2) throws IOException {
        int numExtra = GenericUtils.size(extraPaths);
        if (numExtra > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doRealPathV6({})[id={}] path={}, extra={}", this.getServerSession(), id, path2, extraPaths);
            }
            StringBuilder sb = new StringBuilder(GenericUtils.length(path2) + numExtra * 8);
            sb.append(path2);
            for (String p2 : extraPaths) {
                p = p.resolve(p2);
                options2 = this.getPathResolutionLinkOption(16, "", p);
                sb.append('/').append(p2);
            }
            path2 = sb.toString();
        }
        return this.validateRealPath(id, path2, p, options2);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> doRealPathV345(int id, String path2, Path p, LinkOption ... options2) throws IOException {
        return this.validateRealPath(id, path2, p, options2);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> validateRealPath(int id, String path2, Path f2, LinkOption ... options2) throws IOException {
        Path p = this.normalize(f2);
        Boolean status2 = IoUtils.checkFileExistsAnySymlinks(p, !IoUtils.followLinks(options2));
        return new AbstractMap.SimpleImmutableEntry<Path, Boolean>(p, status2);
    }

    protected void doRemoveDirectory(Buffer buffer, int id) throws IOException {
        String path2 = buffer.getString();
        try {
            this.doRemoveDirectory(id, path2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 15, path2);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doRemoveDirectory(int id, String path2) throws IOException {
        Path p = this.resolveFile(path2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRemoveDirectory({})[id={}] SSH_FXP_RMDIR (path={})[{}]", this.getServerSession(), id, path2, p);
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        boolean followLinks = this.resolvePathResolutionFollowLinks(15, "", p);
        Boolean symlinkCheck = this.validateParentExistWithNoSymlinksIfNeverFollowSymlinks(p, !followLinks);
        if (!Boolean.TRUE.equals(symlinkCheck)) {
            throw new AccessDeniedException(p.toString(), p.toString(), "Parent directories do not exist ore are prohibited symlinks");
        }
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, p, 15, "", false);
        if (!Files.isDirectory(p, options2)) {
            throw this.signalRemovalPreConditionFailure(id, path2, p, new NotDirectoryException(p.toString()), true);
        }
        this.doRemove(id, p, true);
    }

    protected void doRemove(int id, Path p, boolean isDirectory) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session2 = this.getServerSession();
        listener.removing(session2, p, isDirectory);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            accessor.removeFile(this, p, isDirectory);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.removed(session2, p, isDirectory, e2);
            throw e2;
        }
        listener.removed(session2, p, isDirectory, null);
    }

    protected void doMakeDirectory(Buffer buffer, int id) throws IOException {
        String path2 = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doMakeDirectory(id, path2, attrs);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 14, path2, attrs);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doMakeDirectory(int id, String path2, Map<String, ?> attrs) throws IOException {
        Path resolvedPath = this.resolveFile(path2);
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMakeDirectory({})[id={}] SSH_FXP_MKDIR (path={}[{}], attrs={})", session2, id, path2, resolvedPath, attrs);
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, resolvedPath, 14, "", false);
        boolean followLinks = this.resolvePathResolutionFollowLinks(14, "", resolvedPath);
        WithFileAttributeCache.withAttributeCache(resolvedPath, p -> {
            Boolean symlinkCheck = this.validateParentExistWithNoSymlinksIfNeverFollowSymlinks((Path)p, !followLinks);
            if (!Boolean.TRUE.equals(symlinkCheck)) {
                throw new AccessDeniedException(p.toString(), p.toString(), "Parent directories do not exist ore are prohibited symlinks");
            }
            Boolean fileExists = IoUtils.checkFileExists(p, options2);
            if (fileExists == null) {
                throw new AccessDeniedException(p.toString(), p.toString(), "Cannot validate make-directory existence");
            }
            if (fileExists.booleanValue()) {
                if (Files.isDirectory(p, options2)) {
                    throw new FileAlreadyExistsException(p.toString(), p.toString(), "Target directory already exists");
                }
                throw new FileAlreadyExistsException(p.toString(), p.toString(), "Already exists as a file");
            }
            return null;
        });
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.creating(session2, resolvedPath, attrs);
        try {
            accessor.createDirectory(this, resolvedPath);
            this.doSetAttributes(14, "", resolvedPath, attrs, followLinks);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.created(session2, resolvedPath, attrs, e2);
            throw e2;
        }
        listener.created(session2, resolvedPath, attrs, null);
    }

    protected void doRemove(Buffer buffer, int id) throws IOException {
        String path2 = buffer.getString();
        try {
            this.doRemoveFile(id, path2);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 13, path2);
            return;
        }
        this.sendStatus(this.prepareReply(buffer), id, 0, "");
    }

    protected void doRemoveFile(int id, String path2) throws IOException {
        Path resolvedPath = this.resolveFile(path2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRemoveFile({})[id={}] SSH_FXP_REMOVE (path={}[{}])", this.getServerSession(), id, path2, resolvedPath);
        }
        boolean followLinks = this.resolvePathResolutionFollowLinks(13, "", resolvedPath);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, resolvedPath, 13, "", false);
        WithFileAttributeCache.withAttributeCache(resolvedPath, p -> {
            Boolean status2 = this.checkSymlinkState((Path)p, followLinks, options2);
            if (status2 == null) {
                throw this.signalRemovalPreConditionFailure(id, path2, (Path)p, (IOException)new AccessDeniedException(p.toString(), p.toString(), "Cannot determine existence of remove candidate"), false);
            }
            if (!status2.booleanValue()) {
                throw this.signalRemovalPreConditionFailure(id, path2, (Path)p, (IOException)new NoSuchFileException(p.toString(), p.toString(), "Removal candidate not found"), false);
            }
            if (Files.isDirectory(p, options2)) {
                throw this.signalRemovalPreConditionFailure(id, path2, (Path)p, (IOException)new SftpException(24, p.toString() + " is a folder"), false);
            }
            return null;
        });
        this.doRemove(id, resolvedPath, false);
    }

    protected <E extends IOException> E signalRemovalPreConditionFailure(int id, String pathValue, Path path2, E thrown, boolean isRemoveDirectory) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("signalRemovalPreConditionFailure(id={})[{}] signal {} for (directory={}) {}: {}", id, pathValue, thrown.getClass().getSimpleName(), isRemoveDirectory, path2, thrown.getMessage());
        }
        listener.removing(session2, path2, isRemoveDirectory);
        listener.removed(session2, path2, isRemoveDirectory, thrown);
        return thrown;
    }

    protected void doExtended(Buffer buffer, int id) throws IOException {
        String extension = buffer.getString();
        try {
            SftpEventListener listener = this.getSftpEventListenerProxy();
            ServerSession session2 = this.getServerSession();
            listener.receivedExtension(session2, extension, id);
        }
        catch (IOException | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 200, extension);
            return;
        }
        this.executeExtendedCommand(buffer, id, extension);
    }

    protected void executeExtendedCommand(Buffer buffer, int id, String extension) throws IOException {
        switch (extension) {
            case "text-seek": {
                this.doTextSeek(buffer, id);
                break;
            }
            case "version-select": {
                this.doVersionSelect(buffer, id);
                break;
            }
            case "copy-file": {
                this.doCopyFile(buffer, id);
                break;
            }
            case "copy-data": {
                this.doCopyData(buffer, id);
                break;
            }
            case "md5-hash": 
            case "md5-hash-handle": {
                this.doMD5Hash(buffer, id, extension);
                break;
            }
            case "check-file-handle": 
            case "check-file-name": {
                this.doCheckFileHash(buffer, id, extension);
                break;
            }
            case "fsync@openssh.com": {
                this.doOpenSSHFsync(buffer, id);
                break;
            }
            case "space-available": {
                this.doSpaceAvailable(buffer, id);
                break;
            }
            case "hardlink@openssh.com": {
                this.doOpenSSHHardLink(buffer, id);
                break;
            }
            case "lsetstat@openssh.com": {
                this.doSetStat(buffer, id, extension, -1, Boolean.FALSE);
                break;
            }
            case "posix-rename@openssh.com": {
                this.doPosixRename(buffer, id);
                break;
            }
            case "limits@openssh.com": {
                this.doOpenSSHLimits(buffer, id);
                break;
            }
            default: {
                this.doUnsupportedExtension(buffer, id, extension);
            }
        }
    }

    protected void doUnsupportedExtension(Buffer buffer, int id, String extension) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("executeExtendedCommand({}) received unsupported SSH_FXP_EXTENDED({})", (Object)this.getServerSession(), (Object)extension);
        }
        this.sendStatus(this.prepareReply(buffer), id, 8, "Command SSH_FXP_EXTENDED(" + extension + ") is unsupported or not implemented");
    }

    protected void appendExtensions(Buffer buffer, String supportedVersions) {
        ArrayList<String> extras;
        ServerSession session2 = this.getServerSession();
        this.appendVersionsExtension(buffer, supportedVersions, session2);
        this.appendNewlineExtension(buffer, session2);
        this.appendVendorIdExtension(buffer, VersionProperties.getVersionProperties(), session2);
        this.appendOpenSSHExtensions(buffer, session2);
        this.appendAclSupportedExtension(buffer, session2);
        Map<String, OptionalFeature> extensions = this.getSupportedClientExtensions(session2);
        int numExtensions = MapEntryUtils.size(extensions);
        ArrayList<String> arrayList = extras = numExtensions <= 0 ? Collections.emptyList() : new ArrayList<String>(numExtensions);
        if (numExtensions > 0) {
            boolean debugEnabled = this.log.isDebugEnabled();
            for (Map.Entry<String, OptionalFeature> ee : extensions.entrySet()) {
                String name = ee.getKey();
                OptionalFeature f2 = ee.getValue();
                if (!f2.isSupported()) {
                    if (!debugEnabled) continue;
                    this.log.debug("appendExtensions({}) skip unsupported extension={}", (Object)session2, (Object)name);
                    continue;
                }
                extras.add(name);
            }
        }
        this.appendSupportedExtension(buffer, extras);
        this.appendSupported2Extension(buffer, extras);
    }

    protected int appendAclSupportedExtension(Buffer buffer, ServerSession session2) {
        Collection<Integer> maskValues = this.resolveAclSupportedCapabilities(session2);
        int mask = AclSupportedParser.AclCapabilities.constructAclCapabilities(maskValues);
        if (mask != 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("appendAclSupportedExtension({}) capabilities={}", (Object)session2, (Object)AclSupportedParser.AclCapabilities.decodeAclCapabilities(mask));
            }
            buffer.putString("acl-supported");
            int lenPos = buffer.wpos();
            buffer.putUInt(0L);
            buffer.putInt(mask);
            BufferUtils.updateLengthPlaceholder(buffer, lenPos);
        }
        return mask;
    }

    protected Collection<Integer> resolveAclSupportedCapabilities(ServerSession session2) {
        String override = SftpModuleProperties.ACL_SUPPORTED_MASK.getOrNull(session2);
        if (override == null) {
            return DEFAULT_ACL_SUPPORTED_MASK;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveAclSupportedCapabilities({}) override='{}'", (Object)session2, (Object)override);
        }
        if (override.length() == 0) {
            return Collections.emptySet();
        }
        String[] names2 = GenericUtils.split(override, ',');
        HashSet<Integer> maskValues = new HashSet<Integer>(names2.length);
        for (String n : names2) {
            Integer v = ValidateUtils.checkNotNull(AclSupportedParser.AclCapabilities.getAclCapabilityValue(n), "Unknown ACL capability: %s", (Object)n);
            maskValues.add(v);
        }
        return maskValues;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> appendOpenSSHExtensions(Buffer buffer, ServerSession session2) {
        List<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = this.resolveOpenSSHExtensions(session2);
        if (GenericUtils.isEmpty(extList)) {
            return extList;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendOpenSSHExtensions({}): {}", (Object)session2, (Object)extList);
        }
        for (AbstractOpenSSHExtensionParser.OpenSSHExtension ext : extList) {
            buffer.putString(ext.getName());
            buffer.putString(ext.getVersion());
        }
        return extList;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> resolveOpenSSHExtensions(ServerSession session2) {
        String[] pairs2;
        int numExts;
        String value2 = SftpModuleProperties.OPENSSH_EXTENSIONS.getOrNull(session2);
        if (value2 == null) {
            return DEFAULT_OPEN_SSH_EXTENSIONS;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveOpenSSHExtensions({}) override='{}'", (Object)session2, (Object)value2);
        }
        if ((numExts = GenericUtils.length(pairs2 = GenericUtils.split(value2, ','))) <= 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = new ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension>(numExts);
        for (String nvp : pairs2) {
            if (GenericUtils.isEmpty(nvp = GenericUtils.trimToEmpty(nvp))) continue;
            int pos = nvp.indexOf(61);
            ValidateUtils.checkTrue(pos > 0 && pos < nvp.length() - 1, "Malformed OpenSSH extension spec: %s", (Object)nvp);
            String name = GenericUtils.trimToEmpty(nvp.substring(0, pos));
            String version2 = GenericUtils.trimToEmpty(nvp.substring(pos + 1));
            extList.add(new AbstractOpenSSHExtensionParser.OpenSSHExtension(name, ValidateUtils.checkNotNullAndNotEmpty(version2, "No version specified for OpenSSH extension %s", (Object)name)));
        }
        return extList;
    }

    protected Map<String, OptionalFeature> getSupportedClientExtensions(ServerSession session2) {
        String value2 = SftpModuleProperties.CLIENT_EXTENSIONS.getOrNull(session2);
        if (value2 == null) {
            return DEFAULT_SUPPORTED_CLIENT_EXTENSIONS;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getSupportedClientExtensions({}) override='{}'", (Object)session2, (Object)value2);
        }
        if (value2.length() <= 0) {
            return Collections.emptyMap();
        }
        if (value2.indexOf(44) <= 0) {
            return Collections.singletonMap(value2, OptionalFeature.TRUE);
        }
        String[] comps = GenericUtils.split(value2, ',');
        LinkedHashMap<String, OptionalFeature> result2 = new LinkedHashMap<String, OptionalFeature>(comps.length);
        for (String c2 : comps) {
            result2.put(c2, OptionalFeature.TRUE);
        }
        return result2;
    }

    protected String appendVersionsExtension(Buffer buffer, String value2, ServerSession session2) {
        if (GenericUtils.isEmpty(value2)) {
            return value2;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendVersionsExtension({}) value={}", (Object)session2, (Object)value2);
        }
        buffer.putString("versions");
        buffer.putString(value2);
        return value2;
    }

    protected String appendNewlineExtension(Buffer buffer, ServerSession session2) {
        String value2 = this.resolveNewlineValue(session2);
        if (GenericUtils.isEmpty(value2)) {
            return value2;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendNewlineExtension({}) value={}", (Object)session2, (Object)BufferUtils.toHex(':', value2.getBytes(StandardCharsets.UTF_8)));
        }
        buffer.putString("newline");
        buffer.putString(value2);
        return value2;
    }

    protected String resolveNewlineValue(ServerSession session2) {
        return SftpModuleProperties.NEWLINE_VALUE.getRequired(session2);
    }

    protected Map<String, ?> appendVendorIdExtension(Buffer buffer, Map<String, ?> versionProperties, ServerSession session2) {
        if (MapEntryUtils.isEmpty(versionProperties)) {
            return versionProperties;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendVendorIdExtension({}): {}", (Object)session2, (Object)versionProperties);
        }
        buffer.putString("vendor-id");
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(Collections.unmodifiableMap(versionProperties));
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putString(resolver.getStringProperty("groupId", this.getClass().getPackage().getName()));
        buffer.putString(resolver.getStringProperty("artifactId", this.getClass().getSimpleName()));
        buffer.putString(resolver.getStringProperty("version", "SSHD-UNKNOWN"));
        buffer.putLong(0L);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
        return versionProperties;
    }

    protected void appendSupportedExtension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported");
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putInt(701L);
        buffer.putUInt(0L);
        buffer.putInt(63L);
        buffer.putUInt(0L);
        buffer.putUInt(0L);
        buffer.putStringList(extras, false);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void appendSupported2Extension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported2");
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putInt(701L);
        buffer.putUInt(0L);
        buffer.putInt(15L);
        buffer.putUInt(0L);
        buffer.putUInt(0L);
        buffer.putShort(0);
        buffer.putShort(0);
        buffer.putStringList(Collections.emptyList(), true);
        buffer.putStringList(extras, true);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void sendHandle(Buffer buffer, int id, String handle2) throws IOException {
        buffer.putByte((byte)102);
        buffer.putInt(id);
        buffer.putString(handle2, StandardCharsets.ISO_8859_1);
        this.send(buffer);
    }

    protected void sendAttrs(Buffer buffer, int id, Map<String, ?> attributes2) throws IOException {
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, attributes2);
        this.send(buffer);
    }

    protected void sendLink(Buffer buffer, int id, Path file2, String link) throws IOException {
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putUInt(1L);
        String unixPath = link.replace(File.separatorChar, '/');
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.putRemoteFileName(this, file2, buffer, unixPath, true);
        Map attrs = Collections.emptyMap();
        int version2 = this.getVersion();
        if (version2 == 3) {
            String longName = SftpHelper.getLongName(unixPath, attrs);
            accessor.putRemoteFileName(this, file2, buffer, longName, false);
        }
        this.writeAttrs(buffer, attrs);
        SftpHelper.indicateEndOfNamesList(buffer, this.getVersion(), this.getServerSession());
        this.send(buffer);
    }

    protected void sendPath(Buffer buffer, int id, Path f2, Map<String, ?> attrs) throws IOException {
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putUInt(1L);
        String originalPath = f2.toString();
        String unixPath = originalPath.replace(File.separatorChar, '/');
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.putRemoteFileName(this, f2, buffer, unixPath, true);
        int version2 = this.getVersion();
        if (version2 == 3) {
            String longName = this.getLongName(f2, this.getShortName(f2), attrs);
            accessor.putRemoteFileName(this, f2, buffer, longName, false);
        }
        this.writeAttrs(buffer, attrs);
        SftpHelper.indicateEndOfNamesList(buffer, this.getVersion(), this.getServerSession());
        this.send(buffer);
    }

    protected int doReadDir(int id, String handle2, DirectoryHandle dir, Buffer buffer, int maxSize2, boolean followLinks) throws IOException {
        ServerSession session2 = this.getServerSession();
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, dir.getFile(), 12, "", followLinks);
        int nb = 0;
        TreeMap<String, Path> entries2 = new TreeMap<String, Path>(Comparator.naturalOrder());
        while ((dir.isSendDot() || dir.isSendDotDot() || dir.hasNext()) && buffer.wpos() < maxSize2) {
            if (dir.isSendDot()) {
                this.writeDirEntry(id, dir, entries2, buffer, nb, dir.getFile(), ".", options2);
                dir.markDotSent();
            } else if (dir.isSendDotDot()) {
                Path dirPath = dir.getFile();
                Path parentPath = dirPath.getParent();
                if (parentPath != null) {
                    this.writeDirEntry(id, dir, entries2, buffer, nb, parentPath, "..", options2);
                }
                dir.markDotDotSent();
            } else {
                SftpClient.Attributes attributes2;
                Path f2 = dir.next();
                String shortName = this.getShortName(f2);
                if (f2 instanceof WithFileAttributes && (attributes2 = ((WithFileAttributes)((Object)f2)).getAttributes()) != null) {
                    entries2.put(shortName, f2);
                    this.writeDirEntry(session2, id, buffer, nb, f2, shortName, attributes2);
                    ++nb;
                    continue;
                }
                this.writeDirEntry(id, dir, entries2, buffer, nb, f2, shortName, options2);
            }
            ++nb;
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.readEntries(session2, handle2, dir, entries2);
        return nb;
    }

    protected void writeDirEntry(ServerSession session2, int id, Buffer buffer, int index, Path f2, String shortName, SftpClient.Attributes attributes2) throws IOException {
        int version2 = this.getVersion();
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.putRemoteFileName(this, f2, buffer, shortName, true);
        if (version2 == 3) {
            String longName = this.getLongName(f2, shortName, attributes2);
            accessor.putRemoteFileName(this, f2, buffer, longName, false);
            if (this.log.isTraceEnabled()) {
                this.log.trace("writeDirEntry({}) id={})[{}] - writing entry {} [{}]: {}", session2, id, index, shortName, longName, attributes2);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("writeDirEntry({}) id={})[{}] - writing entry {}: {}", session2, id, index, shortName, attributes2);
        }
        SftpHelper.writeAttributes(buffer, attributes2, version2);
    }

    protected void writeDirEntry(int id, DirectoryHandle dir, Map<String, Path> entries2, Buffer buffer, int index, Path f2, String shortName, LinkOption ... options2) throws IOException {
        boolean followLinks = this.resolvePathResolutionFollowLinks(12, "", f2);
        NavigableMap<String, Object> attrs = this.resolveFileAttributes(f2, 65535, !followLinks, options2);
        entries2.put(shortName, f2);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        ServerSession session2 = this.getServerSession();
        accessor.putRemoteFileName(this, f2, buffer, shortName, true);
        int version2 = this.getVersion();
        if (version2 == 3) {
            String longName = this.getLongName(f2, shortName, attrs);
            accessor.putRemoteFileName(this, f2, buffer, longName, false);
            if (this.log.isTraceEnabled()) {
                this.log.trace("writeDirEntry({} id={})[{}] - {} [{}]: {}", session2, id, index, shortName, longName, attrs);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("writeDirEntry({} id={})[{}] - {}: {}", session2, id, index, shortName, attrs);
        }
        this.writeAttrs(buffer, attrs);
    }

    protected String getLongName(Path f2, String shortName, LinkOption ... options2) throws IOException {
        return this.getLongName(f2, shortName, true, options2);
    }

    protected String getLongName(Path f2, String shortName, boolean sendAttrs, LinkOption ... options2) throws IOException {
        Map<Object, Object> attributes2 = sendAttrs ? this.getAttributes(f2, options2) : Collections.emptyMap();
        return this.getLongName(f2, shortName, attributes2);
    }

    protected String getLongName(Path f2, String shortName, Map<String, ?> attributes2) throws IOException {
        return SftpHelper.getLongName(shortName, attributes2);
    }

    protected String getLongName(Path f2, String shortName, SftpClient.Attributes attributes2) throws IOException {
        return this.getLongName(f2, shortName, ((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)((MapEntryUtils.MapBuilder)MapEntryUtils.MapBuilder.builder().put("owner", attributes2.getOwner())).put("group", attributes2.getGroup())).put("size", (Object)attributes2.getSize())).put("isDirectory", (Object)attributes2.isDirectory())).put("isSymbolicLink", (Object)attributes2.isSymbolicLink())).put("permissions", SftpHelper.permissionsToAttributes(attributes2.getPermissions()))).put("lastModifiedTime", attributes2.getModifyTime())).build());
    }

    protected String getShortName(Path f2) throws IOException {
        Path nrm = this.normalize(f2);
        int count2 = nrm.getNameCount();
        if (OsUtils.isUNIX()) {
            Path name = f2.getFileName();
            if (name == null) {
                Path p = this.resolveFile(".");
                name = p.getFileName();
            }
            if (name == null && count2 > 0) {
                name = nrm.getFileName();
            }
            if (name != null) {
                return name.toString();
            }
            return nrm.toString();
        }
        if (count2 > 0) {
            Path name = nrm.getFileName();
            return name.toString();
        }
        return nrm.toString().replace(File.separatorChar, '/');
    }

    protected NavigableMap<String, Object> resolveFileAttributes(Path path2, int flags, boolean neverFollowSymLinks, LinkOption ... options2) throws IOException {
        return WithFileAttributeCache.withAttributeCache(path2, file2 -> {
            Boolean status2 = this.checkSymlinkState((Path)file2, neverFollowSymLinks, options2);
            if (status2 == null) {
                return this.handleUnknownStatusFileAttributes((Path)file2, flags, options2);
            }
            if (!status2.booleanValue()) {
                throw new NoSuchFileException(file2.toString(), file2.toString(), "Attributes N/A for target");
            }
            return this.getAttributes((Path)file2, flags, options2);
        });
    }

    public Boolean checkSymlinkState(Path path2, boolean neverFollowSymLinks, LinkOption[] options2) {
        Boolean status2 = this.validateParentExistWithNoSymlinksIfNeverFollowSymlinks(path2, neverFollowSymLinks);
        if (!Boolean.FALSE.equals(status2)) {
            status2 = IoUtils.checkFileExists(path2, options2);
        }
        return status2;
    }

    public Boolean validateParentExistWithNoSymlinksIfNeverFollowSymlinks(Path path2, boolean neverFollowSymLinks) {
        Boolean status2 = true;
        if (neverFollowSymLinks && path2.getParent() != null) {
            status2 = IoUtils.checkFileExistsAnySymlinks(path2.getParent(), true);
        }
        return status2;
    }

    protected void writeAttrs(Buffer buffer, Map<String, ?> attributes2) {
        SftpHelper.writeAttrs(buffer, this.getVersion(), attributes2);
    }

    protected NavigableMap<String, Object> getAttributes(Path file2, LinkOption ... options2) throws IOException {
        return this.getAttributes(file2, 65535, options2);
    }

    protected NavigableMap<String, Object> handleUnknownStatusFileAttributes(Path file2, int flags, LinkOption ... options2) throws IOException {
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case ThrowException: {
                throw new AccessDeniedException(file2.toString(), file2.toString(), "Cannot determine existence for attributes of target");
            }
            case Warn: {
                this.log.warn("handleUnknownStatusFileAttributes({})[{}] cannot determine existence", (Object)this.getServerSession(), (Object)file2);
                break;
            }
            default: {
                this.log.warn("handleUnknownStatusFileAttributes({})[{}] unknown policy: {}", new Object[]{this.getServerSession(), file2, policy});
            }
        }
        return this.getAttributes(file2, flags, options2);
    }

    protected NavigableMap<String, Object> getAttributes(Path path2, int flags, LinkOption ... options2) throws IOException {
        NavigableMap attrs = WithFileAttributeCache.withAttributeCache(path2, file2 -> this.resolveReportedFileAttributes((Path)file2, flags, options2));
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        return accessor.resolveReportedFileAttributes(this, path2, flags, attrs, options2);
    }

    protected NavigableMap<String, Object> resolveReportedFileAttributes(Path file2, int flags, LinkOption ... options2) throws IOException {
        FileSystem fs = file2.getFileSystem();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        List<Object> views = GenericUtils.isEmpty(supportedViews) ? Collections.emptyList() : (supportedViews.contains("unix") ? SftpFileSystemAccessor.DEFAULT_UNIX_VIEW : GenericUtils.map(supportedViews, v -> v + ":*"));
        for (String v2 : views) {
            NavigableMap<String, Object> ta = this.readFileAttributes(file2, v2, options2);
            if (!MapEntryUtils.isNotEmpty(ta)) continue;
            attrs.putAll(ta);
        }
        NavigableMap<String, Object> completions = this.resolveMissingFileAttributes(file2, flags, attrs, options2);
        if (MapEntryUtils.isNotEmpty(completions)) {
            attrs.putAll(completions);
        }
        return attrs;
    }

    protected NavigableMap<String, Object> resolveMissingFileAttributes(Path file2, int flags, Map<String, Object> current, LinkOption ... options2) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        ServerSession session2 = this.getServerSession();
        TreeMap<String, Object> attrs = null;
        for (Map.Entry re : SftpFileSystemAccessor.FILEATTRS_RESOLVERS.entrySet()) {
            String name = (String)re.getKey();
            Object value2 = MapEntryUtils.isEmpty(current) ? null : current.get(name);
            FileInfoExtractor x = (FileInfoExtractor)re.getValue();
            try {
                Object resolved2 = this.resolveMissingFileAttributeValue(file2, name, value2, x, options2);
                if (Objects.equals(resolved2, value2)) continue;
                if (attrs == null) {
                    attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                }
                attrs.put(name, resolved2);
                if (!debugEnabled) continue;
                this.log.debug("resolveMissingFileAttributes({})[{}[{}]] replace {} with {}", session2, file2, name, value2, resolved2);
            }
            catch (IOException e2) {
                this.warn("resolveMissingFileAttributes({})[{}[{}]] failed ({}) to resolve missing value: {}", session2, file2, name, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
        }
        if (attrs == null) {
            return Collections.emptyNavigableMap();
        }
        return attrs;
    }

    protected Object resolveMissingFileAttributeValue(Path file2, String name, Object value2, FileInfoExtractor<?> x, LinkOption ... options2) throws IOException {
        if (value2 != null) {
            return value2;
        }
        return x.infoOf(file2, options2);
    }

    protected NavigableMap<String, Object> addMissingAttribute(Path file2, NavigableMap<String, Object> current, String name, FileInfoExtractor<?> x, LinkOption ... options2) throws IOException {
        Object value2;
        Object v = value2 = MapEntryUtils.isEmpty(current) ? null : (Object)current.get(name);
        if (value2 != null) {
            return current;
        }
        value2 = x.infoOf(file2, options2);
        if (value2 == null) {
            return current;
        }
        if (current == null) {
            current = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        current.put(name, value2);
        return current;
    }

    protected NavigableMap<String, Object> readFileAttributes(Path file2, String view, LinkOption ... options2) throws IOException {
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            Map<String, ?> attrs = accessor.readFileAttributes(this, file2, view, options2);
            if (MapEntryUtils.isEmpty(attrs)) {
                return Collections.emptyNavigableMap();
            }
            TreeMap<String, Object> sorted2 = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            sorted2.putAll(attrs);
            return sorted2;
        }
        catch (IOException e2) {
            return this.handleReadFileAttributesException(file2, view, options2, e2);
        }
    }

    protected NavigableMap<String, Object> handleReadFileAttributesException(Path file2, String view, LinkOption[] options2, IOException e2) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleReadFileAttributesException(" + file2 + ")[" + view + "] details", e2);
        }
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleReadFileAttributesException({})[{}] {}", file2, view, e2.toString());
                break;
            }
            case ThrowException: {
                throw e2;
            }
            default: {
                this.log.warn("handleReadFileAttributesException({})[{}] Unknown policy ({}) for {}", new Object[]{file2, view, policy, e2.toString()});
            }
        }
        return Collections.emptyNavigableMap();
    }

    protected void doSetAttributes(int cmd, String extension, Path file2, Map<String, ?> attributes2, boolean followLinks) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session2 = this.getServerSession();
        listener.modifyingAttributes(session2, file2, attributes2);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, file2, cmd, extension, followLinks);
            this.setFileAttributes(file2, attributes2, options2);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.modifiedAttributes(session2, file2, attributes2, e2);
            throw e2;
        }
        listener.modifiedAttributes(session2, file2, attributes2, null);
    }

    protected LinkOption[] getPathResolutionLinkOption(int cmd, String extension, Path path2) throws IOException {
        boolean followLinks = this.resolvePathResolutionFollowLinks(cmd, extension, path2);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        return accessor.resolveFileAccessLinkOptions(this, path2, cmd, extension, followLinks);
    }

    protected boolean resolvePathResolutionFollowLinks(int cmd, String extension, Path path2) throws IOException {
        return SftpModuleProperties.AUTO_FOLLOW_LINKS.getRequired(this.getServerSession());
    }

    protected void setFileAttributes(Path file2, Map<String, ?> attributes2, LinkOption ... options2) throws IOException {
        TreeSet<String> unsupported = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        block33: for (Map.Entry<String, ?> ae : attributes2.entrySet()) {
            String attribute = ae.getKey();
            Object value2 = ae.getValue();
            String view = null;
            switch (attribute) {
                case "size": {
                    long newSize = ((Number)value2).longValue();
                    SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
                    HashSet<Enum> openOptions = new HashSet<Enum>();
                    openOptions.add(StandardOpenOption.WRITE);
                    if (!IoUtils.followLinks(options2)) {
                        openOptions.add(LinkOption.NOFOLLOW_LINKS);
                    }
                    SeekableByteChannel channel2 = accessor.openFile(this, null, file2, null, openOptions, new FileAttribute[0]);
                    try {
                        channel2.truncate(newSize);
                        accessor.closeFile(this, null, file2, null, channel2, openOptions);
                        continue block33;
                    }
                    finally {
                        if (channel2 == null) continue block33;
                        channel2.close();
                        continue block33;
                    }
                }
                case "uid": {
                    view = "unix";
                    break;
                }
                case "gid": {
                    view = "unix";
                    break;
                }
                case "owner": {
                    view = "posix";
                    value2 = this.toUser(file2, (UserPrincipal)value2);
                    break;
                }
                case "group": {
                    view = "posix";
                    value2 = this.toGroup(file2, (GroupPrincipal)value2);
                    break;
                }
                case "permissions": {
                    view = "posix";
                    break;
                }
                case "acl": {
                    view = "acl";
                    break;
                }
                case "creationTime": {
                    view = "basic";
                    break;
                }
                case "lastModifiedTime": {
                    view = "basic";
                    break;
                }
                case "lastAccessTime": {
                    view = "basic";
                    break;
                }
                case "extended": {
                    view = "extended";
                    break;
                }
            }
            if (GenericUtils.length(view) <= 0 || value2 == null) continue;
            try {
                this.setFileAttribute(file2, view, attribute, value2, options2);
            }
            catch (Exception e2) {
                this.handleSetFileAttributeFailure(file2, view, attribute, value2, unsupported, e2);
            }
        }
        this.handleUnsupportedAttributes(unsupported);
    }

    protected void handleSetFileAttributeFailure(Path file2, String view, String attribute, Object value2, Collection<String> unsupported, Exception e2) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (e2 instanceof UnsupportedOperationException) {
            if (debugEnabled) {
                this.log.debug("handleSetFileAttributeFailure({})[{}] {}:{}={} unsupported: {}", this.getServerSession(), file2, view, attribute, value2, e2.getMessage());
            }
        } else {
            this.warn("handleSetFileAttributeFailure({})[{}] {}:{}={} - failed ({}) to set: {}", this.getServerSession(), file2, view, attribute, value2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw new IOException(e2);
        }
        unsupported.add(attribute);
    }

    protected void setFileAttribute(Path file2, String view, String attribute, Object value2, LinkOption ... options2) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFileAttribute({})[{}] {}:{}={}", this.getServerSession(), file2, view, attribute, value2);
        }
        if ("acl".equalsIgnoreCase(attribute) && "acl".equalsIgnoreCase(view)) {
            List acl = (List)value2;
            this.setFileAccessControl(file2, acl, options2);
        } else if ("permissions".equalsIgnoreCase(attribute)) {
            Set perms = (Set)value2;
            this.setFilePermissions(file2, perms, options2);
        } else if ("owner".equalsIgnoreCase(attribute) || "group".equalsIgnoreCase(attribute)) {
            this.setFileOwnership(file2, attribute, (Principal)value2, options2);
        } else if ("creationTime".equalsIgnoreCase(attribute) || "lastModifiedTime".equalsIgnoreCase(attribute) || "lastAccessTime".equalsIgnoreCase(attribute)) {
            this.setFileTime(file2, view, attribute, (FileTime)value2, options2);
        } else if ("extended".equalsIgnoreCase(attribute) && "extended".equalsIgnoreCase(view)) {
            Map extensions = (Map)value2;
            this.setFileExtensions(file2, extensions, options2);
        } else {
            this.setFileRawViewAttribute(file2, view, attribute, value2, options2);
        }
    }

    protected void setFileTime(Path file2, String view, String attribute, FileTime value2, LinkOption ... options2) throws IOException {
        if (value2 == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFileTime({})[{}] {}:{}={}", this.getServerSession(), file2, view, attribute, value2);
        }
        this.setFileRawViewAttribute(file2, view, attribute, value2, options2);
    }

    protected void setFileRawViewAttribute(Path file2, String view, String attribute, Object value2, LinkOption ... options2) throws IOException {
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.setFileAttribute(this, file2, view, attribute, value2, options2);
    }

    protected void setFileOwnership(Path file2, String attribute, Principal value2, LinkOption ... options2) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFileOwnership({})[{}] {}={}", this.getServerSession(), file2, attribute, value2);
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        if ("owner".equalsIgnoreCase(attribute)) {
            accessor.setFileOwner(this, file2, value2, options2);
        } else if ("group".equalsIgnoreCase(attribute)) {
            accessor.setGroupOwner(this, file2, value2, options2);
        } else {
            throw new UnsupportedOperationException("Unknown ownership attribute: " + attribute);
        }
    }

    protected void setFileExtensions(Path file2, Map<String, byte[]> extensions, LinkOption ... options2) throws IOException {
        int version2 = this.getVersion();
        if (version2 < 6) {
            if (MapEntryUtils.isNotEmpty(extensions) && this.log.isDebugEnabled()) {
                this.log.debug("setFileExtensions({})[{}]: {}", this.getServerSession(), file2, extensions.keySet());
            }
        } else {
            if (MapEntryUtils.isEmpty(extensions)) {
                return;
            }
            throw new UnsupportedOperationException("File extensions not supported");
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.applyExtensionFileAttributes(this, file2, extensions, options2);
    }

    protected void setFilePermissions(Path file2, Set<PosixFilePermission> perms, LinkOption ... options2) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFilePermissions({})[{}] {}", this.getServerSession(), file2, perms);
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.setFilePermissions(this, file2, perms, options2);
    }

    protected void setFileAccessControl(Path file2, List<AclEntry> acl, LinkOption ... options2) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFileAccessControl({})[{}] {}", this.getServerSession(), file2, acl);
        }
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.setFileAccessControl(this, file2, acl, options2);
    }

    protected void handleUnsupportedAttributes(Collection<String> attributes2) {
        if (attributes2.isEmpty()) {
            return;
        }
        String attrsList = GenericUtils.join(attributes2, ',');
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("Unsupported attributes: {}", (Object)attrsList);
                break;
            }
            case ThrowException: {
                throw new UnsupportedOperationException("Unsupported attributes: " + attrsList);
            }
            default: {
                this.log.warn("Unknown policy ''{}'' for attributes={}", (Object)policy, (Object)attrsList);
            }
        }
    }

    protected GroupPrincipal toGroup(Path file2, GroupPrincipal name) throws IOException {
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            return accessor.resolveGroupOwner(this, file2, name);
        }
        catch (IOException e2) {
            this.handleUserPrincipalLookupServiceException(GroupPrincipal.class, name.toString(), e2);
            return null;
        }
    }

    protected UserPrincipal toUser(Path file2, UserPrincipal name) throws IOException {
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            return accessor.resolveFileOwner(this, file2, name);
        }
        catch (IOException e2) {
            this.handleUserPrincipalLookupServiceException(UserPrincipal.class, name.toString(), e2);
            return null;
        }
    }

    protected void handleUserPrincipalLookupServiceException(Class<? extends Principal> principalType, String name, IOException e2) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleUserPrincipalLookupServiceException({})[{}] details", principalType.getSimpleName(), name, e2);
        }
        UnsupportedAttributePolicy policy = this.getUnsupportedAttributePolicy();
        switch (policy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleUserPrincipalLookupServiceException({})[{}] failed: {}", principalType.getSimpleName(), name, e2.toString());
                break;
            }
            case ThrowException: {
                throw e2;
            }
            default: {
                this.log.warn("Unknown policy ''{}'' for principal={} [{}]", new Object[]{policy, principalType.getSimpleName(), name});
            }
        }
    }

    protected Map<String, Object> readAttrs(Buffer buffer) throws IOException {
        return SftpHelper.readAttrs(buffer, this.getVersion());
    }

    protected <H extends Handle> H validateHandle(String handle2, Handle h2, Class<H> type2) throws IOException {
        if (h2 == null) {
            throw new NoSuchFileException(handle2, handle2, "No such current handle");
        }
        Class<?> t2 = h2.getClass();
        if (!type2.isAssignableFrom(t2)) {
            throw new InvalidHandleException(handle2, h2, type2);
        }
        return (H)((Handle)type2.cast(h2));
    }

    protected void sendStatus(Buffer buffer, int id, Throwable e2, int cmd, Object ... args2) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSendStatus[{}][id={},cmd={}] exception", this.getServerSession(), id, cmd, e2);
        }
        SftpErrorStatusDataHandler handler2 = this.getErrorStatusDataHandler();
        int subStatus = handler2.resolveSubStatus(this, id, e2, cmd, args2);
        String message = handler2.resolveErrorMessage(this, id, e2, subStatus, cmd, args2);
        String lang = handler2.resolveErrorLanguage(this, id, e2, subStatus, cmd, args2);
        this.sendStatus(buffer, id, subStatus, message, lang);
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg) throws IOException {
        this.sendStatus(buffer, id, substatus, msg != null ? msg : "", "");
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSendStatus({})[id={}] SSH_FXP_STATUS (substatus={}, lang={}, msg={})", this.getServerSession(), id, SftpConstants.getStatusName(substatus), lang, msg);
        }
        buffer.putByte((byte)101);
        buffer.putInt(id);
        buffer.putInt(substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected abstract Buffer prepareReply(Buffer var1);

    protected abstract void send(Buffer var1) throws IOException;

    protected Path resolveNormalizedLocation(String remotePath) throws IOException, InvalidPathException {
        Path resolvedPath = this.resolveFile(remotePath);
        return this.normalize(resolvedPath);
    }

    protected Path normalize(Path f2) {
        if (f2 == null) {
            return null;
        }
        Path abs2 = f2.isAbsolute() ? f2 : f2.toAbsolutePath();
        return abs2.normalize();
    }

    protected Path resolveFile(String remotePath) throws IOException, InvalidPathException {
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        Path localPath = accessor.resolveLocalFilePath(this, this.getDefaultDirectory(), remotePath);
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveFile({}) {} => {}", this.getServerSession(), remotePath, localPath);
        }
        return localPath;
    }
}

