/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import org.apache.sshd.sftp.server.SftpSubsystem;

public class DirectoryHandle
extends Handle
implements Iterator<Path> {
    private boolean done;
    private boolean sendDotDot = true;
    private boolean sendDot = true;
    private DirectoryStream<Path> ds;
    private Iterator<Path> fileList;

    public DirectoryHandle(SftpSubsystem subsystem, Path dir, String handle2) throws IOException {
        super(subsystem, dir, handle2);
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        this.signalHandleOpening();
        this.ds = accessor.openDirectory(subsystem, this, dir, handle2, new LinkOption[0]);
        Path parent = dir.getParent();
        if (parent == null) {
            this.sendDotDot = false;
        }
        this.fileList = this.ds.iterator();
        try {
            this.signalHandleOpen();
        }
        catch (IOException e2) {
            this.close();
            throw e2;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void markDone() {
        this.done = true;
        this.fileList = null;
    }

    public boolean isSendDot() {
        return this.sendDot;
    }

    public void markDotSent() {
        this.sendDot = false;
    }

    public boolean isSendDotDot() {
        return this.sendDotDot;
    }

    public void markDotDotSent() {
        this.sendDotDot = false;
    }

    @Override
    public boolean hasNext() {
        return this.fileList.hasNext();
    }

    @Override
    public Path next() {
        return this.fileList.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not allowed to remove " + this.toString());
    }

    @Override
    public void close() throws IOException {
        try {
            SftpSubsystem subsystem = this.getSubsystem();
            SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
            accessor.closeDirectory(subsystem, this, this.getFile(), this.getFileHandle(), this.ds);
        }
        finally {
            super.close();
            this.markDone();
        }
    }
}

