/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import org.apache.sshd.sftp.server.SftpSubsystem;

public class FileHandle
extends Handle {
    private final int access;
    private final SeekableByteChannel fileChannel;
    private final List<FileLock> locks = new ArrayList<FileLock>();
    private final Set<StandardOpenOption> openOptions;
    private final Collection<FileAttribute<?>> fileAttributes;

    public FileHandle(SftpSubsystem subsystem, Path file2, String handle2, int flags, int access, Map<String, Object> attrs) throws IOException {
        super(subsystem, file2, handle2);
        SeekableByteChannel channel2;
        Set<StandardOpenOption> options2 = FileHandle.getOpenOptions(flags, access);
        if (!options2.contains(StandardOpenOption.WRITE) && !options2.contains(StandardOpenOption.APPEND)) {
            options2.add(StandardOpenOption.READ);
        }
        int desiredAccess = access & 0xFFFFFFFB;
        if (options2.contains(StandardOpenOption.APPEND)) {
            desiredAccess |= 0x106;
            options2.add(StandardOpenOption.WRITE);
            options2.remove(StandardOpenOption.APPEND);
        }
        this.access = desiredAccess;
        this.openOptions = Collections.unmodifiableSet(options2);
        this.fileAttributes = Collections.unmodifiableCollection(FileHandle.toFileAttributes(attrs));
        this.signalHandleOpening();
        FileAttribute<?>[] fileAttrs = GenericUtils.isEmpty(this.fileAttributes) ? IoUtils.EMPTY_FILE_ATTRIBUTES : this.fileAttributes.toArray(new FileAttribute[this.fileAttributes.size()]);
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        try {
            channel2 = accessor.openFile(subsystem, this, file2, handle2, this.openOptions, fileAttrs);
        }
        catch (UnsupportedOperationException e2) {
            channel2 = accessor.openFile(subsystem, this, file2, handle2, this.openOptions, IoUtils.EMPTY_FILE_ATTRIBUTES);
            subsystem.doSetAttributes(3, "", file2, attrs, false);
        }
        this.fileChannel = channel2;
        try {
            this.signalHandleOpen();
        }
        catch (IOException e3) {
            this.close();
            throw e3;
        }
    }

    public final Set<StandardOpenOption> getOpenOptions() {
        return this.openOptions;
    }

    public final Collection<FileAttribute<?>> getFileAttributes() {
        return this.fileAttributes;
    }

    public SeekableByteChannel getFileChannel() {
        return this.fileChannel;
    }

    public int getAccessMask() {
        return this.access;
    }

    public boolean isOpenAppend() {
        return (this.getAccessMask() & 4) != 0;
    }

    public int read(byte[] data2, long offset) throws IOException {
        return this.read(data2, 0, data2.length, offset, null);
    }

    public int read(byte[] data2, int doff, int length, long offset) throws IOException {
        return this.read(data2, doff, length, offset, null);
    }

    public int read(byte[] data2, int doff, int length, long offset, AtomicReference<Boolean> eof) throws IOException {
        SeekableByteChannel channel2 = this.getFileChannel();
        int l = (channel2 = channel2.position(offset)).read(ByteBuffer.wrap(data2, doff, length));
        if (l > 0 && eof != null && l < length) {
            eof.set(channel2.position() >= channel2.size());
        }
        return l;
    }

    public void append(byte[] data2) throws IOException {
        this.append(data2, 0, data2.length);
    }

    public void append(byte[] data2, int doff, int length) throws IOException {
        SeekableByteChannel channel2 = this.getFileChannel();
        this.write(data2, doff, length, channel2.size());
    }

    public void write(byte[] data2, long offset) throws IOException {
        this.write(data2, 0, data2.length, offset);
    }

    public void write(byte[] data2, int doff, int length, long offset) throws IOException {
        SeekableByteChannel channel2 = this.getFileChannel();
        channel2 = channel2.position(offset);
        channel2.write(ByteBuffer.wrap(data2, doff, length));
    }

    @Override
    public void close() throws IOException {
        super.close();
        SftpSubsystem subsystem = this.getSubsystem();
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        accessor.closeFile(subsystem, this, this.getFile(), this.getFileHandle(), this.getFileChannel(), this.getOpenOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(long offset, long length, int mask) throws IOException {
        boolean writeLock;
        boolean bl = writeLock = (mask & 0x180) != 0;
        if (!writeLock) {
            boolean readLock;
            boolean bl2 = readLock = (mask & 0x40) != 0;
            if (!readLock && this.canWrite()) {
                writeLock = true;
            }
        }
        if (writeLock && !this.canWrite()) {
            throw new SftpException(26, "Write lock requested, but handle opened for reading only");
        }
        if (!writeLock && !this.canRead()) {
            throw new SftpException(26, "Read lock requested, but handle opened for writing only");
        }
        SeekableByteChannel channel2 = this.getFileChannel();
        long size2 = length == 0L ? channel2.size() - offset : length;
        SftpSubsystem subsystem = this.getSubsystem();
        SftpFileSystemAccessor accessor = subsystem.getFileSystemAccessor();
        FileLock lock = null;
        try {
            lock = accessor.tryLock(subsystem, this, this.getFile(), this.getFileHandle(), channel2, offset, size2, !writeLock);
        }
        catch (NonReadableChannelException | NonWritableChannelException e2) {
            SftpException error2 = new SftpException(26, "Could not acquire channel lock; write=" + writeLock + ": " + e2.toString());
            error2.initCause(e2);
            throw error2;
        }
        if (lock == null) {
            throw new SftpException(25, "Overlapping lock held by another program on range [" + offset + "-" + (offset + length) + "]");
        }
        List<FileLock> list = this.locks;
        synchronized (list) {
            this.locks.add(lock);
        }
    }

    private boolean canRead() {
        return this.getOpenOptions().contains(StandardOpenOption.READ);
    }

    private boolean canWrite() {
        Set<StandardOpenOption> options2 = this.getOpenOptions();
        return options2.contains(StandardOpenOption.WRITE) || options2.contains(StandardOpenOption.APPEND);
    }

    public void unlock(long offset, long length) throws IOException {
        SeekableByteChannel channel2 = this.getFileChannel();
        long size2 = length == 0L ? channel2.size() - offset : length;
        FileLock lock = null;
        Iterator<FileLock> iterator2 = this.locks.iterator();
        while (iterator2.hasNext()) {
            FileLock l = iterator2.next();
            if (l.position() != offset || l.size() != size2) continue;
            iterator2.remove();
            lock = l;
            break;
        }
        if (lock == null) {
            throw new SftpException(31, "No matching lock found on range [" + offset + "-" + (offset + length));
        }
        lock.release();
    }

    public static Collection<FileAttribute<?>> toFileAttributes(Map<String, ?> attrs) {
        if (MapEntryUtils.isEmpty(attrs)) {
            return Collections.emptyList();
        }
        LinkedList attributes2 = null;
        for (Map.Entry<String, ?> attr : attrs.entrySet()) {
            FileAttribute<?> fileAttr = FileHandle.toFileAttribute(attr.getKey(), attr.getValue());
            if (fileAttr == null) continue;
            if (attributes2 == null) {
                attributes2 = new LinkedList();
            }
            attributes2.add(fileAttr);
        }
        return attributes2 == null ? Collections.emptyList() : attributes2;
    }

    public static FileAttribute<?> toFileAttribute(final String key2, final Object val) {
        if ("isOther".equals(key2)) {
            if (((Boolean)val).booleanValue()) {
                throw new IllegalArgumentException("Not allowed to use " + key2 + "=" + val);
            }
            return null;
        }
        if ("isRegularFile".equals(key2)) {
            if (!((Boolean)val).booleanValue()) {
                throw new IllegalArgumentException("Not allowed to use " + key2 + "=" + val);
            }
            return null;
        }
        return new FileAttribute<Object>(){
            private final String s;
            {
                this.s = key2 + "=" + val;
            }

            @Override
            public String name() {
                return key2;
            }

            @Override
            public Object value() {
                return val;
            }

            public String toString() {
                return this.s;
            }
        };
    }

    public static Set<StandardOpenOption> getOpenOptions(int flags, int access) {
        EnumSet<StandardOpenOption> options2 = EnumSet.noneOf(StandardOpenOption.class);
        if ((access & 0x81) != 0) {
            options2.add(StandardOpenOption.READ);
        }
        if ((access & 0x102) != 0) {
            options2.add(StandardOpenOption.WRITE);
        }
        int accessDisposition = flags & 7;
        switch (accessDisposition) {
            case 0: {
                options2.add(StandardOpenOption.CREATE_NEW);
                break;
            }
            case 1: {
                options2.add(StandardOpenOption.CREATE);
                options2.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                options2.add(StandardOpenOption.CREATE);
                break;
            }
            case 4: {
                options2.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
        }
        if ((flags & 0x18) != 0) {
            options2.add(StandardOpenOption.APPEND);
        }
        return options2;
    }
}

