/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpSubsystem;

public abstract class Handle
implements Channel,
AttributeStore {
    private final SftpSubsystem sftpSubsystem;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Path file;
    private final String handle;
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();

    protected Handle(SftpSubsystem subsystem, Path file2, String handle2) {
        this.sftpSubsystem = Objects.requireNonNull(subsystem, "No subsystem instance provided");
        this.file = Objects.requireNonNull(file2, "No local file path");
        this.handle = ValidateUtils.checkNotNull(handle2, "No assigned handle for %s", (Object)file2);
    }

    protected SftpSubsystem getSubsystem() {
        return this.sftpSubsystem;
    }

    protected void signalHandleOpening() throws IOException {
        SftpSubsystem subsystem = this.getSubsystem();
        SftpEventListener listener = subsystem.getSftpEventListenerProxy();
        ServerSession session2 = subsystem.getServerSession();
        listener.opening(session2, this.handle, this);
    }

    protected void signalHandleOpen() throws IOException {
        SftpSubsystem subsystem = this.getSubsystem();
        SftpEventListener listener = subsystem.getSftpEventListenerProxy();
        ServerSession session2 = subsystem.getServerSession();
        listener.open(session2, this.handle, this);
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileHandle() {
        return this.handle;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key2) {
        return (T)this.attributes.get(Objects.requireNonNull(key2, "No key"));
    }

    @Override
    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key2, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key2, "No key"), resolver);
    }

    @Override
    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key2, T value2) {
        return (T)this.attributes.put(Objects.requireNonNull(key2, "No key"), Objects.requireNonNull(value2, "No value"));
    }

    @Override
    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key2) {
        return (T)this.attributes.remove(Objects.requireNonNull(key2, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            return;
        }
    }

    public String toString() {
        return Objects.toString(this.getFile());
    }

    protected static String safe(String handle2) {
        if (handle2 == null) {
            return "null";
        }
        return BufferUtils.toHex('\u0000', handle2.getBytes(StandardCharsets.ISO_8859_1));
    }
}

