/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.UnknownServiceException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.BufferedIoOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.ChannelSessionAware;
import org.apache.sshd.server.command.AsyncCommand;
import org.apache.sshd.server.command.AsyncCommandErrorStreamAware;
import org.apache.sshd.server.command.CommandDirectErrorStreamAware;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.WithFileAttributeCache;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.SftpHelper;
import org.apache.sshd.sftp.server.AbstractSftpSubsystemHelper;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.Handle;
import org.apache.sshd.sftp.server.SftpErrorStatusDataHandler;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import org.apache.sshd.sftp.server.SftpSubsystemConfigurator;

public class SftpSubsystem
extends AbstractSftpSubsystemHelper
implements Runnable,
FileSystemAware,
ExecutorServiceCarrier,
AsyncCommand,
ChannelDataReceiver {
    protected static final Buffer CLOSE = new ByteArrayBuffer(null, 0, 0);
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicLong requestsCount = new AtomicLong(0L);
    protected final Map<String, byte[]> extensions = new TreeMap(Comparator.naturalOrder());
    protected final Map<String, Handle> handles = new ConcurrentHashMap<String, Handle>();
    protected final Buffer buffer = new ByteArrayBuffer(1024);
    protected final BlockingQueue<Buffer> requests = new LinkedBlockingQueue<Buffer>();
    protected ExitCallback callback;
    protected IoOutputStream out;
    protected Environment env;
    protected Random randomizer;
    protected int maxHandleCount = 0x7FFFFFFE;
    protected Deque<String> unusedHandles;
    protected int fileHandleSize = 4;
    protected int maxFileHandleRounds = 4;
    protected Future<?> pendingFuture;
    protected byte[] workBuf = new byte[Math.max(4, 4)];
    protected FileSystem fileSystem = FileSystems.getDefault();
    protected Path defaultDir = this.fileSystem.getPath("", new String[0]).toAbsolutePath().normalize();
    protected int version;
    protected CloseableExecutorService executorService;
    private final ServerSession serverSession;

    public SftpSubsystem(ChannelSession channel2, SftpSubsystemConfigurator configurator) {
        super(channel2, configurator);
        CloseableExecutorService executorService = configurator.getExecutorService();
        this.executorService = executorService == null ? ThreadUtils.newSingleThreadExecutor(this.getClass().getSimpleName() + "-" + Math.abs(System.nanoTime() & 0xFFFFL)) : executorService;
        this.serverSession = Objects.requireNonNull(channel2.getServerSession(), "No session associated with the channel");
        this.initializeSessionRelatedMember(this.serverSession, channel2);
        ChannelDataReceiver errorDataChannelReceiver = this.resolveErrorDataChannelReceiver(channel2, configurator.getErrorChannelDataReceiver());
        channel2.setDataReceiver(this);
        channel2.setExtendedDataWriter(errorDataChannelReceiver);
        SftpErrorStatusDataHandler errHandler = this.getErrorStatusDataHandler();
        if (errHandler instanceof ChannelSessionAware) {
            ((ChannelSessionAware)((Object)errHandler)).setChannelSession(channel2);
        }
    }

    protected ChannelDataReceiver resolveErrorDataChannelReceiver(ChannelSession channelSession, ChannelDataReceiver receiver2) {
        return receiver2 != null ? receiver2 : new ChannelDataReceiver(){

            @Override
            public void close() throws IOException {
                if (SftpSubsystem.this.log.isDebugEnabled()) {
                    SftpSubsystem.this.log.debug("stderrData({}) closing", (Object)SftpSubsystem.this.getSession());
                }
            }

            @Override
            public int data(ChannelSession channel2, byte[] buf, int start2, int len2) throws IOException {
                if (SftpSubsystem.this.log.isDebugEnabled()) {
                    SftpSubsystem.this.log.debug("stderrData({}) received {} data bytes", (Object)channel2, (Object)len2);
                }
                return len2;
            }
        };
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Path getDefaultDirectory() {
        return this.defaultDir;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.executorService;
    }

    protected void initializeSessionRelatedMember(ServerSession session2, ChannelSession channel2) {
        ServerFactoryManager manager = session2.getFactoryManager();
        Factory<? extends Random> factory2 = manager.getRandomFactory();
        this.randomizer = factory2.create();
        this.maxHandleCount = SftpModuleProperties.MAX_OPEN_HANDLES_PER_SESSION.getRequired(session2);
        this.fileHandleSize = SftpModuleProperties.FILE_HANDLE_SIZE.getRequired(channel2);
        this.maxFileHandleRounds = SftpModuleProperties.MAX_FILE_HANDLE_RAND_ROUNDS.getRequired(channel2);
        if (this.fileHandleSize > 4) {
            AbstractChannel.PacketValidator validator = (packetSize, maximumPacketSize, extendedData) -> {
                if (AbstractChannel.DEFAULT_PACKET_VALIDATOR.isValid(packetSize, maximumPacketSize, extendedData)) {
                    return true;
                }
                return !extendedData && packetSize == maximumPacketSize + (long)this.fileHandleSize - 4L;
            };
            channel2.setPacketValidator(validator);
        } else {
            this.unusedHandles = new LinkedList<String>();
        }
        if (this.workBuf.length < this.fileHandleSize) {
            this.workBuf = new byte[this.fileHandleSize];
        }
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        if (fileSystem != this.fileSystem) {
            this.fileSystem = fileSystem;
            this.defaultDir = fileSystem.getPath("", new String[0]).toAbsolutePath().normalize();
        }
    }

    @Override
    public void setExitCallback(ExitCallback callback2) {
        this.callback = callback2;
    }

    @Override
    public void setInputStream(InputStream in) {
    }

    @Override
    public void setOutputStream(OutputStream out2) {
    }

    @Override
    public void setErrorStream(OutputStream err) {
        SftpErrorStatusDataHandler errHandler = this.getErrorStatusDataHandler();
        if (errHandler instanceof CommandDirectErrorStreamAware) {
            ((CommandDirectErrorStreamAware)((Object)errHandler)).setErrorStream(err);
        }
    }

    @Override
    public void setIoInputStream(IoInputStream in) {
    }

    @Override
    public void setIoOutputStream(IoOutputStream out2) {
        ChannelSession channel2 = this.getServerChannelSession();
        long channelId = channel2.getChannelId();
        this.out = new BufferedIoOutputStream("sftp-out@" + channelId, channelId, out2, channel2);
    }

    @Override
    public void setIoErrorStream(IoOutputStream err) {
        SftpErrorStatusDataHandler errHandler = this.getErrorStatusDataHandler();
        if (errHandler instanceof AsyncCommandErrorStreamAware) {
            ((AsyncCommandErrorStreamAware)((Object)errHandler)).setIoErrorStream(err);
        }
    }

    @Override
    public void start(ChannelSession channel2, Environment env) throws IOException {
        this.env = env;
        try {
            CloseableExecutorService executor = this.getExecutorService();
            this.pendingFuture = executor.submit(this);
        }
        catch (RuntimeException e2) {
            this.log.error("Failed (" + e2.getClass().getSimpleName() + ") to start command: " + e2.getMessage(), e2);
            throw new IOException(e2);
        }
    }

    @Override
    public int data(ChannelSession channel2, byte[] buf, int start2, int len2) throws IOException {
        this.buffer.compact();
        this.buffer.putRawBytes(buf, start2, len2);
        while (this.buffer.available() >= 4) {
            int rpos = this.buffer.rpos();
            int msglen = this.buffer.getInt();
            if (this.buffer.available() >= msglen) {
                ByteArrayBuffer b2 = new ByteArrayBuffer(msglen + 4 + 64, false);
                ((Buffer)b2).putUInt(msglen);
                ((Buffer)b2).putRawBytes(this.buffer.array(), this.buffer.rpos(), msglen);
                this.requests.add(b2);
                this.buffer.rpos(rpos + msglen + 4);
                continue;
            }
            this.buffer.rpos(rpos);
            break;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int exitCode = 0;
        long buffersCount = 0L;
        try {
            Buffer buffer;
            ChannelSession channel2 = this.getServerChannelSession();
            LocalWindow localWindow = channel2.getLocalWindow();
            while ((buffer = this.requests.take()) != CLOSE) {
                int len2 = buffer.available();
                ++buffersCount;
                this.process(buffer);
                localWindow.release(len2);
            }
            this.closeAllHandles();
            this.callback.onExit(exitCode, exitCode != 0);
        }
        catch (Throwable t2) {
            try {
                if (!this.closed.get()) {
                    ServerSession session2 = this.getServerSession();
                    this.error("run({}) {} caught in SFTP subsystem after {} buffers: {}", session2, t2.getClass().getSimpleName(), buffersCount, t2.getMessage(), t2);
                    exitCode = -1;
                }
                this.closeAllHandles();
                this.callback.onExit(exitCode, exitCode != 0);
            }
            catch (Throwable throwable) {
                this.closeAllHandles();
                this.callback.onExit(exitCode, exitCode != 0);
                throw throwable;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.requests.clear();
        this.requests.add(CLOSE);
    }

    @Override
    protected void doProcess(Buffer buffer, int length, int type2, int id) throws IOException {
        super.doProcess(buffer, length, type2, id);
        if (type2 != 1) {
            this.requestsCount.incrementAndGet();
        }
    }

    @Override
    protected void createLink(int id, String existingPath, String linkPath, boolean symLink) throws IOException {
        Path link = this.resolveFile(linkPath);
        Path existing = this.fileSystem.getPath(existingPath, new String[0]);
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("createLink({})[id={}], existing={}[{}], link={}[{}], symlink={})", session2, id, linkPath, link, existingPath, existing, symLink);
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.linking(session2, link, existing, symLink);
        try {
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            accessor.createLink(this, link, existing, symLink);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.linked(session2, link, existing, symLink, e2);
            throw e2;
        }
        listener.linked(session2, link, existing, symLink, null);
    }

    @Override
    protected void doTextSeek(int id, String handle2, long line) throws IOException {
        Handle h2 = this.handles.get(handle2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doTextSeek({})[id={}] SSH_FXP_EXTENDED(text-seek) (handle={}[{}], line={})", this.getServerSession(), id, Handle.safe(handle2), h2, line);
        }
        FileHandle fileHandle = this.validateHandle(handle2, h2, FileHandle.class);
        throw new UnknownServiceException("doTextSeek(" + fileHandle + ")");
    }

    @Override
    protected void doOpenSSHFsync(int id, String handle2) throws IOException {
        Handle h2 = this.handles.get(handle2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHFsync({})[id={}] {}[{}]", this.getServerSession(), id, Handle.safe(handle2), h2);
        }
        FileHandle fileHandle = this.validateHandle(handle2, h2, FileHandle.class);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        accessor.syncFileData(this, fileHandle, fileHandle.getFile(), fileHandle.getFileHandle(), fileHandle.getFileChannel());
    }

    @Override
    protected void doCheckFileHash(int id, String targetType, String target, Collection<String> algos, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        String a2;
        Path path2;
        if ("check-file-handle".equalsIgnoreCase(targetType)) {
            Handle h2 = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h2, FileHandle.class);
            path2 = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException(path2.toString(), path2.toString(), "File not opened for read");
            }
        } else {
            path2 = this.resolveFile(target);
            for (int index = 0; Files.isSymbolicLink(path2) && index < 127; ++index) {
                path2 = Files.readSymbolicLink(path2);
            }
            if (Files.isSymbolicLink(path2)) {
                throw new FileSystemLoopException(target);
            }
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, path2, 200, targetType, false);
            if (Files.isDirectory(path2, options2)) {
                throw new NotDirectoryException(path2.toString());
            }
        }
        ValidateUtils.checkNotNullAndNotEmpty(algos, "No hash algorithms specified", new Object[0]);
        BuiltinDigests factory2 = null;
        Iterator<String> iterator2 = algos.iterator();
        while (iterator2.hasNext() && ((factory2 = BuiltinDigests.fromFactoryName(a2 = iterator2.next())) == null || !factory2.isSupported())) {
        }
        ValidateUtils.checkNotNull(factory2, "No matching digest factory found for %s", algos);
        this.doCheckFileHash(id, path2, factory2, startOffset, length, blockSize, buffer);
    }

    @Override
    protected byte[] doMD5Hash(int id, String targetType, String target, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        Path path2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMD5Hash({})({})[{}] offset={}, length={}, quick-hash={}", this.getServerSession(), targetType, target, startOffset, length, BufferUtils.toHex(':', quickCheckHash));
        }
        if ("md5-hash-handle".equalsIgnoreCase(targetType)) {
            Handle h2 = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h2, FileHandle.class);
            path2 = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException(path2.toString(), path2.toString(), "File not opened for read");
            }
        } else {
            SftpFileSystemAccessor accessor;
            LinkOption[] options2;
            path2 = this.resolveFile(target);
            if (Files.isDirectory(path2, options2 = (accessor = this.getFileSystemAccessor()).resolveFileAccessLinkOptions(this, path2, 200, targetType, true))) {
                throw new NotDirectoryException(path2.toString());
            }
        }
        long effectiveLength = length;
        long totalSize = Files.size(path2);
        if (startOffset == 0L && length == 0L) {
            effectiveLength = totalSize;
        } else {
            long maxRead = startOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - startOffset;
            }
        }
        return this.doMD5Hash(id, path2, startOffset, effectiveLength, quickCheckHash);
    }

    @Override
    protected void doVersionSelect(Buffer buffer, int id, String proposed) throws IOException {
        ServerSession session2 = this.getServerSession();
        if (this.requestsCount.get() > 0L) {
            this.sendStatus(this.prepareReply(buffer), id, 4, "Version selection not the 1st request for proposal = " + proposed);
            session2.close(true);
            return;
        }
        Boolean result2 = this.validateProposedVersion(buffer, id, proposed);
        if (result2 == null) {
            session2.close(true);
            return;
        }
        if (result2.booleanValue()) {
            this.version = Integer.parseInt(proposed);
            this.sendStatus(this.prepareReply(buffer), id, 0, "");
        } else {
            this.sendStatus(this.prepareReply(buffer), id, 4, "Unsupported version " + proposed);
            session2.close(true);
        }
    }

    @Override
    protected void doBlock(int id, String handle2, long offset, long length, int mask) throws IOException {
        int vers = this.getVersion();
        if (vers < 6) {
            throw new UnsupportedOperationException("File locks are not supported in sftp v" + vers + ", need SFTPv6");
        }
        Handle p = this.handles.get(handle2);
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doBlock({})[id={}] SSH_FXP_BLOCK (handle={}[{}], offset={}, length={}, mask=0x{})", session2, id, Handle.safe(handle2), p, offset, length, Integer.toHexString(mask));
        }
        FileHandle fileHandle = this.validateHandle(handle2, p, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.blocking(session2, handle2, fileHandle, offset, length, mask);
        try {
            fileHandle.lock(offset, length, mask);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.blocked(session2, handle2, fileHandle, offset, length, mask, e2);
            throw e2;
        }
        listener.blocked(session2, handle2, fileHandle, offset, length, mask, null);
    }

    @Override
    protected void doUnblock(int id, String handle2, long offset, long length) throws IOException {
        int vers = this.getVersion();
        if (vers < 6) {
            throw new UnsupportedOperationException("File locks are not supported in sftp v" + vers + ", need SFTPv6");
        }
        Handle p = this.handles.get(handle2);
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doUnblock({})[id={}] SSH_FXP_UNBLOCK (handle={}[{}], offset={}, length={})", session2, id, Handle.safe(handle2), p, offset, length);
        }
        FileHandle fileHandle = this.validateHandle(handle2, p, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.unblocking(session2, handle2, fileHandle, offset, length);
        try {
            fileHandle.unlock(offset, length);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.unblocked(session2, handle2, fileHandle, offset, length, e2);
            throw e2;
        }
        listener.unblocked(session2, handle2, fileHandle, offset, length, null);
    }

    @Override
    protected void doCopyData(int id, String readHandle, long readOffset, long readLength, String writeHandle, long writeOffset) throws IOException {
        Handle wh;
        boolean inPlaceCopy = readHandle.equals(writeHandle);
        Handle rh = this.handles.get(readHandle);
        Handle handle2 = wh = inPlaceCopy ? rh : this.handles.get(writeHandle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doCopyData({})[id={}] SSH_FXP_EXTENDED[{}] read={}[{}], read-offset={}, read-length={}, write={}[{}], write-offset={})", this.getServerSession(), id, "copy-data", Handle.safe(readHandle), rh, readOffset, readLength, Handle.safe(writeHandle), wh, writeOffset);
        }
        FileHandle srcHandle = this.validateHandle(readHandle, rh, FileHandle.class);
        Path srcPath = srcHandle.getFile();
        int srcAccess = srcHandle.getAccessMask();
        if ((srcAccess & 1) != 1) {
            throw new AccessDeniedException(srcPath.toString(), srcPath.toString(), "Source file not opened for read");
        }
        ValidateUtils.checkTrue(readLength >= 0L, "Invalid read length: %d", readLength);
        ValidateUtils.checkTrue(readOffset >= 0L, "Invalid read offset: %d", readOffset);
        long totalSize = Files.size(srcHandle.getFile());
        long effectiveLength = readLength;
        if (effectiveLength == 0L) {
            effectiveLength = totalSize - readOffset;
        } else {
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - readOffset;
            }
        }
        ValidateUtils.checkTrue(effectiveLength > 0L, "Non-positive effective copy data length: %d", effectiveLength);
        FileHandle dstHandle = inPlaceCopy ? srcHandle : this.validateHandle(writeHandle, wh, FileHandle.class);
        int dstAccess = dstHandle.getAccessMask();
        if ((dstAccess & 2) != 2) {
            throw new AccessDeniedException(srcHandle.toString(), srcHandle.toString(), "Source handle not opened for write");
        }
        ValidateUtils.checkTrue(writeOffset >= 0L, "Invalid write offset: %d", writeOffset);
        if (inPlaceCopy) {
            long maxWrite;
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                maxRead = totalSize;
            }
            if ((maxWrite = writeOffset + effectiveLength) > readOffset) {
                throw new IllegalArgumentException("Write range end [" + writeOffset + "-" + maxWrite + "] overlaps with read range [" + readOffset + "-" + maxRead + "]");
            }
            if (maxRead > writeOffset) {
                throw new IllegalArgumentException("Read range end [" + readOffset + "-" + maxRead + "] overlaps with write range [" + writeOffset + "-" + maxWrite + "]");
            }
        }
        byte[] copyBuf = new byte[Math.min(8192, (int)effectiveLength)];
        while (effectiveLength > 0L) {
            int remainLength = Math.min(copyBuf.length, (int)effectiveLength);
            int readLen = srcHandle.read(copyBuf, 0, remainLength, readOffset);
            if (readLen < 0) {
                throw new EOFException("Premature EOF while still remaining " + effectiveLength + " bytes");
            }
            dstHandle.write(copyBuf, 0, readLen, writeOffset);
            effectiveLength -= (long)readLen;
            readOffset += (long)readLen;
            writeOffset += (long)readLen;
        }
    }

    @Override
    protected void doReadDir(Buffer buffer, int id) throws IOException {
        String handle2 = buffer.getString(StandardCharsets.ISO_8859_1);
        Handle h2 = this.handles.get(handle2);
        ServerSession session2 = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("doReadDir({})[id={}] SSH_FXP_READDIR (handle={}[{}])", session2, id, Handle.safe(handle2), h2);
        }
        Buffer reply = null;
        try {
            DirectoryHandle dh = this.validateHandle(handle2, h2, DirectoryHandle.class);
            if (dh.isDone()) {
                this.sendStatus(this.prepareReply(buffer), id, 1, "Directory reading is done");
                return;
            }
            Path file2 = dh.getFile();
            if (!(file2 instanceof SftpPath)) {
                LinkOption[] options2 = this.getPathResolutionLinkOption(12, "", file2);
                Boolean status2 = IoUtils.checkFileExistsAnySymlinks(file2, !IoUtils.followLinks(options2));
                if (status2 == null) {
                    throw new AccessDeniedException(file2.toString(), file2.toString(), "Cannot determine existence of read-dir");
                }
                if (!status2.booleanValue()) {
                    throw new NoSuchFileException(file2.toString(), file2.toString(), "Non-existent directory");
                }
                if (!Files.isDirectory(file2, options2)) {
                    throw new NotDirectoryException(file2.toString());
                }
                if (!Files.isReadable(file2)) {
                    throw new AccessDeniedException(file2.toString(), file2.toString(), "Not readable");
                }
            }
            SftpEventListener listener = this.getSftpEventListenerProxy();
            listener.readingEntries(session2, handle2, dh);
            if (dh.isSendDot() || dh.isSendDotDot() || dh.hasNext()) {
                reply = this.prepareReply(buffer);
                reply.putByte((byte)104);
                reply.putInt(id);
                int lenPos = reply.wpos();
                reply.putUInt(0L);
                int maxDataSize = SftpModuleProperties.MAX_READDIR_DATA_SIZE.getRequired(session2);
                int count2 = this.doReadDir(id, handle2, dh, reply, maxDataSize, false);
                BufferUtils.updateLengthPlaceholder(reply, lenPos, count2);
                if (!(dh.isSendDot() || dh.isSendDotDot() || dh.hasNext())) {
                    dh.markDone();
                }
                int sftpVersion = this.getVersion();
                Boolean indicator = SftpHelper.indicateEndOfNamesList(reply, sftpVersion, session2, dh.isDone());
                if (debugEnabled) {
                    this.log.debug("doReadDir({})({})[{}] - sending {} entries - eol={} (SFTP version {})", session2, Handle.safe(handle2), h2, count2, indicator, sftpVersion);
                }
            } else {
                dh.markDone();
                this.sendStatus(this.prepareReply(buffer), id, 1, "Empty directory");
                return;
            }
            Objects.requireNonNull(reply, "No reply buffer created");
        }
        catch (IOException | Error | RuntimeException e2) {
            this.sendStatus(this.prepareReply(buffer), id, e2, 12, Handle.safe(handle2));
            return;
        }
        this.send(reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doOpenDir(int id, String path2, Path dir, LinkOption ... options2) throws IOException {
        String handle2;
        WithFileAttributeCache.withAttributeCache(dir, p -> {
            Boolean status2 = IoUtils.checkFileExistsAnySymlinks(p, !IoUtils.followLinks(options2));
            if (status2 == null) {
                throw this.signalOpenFailure(id, path2, (Path)p, true, new AccessDeniedException(p.toString(), p.toString(), "Cannot determine open-dir existence"));
            }
            if (!status2.booleanValue()) {
                throw this.signalOpenFailure(id, path2, (Path)p, true, new NoSuchFileException(path2, path2, "Referenced target directory N/A"));
            }
            if (!Files.isDirectory(p, options2)) {
                throw this.signalOpenFailure(id, path2, (Path)p, true, new NotDirectoryException(path2));
            }
            if (!Files.isReadable(p)) {
                throw this.signalOpenFailure(id, path2, (Path)p, true, new AccessDeniedException(p.toString(), p.toString(), "Not readable"));
            }
            return null;
        });
        try {
            Map<String, Handle> map2 = this.handles;
            synchronized (map2) {
                handle2 = this.generateFileHandle(dir);
                DirectoryHandle dirHandle = new DirectoryHandle(this, dir, handle2);
                this.handles.put(handle2, dirHandle);
            }
        }
        catch (IOException e2) {
            throw this.signalOpenFailure(id, path2, dir, true, e2);
        }
        return handle2;
    }

    @Override
    protected void doFSetStat(int id, String handle2, Map<String, ?> attrs) throws IOException {
        Handle h2 = this.handles.get(handle2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doFsetStat({})[id={}] SSH_FXP_FSETSTAT (handle={}[{}], attrs={})", this.getServerSession(), id, Handle.safe(handle2), h2, attrs);
        }
        Handle fileHandle = this.validateHandle(handle2, h2, Handle.class);
        Path path2 = fileHandle.getFile();
        boolean followLinks = this.resolvePathResolutionFollowLinks(10, "", path2);
        this.doSetAttributes(10, "", path2, attrs, followLinks);
    }

    @Override
    protected Map<String, Object> doFStat(int id, String handle2, int flags) throws IOException {
        Handle h2 = this.handles.get(handle2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doFStat({})[id={}] SSH_FXP_FSTAT (handle={}[{}], flags=0x{})", this.getServerSession(), id, Handle.safe(handle2), h2, Integer.toHexString(flags));
        }
        Handle fileHandle = this.validateHandle(handle2, h2, Handle.class);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        Path file2 = fileHandle.getFile();
        LinkOption[] options2 = accessor.resolveFileAccessLinkOptions(this, file2, 8, "", true);
        boolean followLinks = this.resolvePathResolutionFollowLinks(8, handle2, file2);
        return this.resolveFileAttributes(file2, flags, followLinks, options2);
    }

    @Override
    protected void doWrite(int id, String handle2, long offset, int length, byte[] data2, int doff, int remaining) throws IOException {
        Handle h2 = this.handles.get(handle2);
        ServerSession session2 = this.getServerSession();
        int maxAllowed = SftpModuleProperties.MAX_WRITEDATA_PACKET_LENGTH.getRequired(session2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doWrite({})[id={}] SSH_FXP_WRITE (handle={}[{}], offset={}, length={}, maxAllowed={})", session2, id, Handle.safe(handle2), h2, offset, length, maxAllowed);
        }
        FileHandle fh = this.validateHandle(handle2, h2, FileHandle.class);
        if (length < 0) {
            throw new IllegalStateException("Bad length (" + length + ") for writing to " + fh);
        }
        if (remaining < length) {
            throw new IllegalStateException("Not enough buffer data for writing to " + fh + ": required=" + length + ", available=" + remaining);
        }
        if (length > maxAllowed) {
            throw new IOException("Reuested write size (" + length + ") exceeds max. allowed (" + maxAllowed + ")");
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.writing(session2, handle2, fh, offset, data2, doff, length);
        try {
            if (fh.isOpenAppend()) {
                fh.append(data2, doff, length);
            } else {
                fh.write(data2, doff, length, offset);
            }
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.written(session2, handle2, fh, offset, data2, doff, length, e2);
            throw e2;
        }
        listener.written(session2, handle2, fh, offset, data2, doff, length, null);
    }

    @Override
    protected int doRead(int id, String handle2, long offset, int length, byte[] data2, int doff, AtomicReference<Boolean> eof) throws IOException {
        int readLen;
        Handle h2 = this.handles.get(handle2);
        ServerSession session2 = this.getServerSession();
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[id={}] SSH_FXP_READ (handle={}[{}], offset={}, length={})", session2, id, Handle.safe(handle2), h2, offset, length);
        }
        ValidateUtils.checkTrue((long)length > 0L, "Invalid read length: %d", length);
        FileHandle fh = this.validateHandle(handle2, h2, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.reading(session2, handle2, fh, offset, data2, doff, length);
        try {
            readLen = fh.read(data2, doff, length, offset, eof);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.read(session2, handle2, fh, offset, data2, doff, length, -1, e2);
            throw e2;
        }
        listener.read(session2, handle2, fh, offset, data2, doff, length, readLen, null);
        return readLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose(int id, String handle2) throws IOException {
        Handle h2;
        Map<String, Handle> map2 = this.handles;
        synchronized (map2) {
            h2 = this.handles.remove(handle2);
            if (this.fileHandleSize == 4) {
                if (this.handles.isEmpty()) {
                    this.unusedHandles.clear();
                } else if (h2 != null && handle2 != null) {
                    this.unusedHandles.push(handle2);
                }
            }
        }
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doClose({})[id={}] SSH_FXP_CLOSE (handle={}[{}])", session2, id, Handle.safe(handle2), h2);
        }
        Handle nodeHandle = this.validateHandle(handle2, h2, Handle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        try {
            listener.closing(session2, handle2, nodeHandle);
            nodeHandle.close();
            listener.closed(session2, handle2, nodeHandle, null);
        }
        catch (IOException | Error | RuntimeException e2) {
            listener.closed(session2, handle2, nodeHandle, e2);
            throw e2;
        }
        finally {
            nodeHandle.clearAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doOpen(int id, String path2, int pflags, int access, Map<String, Object> attrs) throws IOException {
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({})[id={}] SSH_FXP_OPEN (path={}, access=0x{}, pflags=0x{}, attrs={})", session2, id, path2, Integer.toHexString(access), Integer.toHexString(pflags), attrs);
        }
        Path file2 = this.resolveFile(path2);
        try {
            Map<String, Handle> map2 = this.handles;
            synchronized (map2) {
                String handle2 = this.generateFileHandle(file2);
                FileHandle fileHandle = new FileHandle(this, file2, handle2, pflags, access, attrs);
                this.handles.put(handle2, fileHandle);
                return handle2;
            }
        }
        catch (IOException e2) {
            throw this.signalOpenFailure(id, path2, file2, false, e2);
        }
    }

    protected String generateFileHandle(Path file2) throws IOException {
        int curHandleCount = this.handles.size();
        if (curHandleCount >= this.maxHandleCount) {
            throw new SftpException(14, "Too many open handles: current=" + curHandleCount + ", max.=" + this.maxHandleCount);
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        if (this.fileHandleSize == 4) {
            String handle2 = this.unusedHandles.poll();
            if (handle2 == null) {
                Arrays.fill(this.workBuf, (byte)0);
                BufferUtils.putUInt(curHandleCount, this.workBuf);
                handle2 = new String(this.workBuf, 0, 4, StandardCharsets.ISO_8859_1);
            }
            if (traceEnabled) {
                this.log.trace("generateFileHandle({})[{}] {}", this.getServerSession(), file2, Handle.safe(handle2));
            }
            return handle2;
        }
        ServerSession session2 = this.getServerSession();
        for (int index = 0; index < this.maxFileHandleRounds; ++index) {
            this.randomizer.fill(this.workBuf, 0, this.fileHandleSize);
            String handle3 = new String(this.workBuf, 0, this.fileHandleSize, StandardCharsets.ISO_8859_1);
            if (this.handles.containsKey(handle3)) {
                if (!traceEnabled) continue;
                this.log.trace("generateFileHandle({})[{}] handle={} in use at round {}", session2, file2, Handle.safe(handle3), index);
                continue;
            }
            if (traceEnabled) {
                this.log.trace("generateFileHandle({})[{}] {}", session2, file2, Handle.safe(handle3));
            }
            return handle3;
        }
        throw new StreamCorruptedException("Failed to generate a unique file handle for " + file2);
    }

    @Override
    protected void doInit(Buffer buffer, int id) throws IOException {
        Map.Entry<Integer, String> negotiated;
        ServerSession session2 = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doInit({})[id={}] SSH_FXP_INIT (version={})", session2, id, id);
        }
        if ((negotiated = this.checkVersionCompatibility(buffer, id, id, 8)) == null) {
            return;
        }
        this.version = negotiated.getKey();
        while (buffer.available() > 0) {
            String name = buffer.getString();
            byte[] data2 = buffer.getBytes();
            this.extensions.put(name, data2);
        }
        buffer = this.prepareReply(buffer);
        buffer.putByte((byte)2);
        buffer.putUInt(this.version);
        this.appendExtensions(buffer, negotiated.getValue());
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.initialized(session2, this.version);
        this.send(buffer);
    }

    @Override
    protected Buffer prepareReply(Buffer buffer) {
        buffer.clear();
        buffer.putUInt(0L);
        return buffer;
    }

    @Override
    protected void send(Buffer buffer) throws IOException {
        BufferUtils.updateLengthPlaceholder(buffer, 0);
        this.out.writeBuffer(buffer);
    }

    @Override
    public void destroy(ChannelSession channel2) {
        block12: {
            if (this.closed.getAndSet(true)) {
                return;
            }
            ServerSession session2 = this.getServerSession();
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("destroy({}) - mark as closed", (Object)session2);
            }
            try {
                SftpEventListener listener = this.getSftpEventListenerProxy();
                listener.destroying(session2);
            }
            catch (Exception e2) {
                this.warn("destroy({}) Failed ({}) to announce destruction event: {}", session2, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
            if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
                boolean result2 = this.pendingFuture.cancel(true);
                if (debugEnabled) {
                    this.log.debug("destroy({}) - cancel pending future={}", (Object)session2, (Object)result2);
                }
            }
            this.pendingFuture = null;
            CloseableExecutorService executors = this.getExecutorService();
            if (executors != null && !executors.isShutdown()) {
                List<Runnable> runners = executors.shutdownNow();
                if (debugEnabled) {
                    this.log.debug("destroy({}) - shutdown executor service - runners count={}", (Object)session2, (Object)runners.size());
                }
            }
            this.executorService = null;
            try {
                this.fileSystem.close();
            }
            catch (UnsupportedOperationException e3) {
                if (debugEnabled) {
                    this.log.debug("destroy({}) closing the file system is not supported", (Object)session2);
                }
            }
            catch (IOException e4) {
                if (!debugEnabled) break block12;
                this.log.warn("destroy({}) failed to close the file system", (Object)session2, (Object)e4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllHandles() {
        boolean debugEnabled = this.log.isDebugEnabled();
        ServerSession session2 = this.getServerSession();
        SftpEventListener listener = this.getSftpEventListenerProxy();
        for (Map.Entry<String, Handle> fe : this.handles.entrySet()) {
            String id = fe.getKey();
            Handle handle2 = fe.getValue();
            try {
                if (debugEnabled) {
                    this.log.debug("closeAllHandles({}) exiting pending handle {} [{}]", session2, Handle.safe(id), handle2);
                }
                listener.exiting(session2, handle2);
            }
            catch (IOException | RuntimeException e2) {
                this.log.warn("closeAllHandles({}) failed ({}) to inform listener of exit for handle={}[{}]: {}", session2, e2.getClass().getSimpleName(), Handle.safe(id), handle2, e2.getMessage());
            }
            try {
                handle2.close();
                if (!debugEnabled) continue;
                this.log.debug("closeAllHandles({}) closed pending handle {} [{}]", session2, Handle.safe(id), handle2);
            }
            catch (IOException | RuntimeException e3) {
                this.log.warn("closeAllHandles({}) failed ({}) to close handle={}[{}]: {}", session2, e3.getClass().getSimpleName(), Handle.safe(id), handle2, e3.getMessage());
            }
            finally {
                handle2.clearAttributes();
            }
        }
        this.handles.clear();
    }
}

