/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ManagedExecutorServiceSupplier;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.sftp.server.AbstractSftpEventListenerManager;
import org.apache.sshd.sftp.server.SftpErrorStatusDataHandler;
import org.apache.sshd.sftp.server.SftpFileSystemAccessor;
import org.apache.sshd.sftp.server.SftpFileSystemAccessorManager;
import org.apache.sshd.sftp.server.SftpSubsystem;
import org.apache.sshd.sftp.server.SftpSubsystemConfigurator;
import org.apache.sshd.sftp.server.UnsupportedAttributePolicy;

public class SftpSubsystemFactory
extends AbstractSftpEventListenerManager
implements ManagedExecutorServiceSupplier,
SubsystemFactory,
SftpFileSystemAccessorManager,
SftpSubsystemConfigurator {
    public static final String NAME = "sftp";
    public static final UnsupportedAttributePolicy DEFAULT_POLICY = UnsupportedAttributePolicy.Warn;
    private Supplier<? extends CloseableExecutorService> executorsProvider;
    private UnsupportedAttributePolicy policy = DEFAULT_POLICY;
    private SftpFileSystemAccessor fileSystemAccessor = SftpFileSystemAccessor.DEFAULT;
    private SftpErrorStatusDataHandler errorStatusDataHandler = SftpErrorStatusDataHandler.DEFAULT;
    private ChannelDataReceiver errorChannelDataReceiver;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Supplier<? extends CloseableExecutorService> getExecutorServiceProvider() {
        return this.executorsProvider;
    }

    @Override
    public void setExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider2) {
        this.executorsProvider = provider2;
    }

    @Override
    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.policy;
    }

    public void setUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
        this.policy = Objects.requireNonNull(p, "No policy");
    }

    @Override
    public SftpFileSystemAccessor getFileSystemAccessor() {
        return this.fileSystemAccessor;
    }

    @Override
    public void setFileSystemAccessor(SftpFileSystemAccessor accessor) {
        this.fileSystemAccessor = Objects.requireNonNull(accessor, "No accessor");
    }

    @Override
    public SftpErrorStatusDataHandler getErrorStatusDataHandler() {
        return this.errorStatusDataHandler;
    }

    public void setErrorStatusDataHandler(SftpErrorStatusDataHandler handler2) {
        this.errorStatusDataHandler = Objects.requireNonNull(handler2, "No error status data handler provided");
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.resolveExecutorService();
    }

    @Override
    public ChannelDataReceiver getErrorChannelDataReceiver() {
        return this.errorChannelDataReceiver;
    }

    public void setErrorChannelDataReceiver(ChannelDataReceiver errorChannelDataReceiver) {
        this.errorChannelDataReceiver = errorChannelDataReceiver;
    }

    @Override
    public Command createSubsystem(ChannelSession channel2) throws IOException {
        SftpSubsystem subsystem = new SftpSubsystem(channel2, this);
        GenericUtils.forEach(this.getRegisteredListeners(), subsystem::addSftpEventListener);
        return subsystem;
    }

    public static class Builder
    extends AbstractSftpEventListenerManager
    implements ObjectBuilder<SftpSubsystemFactory> {
        private Supplier<? extends CloseableExecutorService> executorsProvider;
        private UnsupportedAttributePolicy policy = DEFAULT_POLICY;
        private SftpFileSystemAccessor fileSystemAccessor = SftpFileSystemAccessor.DEFAULT;
        private SftpErrorStatusDataHandler errorStatusDataHandler = SftpErrorStatusDataHandler.DEFAULT;
        private ChannelDataReceiver errorChannelDataReceiver;

        public Builder withExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider2) {
            this.executorsProvider = provider2;
            return this;
        }

        public Builder withUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
            this.policy = Objects.requireNonNull(p, "No policy");
            return this;
        }

        public Builder withFileSystemAccessor(SftpFileSystemAccessor accessor) {
            this.fileSystemAccessor = Objects.requireNonNull(accessor, "No accessor");
            return this;
        }

        public Builder withSftpErrorStatusDataHandler(SftpErrorStatusDataHandler handler2) {
            this.errorStatusDataHandler = Objects.requireNonNull(handler2, "No error status handler");
            return this;
        }

        public Builder withErrorChannelDataReceiver(ChannelDataReceiver receiver2) {
            this.errorChannelDataReceiver = receiver2;
            return this;
        }

        @Override
        public SftpSubsystemFactory build() {
            SftpSubsystemFactory factory2 = new SftpSubsystemFactory();
            factory2.setExecutorServiceProvider(this.executorsProvider);
            factory2.setUnsupportedAttributePolicy(this.policy);
            factory2.setFileSystemAccessor(this.fileSystemAccessor);
            factory2.setErrorStatusDataHandler(this.errorStatusDataHandler);
            factory2.setErrorChannelDataReceiver(this.errorChannelDataReceiver);
            GenericUtils.forEach(this.getRegisteredListeners(), factory2::addSftpEventListener);
            return factory2;
        }
    }
}

