/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.server;

import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;

public final class UnixDateFormat {
    public static final List<String> MONTHS = Collections.unmodifiableList(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));
    public static final long SIX_MONTHS = 15811200000L;

    private UnixDateFormat() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static String getUnixDate(FileTime time) {
        return UnixDateFormat.getUnixDate(time != null ? time.toMillis() : -1L);
    }

    public static String getUnixDate(long millis) {
        if (millis < 0L) {
            return "------------";
        }
        StringBuilder sb = new StringBuilder(16);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(MONTHS.get(cal.get(2)));
        sb.append(' ');
        int day2 = cal.get(5);
        if (day2 < 10) {
            sb.append(' ');
        }
        sb.append(day2);
        sb.append(' ');
        long nowTime = System.currentTimeMillis();
        if (Math.abs(nowTime - millis) > 15811200000L) {
            int year2 = cal.get(1);
            sb.append(' ');
            sb.append(year2);
        } else {
            int hh = cal.get(11);
            if (hh < 10) {
                sb.append('0');
            }
            sb.append(hh);
            sb.append(':');
            int mm4 = cal.get(12);
            if (mm4 < 10) {
                sb.append('0');
            }
            sb.append(mm4);
        }
        return sb.toString();
    }
}

