/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.HtmlElement;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.ParseStatus;

class HtmlAutoCloseElement
extends HtmlElement {
    protected final char[][] autoCloseRequired;
    protected final char[][] autoCloseLimits;

    HtmlAutoCloseElement(String name, String[] autoCloseElements, String[] autoCloseLimits) {
        super(name);
        Object autoCloseLimitsCharArray;
        if (autoCloseElements == null) {
            throw new IllegalArgumentException("The array of auto-close elements cannot be null");
        }
        char[][] autoCloseElementsCharArray = new char[autoCloseElements.length][];
        for (int i2 = 0; i2 < autoCloseElementsCharArray.length; ++i2) {
            autoCloseElementsCharArray[i2] = autoCloseElements[i2].toCharArray();
        }
        if (autoCloseLimits != null) {
            autoCloseLimitsCharArray = new char[autoCloseLimits.length][];
            for (int i3 = 0; i3 < ((char[][])autoCloseLimitsCharArray).length; ++i3) {
                autoCloseLimitsCharArray[i3] = autoCloseLimits[i3].toCharArray();
            }
        } else {
            autoCloseLimitsCharArray = null;
        }
        this.autoCloseRequired = autoCloseElementsCharArray;
        this.autoCloseLimits = autoCloseLimitsCharArray;
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler2, ParseStatus status2, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoCloseEnabled && !status2.isAutoOpenCloseDone()) {
            status2.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            return;
        }
        handler2.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler2, ParseStatus status2, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoCloseEnabled && !status2.isAutoOpenCloseDone()) {
            status2.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            return;
        }
        handler2.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }
}

