/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.attoparser.HtmlMarkupHandler;
import org.attoparser.IMarkupHandler;
import org.attoparser.IMarkupParser;
import org.attoparser.MarkupEventProcessorHandler;
import org.attoparser.ParseException;
import org.attoparser.ParseStatus;
import org.attoparser.ParsingCDATASectionMarkupUtil;
import org.attoparser.ParsingCommentMarkupUtil;
import org.attoparser.ParsingDocTypeMarkupUtil;
import org.attoparser.ParsingElementMarkupUtil;
import org.attoparser.ParsingLocatorUtil;
import org.attoparser.ParsingMarkupUtil;
import org.attoparser.ParsingProcessingInstructionUtil;
import org.attoparser.ParsingXmlDeclarationMarkupUtil;
import org.attoparser.config.ParseConfiguration;
import org.attoparser.select.ParseSelection;

public final class MarkupParser
implements IMarkupParser {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_POOL_SIZE = 2;
    private final ParseConfiguration configuration;
    private final BufferPool pool;

    public MarkupParser(ParseConfiguration configuration) {
        this(configuration, 2, 4096);
    }

    public MarkupParser(ParseConfiguration configuration, int poolSize, int bufferSize) {
        this.configuration = configuration;
        this.pool = new BufferPool(poolSize, bufferSize);
    }

    @Override
    public void parse(String document, IMarkupHandler handler2) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(new StringReader(document), handler2);
    }

    @Override
    public void parse(char[] document, IMarkupHandler handler2) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(document, 0, document.length, handler2);
    }

    @Override
    public void parse(char[] document, int offset, int len2, IMarkupHandler handler2) throws ParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        if (offset < 0 || len2 < 0) {
            throw new IllegalArgumentException("Neither document offset (" + offset + ") nor document length (" + len2 + ") can be less than zero");
        }
        if (handler2 == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        IMarkupHandler markupHandler = ParseConfiguration.ParsingMode.HTML.equals((Object)this.configuration.getMode()) ? new HtmlMarkupHandler(handler2) : handler2;
        markupHandler = new MarkupEventProcessorHandler(markupHandler);
        markupHandler.setParseConfiguration(this.configuration);
        ParseStatus status2 = new ParseStatus();
        markupHandler.setParseStatus(status2);
        ParseSelection selection = new ParseSelection();
        markupHandler.setParseSelection(selection);
        this.parseDocument(document, offset, len2, markupHandler, status2);
    }

    @Override
    public void parse(Reader reader2, IMarkupHandler handler2) throws ParseException {
        if (reader2 == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (handler2 == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        IMarkupHandler markupHandler = ParseConfiguration.ParsingMode.HTML.equals((Object)this.configuration.getMode()) ? new HtmlMarkupHandler(handler2) : handler2;
        markupHandler = new MarkupEventProcessorHandler(markupHandler);
        markupHandler.setParseConfiguration(this.configuration);
        ParseStatus status2 = new ParseStatus();
        markupHandler.setParseStatus(status2);
        ParseSelection selection = new ParseSelection();
        markupHandler.setParseSelection(selection);
        this.parseDocument(reader2, this.pool.poolBufferSize, markupHandler, status2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseDocument(Reader reader2, int suggestedBufferSize, IMarkupHandler handler2, ParseStatus status2) throws ParseException {
        long parsingStartTimeNanos = System.nanoTime();
        char[] buffer = null;
        try {
            handler2.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            int bufferSize2333332 = suggestedBufferSize;
            buffer = this.pool.allocateBuffer(bufferSize2333332);
            int bufferContentSize = reader2.read(buffer);
            boolean cont = bufferContentSize != -1;
            status2.offset = -1;
            status2.line = 1;
            status2.col = 1;
            status2.inStructure = false;
            status2.parsingDisabled = true;
            status2.parsingDisabledLimitSequence = null;
            status2.autoCloseRequired = null;
            status2.autoCloseLimits = null;
            while (cont) {
                this.parseBuffer(buffer, 0, bufferContentSize, handler2, status2);
                int readOffset = 0;
                int readLen = bufferSize2333332;
                if (status2.offset == 0) {
                    if (bufferContentSize == bufferSize2333332) {
                        char[] newBuffer = null;
                        try {
                            newBuffer = this.pool.allocateBuffer(bufferSize2333332 *= 2);
                            System.arraycopy(buffer, 0, newBuffer, 0, bufferContentSize);
                            this.pool.releaseBuffer(buffer);
                            buffer = newBuffer;
                        }
                        catch (Exception ignored) {
                            this.pool.releaseBuffer(newBuffer);
                        }
                    }
                    readOffset = bufferContentSize;
                    readLen = bufferSize2333332 - readOffset;
                } else if (status2.offset < bufferContentSize) {
                    System.arraycopy(buffer, status2.offset, buffer, 0, bufferContentSize - status2.offset);
                    readOffset = bufferContentSize - status2.offset;
                    readLen = bufferSize2333332 - readOffset;
                    status2.offset = 0;
                    bufferContentSize = readOffset;
                }
                int read2 = reader2.read(buffer, readOffset, readLen);
                if (read2 != -1) {
                    bufferContentSize = readOffset + read2;
                    continue;
                }
                cont = false;
            }
            int lastLine = status2.line;
            int lastCol = status2.col;
            int lastStart = status2.offset;
            int lastLen = bufferContentSize - lastStart;
            if (lastLen > 0) {
                if (status2.inStructure) {
                    throw new ParseException("Incomplete structure: \"" + new String(buffer, lastStart, lastLen) + "\"", status2.line, status2.col);
                }
                handler2.handleText(buffer, lastStart, lastLen, status2.line, status2.col);
                for (int i2 = lastStart; i2 < lastStart + lastLen; ++i2) {
                    char c2 = buffer[i2];
                    if (c2 == '\n') {
                        ++lastLine;
                        lastCol = 1;
                        continue;
                    }
                    ++lastCol;
                }
            }
            long parsingEndTimeNanos = System.nanoTime();
            handler2.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLine, lastCol);
        }
        catch (ParseException e2) {
            try {
                throw e2;
                catch (Exception e3) {
                    throw new ParseException(e3);
                }
            }
            catch (Throwable throwable) {
                this.pool.releaseBuffer(buffer);
                try {
                    reader2.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.pool.releaseBuffer(buffer);
        try {
            reader2.close();
            return;
        }
        catch (Throwable bufferSize2333332) {
            return;
        }
    }

    void parseDocument(char[] buffer, int offset, int len2, IMarkupHandler handler2, ParseStatus status2) throws ParseException {
        long parsingStartTimeNanos = System.nanoTime();
        try {
            handler2.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            status2.offset = -1;
            status2.line = 1;
            status2.col = 1;
            status2.inStructure = false;
            status2.parsingDisabled = true;
            status2.parsingDisabledLimitSequence = null;
            status2.autoCloseRequired = null;
            status2.autoCloseLimits = null;
            this.parseBuffer(buffer, offset, len2, handler2, status2);
            int lastLine = status2.line;
            int lastCol = status2.col;
            int lastStart = status2.offset;
            int lastLen = offset + len2 - lastStart;
            if (lastLen > 0) {
                if (status2.inStructure) {
                    throw new ParseException("Incomplete structure: \"" + new String(buffer, lastStart, lastLen) + "\"", status2.line, status2.col);
                }
                handler2.handleText(buffer, lastStart, lastLen, status2.line, status2.col);
                for (int i2 = lastStart; i2 < lastStart + lastLen; ++i2) {
                    char c2 = buffer[i2];
                    if (c2 == '\n') {
                        ++lastLine;
                        lastCol = 1;
                        continue;
                    }
                    ++lastCol;
                }
            }
            long parsingEndTimeNanos = System.nanoTime();
            handler2.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLine, lastCol);
        }
        catch (ParseException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ParseException(e3);
        }
    }

    private void parseBuffer(char[] buffer, int offset, int len2, IMarkupHandler handler2, ParseStatus status2) throws ParseException {
        int i2;
        int[] locator = new int[]{status2.line, status2.col};
        int maxi = offset + len2;
        int current = i2 = offset;
        boolean inOpenElement = false;
        boolean inCloseElement = false;
        boolean inComment = false;
        boolean inCdata = false;
        boolean inDocType = false;
        boolean inXmlDeclaration = false;
        boolean inProcessingInstruction = false;
        while (i2 < maxi) {
            int tagEnd;
            boolean avoidQuotes;
            boolean inStructure;
            int currentLine = locator[0];
            int currentCol = locator[1];
            if (status2.parsingDisabledLimitSequence != null) {
                int sequenceIndex = ParsingMarkupUtil.findCharacterSequence(buffer, i2, maxi, locator, status2.parsingDisabledLimitSequence);
                if (sequenceIndex == -1) {
                    if (this.configuration.isTextSplittable()) {
                        handler2.handleText(buffer, current, len2 - current, currentLine, currentCol);
                        current = len2;
                    }
                    status2.offset = current;
                    status2.line = currentLine;
                    status2.col = currentCol;
                    status2.inStructure = false;
                    return;
                }
                handler2.handleText(buffer, current, sequenceIndex - current, currentLine, currentCol);
                status2.parsingDisabledLimitSequence = null;
                status2.parsingDisabled = true;
                i2 = current = sequenceIndex;
            }
            boolean bl = inStructure = inOpenElement || inCloseElement || inComment || inCdata || inDocType || inXmlDeclaration || inProcessingInstruction;
            if (!inStructure) {
                int tagStart = ParsingMarkupUtil.findNextStructureStart(buffer, i2, maxi, locator);
                if (tagStart == -1) {
                    if (this.configuration.isTextSplittable()) {
                        handler2.handleText(buffer, current, len2 - current, currentLine, currentCol);
                        if (status2.parsingDisabledLimitSequence != null) {
                            status2.parsingDisabled = false;
                        }
                        current = len2;
                    }
                    status2.offset = current;
                    status2.line = currentLine;
                    status2.col = currentCol;
                    status2.inStructure = false;
                    return;
                }
                inOpenElement = ParsingElementMarkupUtil.isOpenElementStart(buffer, tagStart, maxi);
                if (!(inOpenElement || (inCloseElement = ParsingElementMarkupUtil.isCloseElementStart(buffer, tagStart, maxi)) || (inComment = ParsingCommentMarkupUtil.isCommentStart(buffer, tagStart, maxi)) || (inCdata = ParsingCDATASectionMarkupUtil.isCDATASectionStart(buffer, tagStart, maxi)) || (inDocType = ParsingDocTypeMarkupUtil.isDocTypeStart(buffer, tagStart, maxi)) || (inXmlDeclaration = ParsingXmlDeclarationMarkupUtil.isXmlDeclarationStart(buffer, tagStart, maxi)))) {
                    inProcessingInstruction = ParsingProcessingInstructionUtil.isProcessingInstructionStart(buffer, tagStart, maxi);
                }
                boolean bl2 = inStructure = inOpenElement || inCloseElement || inComment || inCdata || inDocType || inXmlDeclaration || inProcessingInstruction;
                while (!inStructure) {
                    ParsingLocatorUtil.countChar(locator, buffer[tagStart]);
                    tagStart = ParsingMarkupUtil.findNextStructureStart(buffer, tagStart + 1, maxi, locator);
                    if (tagStart == -1) {
                        status2.offset = current;
                        status2.line = currentLine;
                        status2.col = currentCol;
                        status2.inStructure = false;
                        return;
                    }
                    inOpenElement = ParsingElementMarkupUtil.isOpenElementStart(buffer, tagStart, maxi);
                    if (!(inOpenElement || (inCloseElement = ParsingElementMarkupUtil.isCloseElementStart(buffer, tagStart, maxi)) || (inComment = ParsingCommentMarkupUtil.isCommentStart(buffer, tagStart, maxi)) || (inCdata = ParsingCDATASectionMarkupUtil.isCDATASectionStart(buffer, tagStart, maxi)) || (inDocType = ParsingDocTypeMarkupUtil.isDocTypeStart(buffer, tagStart, maxi)) || (inXmlDeclaration = ParsingXmlDeclarationMarkupUtil.isXmlDeclarationStart(buffer, tagStart, maxi)))) {
                        inProcessingInstruction = ParsingProcessingInstructionUtil.isProcessingInstructionStart(buffer, tagStart, maxi);
                    }
                    inStructure = inOpenElement || inCloseElement || inComment || inCdata || inDocType || inXmlDeclaration || inProcessingInstruction;
                }
                if (tagStart > current) {
                    handler2.handleText(buffer, current, tagStart - current, currentLine, currentCol);
                    if (status2.parsingDisabledLimitSequence != null) {
                        status2.parsingDisabled = false;
                    }
                }
                i2 = current = tagStart;
                continue;
            }
            boolean bl3 = avoidQuotes = inOpenElement || inCloseElement || inDocType || inXmlDeclaration;
            int n = inDocType ? ParsingDocTypeMarkupUtil.findNextDocTypeStructureEnd(buffer, i2, maxi, locator) : (tagEnd = avoidQuotes ? ParsingMarkupUtil.findNextStructureEndAvoidQuotes(buffer, i2, maxi, locator) : ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, i2, maxi, locator));
            if (tagEnd < 0) {
                status2.offset = current;
                status2.line = currentLine;
                status2.col = currentCol;
                status2.inStructure = true;
                return;
            }
            if (inOpenElement) {
                if (buffer[tagEnd - 1] == '/') {
                    ParsingElementMarkupUtil.parseStandaloneElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                } else {
                    ParsingElementMarkupUtil.parseOpenElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                }
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inOpenElement = false;
            } else if (inCloseElement) {
                ParsingElementMarkupUtil.parseCloseElement(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inCloseElement = false;
            } else if (inComment) {
                while (tagEnd - current < 6 || buffer[tagEnd - 1] != '-' || buffer[tagEnd - 2] != '-') {
                    ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
                    if ((tagEnd = ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, tagEnd + 1, maxi, locator)) != -1) continue;
                    status2.offset = current;
                    status2.line = currentLine;
                    status2.col = currentCol;
                    status2.inStructure = true;
                    return;
                }
                ParsingCommentMarkupUtil.parseComment(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inComment = false;
            } else if (inCdata) {
                while (tagEnd - current < 11 || buffer[tagEnd - 1] != ']' || buffer[tagEnd - 2] != ']') {
                    ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
                    if ((tagEnd = ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, tagEnd + 1, maxi, locator)) != -1) continue;
                    status2.offset = current;
                    status2.line = currentLine;
                    status2.col = currentCol;
                    status2.inStructure = true;
                    return;
                }
                ParsingCDATASectionMarkupUtil.parseCDATASection(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inCdata = false;
            } else if (inDocType) {
                ParsingDocTypeMarkupUtil.parseDocType(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inDocType = false;
            } else if (inXmlDeclaration) {
                ParsingXmlDeclarationMarkupUtil.parseXmlDeclaration(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inXmlDeclaration = false;
            } else if (inProcessingInstruction) {
                while (tagEnd - current < 5 || buffer[tagEnd - 1] != '?') {
                    ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
                    if ((tagEnd = ParsingMarkupUtil.findNextStructureEndDontAvoidQuotes(buffer, tagEnd + 1, maxi, locator)) != -1) continue;
                    status2.offset = current;
                    status2.line = currentLine;
                    status2.col = currentCol;
                    status2.inStructure = true;
                    return;
                }
                ParsingProcessingInstructionUtil.parseProcessingInstruction(buffer, current, tagEnd - current + 1, currentLine, currentCol, handler2);
                if (status2.parsingDisabledLimitSequence != null) {
                    status2.parsingDisabled = false;
                }
                inProcessingInstruction = false;
            } else {
                throw new IllegalStateException("Illegal parsing state: structure is not of a recognized type");
            }
            ParsingLocatorUtil.countChar(locator, buffer[tagEnd]);
            i2 = current = tagEnd + 1;
        }
        status2.offset = current;
        status2.line = locator[0];
        status2.col = locator[1];
        status2.inStructure = false;
    }

    private static final class BufferPool {
        private final char[][] pool;
        private final boolean[] allocated;
        private final int poolBufferSize;

        private BufferPool(int poolSize, int poolBufferSize) {
            this.pool = new char[poolSize][];
            this.allocated = new boolean[poolSize];
            this.poolBufferSize = poolBufferSize;
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                this.pool[i2] = new char[this.poolBufferSize];
            }
            Arrays.fill(this.allocated, false);
        }

        private synchronized char[] allocateBuffer(int bufferSize) {
            if (bufferSize != this.poolBufferSize) {
                return new char[bufferSize];
            }
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (this.allocated[i2]) continue;
                this.allocated[i2] = true;
                return this.pool[i2];
            }
            return new char[bufferSize];
        }

        private synchronized void releaseBuffer(char[] buffer) {
            if (buffer == null) {
                return;
            }
            if (buffer.length != this.poolBufferSize) {
                return;
            }
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (this.pool[i2] != buffer) continue;
                this.allocated[i2] = false;
                return;
            }
        }
    }
}

