/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.IAttributeSequenceHandler;
import org.attoparser.ParseException;
import org.attoparser.ParsingMarkupUtil;

public final class ParsingAttributeSequenceUtil {
    private ParsingAttributeSequenceUtil() {
    }

    public static void parseAttributeSequence(char[] buffer, int offset, int len2, int line, int col, IAttributeSequenceHandler handler2) throws ParseException {
        int i2;
        int maxi = offset + len2;
        int[] locator = new int[]{line, col};
        int current = i2 = offset;
        while (i2 < maxi) {
            int valueEnd;
            int j2;
            boolean equalsPresent;
            int currentArtifactLine = locator[0];
            int currentArtifactCol = locator[1];
            int wsEnd = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
            if (wsEnd == -1) {
                handler2.handleInnerWhiteSpace(buffer, current, maxi - current, currentArtifactLine, currentArtifactCol);
                i2 = maxi;
                continue;
            }
            if (wsEnd > current) {
                int wsOffset = current;
                int wsLen = wsEnd - current;
                handler2.handleInnerWhiteSpace(buffer, wsOffset, wsLen, currentArtifactLine, currentArtifactCol);
                current = i2 = wsEnd;
            }
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            int attributeNameEnd = ParsingMarkupUtil.findNextOperatorCharWildcard(buffer, i2, maxi, locator);
            if (attributeNameEnd == -1) {
                handler2.handleAttribute(buffer, current, maxi - current, currentArtifactLine, currentArtifactCol, 0, 0, locator[0], locator[1], 0, 0, 0, 0, locator[0], locator[1]);
                i2 = maxi;
                continue;
            }
            if (attributeNameEnd <= current) {
                throw new ParseException("Bad attribute name in sequence \"" + new String(buffer, offset, len2) + "\": attribute names cannot start with an equals sign", currentArtifactLine, currentArtifactCol);
            }
            int attributeNameOffset = current;
            int attributeNameLen = attributeNameEnd - current;
            int attributeNameLine = currentArtifactLine;
            int attributeNameCol = currentArtifactCol;
            current = i2 = attributeNameEnd;
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            int operatorEnd = ParsingMarkupUtil.findNextNonOperatorCharWildcard(buffer, i2, maxi, locator);
            if (operatorEnd == -1) {
                equalsPresent = false;
                for (j2 = i2; j2 < maxi; ++j2) {
                    if (buffer[j2] != '=') continue;
                    equalsPresent = true;
                    break;
                }
                if (equalsPresent) {
                    handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, current, maxi - current, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, locator[0], locator[1]);
                } else {
                    handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, 0, 0, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, currentArtifactLine, currentArtifactCol);
                    handler2.handleInnerWhiteSpace(buffer, current, maxi - current, currentArtifactLine, currentArtifactCol);
                }
                i2 = maxi;
                continue;
            }
            equalsPresent = false;
            for (j2 = current; j2 < operatorEnd; ++j2) {
                if (buffer[j2] != '=') continue;
                equalsPresent = true;
                break;
            }
            if (!equalsPresent) {
                handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, 0, 0, currentArtifactLine, currentArtifactCol, 0, 0, 0, 0, currentArtifactLine, currentArtifactCol);
                handler2.handleInnerWhiteSpace(buffer, current, operatorEnd - current, currentArtifactLine, currentArtifactCol);
                current = i2 = operatorEnd;
                continue;
            }
            int operatorOffset = current;
            int operatorLen = operatorEnd - current;
            int operatorLine = currentArtifactLine;
            int operatorCol = currentArtifactCol;
            current = i2 = operatorEnd;
            currentArtifactLine = locator[0];
            currentArtifactCol = locator[1];
            boolean attributeEndsWithQuotes = i2 < maxi && (buffer[current] == '\"' || buffer[current] == '\'');
            int n = valueEnd = attributeEndsWithQuotes ? ParsingMarkupUtil.findNextAnyCharAvoidQuotesWildcard(buffer, i2, maxi, locator) : ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, false, locator);
            if (valueEnd == -1) {
                int valueContentOffset = current;
                int valueContentLen = maxi - current;
                if (ParsingAttributeSequenceUtil.isValueSurroundedByCommas(buffer, current, maxi - current)) {
                    ++valueContentOffset;
                    valueContentLen -= 2;
                }
                handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, current, maxi - current, currentArtifactLine, currentArtifactCol);
                i2 = maxi;
                continue;
            }
            int valueOuterOffset = current;
            int valueOuterLen = valueEnd - current;
            int valueContentOffset = valueOuterOffset;
            int valueContentLen = valueOuterLen;
            if (ParsingAttributeSequenceUtil.isValueSurroundedByCommas(buffer, valueOuterOffset, valueOuterLen)) {
                valueContentOffset = valueOuterOffset + 1;
                valueContentLen = valueOuterLen - 2;
            }
            handler2.handleAttribute(buffer, attributeNameOffset, attributeNameLen, attributeNameLine, attributeNameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, currentArtifactLine, currentArtifactCol);
            current = i2 = valueEnd;
        }
    }

    private static boolean isValueSurroundedByCommas(char[] buffer, int offset, int len2) {
        return len2 >= 2 && (buffer[offset] == '\"' && buffer[offset + len2 - 1] == '\"' || buffer[offset] == '\'' && buffer[offset + len2 - 1] == '\'');
    }
}

