/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.ICDATASectionHandler;
import org.attoparser.ParseException;

public final class ParsingCDATASectionMarkupUtil {
    private ParsingCDATASectionMarkupUtil() {
    }

    public static void parseCDATASection(char[] buffer, int offset, int len2, int line, int col, ICDATASectionHandler handler2) throws ParseException {
        if (len2 < 12 || !ParsingCDATASectionMarkupUtil.isCDATASectionStart(buffer, offset, offset + len2) || !ParsingCDATASectionMarkupUtil.isCDATASectionEnd(buffer, offset + len2 - 3, offset + len2)) {
            throw new ParseException("Could not parse as a well-formed CDATA Section: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 9;
        int contentLen = len2 - 12;
        handler2.handleCDATASection(buffer, contentOffset, contentLen, offset, len2, line, col);
    }

    static boolean isCDATASectionStart(char[] buffer, int offset, int maxi) {
        return !(maxi - offset <= 8 || buffer[offset] != '<' || buffer[offset + 1] != '!' || buffer[offset + 2] != '[' || buffer[offset + 3] != 'C' && buffer[offset + 3] != 'c' || buffer[offset + 4] != 'D' && buffer[offset + 4] != 'd' || buffer[offset + 5] != 'A' && buffer[offset + 5] != 'a' || buffer[offset + 6] != 'T' && buffer[offset + 6] != 't' || buffer[offset + 7] != 'A' && buffer[offset + 7] != 'a' || buffer[offset + 8] != '[');
    }

    static boolean isCDATASectionEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 2 && buffer[offset] == ']' && buffer[offset + 1] == ']' && buffer[offset + 2] == '>';
    }
}

