/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.ICommentHandler;
import org.attoparser.ParseException;

public final class ParsingCommentMarkupUtil {
    private ParsingCommentMarkupUtil() {
    }

    public static void parseComment(char[] buffer, int offset, int len2, int line, int col, ICommentHandler handler2) throws ParseException {
        if (len2 < 7 || !ParsingCommentMarkupUtil.isCommentStart(buffer, offset, offset + len2) || !ParsingCommentMarkupUtil.isCommentEnd(buffer, offset + len2 - 3, offset + len2)) {
            throw new ParseException("Could not parse as a well-formed Comment: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 4;
        int contentLen = len2 - 7;
        handler2.handleComment(buffer, contentOffset, contentLen, offset, len2, line, col);
    }

    static boolean isCommentStart(char[] buffer, int offset, int maxi) {
        return maxi - offset > 3 && buffer[offset] == '<' && buffer[offset + 1] == '!' && buffer[offset + 2] == '-' && buffer[offset + 3] == '-';
    }

    static boolean isCommentEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 2 && buffer[offset] == '-' && buffer[offset + 1] == '-' && buffer[offset + 2] == '>';
    }
}

