/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.IDocTypeHandler;
import org.attoparser.ParseException;
import org.attoparser.ParsingLocatorUtil;
import org.attoparser.ParsingMarkupUtil;

public final class ParsingDocTypeMarkupUtil {
    private static final char[] DOCTYPE_TYPE_PUBLIC_UPPER = "PUBLIC".toCharArray();
    private static final char[] DOCTYPE_TYPE_PUBLIC_LOWER = "public".toCharArray();
    private static final char[] DOCTYPE_TYPE_SYSTEM_UPPER = "SYSTEM".toCharArray();
    private static final char[] DOCTYPE_TYPE_SYSTEM_LOWER = "system".toCharArray();

    private ParsingDocTypeMarkupUtil() {
    }

    public static void parseDocType(char[] buffer, int offset, int len2, int line, int col, IDocTypeHandler handler2) throws ParseException {
        if (len2 < 10 || !ParsingDocTypeMarkupUtil.isDocTypeStart(buffer, offset, offset + len2) || !ParsingDocTypeMarkupUtil.isDocTypeEnd(buffer, offset + len2 - 1, offset + len2)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len2 - 3;
        int internalSubsetLastChar = ParsingDocTypeMarkupUtil.findInternalSubsetEndChar(buffer, contentOffset, contentLen);
        if (internalSubsetLastChar == -1) {
            ParsingDocTypeMarkupUtil.doParseDetailedDocTypeWithInternalSubset(buffer, contentOffset, contentLen, offset, len2, line, col, 0, 0, 0, 0, handler2);
            return;
        }
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int internalSubsetStart = ParsingDocTypeMarkupUtil.findInternalSubsetStartCharWildcard(buffer, contentOffset, maxi, locator);
        if (internalSubsetStart == -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        ParsingDocTypeMarkupUtil.doParseDetailedDocTypeWithInternalSubset(buffer, contentOffset, internalSubsetStart - contentOffset, offset, len2, line, col, internalSubsetStart + 1, internalSubsetLastChar - internalSubsetStart - 1, locator[0], locator[1], handler2);
    }

    private static void doParseDetailedDocTypeWithInternalSubset(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, IDocTypeHandler handler2) throws ParseException {
        int i2 = contentOffset;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int keywordEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, false, locator);
        if (keywordEnd == -1) {
            handler2.handleDocType(buffer, i2, maxi - i2, line, col + 2, 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int keywordOffset = i2;
        int keywordLen = keywordEnd - keywordOffset;
        int keywordLine = line;
        int keywordCol = col + 2;
        i2 = keywordEnd;
        int currentDocTypeLine = locator[0];
        int currentDocTypeCol = locator[1];
        int elementNameStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
        if (elementNameStart == -1) {
            handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, 0, 0, currentDocTypeLine, currentDocTypeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, internalSubsetOffset, internalSubsetLen, Math.max(currentDocTypeLine, internalSubsetLine), Math.max(currentDocTypeCol, internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        i2 = elementNameStart;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, false, locator);
        if (elementNameEnd == -1) {
            handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, i2, maxi - i2, currentDocTypeLine, currentDocTypeCol, 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int elementNameOffset = elementNameStart;
        int elementNameLen = elementNameEnd - elementNameOffset;
        int elementNameLine = currentDocTypeLine;
        int elementNameCol = currentDocTypeCol;
        i2 = elementNameEnd;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int typeStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
        if (typeStart == -1) {
            handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        i2 = typeStart;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int typeEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, true, locator);
        if (typeEnd == -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": If a type is specified (PUBLIC or SYSTEM), at least a public or a system ID has to be specified", line, col);
        }
        int typeOffset = typeStart;
        int typeLen = typeEnd - typeOffset;
        int typeLine = currentDocTypeLine;
        int typeCol = currentDocTypeCol;
        i2 = typeEnd;
        if (!ParsingDocTypeMarkupUtil.isValidDocTypeType(buffer, typeOffset, typeLen)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": DOCTYPE type must be either \"PUBLIC\" or \"SYSTEM\"", line, col);
        }
        boolean isTypePublic = buffer[typeOffset] == DOCTYPE_TYPE_PUBLIC_UPPER[0] || buffer[typeOffset] == DOCTYPE_TYPE_PUBLIC_LOWER[0];
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec1Start = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
        if (spec1Start == -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": If a type is specified (PUBLIC or SYSTEM), at least a public or a system ID has to be specified", line, col);
        }
        i2 = spec1Start;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec1End = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, true, locator);
        if (spec1End == -1) {
            if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, i2, maxi - i2)) {
                throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
            }
            if (isTypePublic) {
                handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, i2 + 1, maxi - (i2 + 2), currentDocTypeLine, currentDocTypeCol, 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
                return;
            }
            handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, i2 + 1, maxi - (i2 + 2), currentDocTypeLine, currentDocTypeCol, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int spec1Offset = spec1Start;
        int spec1Len = spec1End - spec1Offset;
        int spec1Line = currentDocTypeLine;
        int spec1Col = currentDocTypeCol;
        i2 = spec1End;
        if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, spec1Offset, spec1Len)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
        }
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec2Start = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
        if (spec2Start == -1) {
            if (isTypePublic) {
                handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
                return;
            }
            handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, 0, 0, spec1Line, spec1Col, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        i2 = spec2Start;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec2End = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, true, locator);
        if (spec2End == -1) {
            if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, i2, maxi - i2)) {
                throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
            }
            if (!isTypePublic) {
                throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": type SYSTEM only allows specifying one element (a system ID)", line, col);
            }
            handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, i2 + 1, maxi - (i2 + 2), currentDocTypeLine, currentDocTypeCol, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int spec2Offset = spec2Start;
        int spec2Len = spec2End - spec2Offset;
        int spec2Line = currentDocTypeLine;
        int spec2Col = currentDocTypeCol;
        i2 = spec2End;
        if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, spec2Start, spec2Len)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
        }
        if (!isTypePublic) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": type SYSTEM only allows specifying one element (a system ID)", line, col);
        }
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int clauseEndStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
        if (clauseEndStart != -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": More elements found than allowed", line, col);
        }
        handler2.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, spec2Offset + 1, spec2Len - 2, spec2Line, spec2Col, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
    }

    static boolean isDocTypeStart(char[] buffer, int offset, int maxi) {
        return !(maxi - offset <= 9 || buffer[offset] != '<' || buffer[offset + 1] != '!' || buffer[offset + 2] != 'D' && buffer[offset + 2] != 'd' || buffer[offset + 3] != 'O' && buffer[offset + 3] != 'o' || buffer[offset + 4] != 'C' && buffer[offset + 4] != 'c' || buffer[offset + 5] != 'T' && buffer[offset + 5] != 't' || buffer[offset + 6] != 'Y' && buffer[offset + 6] != 'y' || buffer[offset + 7] != 'P' && buffer[offset + 7] != 'p' || buffer[offset + 8] != 'E' && buffer[offset + 8] != 'e' || !Character.isWhitespace(buffer[offset + 9]) && buffer[offset + 9] != '>');
    }

    static boolean isDocTypeEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 0 && buffer[offset] == '>';
    }

    private static boolean isValidDocTypeType(char[] buffer, int offset, int len2) {
        if (len2 != 6) {
            return false;
        }
        if (buffer[offset] == DOCTYPE_TYPE_PUBLIC_UPPER[0] || buffer[offset] == DOCTYPE_TYPE_PUBLIC_LOWER[0]) {
            for (int i2 = 1; i2 < 6; ++i2) {
                if (buffer[offset + i2] == DOCTYPE_TYPE_PUBLIC_UPPER[i2] || buffer[offset + i2] == DOCTYPE_TYPE_PUBLIC_LOWER[i2]) continue;
                return false;
            }
            return true;
        }
        if (buffer[offset] == DOCTYPE_TYPE_SYSTEM_UPPER[0] || buffer[offset] == DOCTYPE_TYPE_SYSTEM_LOWER[0]) {
            for (int i3 = 1; i3 < 6; ++i3) {
                if (buffer[offset + i3] == DOCTYPE_TYPE_SYSTEM_UPPER[i3] || buffer[offset + i3] == DOCTYPE_TYPE_SYSTEM_LOWER[i3]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isValidDocTypeSpec(char[] buffer, int offset, int len2) {
        return len2 >= 2 && (buffer[offset] == '\"' && buffer[offset + len2 - 1] == '\"' || buffer[offset] == '\'' && buffer[offset + len2 - 1] == '\'');
    }

    private static int findInternalSubsetEndChar(char[] buffer, int offset, int len2) {
        int maxi = offset + len2;
        for (int i2 = maxi - 1; i2 > offset; --i2) {
            char c2 = buffer[i2];
            if (Character.isWhitespace(c2)) continue;
            if (c2 == ']') {
                return i2;
            }
            return -1;
        }
        return -1;
    }

    private static int findInternalSubsetStartCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        for (int i2 = offset; i2 < maxi; ++i2) {
            char c2 = text[i2];
            if (!inApos && c2 == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes && c2 == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && c2 == '[') {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
        }
        return -1;
    }

    static int findNextDocTypeStructureEnd(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int bracketLevel = 0;
        for (int i2 = offset; i2 < maxi; ++i2) {
            char c2 = text[i2];
            if (!inApos && c2 == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes && c2 == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && c2 == '[') {
                ++bracketLevel;
            } else if (!inQuotes && !inApos && c2 == ']') {
                --bracketLevel;
            } else if (!inQuotes && !inApos && bracketLevel == 0 && c2 == '>') {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c2);
        }
        if (bracketLevel != 0) {
            return -2;
        }
        return -1;
    }
}

