/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.ParsingAttributeSequenceUtil;
import org.attoparser.ParsingMarkupUtil;

public final class ParsingElementMarkupUtil {
    private ParsingElementMarkupUtil() {
    }

    public static void parseStandaloneElement(char[] buffer, int offset, int len2, int line, int col, IMarkupHandler markupHandler) throws ParseException {
        if (len2 < 4 || !ParsingElementMarkupUtil.isOpenElementStart(buffer, offset, offset + len2) || !ParsingElementMarkupUtil.isElementEnd(buffer, offset + len2 - 2, offset + len2, true)) {
            throw new ParseException("Could not parse as a well-formed standalone element: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 1;
        int contentLen = len2 - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 1};
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            markupHandler.handleStandaloneElementStart(buffer, contentOffset, contentLen, true, line, col);
            markupHandler.handleStandaloneElementEnd(buffer, contentOffset, contentLen, true, locator[0], locator[1]);
            return;
        }
        markupHandler.handleStandaloneElementStart(buffer, contentOffset, elementNameEnd - contentOffset, true, line, col);
        ParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], markupHandler);
        ParsingMarkupUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        markupHandler.handleStandaloneElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, true, locator[0], locator[1]);
    }

    public static void parseOpenElement(char[] buffer, int offset, int len2, int line, int col, IMarkupHandler markupHandler) throws ParseException {
        if (len2 < 3 || !ParsingElementMarkupUtil.isOpenElementStart(buffer, offset, offset + len2) || !ParsingElementMarkupUtil.isElementEnd(buffer, offset + len2 - 1, offset + len2, false)) {
            throw new ParseException("Could not parse as a well-formed open element: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 1;
        int contentLen = len2 - 2;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 1};
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            markupHandler.handleOpenElementStart(buffer, contentOffset, contentLen, line, col);
            markupHandler.handleOpenElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        markupHandler.handleOpenElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        ParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], markupHandler);
        ParsingMarkupUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        markupHandler.handleOpenElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    public static void parseCloseElement(char[] buffer, int offset, int len2, int line, int col, IMarkupHandler markupHandler) throws ParseException {
        if (len2 < 4 || !ParsingElementMarkupUtil.isCloseElementStart(buffer, offset, offset + len2) || !ParsingElementMarkupUtil.isElementEnd(buffer, offset + len2 - 1, offset + len2, false)) {
            throw new ParseException("Could not parse as a well-formed close element: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len2 - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            markupHandler.handleCloseElementStart(buffer, contentOffset, contentLen, line, col);
            markupHandler.handleCloseElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        markupHandler.handleCloseElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        int currentArtifactLine = locator[0];
        int currentArtifactCol = locator[1];
        int wsEnd = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, elementNameEnd, maxi, locator);
        if (wsEnd != -1) {
            throw new ParseException("Could not parse as a well-formed closing element \"</" + new String(buffer, contentOffset, contentLen) + ">\": No attributes are allowed here", line, col);
        }
        markupHandler.handleInnerWhiteSpace(buffer, elementNameEnd, maxi - elementNameEnd, currentArtifactLine, currentArtifactCol);
        markupHandler.handleCloseElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    static boolean isOpenElementStart(char[] buffer, int offset, int maxi) {
        int len2 = maxi - offset;
        return len2 > 1 && buffer[offset] == '<' && ParsingElementMarkupUtil.isElementName(buffer, offset + 1, maxi);
    }

    static boolean isCloseElementStart(char[] buffer, int offset, int maxi) {
        int len2 = maxi - offset;
        return len2 > 2 && buffer[offset] == '<' && buffer[offset + 1] == '/' && ParsingElementMarkupUtil.isElementName(buffer, offset + 2, maxi);
    }

    static boolean isElementEnd(char[] buffer, int offset, int maxi, boolean minimized) {
        int len2 = maxi - offset;
        if (len2 < 1) {
            return false;
        }
        if (minimized) {
            if (len2 < 2 || buffer[offset] != '/') {
                return false;
            }
            return buffer[offset + 1] == '>';
        }
        return buffer[offset] == '>';
    }

    private static boolean isElementName(char[] buffer, int offset, int maxi) {
        int len2 = maxi - offset;
        if (len2 > 1 && buffer[offset] == '!') {
            if (len2 > 8) {
                return buffer[offset + 1] != '-' && buffer[offset + 1] != '!' && buffer[offset + 1] != '/' && buffer[offset + 1] != '?' && buffer[offset + 1] != '[' && (buffer[offset + 1] != 'D' && buffer[offset + 1] != 'd' || buffer[offset + 2] != 'O' && buffer[offset + 2] != 'o' || buffer[offset + 3] != 'C' && buffer[offset + 3] != 'c' || buffer[offset + 4] != 'T' && buffer[offset + 4] != 't' || buffer[offset + 5] != 'Y' && buffer[offset + 5] != 'y' || buffer[offset + 6] != 'P' && buffer[offset + 6] != 'p' || buffer[offset + 7] != 'E' && buffer[offset + 7] != 'e' || !Character.isWhitespace(buffer[offset + 8]) && buffer[offset + 8] != '>');
            }
            return buffer[offset + 1] != '-' && buffer[offset + 1] != '!' && buffer[offset + 1] != '/' && buffer[offset + 1] != '?' && buffer[offset + 1] != '[' && !Character.isWhitespace(buffer[offset + 1]);
        }
        return len2 > 0 && buffer[offset] != '-' && buffer[offset] != '!' && buffer[offset] != '/' && buffer[offset] != '?' && buffer[offset] != '[' && !Character.isWhitespace(buffer[offset]);
    }
}

