/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.IProcessingInstructionHandler;
import org.attoparser.ParseException;
import org.attoparser.ParsingMarkupUtil;

public final class ParsingProcessingInstructionUtil {
    private ParsingProcessingInstructionUtil() {
    }

    public static void parseProcessingInstruction(char[] buffer, int offset, int len2, int line, int col, IProcessingInstructionHandler handler2) throws ParseException {
        if (len2 < 4 || !ParsingProcessingInstructionUtil.isProcessingInstructionStart(buffer, offset, offset + len2) || !ParsingProcessingInstructionUtil.isProcessingInstructionEnd(buffer, offset + len2 - 2, offset + len2)) {
            throw new ParseException("Could not parse as a well-formed Processing Instruction: \"" + new String(buffer, offset, len2) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int i2 = contentOffset;
        int contentLen = len2 - 4;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int targetEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i2, maxi, false, locator);
        if (targetEnd == -1) {
            handler2.handleProcessingInstruction(buffer, i2, maxi - i2, line, col + 2, 0, 0, locator[0], locator[1], offset, len2, line, col);
            return;
        }
        int targetOffset = i2;
        int targetLen = targetEnd - targetOffset;
        i2 = targetEnd;
        int contentStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i2, maxi, locator);
        if (contentStart == -1) {
            handler2.handleProcessingInstruction(buffer, targetOffset, targetLen, line, col + 2, 0, 0, locator[0], locator[1], offset, len2, line, col);
            return;
        }
        handler2.handleProcessingInstruction(buffer, targetOffset, targetLen, line, col + 2, contentStart, maxi - contentStart, locator[0], locator[1], offset, len2, line, col);
    }

    static boolean isProcessingInstructionStart(char[] buffer, int offset, int maxi) {
        int len2 = maxi - offset;
        if (len2 > 5) {
            return buffer[offset] == '<' && buffer[offset + 1] == '?' && buffer[offset + 2] != ' ' && !Character.isWhitespace(buffer[offset + 2]) && (buffer[offset + 2] != 'x' || buffer[offset + 3] != 'm' || buffer[offset + 4] != 'l' || !Character.isWhitespace(buffer[offset + 5]));
        }
        return len2 > 2 && buffer[offset] == '<' && buffer[offset + 1] == '?' && buffer[offset + 2] != ' ' && !Character.isWhitespace(buffer[offset + 2]);
    }

    static boolean isProcessingInstructionEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '?' && buffer[offset + 1] == '>';
    }
}

