/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.attoparser.dom.AbstractNode;
import org.attoparser.dom.INestableNode;
import org.attoparser.dom.INode;

abstract class AbstractNestableNode
extends AbstractNode
implements INestableNode {
    private List<INode> children = null;
    private int childrenLen = 0;

    protected AbstractNestableNode() {
    }

    @Override
    public boolean hasChildren() {
        return this.childrenLen != 0;
    }

    @Override
    public int numChildren() {
        return this.childrenLen;
    }

    @Override
    public List<INode> getChildren() {
        if (this.childrenLen == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public <T extends INode> List<T> getChildrenOfType(Class<T> type2) {
        if (this.childrenLen == 0) {
            return Collections.emptyList();
        }
        ArrayList<INode> selectedChildren = new ArrayList<INode>(5);
        for (INode child : this.children) {
            if (!type2.isInstance(child)) continue;
            selectedChildren.add(child);
        }
        return Collections.unmodifiableList(selectedChildren);
    }

    @Override
    public INode getFirstChild() {
        if (this.childrenLen == 0) {
            return null;
        }
        return this.children.get(0);
    }

    @Override
    public <T extends INode> T getFirstChildOfType(Class<T> type2) {
        if (this.childrenLen == 0) {
            return null;
        }
        for (INode child : this.children) {
            if (!type2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Override
    public void addChild(INode newChild) {
        if (newChild != null) {
            if (this.childrenLen == 0) {
                this.children = new ArrayList<INode>(5);
            }
            this.children.add(newChild);
            ++this.childrenLen;
            newChild.setParent(this);
        }
    }

    @Override
    public final void insertChild(int index, INode newChild) {
        if (newChild != null) {
            if (this.childrenLen == 0) {
                this.children = new ArrayList<INode>(5);
            }
            if (index <= this.childrenLen) {
                this.children.add(index, newChild);
                ++this.childrenLen;
                newChild.setParent(this);
            }
        }
    }

    @Override
    public final void insertChildBefore(INode before, INode newChild) {
        if (newChild != null && this.childrenLen > 0) {
            for (int i2 = 0; i2 < this.childrenLen; ++i2) {
                INode currentChild = this.children.get(i2);
                if (currentChild != before) continue;
                this.insertChild(i2, newChild);
                return;
            }
        }
    }

    @Override
    public final void insertChildAfter(INode after, INode newChild) {
        if (newChild != null && this.childrenLen > 0) {
            for (int i2 = 0; i2 < this.childrenLen; ++i2) {
                INode currentChild = this.children.get(i2);
                if (currentChild != after) continue;
                this.insertChild(i2 + 1, newChild);
                return;
            }
        }
    }

    @Override
    public final void removeChild(INode child) {
        if (child != null && child.getParent() == this) {
            Iterator<INode> childrenIter = this.children.iterator();
            while (childrenIter.hasNext()) {
                INode nodeChild = childrenIter.next();
                if (nodeChild != child) continue;
                childrenIter.remove();
                --this.childrenLen;
                break;
            }
            if (this.childrenLen == 0) {
                this.children = null;
            }
        }
    }

    @Override
    public final void clearChildren() {
        this.children = null;
        this.childrenLen = 0;
    }
}

