/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.select;

public final class ParseSelection {
    private int levelCounter = 0;
    ParseSelectionLevel[] levels;

    int subscribeLevel() {
        ParseSelectionLevel[] newLevels = new ParseSelectionLevel[this.levelCounter + 1];
        if (this.levels != null) {
            System.arraycopy(this.levels, 0, newLevels, 0, this.levelCounter);
        }
        this.levels = newLevels;
        this.levels[this.levelCounter] = new ParseSelectionLevel();
        return this.levelCounter++;
    }

    public int getSelectionLevels() {
        return this.levelCounter;
    }

    public String[] getSelectors(int level) {
        if (level >= this.levelCounter) {
            throw new IllegalArgumentException("Cannot return current selection: max level is " + this.levelCounter + " (specified: " + level + ")");
        }
        if (this.levels == null) {
            return null;
        }
        return this.levels[level].selectors;
    }

    public String[] getCurrentSelection(int level) {
        if (level >= this.levelCounter) {
            throw new IllegalArgumentException("Cannot return current selection: max level is " + this.levelCounter + " (specified: " + level + ")");
        }
        if (this.levels == null) {
            return null;
        }
        return this.levels[level].getCurrentSelection();
    }

    public boolean isMatchingAny(int level) {
        if (level >= this.levelCounter) {
            throw new IllegalArgumentException("Cannot return current selection: max level is " + this.levelCounter + " (specified: " + level + ")");
        }
        if (this.levels == null) {
            return false;
        }
        return this.levels[level].isSelectionActive();
    }

    public boolean isMatchingAny() {
        if (this.levels == null) {
            return false;
        }
        int i2 = 0;
        int n = this.levelCounter;
        while (n-- != 0) {
            if (this.levels[i2].isSelectionActive()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public String toString() {
        if (this.levels.length == 0) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder(40);
        strBuilder.append(this.levels[0]);
        if (this.levels.length > 1) {
            for (int i2 = 1; i2 < this.levels.length; ++i2) {
                strBuilder.append(" -> ");
                strBuilder.append(this.levels[i2]);
            }
        }
        return strBuilder.toString();
    }

    static final class ParseSelectionLevel {
        String[] selectors;
        boolean[] selection;

        private ParseSelectionLevel() {
        }

        String[] getCurrentSelection() {
            if (this.selection == null) {
                return null;
            }
            int size2 = 0;
            int i2 = 0;
            int n = this.selectors.length;
            while (n-- != 0) {
                if (this.selection[i2]) {
                    ++size2;
                }
                ++i2;
            }
            if (size2 == this.selectors.length) {
                return this.selectors;
            }
            String[] currentSelection = new String[size2];
            int j2 = 0;
            i2 = 0;
            n = this.selectors.length;
            while (n-- != 0) {
                if (this.selection[i2]) {
                    currentSelection[j2++] = this.selectors[i2];
                }
                ++i2;
            }
            return currentSelection;
        }

        public boolean isSelectionActive() {
            if (this.selection == null) {
                return false;
            }
            int i2 = 0;
            int n = this.selectors.length;
            while (n-- != 0) {
                if (this.selection[i2]) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder(20);
            strBuilder.append('[');
            if (this.selection != null) {
                for (int i2 = 0; i2 < this.selectors.length; ++i2) {
                    if (!this.selection[i2]) continue;
                    if (strBuilder.length() > 1) {
                        strBuilder.append(',');
                    }
                    strBuilder.append(this.selectors[i2]);
                }
            }
            strBuilder.append(']');
            return strBuilder.toString();
        }
    }
}

