/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.util;

public final class TextUtil {
    public static boolean equals(boolean caseSensitive, CharSequence text1, CharSequence text2) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1 == text2) {
            return true;
        }
        if (text1 instanceof String && text2 instanceof String) {
            return caseSensitive ? text1.equals(text2) : ((String)text1).equalsIgnoreCase((String)text2);
        }
        return TextUtil.equals(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length());
    }

    public static boolean equals(boolean caseSensitive, CharSequence text1, char[] text2) {
        return TextUtil.equals(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length);
    }

    public static boolean equals(boolean caseSensitive, char[] text1, char[] text2) {
        if (text1 == text2) {
            return true;
        }
        return TextUtil.equals(caseSensitive, text1, 0, text1.length, text2, 0, text2.length);
    }

    public static boolean equals(boolean caseSensitive, char[] text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text buffer being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        if (text1Len != text2Len) {
            return false;
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return true;
        }
        int n = text1Len;
        int i2 = 0;
        while (n-- != 0) {
            char c1 = text1[text1Offset + i2];
            char c2 = text2[text2Offset + i2];
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean equals(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        if (text1Len != text2Len) {
            return false;
        }
        int n = text1Len;
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i2);
            if (c1 != (c2 = text2[text2Offset + i2])) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean equals(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, CharSequence text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1Len != text2Len) {
            return false;
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return true;
        }
        int n = text1Len;
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i2);
            if (c1 != (c2 = text2.charAt(text2Offset + i2))) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, CharSequence prefix2) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix2 == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (text instanceof String && prefix2 instanceof String) {
            return caseSensitive ? ((String)text).startsWith((String)prefix2) : TextUtil.startsWith(caseSensitive, text, 0, text.length(), prefix2, 0, prefix2.length());
        }
        return TextUtil.startsWith(caseSensitive, text, 0, text.length(), prefix2, 0, prefix2.length());
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, char[] prefix2) {
        return TextUtil.startsWith(caseSensitive, text, 0, text.length(), prefix2, 0, prefix2.length);
    }

    public static boolean startsWith(boolean caseSensitive, char[] text, char[] prefix2) {
        return TextUtil.startsWith(caseSensitive, text, 0, text.length, prefix2, 0, prefix2.length);
    }

    public static boolean startsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, char[] prefix2, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix2 == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c1 = text[textOffset + i2];
            char c2 = prefix2[prefixOffset + i2];
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, char[] prefix2, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix2 == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textOffset + i2);
            if (c1 != (c2 = prefix2[prefixOffset + i2])) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, CharSequence prefix2, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix2 == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c1 = text[textOffset + i2];
            char c2 = prefix2.charAt(prefixOffset + i2);
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean startsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, CharSequence prefix2, int prefixOffset, int prefixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (prefix2 == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (textLen < prefixLen) {
            return false;
        }
        int n = prefixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textOffset + i2);
            if (c1 != (c2 = prefix2.charAt(prefixOffset + i2))) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, CharSequence suffix) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (text instanceof String && suffix instanceof String) {
            return caseSensitive ? ((String)text).endsWith((String)suffix) : TextUtil.endsWith(caseSensitive, text, 0, text.length(), suffix, 0, suffix.length());
        }
        return TextUtil.endsWith(caseSensitive, text, 0, text.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, char[] suffix) {
        return TextUtil.endsWith(caseSensitive, text, 0, text.length(), suffix, 0, suffix.length);
    }

    public static boolean endsWith(boolean caseSensitive, char[] text, char[] suffix) {
        return TextUtil.endsWith(caseSensitive, text, 0, text.length, suffix, 0, suffix.length);
    }

    public static boolean endsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, char[] suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c1 = text[textReverseOffset - i2];
            char c2 = suffix[suffixReverseOffset - i2];
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, char[] suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textReverseOffset - i2);
            if (c1 != (c2 = suffix[suffixReverseOffset - i2])) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, char[] text, int textOffset, int textLen, CharSequence suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c1 = text[textReverseOffset - i2];
            char c2 = suffix.charAt(suffixReverseOffset - i2);
            if (c1 != c2) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean endsWith(boolean caseSensitive, CharSequence text, int textOffset, int textLen, CharSequence suffix, int suffixOffset, int suffixLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        if (textLen < suffixLen) {
            return false;
        }
        int textReverseOffset = textOffset + textLen - 1;
        int suffixReverseOffset = suffixOffset + suffixLen - 1;
        int n = suffixLen;
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text.charAt(textReverseOffset - i2);
            if (c1 != (c2 = suffix.charAt(suffixReverseOffset - i2))) {
                if (caseSensitive) {
                    return false;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, CharSequence fragment) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (text instanceof String && fragment instanceof String) {
            return caseSensitive ? ((String)text).contains(fragment) : TextUtil.contains(caseSensitive, text, 0, text.length(), fragment, 0, fragment.length());
        }
        return TextUtil.contains(caseSensitive, text, 0, text.length(), fragment, 0, fragment.length());
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, char[] fragment) {
        return TextUtil.contains(caseSensitive, text, 0, text.length(), fragment, 0, fragment.length);
    }

    public static boolean contains(boolean caseSensitive, char[] text, char[] fragment) {
        return TextUtil.contains(caseSensitive, text, 0, text.length, fragment, 0, fragment.length);
    }

    public static boolean contains(boolean caseSensitive, char[] text, int textOffset, int textLen, char[] fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j2 = 0;
        for (int i2 = 0; i2 < textLen; ++i2) {
            char c1 = text[textOffset + i2];
            char c2 = fragment[fragmentOffset + j2];
            if (c1 == c2) {
                if (++j2 != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
            }
            if (j2 > 0) {
                i2 -= j2;
            }
            j2 = 0;
        }
        return false;
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, int textOffset, int textLen, char[] fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j2 = 0;
        for (int i2 = 0; i2 < textLen; ++i2) {
            char c2;
            char c1 = text.charAt(textOffset + i2);
            if (c1 == (c2 = fragment[fragmentOffset + j2])) {
                if (++j2 != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
            }
            if (j2 > 0) {
                i2 -= j2;
            }
            j2 = 0;
        }
        return false;
    }

    public static boolean contains(boolean caseSensitive, char[] text, int textOffset, int textLen, CharSequence fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j2 = 0;
        for (int i2 = 0; i2 < textLen; ++i2) {
            char c1 = text[textOffset + i2];
            char c2 = fragment.charAt(fragmentOffset + j2);
            if (c1 == c2) {
                if (++j2 != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
            }
            if (j2 > 0) {
                i2 -= j2;
            }
            j2 = 0;
        }
        return false;
    }

    public static boolean contains(boolean caseSensitive, CharSequence text, int textOffset, int textLen, CharSequence fragment, int fragmentOffset, int fragmentLen) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        if (fragment == null) {
            throw new IllegalArgumentException("Fragment cannot be null");
        }
        if (textLen < fragmentLen) {
            return false;
        }
        if (fragmentLen == 0) {
            return true;
        }
        int j2 = 0;
        for (int i2 = 0; i2 < textLen; ++i2) {
            char c2;
            char c1 = text.charAt(textOffset + i2);
            if (c1 == (c2 = fragment.charAt(fragmentOffset + j2))) {
                if (++j2 != fragmentLen) continue;
                return true;
            }
            if (!caseSensitive) {
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
                    if (++j2 != fragmentLen) continue;
                    return true;
                }
            }
            if (j2 > 0) {
                i2 -= j2;
            }
            j2 = 0;
        }
        return false;
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, CharSequence text2) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1 instanceof String && text2 instanceof String) {
            return caseSensitive ? ((String)text1).compareTo((String)text2) : ((String)text1).compareToIgnoreCase((String)text2);
        }
        return TextUtil.compareTo(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length());
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, char[] text2) {
        return TextUtil.compareTo(caseSensitive, text1, 0, text1.length(), text2, 0, text2.length);
    }

    public static int compareTo(boolean caseSensitive, char[] text1, char[] text2) {
        return TextUtil.compareTo(caseSensitive, text1, 0, text1.length, text2, 0, text2.length);
    }

    public static int compareTo(boolean caseSensitive, char[] text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text buffer being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return 0;
        }
        int n = Math.min(text1Len, text2Len);
        int i2 = 0;
        while (n-- != 0) {
            char c1 = text1[text1Offset + i2];
            char c2 = text2[text2Offset + i2];
            if (c1 != c2) {
                if (caseSensitive) {
                    return c1 - c2;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
            }
            ++i2;
        }
        return text1Len - text2Len;
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, char[] text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text buffer being compared cannot be null");
        }
        int n = Math.min(text1Len, text2Len);
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i2);
            if (c1 != (c2 = text2[text2Offset + i2])) {
                if (caseSensitive) {
                    return c1 - c2;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
            }
            ++i2;
        }
        return text1Len - text2Len;
    }

    public static int compareTo(boolean caseSensitive, CharSequence text1, int text1Offset, int text1Len, CharSequence text2, int text2Offset, int text2Len) {
        if (text1 == null) {
            throw new IllegalArgumentException("First text being compared cannot be null");
        }
        if (text2 == null) {
            throw new IllegalArgumentException("Second text being compared cannot be null");
        }
        if (text1 == text2 && text1Offset == text2Offset && text1Len == text2Len) {
            return 0;
        }
        int n = Math.min(text1Len, text2Len);
        int i2 = 0;
        while (n-- != 0) {
            char c2;
            char c1 = text1.charAt(text1Offset + i2);
            if (c1 != (c2 = text2.charAt(text2Offset + i2))) {
                if (caseSensitive) {
                    return c1 - c2;
                }
                if ((c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
            }
            ++i2;
        }
        return text1Len - text2Len;
    }

    public static int binarySearch(boolean caseSensitive, char[][] values2, char[] text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtil.binarySearch(caseSensitive, values2, 0, values2.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, char[][] values2, CharSequence text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtil.binarySearch(caseSensitive, values2, 0, values2.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values2, char[] text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtil.binarySearch(caseSensitive, values2, 0, values2.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values2, CharSequence text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        return TextUtil.binarySearch(caseSensitive, values2, 0, values2.length, text, textOffset, textLen);
    }

    public static int binarySearch(boolean caseSensitive, char[][] values2, int valuesOffset, int valuesLen, char[] text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char[] midVal = values2[mid];
            int cmp = TextUtil.compareTo(caseSensitive, midVal, 0, midVal.length, text, textOffset, textLen);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(boolean caseSensitive, char[][] values2, int valuesOffset, int valuesLen, CharSequence text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char[] midVal = values2[mid];
            int cmp = TextUtil.compareTo(caseSensitive, text, textOffset, textLen, midVal, 0, midVal.length);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values2, int valuesOffset, int valuesLen, char[] text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CharSequence midVal = values2[mid];
            int cmp = TextUtil.compareTo(caseSensitive, midVal, 0, midVal.length(), text, textOffset, textLen);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(boolean caseSensitive, CharSequence[] values2, int valuesOffset, int valuesLen, CharSequence text, int textOffset, int textLen) {
        if (values2 == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        int low = valuesOffset;
        int high = valuesOffset + valuesLen - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CharSequence midVal = values2[mid];
            int cmp = TextUtil.compareTo(caseSensitive, text, textOffset, textLen, midVal, 0, midVal.length());
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int hashCode(char[] text, int textOffset, int textLen) {
        int h2 = 0;
        int off = textOffset;
        for (int i2 = 0; i2 < textLen; ++i2) {
            h2 = 31 * h2 + text[off++];
        }
        return h2;
    }

    public static int hashCode(CharSequence text) {
        return TextUtil.hashCodePart(0, text);
    }

    public static int hashCode(CharSequence text, int beginIndex, int endIndex) {
        return TextUtil.hashCodePart(0, text, beginIndex, endIndex);
    }

    public static int hashCode(CharSequence text0, CharSequence text1) {
        return TextUtil.hashCodePart(TextUtil.hashCodePart(0, text0), text1);
    }

    public static int hashCode(CharSequence text0, CharSequence text1, CharSequence text2) {
        return TextUtil.hashCodePart(TextUtil.hashCodePart(TextUtil.hashCodePart(0, text0), text1), text2);
    }

    public static int hashCode(CharSequence text0, CharSequence text1, CharSequence text2, CharSequence text3) {
        return TextUtil.hashCodePart(TextUtil.hashCodePart(TextUtil.hashCodePart(TextUtil.hashCodePart(0, text0), text1), text2), text3);
    }

    public static int hashCode(CharSequence text0, CharSequence text1, CharSequence text2, CharSequence text3, CharSequence text4) {
        return TextUtil.hashCodePart(TextUtil.hashCodePart(TextUtil.hashCodePart(TextUtil.hashCodePart(TextUtil.hashCodePart(0, text0), text1), text2), text3), text4);
    }

    private static int hashCodePart(int h2, CharSequence text) {
        return TextUtil.hashCodePart(h2, text, 0, text.length());
    }

    private static int hashCodePart(int h2, CharSequence text, int beginIndex, int endIndex) {
        if (h2 == 0 && beginIndex == 0 && endIndex == text.length() && text instanceof String) {
            return text.hashCode();
        }
        int hh = h2;
        for (int i2 = beginIndex; i2 < endIndex; ++i2) {
            hh = 31 * hh + text.charAt(i2);
        }
        return hh;
    }

    private TextUtil() {
    }
}

