/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.Paths;

public class CleanCommand
extends GitCommand<Set<String>> {
    private Set<String> paths = Collections.emptySet();
    private boolean dryRun;
    private boolean directories;
    private boolean ignore = true;
    private boolean force = false;

    protected CleanCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Set<String> call() throws NoWorkTreeException, GitAPIException {
        Set<String> files2 = new TreeSet<String>();
        try {
            try {
                StatusCommand command2 = new StatusCommand(this.repo);
                Status status2 = command2.call();
                TreeSet<String> untrackedFiles = new TreeSet<String>(status2.getUntracked());
                TreeSet<String> untrackedDirs = new TreeSet<String>(status2.getUntrackedFolders());
                FS fs = this.getRepository().getFS();
                for (String p : status2.getIgnoredNotInIndex()) {
                    File f2 = new File(this.repo.getWorkTree(), p);
                    if (fs.isFile(f2) || fs.isSymLink(f2)) {
                        untrackedFiles.add(p);
                        continue;
                    }
                    if (!fs.isDirectory(f2)) continue;
                    untrackedDirs.add(p);
                }
                Set<String> filtered2 = this.filterFolders(untrackedFiles, untrackedDirs);
                Set<String> notIgnoredFiles = this.filterIgnorePaths(filtered2, status2.getIgnoredNotInIndex(), true);
                Set<String> notIgnoredDirs = this.filterIgnorePaths(untrackedDirs, status2.getIgnoredNotInIndex(), false);
                for (String file2 : notIgnoredFiles) {
                    if (!this.paths.isEmpty() && !this.paths.contains(file2)) continue;
                    files2 = this.cleanPath(file2, files2);
                }
                for (String dir : notIgnoredDirs) {
                    if (!this.paths.isEmpty() && !this.paths.contains(dir)) continue;
                    files2 = this.cleanPath(dir, files2);
                }
            }
            catch (IOException e2) {
                throw new JGitInternalException(e2.getMessage(), e2);
            }
        }
        finally {
            if (!this.dryRun && !files2.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(null, files2));
            }
        }
        return files2;
    }

    private Set<String> cleanPath(String path2, Set<String> inFiles) throws IOException {
        File curFile = new File(this.repo.getWorkTree(), path2);
        if (curFile.isDirectory()) {
            if (this.directories) {
                if (new File(curFile, ".git").exists()) {
                    if (this.force) {
                        if (!this.dryRun) {
                            FileUtils.delete(curFile, 5);
                        }
                        inFiles.add(path2 + "/");
                    }
                } else {
                    if (!this.dryRun) {
                        FileUtils.delete(curFile, 5);
                    }
                    inFiles.add(path2 + "/");
                }
            }
        } else {
            if (!this.dryRun) {
                FileUtils.delete(curFile, 4);
            }
            inFiles.add(path2);
        }
        return inFiles;
    }

    private Set<String> filterIgnorePaths(Set<String> inputPaths, Set<String> ignoredNotInIndex, boolean exact2) {
        if (this.ignore) {
            TreeSet<String> filtered2 = new TreeSet<String>(inputPaths);
            block0: for (String path2 : inputPaths) {
                for (String ignored : ignoredNotInIndex) {
                    if ((!exact2 || !path2.equals(ignored)) && (exact2 || !Paths.isEqualOrPrefix(ignored, path2))) continue;
                    filtered2.remove(path2);
                    continue block0;
                }
            }
            return filtered2;
        }
        return inputPaths;
    }

    private Set<String> filterFolders(Set<String> untracked, Set<String> untrackedFolders) {
        TreeSet<String> filtered2 = new TreeSet<String>(untracked);
        block0: for (String file2 : untracked) {
            for (String folder : untrackedFolders) {
                if (!Paths.isEqualOrPrefix(folder, file2)) continue;
                filtered2.remove(file2);
                continue block0;
            }
        }
        return filtered2;
    }

    public CleanCommand setPaths(Set<String> paths) {
        this.paths = paths;
        return this;
    }

    public CleanCommand setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public CleanCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public CleanCommand setCleanDirectories(boolean dirs) {
        this.directories = dirs;
        return this;
    }

    public CleanCommand setIgnore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }
}

