/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SkipRevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class LogCommand
extends GitCommand<Iterable<RevCommit>> {
    private RevWalk walk;
    private boolean startSpecified = false;
    private RevFilter revFilter;
    private final List<PathFilter> pathFilters = new ArrayList<PathFilter>();
    private final List<TreeFilter> excludeTreeFilters = new ArrayList<TreeFilter>();
    private int maxCount = -1;
    private int skip = -1;

    protected LogCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
    }

    @Override
    public Iterable<RevCommit> call() throws GitAPIException, NoHeadException {
        this.checkCallable();
        ArrayList<TreeFilter> filters = new ArrayList<TreeFilter>();
        if (!this.pathFilters.isEmpty()) {
            filters.add(AndTreeFilter.create(PathFilterGroup.create(this.pathFilters), TreeFilter.ANY_DIFF));
        }
        if (!this.excludeTreeFilters.isEmpty()) {
            for (TreeFilter f2 : this.excludeTreeFilters) {
                filters.add(AndTreeFilter.create(f2, TreeFilter.ANY_DIFF));
            }
        }
        if (!filters.isEmpty()) {
            if (filters.size() == 1) {
                this.walk.setTreeFilter((TreeFilter)filters.get(0));
            } else {
                this.walk.setTreeFilter(AndTreeFilter.create(filters));
            }
        }
        if (this.skip > -1 && this.maxCount > -1) {
            this.walk.setRevFilter(AndRevFilter.create(SkipRevFilter.create(this.skip), MaxCountRevFilter.create(this.maxCount)));
        } else if (this.skip > -1) {
            this.walk.setRevFilter(SkipRevFilter.create(this.skip));
        } else if (this.maxCount > -1) {
            this.walk.setRevFilter(MaxCountRevFilter.create(this.maxCount));
        }
        if (!this.startSpecified) {
            try {
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add(headId);
            }
            catch (IOException e2) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, e2);
            }
        }
        if (this.revFilter != null) {
            this.walk.setRevFilter(this.revFilter);
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId start2) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(true, start2);
    }

    public LogCommand not(AnyObjectId start2) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(false, start2);
    }

    public LogCommand addRange(AnyObjectId since, AnyObjectId until) throws MissingObjectException, IncorrectObjectTypeException {
        return this.not(since).add(until);
    }

    public LogCommand all() throws IOException {
        for (Ref ref : this.getRepository().getRefDatabase().getRefs()) {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().getRefDatabase().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            RevCommit commit = null;
            try {
                commit = this.walk.parseCommit(objectId);
            }
            catch (IncorrectObjectTypeException | MissingObjectException iOException) {
                // empty catch block
            }
            if (commit == null) continue;
            this.add(commit);
        }
        return this;
    }

    public LogCommand addPath(String path2) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create(path2));
        return this;
    }

    public LogCommand excludePath(String path2) {
        this.checkCallable();
        this.excludeTreeFilters.add(PathFilter.create(path2).negate());
        return this;
    }

    public LogCommand setSkip(int skip) {
        this.checkCallable();
        this.skip = skip;
        return this;
    }

    public LogCommand setMaxCount(int maxCount) {
        this.checkCallable();
        this.maxCount = maxCount;
        return this;
    }

    private LogCommand add(boolean include, AnyObjectId start2) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        this.checkCallable();
        try {
            if (include) {
                this.walk.markStart(this.walk.lookupCommit(start2));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(start2));
            }
            return this;
        }
        catch (IncorrectObjectTypeException | MissingObjectException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, start2), e3);
        }
    }

    public LogCommand setRevFilter(RevFilter aFilter) {
        this.checkCallable();
        this.revFilter = aFilter;
        return this;
    }
}

